---
generated_at: 2026-01-27 12:57:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-npm_run_build-docs.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間120秒以内**：実測値に基づかない推定値
  2. **threejs.orgでの公開**：設定ファイルからは直接確認不可
  3. **カスタムテンプレートの詳細**：テンプレート内容は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（build-docs定義）
- E-02: `utils/docs/jsdoc.config.json` - JSDoc設定ファイル
- E-03: `utils/docs/jsdoc.config.json` - opts.destination: "docs"
- E-04: `utils/docs/jsdoc.config.json` - source.include配列
- E-05: `utils/docs/jsdoc.config.json` - source.exclude配列
- E-06: `utils/docs/jsdoc.config.json` - plugins: ["plugins/markdown"]
- E-07: `utils/docs/jsdoc.config.json` - themeOpts.ignoreInheritedSymbols
- E-08: `package.json` - devDependencies（jsdoc v4.0.5）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run build-docsコマンドが存在する | E-01 | ○ |
| C-02 | JSDocを使用してドキュメントを生成する | E-01, E-02 | ○ |
| C-03 | jsdoc.config.jsonを設定ファイルとして使用 | E-01, E-02 | ○ |
| C-04 | docs/ディレクトリに出力する | E-03 | ○ |
| C-05 | src/ディレクトリを対象とする | E-04 | ○ |
| C-06 | examples/jsm/ディレクトリを対象とする | E-04 | ○ |
| C-07 | src/extras/libを除外する | E-05 | ○ |
| C-08 | src/renderers/common/extras/PMREMGenerator.jsを除外 | E-05 | ○ |
| C-09 | examples/jsm/libsを除外する | E-05 | ○ |
| C-10 | Markdownプラグインを使用する | E-06 | ○ |
| C-11 | ignoreInheritedSymbolsがtrueに設定 | E-07 | ○ |
| C-12 | utils/docs/template/をテンプレートとして使用 | E-02 | ○ |
| C-13 | UTF-8エンコーディングを使用 | E-02 | ○ |
| C-14 | 再帰的にファイルを走査する | E-02 | ○ |
| C-15 | JSDoc v4.0.5以上を使用 | E-08 | ○ |
| C-16 | package.jsonを参照する | E-02 | ○ |
| C-17 | outputSourceFilesがfalseに設定 | E-02 | ○ |
| C-18 | examples/jsm/offscreenを除外する | E-05 | ○ |
| C-19 | examples/jsm/lines/webgpuを除外する | E-05 | ○ |
| C-20 | 目標処理時間は120秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間120秒の根拠が明示されていない
  - 候補：実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックは設定ファイルに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] jsdoc.config.jsonの除外ファイル一覧が正確か確認
- [ ] カスタムテンプレートの存在確認
- [ ] 出力先docs/ディレクトリの用途が正しいか確認
