---
generated_at: 2026-01-27 12:58:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：4-npm_run_dev.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間5秒以内**：実測値に基づかない推定値
  2. **メモリ使用量256MB**：明示的な設定なし
  3. **npm run startのエイリアス**：package.jsonで確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（dev, start定義）
- E-02: `utils/build/dev.js` - ビルドスクリプト全体
- E-03: `utils/build/dev.js` - rm(), mkdir()によるbuild/初期化（3-5行目）
- E-04: `utils/build/dev.js` - contentsオブジェクト（7-13行目）
- E-05: `utils/build/dev.js` - Promise.all + writeFile（15-17行目）
- E-06: `utils/server.js` - HTTPサーバー実装
- E-07: `utils/server.js` - tryListen関数（178-212行目）
- E-08: `utils/server.js` - mimeTypes定義（17-43行目）
- E-09: `utils/server.js` - Range Request対応（139-163行目）
- E-10: `utils/server.js` - パストラバーサル対策（53-59行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run devコマンドが存在する | E-01 | ○ |
| C-02 | dev.jsとserver.jsを順次実行する | E-01 | ○ |
| C-03 | build/ディレクトリを削除して再作成する | E-03 | ○ |
| C-04 | 5つのエクスポートファイルを生成する | E-04 | ○ |
| C-05 | three.core.jsがsrc/Three.Core.jsをエクスポート | E-04 | ○ |
| C-06 | three.module.jsがsrc/Three.jsをエクスポート | E-04 | ○ |
| C-07 | three.tsl.jsがsrc/Three.TSL.jsをエクスポート | E-04 | ○ |
| C-08 | three.webgpu.jsがsrc/Three.WebGPU.jsをエクスポート | E-04 | ○ |
| C-09 | three.webgpu.nodes.jsがsrc/Three.WebGPU.Nodes.jsをエクスポート | E-04 | ○ |
| C-10 | Promise.allで並列にファイル作成 | E-05 | ○ |
| C-11 | ポート8080でサーバー起動 | E-01, E-06 | ○ |
| C-12 | 最大20回のポートリトライ | E-07 | ○ |
| C-13 | MIMEタイプを拡張子で判定 | E-08 | ○ |
| C-14 | Range Requestsに対応 | E-09 | ○ |
| C-15 | パストラバーサル対策あり | E-10 | ○ |
| C-16 | ディレクトリ一覧機能あり | E-06 | ○ |
| C-17 | npm run startはdevのエイリアス | E-01 | ○ |
| C-18 | // dev buildコメントが付与される | E-04 | ○ |
| C-19 | Ctrl+Cでサーバー停止 | E-06 | ○ |
| C-20 | ネットワークIPアドレスを表示 | E-06 | ○ |
| C-21 | export * from形式でエクスポート | E-04 | ○ |
| C-22 | 目標処理時間は5秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間5秒の根拠が明示されていない
  - 候補：実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] エクスポートファイルの生成内容がdev.jsと一致するか確認
- [ ] サーバー機能（Range Request、MIMEタイプ等）が正確か確認
- [ ] セキュリティ対策（パストラバーサル）の動作確認
