---
generated_at: 2026-01-27 12:59:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：5-npm_run_preview.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（初回30秒、再ビルド10秒）**：実測値に基づかない推定値
  2. **メモリ使用量1024MB**：明示的な設定なし
  3. **ビルド成果物の詳細**：minified版は含まれないことの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（preview定義）
- E-02: `utils/build/preview.js` - プレビュースクリプト全体
- E-03: `utils/build/preview.js` - spawn('npx', ['rollup', ...])（9-18行目）
- E-04: `utils/build/preview.js` - spawn('node', ['utils/server.js', ...])（21-25行目）
- E-05: `utils/build/preview.js` - prefix関数（28-41行目）
- E-06: `utils/build/preview.js` - cleanup関数（49-55行目）
- E-07: `utils/build/preview.js` - SIGINTとSIGTERMのハンドリング（57-58行目）
- E-08: `utils/build/preview.js` - closeイベントハンドリング（60-61行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run previewコマンドが存在する | E-01 | ○ |
| C-02 | preview.jsを実行する | E-01, E-02 | ○ |
| C-03 | Rollupをウォッチモード（-w）で起動 | E-03 | ○ |
| C-04 | インラインソースマップ（-m inline）を使用 | E-03 | ○ |
| C-05 | HTTPサーバーをポート8080で起動 | E-04 | ○ |
| C-06 | [ROLLUP]プレフィックスで出力表示 | E-05 | ○ |
| C-07 | [HTTP]プレフィックスで出力表示 | E-05 | ○ |
| C-08 | 青背景でROLLUP出力を表示 | E-05 | ○ |
| C-09 | 緑背景でHTTP出力を表示 | E-05 | ○ |
| C-10 | SIGINT/SIGTERMでクリーンアップ実行 | E-06, E-07 | ○ |
| C-11 | 両プロセスをkillして終了 | E-06 | ○ |
| C-12 | プロセス終了時にもう一方も終了 | E-08 | ○ |
| C-13 | rollup.config.jsを設定ファイルとして使用 | E-03 | ○ |
| C-14 | shell: trueでRollupを起動 | E-03 | ○ |
| C-15 | shell: falseでサーバーを起動 | E-04 | ○ |
| C-16 | spawnで子プロセスを起動 | E-03, E-04 | ○ |
| C-17 | ルートディレクトリを__dirnameから取得 | E-02 | ○ |
| C-18 | stdoutとstderrをprefixで処理 | E-02 | ○ |
| C-19 | ファイル変更時に自動再ビルド | E-03 | ○ |
| C-20 | 目標処理時間（初回30秒、再ビルド10秒） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠が明示されていない
  - 候補：実行ログ / ベンチマーク結果 / 開発者の経験値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] spawnのオプションが正確に記載されているか確認
- [ ] シグナル処理とクリーンアップの動作確認
- [ ] 出力ファイルにインラインソースマップが含まれるか確認
