---
generated_at: 2026-01-27 13:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：6-npm_run_lint.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間60秒以内**：実測値に基づかない推定値
  2. **メモリ使用量512MB**：明示的な設定なし
  3. **ファイル数「数百ファイル」**：正確な数は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（lint, lint-core定義）
- E-02: `eslint.config.js` - ESLint設定ファイル全体
- E-03: `eslint.config.js` - ignoresセクション（11-24行目）
- E-04: `eslint.config.js` - rulesセクション（90-122行目）
- E-05: `eslint.config.js` - plugins設定（36-39行目）
- E-06: `eslint.config.js` - languageOptions（40-70行目）
- E-07: `eslint.config.js` - jsdoc settings（76-88行目）
- E-08: `package.json` - devDependencies（eslint, eslint-config-mdcs等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run lintコマンドが存在する | E-01 | ○ |
| C-02 | npm run lintはnpm run lint-coreを実行する | E-01 | ○ |
| C-03 | eslint srcを実行する | E-01 | ○ |
| C-04 | eslint.config.jsを設定ファイルとして使用 | E-02 | ○ |
| C-05 | node_modules, build, libs等を除外 | E-03 | ○ |
| C-06 | no-throw-literalルールがerror | E-04 | ○ |
| C-07 | quotesルールでシングルクォート強制 | E-04 | ○ |
| C-08 | prefer-constルールが有効 | E-04 | ○ |
| C-09 | no-irregular-whitespaceルールが有効 | E-04 | ○ |
| C-10 | no-duplicate-importsルールが有効 | E-04 | ○ |
| C-11 | prefer-spreadルールが有効 | E-04 | ○ |
| C-12 | jsdoc/check-typesルールが有効 | E-04 | ○ |
| C-13 | no-useless-escapeがoff | E-04 | ○ |
| C-14 | eslint-config-mdcsを使用 | E-05, E-08 | ○ |
| C-15 | eslint-plugin-compatを使用 | E-05, E-08 | ○ |
| C-16 | eslint-plugin-htmlを使用 | E-05, E-08 | ○ |
| C-17 | eslint-plugin-jsdocを使用 | E-05, E-08 | ○ |
| C-18 | ECMAScript 2018をターゲット | E-06 | ○ |
| C-19 | ブラウザ・Node.js・ES2017グローバルを許可 | E-06 | ○ |
| C-20 | ESLint v9.0.0以上を使用 | E-08 | ○ |
| C-21 | jsdocの設定にpreferredTypesを定義 | E-07 | ○ |
| C-22 | 目標処理時間は60秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間60秒の根拠が明示されていない
  - 候補：CI実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックは設定ファイルに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] eslint.config.jsのルール一覧が正確に記載されているか確認
- [ ] 除外パターンが実際の設定と一致するか確認
- [ ] npm run lintとnpm run lint-coreの関係が正確か確認
