---
generated_at: 2026-01-27 13:01:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-npm_run_lint-fix.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間300秒以内**：実測値に基づかない推定値
  2. **lint-docs対象**：package.jsonにlint-docsコマンドが存在するか要確認
  3. **9つのlintコマンド**：正確な数と順序を確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（lint-fix定義）
- E-02: `package.json` - lint-core定義（eslint src）
- E-03: `package.json` - lint-addons定義（eslint examples/jsm）
- E-04: `package.json` - lint-examples定義（eslint examples）
- E-05: `package.json` - lint-editor定義（eslint editor）
- E-06: `package.json` - lint-playground定義（eslint playground）
- E-07: `package.json` - lint-manual定義（eslint manual）
- E-08: `package.json` - lint-test定義（eslint test）
- E-09: `package.json` - lint-utils定義（eslint utils）
- E-10: `eslint.config.js` - ESLint設定ファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run lint-fixコマンドが存在する | E-01 | ○ |
| C-02 | lint-core --fixを実行する | E-01, E-02 | ○ |
| C-03 | lint-addons --fixを実行する | E-01, E-03 | ○ |
| C-04 | lint-examples --fixを実行する | E-01, E-04 | ○ |
| C-05 | lint-editor --fixを実行する | E-01, E-05 | ○ |
| C-06 | lint-playground --fixを実行する | E-01, E-06 | ○ |
| C-07 | lint-manual --fixを実行する | E-01, E-07 | ○ |
| C-08 | lint-test --fixを実行する | E-01, E-08 | ○ |
| C-09 | lint-utils --fixを実行する | E-01, E-09 | ○ |
| C-10 | &&でコマンドを連結している | E-01 | ○ |
| C-11 | --fixオプションで自動修正を有効化 | E-01 | ○ |
| C-12 | src/を対象としている | E-02 | ○ |
| C-13 | examples/jsm/を対象としている | E-03 | ○ |
| C-14 | examples/を対象としている | E-04 | ○ |
| C-15 | editor/を対象としている | E-05 | ○ |
| C-16 | test/を対象としている | E-08 | ○ |
| C-17 | utils/を対象としている | E-09 | ○ |
| C-18 | 目標処理時間は300秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間300秒の根拠が明示されていない
  - 候補：実行ログ / ベンチマーク結果
- lint-docsコマンドの存在確認が必要
  - package.jsonで定義を確認する必要あり

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - lint-docsコマンドの存在が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] lint-fixコマンドの実行順序がpackage.jsonと一致するか確認
- [ ] lint-docsコマンドがpackage.jsonに存在するか確認
- [ ] 各対象ディレクトリが正確に記載されているか確認
