---
generated_at: 2026-01-27 13:02:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：8-npm_run_test.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間180秒以内**：実測値に基づかない推定値
  2. **テストケース数「数百」**：正確な数は未確認
  3. **CI環境Node.js 24**：ci.ymlで確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（test定義）
- E-02: `package.json` - lint定義
- E-03: `package.json` - test-unit定義
- E-04: `package.json` - test-unit-addons定義
- E-05: `test/unit/three.source.unit.js` - コアテストエントリポイント
- E-06: `test/unit/three.addons.unit.js` - アドオンテストエントリポイント
- E-07: `package.json` - devDependencies（qunit v2.19.4）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run testコマンドが存在する | E-01 | ○ |
| C-02 | lint, test-unit, test-unit-addonsを順次実行 | E-01 | ○ |
| C-03 | &&でコマンドを連結している | E-01 | ○ |
| C-04 | lintが失敗すると後続は実行されない | E-01 | ○ |
| C-05 | test-unitはqunit test/unit/three.source.unit.jsを実行 | E-03 | ○ |
| C-06 | test-unit-addonsはqunit test/unit/three.addons.unit.jsを実行 | E-04 | ○ |
| C-07 | three.source.unit.jsがコアテストのエントリ | E-05 | ○ |
| C-08 | three.addons.unit.jsがアドオンテストのエントリ | E-06 | ○ |
| C-09 | QUnit v2.19.4以上を使用 | E-07 | ○ |
| C-10 | lintはeslint srcを実行 | E-02 | ○ |
| C-11 | ファイルの変更は行わない（読み取り専用） | E-01 | ○ |
| C-12 | 終了コード0は全成功を示す | E-01 | ○ |
| C-13 | 終了コード1は失敗を示す | E-01 | ○ |
| C-14 | CI/CDでのtestジョブとして実行 | E-08 | ○ |
| C-15 | E2Eテストは含まれない | E-01 | ○ |
| C-16 | PRマージ前の必須チェック | E-08 | ○ |
| C-17 | ヘッドレス環境で実行 | E-03, E-04 | ○ |
| C-18 | 目標処理時間は180秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間180秒の根拠が明示されていない
  - 候補：CI実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックは設定ファイルに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] testコマンドの実行順序がpackage.jsonと一致するか確認
- [ ] 各サブコマンドの内容が正確か確認
- [ ] CI/CD環境の設定（Node.jsバージョン等）を確認
