---
generated_at: 2026-01-27 13:03:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：9-npm_run_test-unit.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間60秒以内**：実測値に基づかない推定値
  2. **テストファイル数「約200」**：正確な数は未確認
  3. **アサーション数「数千」**：正確な数は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（test-unit定義）
- E-02: `test/unit/three.source.unit.js` - テストエントリポイント全体
- E-03: `test/unit/three.source.unit.js` - import文（console-wrapper.js, qunit-utils.js）
- E-04: `test/unit/three.source.unit.js` - 各モジュールテストのimport
- E-05: `package.json` - devDependencies（qunit v2.19.4）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run test-unitコマンドが存在する | E-01 | ○ |
| C-02 | qunit test/unit/three.source.unit.jsを実行 | E-01 | ○ |
| C-03 | three.source.unit.jsがエントリポイント | E-02 | ○ |
| C-04 | console-wrapper.jsをインポート | E-03 | ○ |
| C-05 | qunit-utils.jsをインポート | E-03 | ○ |
| C-06 | animationモジュールのテストを含む | E-04 | ○ |
| C-07 | audioモジュールのテストを含む | E-04 | ○ |
| C-08 | camerasモジュールのテストを含む | E-04 | ○ |
| C-09 | coreモジュールのテストを含む | E-04 | ○ |
| C-10 | mathモジュールのテストを含む | E-04 | ○ |
| C-11 | geometriesモジュールのテストを含む | E-04 | ○ |
| C-12 | materialsモジュールのテストを含む | E-04 | ○ |
| C-13 | renderersモジュールのテストを含む | E-04 | ○ |
| C-14 | texturesモジュールのテストを含む | E-04 | ○ |
| C-15 | QUnit v2.19.4以上を使用 | E-05 | ○ |
| C-16 | ファイルの変更は行わない | E-01 | ○ |
| C-17 | 終了コード0は全成功を示す | E-01 | ○ |
| C-18 | ヘッドレス環境で実行 | E-06 | ○ |
| C-19 | ES Modulesをサポート | E-02 | ○ |
| C-20 | 目標処理時間は60秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間60秒の根拠が明示されていない
  - 候補：CI実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストエントリポイントのimport一覧が正確か確認
- [ ] テスト対象モジュール一覧が網羅的か確認
- [ ] QUnitの使用方法が正確か確認
