---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 192
  claims_with_evidence: 192
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート: animation モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：192 / 192、根拠なし：0
- 優先レビュー（高）
  1. 全テストケースはソースコードから直接抽出されており、根拠が明確
  2. Three.js animationモジュールの全14ファイルを解析
  3. 主要クラス・メソッドを網羅的にカバー

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/animation/AnimationUtils.js` - AnimationUtilsクラスとユーティリティ関数
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/animation/PropertyBinding.js` - PropertyBindingクラスとCompositeクラス
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/animation/KeyframeTrack.js` - KeyframeTrackクラス
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/animation/AnimationMixer.js` - AnimationMixerクラス
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/animation/PropertyMixer.js` - PropertyMixerクラス
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/animation/AnimationClip.js` - AnimationClipクラス
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/animation/AnimationAction.js` - AnimationActionクラス
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/animation/AnimationObjectGroup.js` - AnimationObjectGroupクラス
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/animation/tracks/VectorKeyframeTrack.js` - VectorKeyframeTrackクラス
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/animation/tracks/NumberKeyframeTrack.js` - NumberKeyframeTrackクラス
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/animation/tracks/ColorKeyframeTrack.js` - ColorKeyframeTrackクラス
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/animation/tracks/StringKeyframeTrack.js` - StringKeyframeTrackクラス
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/animation/tracks/QuaternionKeyframeTrack.js` - QuaternionKeyframeTrackクラス
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/animation/tracks/BooleanKeyframeTrack.js` - BooleanKeyframeTrackクラス

## 3) Claims と根拠の対応（レビューの主戦場）

### AnimationUtils (UT-ANI-001 ~ UT-ANI-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | convertArray: 配列を指定型に変換 | E-01 (L12-24) | ○ |
| C-02 | convertArray: 同じ型は元配列を返却 | E-01 (L14) | ○ |
| C-03 | convertArray: null/undefined処理 | E-01 (L14) | ○ |
| C-04 | convertArray: Array.prototype.slice使用 | E-01 (L22) | ○ |
| C-05 | isTypedArray: TypedArray判定 | E-01 (L402-406) | ○ |
| C-06 | isTypedArray: 通常配列判定 | E-01 (L402-406) | ○ |
| C-07 | getKeyframeOrder: ソート順序生成 | E-01 (L32-48) | ○ |
| C-08 | getKeyframeOrder: 空配列処理 | E-01 (L40-46) | ○ |
| C-09 | sortedArray: 指定順序でソート | E-01 (L58-77) | ○ |
| C-10 | sortedArray: stride>1対応 | E-01 (L66-71) | ○ |
| C-11 | flattenJSON: JSONから時間・値抽出 | E-01 (L87-158) | ○ |
| C-12 | flattenJSON: 配列値展開 | E-01 (L102-118) | ○ |
| C-13 | flattenJSON: toArrayオブジェクト対応 | E-01 (L119-137) | ○ |
| C-14 | flattenJSON: 欠損値スキップ | E-01 (L91-97) | ○ |
| C-15 | subclip: サブクリップ生成 | E-01 (L171-239) | ○ |
| C-16 | subclip: 開始時間0シフト | E-01 (L230-234) | ○ |
| C-17 | subclip: 範囲外トラック除外 | E-01 (L203) | ○ |
| C-18 | makeClipAdditive: Additive変換 | E-01 (L251-371) | ○ |
| C-19 | makeClipAdditive: Quaternion変換 | E-01 (L325-349) | ○ |
| C-20 | makeClipAdditive: fps<=0フォールバック | E-01 (L253) | ○ |
| C-21 | makeClipAdditive: bool/stringスキップ | E-01 (L265) | ○ |

### KeyframeTrack (UT-ANI-022 ~ UT-ANI-048)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | constructor: 正常初期化 | E-03 (L29-58) | ○ |
| C-23 | constructor: name未定義エラー | E-03 (L31) | ○ |
| C-24 | constructor: times空エラー | E-03 (L32) | ○ |
| C-25 | toJSON: シリアライズ | E-03 (L68-104) | ○ |
| C-26 | setInterpolation: Linear設定 | E-03 (L190-193) | ○ |
| C-27 | setInterpolation: Discrete設定 | E-03 (L184-188) | ○ |
| C-28 | setInterpolation: Smooth設定 | E-03 (L196-200) | ○ |
| C-29 | setInterpolation: 不正補間フォールバック | E-03 (L210-232) | ○ |
| C-30 | getInterpolation: 補間タイプ返却 | E-03 (L246-268) | ○ |
| C-31 | getValueSize: 値サイズ計算 | E-03 (L275-279) | ○ |
| C-32 | shift: 時間オフセット | E-03 (L287-303) | ○ |
| C-33 | shift: オフセット0最適化 | E-03 (L289) | ○ |
| C-34 | scale: 時間スケール | E-03 (L311-327) | ○ |
| C-35 | scale: スケール1最適化 | E-03 (L313) | ○ |
| C-36 | trim: 範囲トリミング | E-03 (L339-378) | ○ |
| C-37 | trim: 最小キーフレーム保証 | E-03 (L364-368) | ○ |
| C-38 | validate: 有効トラック検証 | E-03 (L387-460) | ○ |
| C-39 | validate: 値サイズ整数検証 | E-03 (L392-397) | ○ |
| C-40 | validate: NaN時間検証 | E-03 (L417-422) | ○ |
| C-41 | validate: 時間順序検証 | E-03 (L425-430) | ○ |
| C-42 | validate: NaN値検証 | E-03 (L439-451) | ○ |
| C-43 | optimize: 重複キーフレーム削除 | E-03 (L469-578) | ○ |
| C-44 | optimize: 境界キーフレーム保持 | E-03 (L552-564) | ○ |
| C-45 | clone: トラッククローン | E-03 (L587-600) | ○ |
| C-46 | InterpolantFactoryMethodDiscrete | E-03 (L113-117) | ○ |
| C-47 | InterpolantFactoryMethodLinear | E-03 (L126-130) | ○ |
| C-48 | InterpolantFactoryMethodSmooth | E-03 (L139-143) | ○ |

### AnimationClip (UT-ANI-049 ~ UT-ANI-066)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | constructor: 正常初期化 | E-06 (L32-86) | ○ |
| C-50 | constructor: 負duration自動計算 | E-06 (L80-84) | ○ |
| C-51 | parse: JSONデシリアライズ | E-06 (L95-114) | ○ |
| C-52 | parse: FPS時間スケール | E-06 (L99, L103) | ○ |
| C-53 | toJSON: シリアライズ | E-06 (L123-147) | ○ |
| C-54 | CreateFromMorphTargetSequence | E-06 (L163-203) | ○ |
| C-55 | CreateFromMorphTargetSequence: ループキーフレーム | E-06 (L186-190) | ○ |
| C-56 | findByName: 名前検索 | E-06 (L215-238) | ○ |
| C-57 | findByName: Object3D対応 | E-06 (L219-224) | ○ |
| C-58 | findByName: 検索失敗null | E-06 (L236) | ○ |
| C-59 | CreateClipsFromMorphTargetSequences | E-06 (L253-296) | ○ |
| C-60 | resetDuration: 最長トラック計算 | E-06 (L441-458) | ○ |
| C-61 | trim: 一括トリム | E-06 (L465-475) | ○ |
| C-62 | validate: 全トラック検証 | E-06 (L483-495) | ○ |
| C-63 | validate: 無効トラック検出 | E-06 (L489) | ○ |
| C-64 | optimize: 一括最適化 | E-06 (L503-513) | ○ |
| C-65 | clone: クリップクローン | E-06 (L520-536) | ○ |
| C-66 | clone: userDataディープコピー | E-06 (L532) | ○ |

### AnimationMixer (UT-ANI-067 ~ UT-ANI-084)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | constructor: 正常初期化 | E-04 (L23-57) | ○ |
| C-68 | clipAction: アクション生成 | E-04 (L557-616) | ○ |
| C-69 | clipAction: キャッシュ | E-04 (L585-590) | ○ |
| C-70 | clipAction: 文字列名検索 | E-04 (L562) | ○ |
| C-71 | clipAction: 検索失敗null | E-04 (L604) | ○ |
| C-72 | existingAction: 既存取得 | E-04 (L625-645) | ○ |
| C-73 | existingAction: 不在null | E-04 (L643) | ○ |
| C-74 | stopAllAction: 一括停止 | E-04 (L652-665) | ○ |
| C-75 | update: 時間更新 | E-04 (L676-711) | ○ |
| C-76 | update: タイムスケール適用 | E-04 (L678) | ○ |
| C-77 | update: バインディング適用 | E-04 (L700-707) | ○ |
| C-78 | setTime: 時間設定 | E-04 (L722-733) | ○ |
| C-79 | setTime: 全アクション時間リセット | E-04 (L725-729) | ○ |
| C-80 | getRoot: ルート取得 | E-04 (L740-744) | ○ |
| C-81 | uncacheClip: クリップキャッシュ解放 | E-04 (L752-791) | ○ |
| C-82 | uncacheRoot: ルートキャッシュ解放 | E-04 (L801-835) | ○ |
| C-83 | uncacheAction: アクションキャッシュ解放 | E-04 (L845-856) | ○ |
| C-84 | stats: 統計取得 | E-04 (L223-262) | ○ |

### AnimationAction (UT-ANI-085 ~ UT-ANI-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | constructor: 正常初期化 | E-07 (L17-168) | ○ |
| C-86 | play: 再生開始 | E-07 (L175-181) | ○ |
| C-87 | stop: 停止 | E-07 (L188-194) | ○ |
| C-88 | reset: リセット | E-07 (L201-212) | ○ |
| C-89 | isRunning: 再生中判定 | E-07 (L219-224) | ○ |
| C-90 | isRunning: 一時停止判定 | E-07 (L221) | ○ |
| C-91 | isScheduled: スケジュール判定 | E-07 (L231-235) | ○ |
| C-92 | startAt: 開始時間設定 | E-07 (L243-249) | ○ |
| C-93 | setLoop: ループモード設定 | E-07 (L258-265) | ○ |
| C-94 | setLoop: LoopOnce設定 | E-07 (L260) | ○ |
| C-95 | setLoop: LoopPingPong設定 | E-07 (L260) | ○ |
| C-96 | setEffectiveWeight: ウェイト設定 | E-07 (L276-285) | ○ |
| C-97 | setEffectiveWeight: disabled時 | E-07 (L281) | ○ |
| C-98 | getEffectiveWeight: ウェイト取得 | E-07 (L292-296) | ○ |
| C-99 | fadeIn: フェードイン | E-07 (L305-309) | ○ |
| C-100 | fadeOut: フェードアウト | E-07 (L318-322) | ○ |
| C-101 | crossFadeFrom: クロスフェード | E-07 (L333-353) | ○ |
| C-102 | crossFadeFrom: ワープ付き | E-07 (L338-349) | ○ |
| C-103 | crossFadeTo: 逆クロスフェード | E-07 (L364-368) | ○ |
| C-104 | stopFading: フェード停止 | E-07 (L375-388) | ○ |
| C-105 | setEffectiveTimeScale: タイムスケール設定 | E-07 (L399-406) | ○ |
| C-106 | setEffectiveTimeScale: paused時 | E-07 (L402) | ○ |
| C-107 | getEffectiveTimeScale: タイムスケール取得 | E-07 (L413-417) | ○ |
| C-108 | setDuration: 再生時間設定 | E-07 (L424-430) | ○ |
| C-109 | syncWith: 同期 | E-07 (L438-446) | ○ |
| C-110 | halt: 減速停止 | E-07 (L454-458) | ○ |
| C-111 | warp: ワープ | E-07 (L470-496) | ○ |
| C-112 | stopWarping: ワープ停止 | E-07 (L503-516) | ○ |
| C-113 | getMixer: ミキサー取得 | E-07 (L523-527) | ○ |
| C-114 | getClip: クリップ取得 | E-07 (L534-538) | ○ |
| C-115 | getRoot: ルート取得 | E-07 (L545-549) | ○ |
| C-116 | getRoot: localRoot取得 | E-07 (L547) | ○ |
| C-117 | _update: 更新処理 | E-07 (L553-629) | ○ |
| C-118 | _update: disabled時 | E-07 (L557-564) | ○ |
| C-119 | _updateTime: LoopRepeat | E-07 (L770-847) | ○ |
| C-120 | _updateTime: LoopOnce終了イベント | E-07 (L763-768) | ○ |
| C-121 | _updateTime: LoopPingPong | E-07 (L854-860) | ○ |
| C-122 | _updateTime: clampWhenFinished | E-07 (L758, L809) | ○ |

### PropertyBinding (UT-ANI-123 ~ UT-ANI-146)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | constructor: 正常初期化 | E-02 (L118-152) | ○ |
| C-124 | create: PropertyBinding返却 | E-02 (L164-176) | ○ |
| C-125 | create: Composite返却 | E-02 (L172) | ○ |
| C-126 | sanitizeNodeName: スペース置換 | E-02 (L185-189) | ○ |
| C-127 | sanitizeNodeName: 予約文字削除 | E-02 (L187) | ○ |
| C-128 | parseTrackName: パース | E-02 (L209-255) | ○ |
| C-129 | parseTrackName: インデックスパース | E-02 (L225) | ○ |
| C-130 | parseTrackName: オブジェクト名パース | E-02 (L222-244) | ○ |
| C-131 | parseTrackName: 無効名エラー | E-02 (L213-217) | ○ |
| C-132 | parseTrackName: プロパティ名空エラー | E-02 (L247-251) | ○ |
| C-133 | findNode: ルート自身返却 | E-02 (L266-272) | ○ |
| C-134 | findNode: 子ノード検索 | E-02 (L288-320) | ○ |
| C-135 | findNode: ボーン検索 | E-02 (L275-285) | ○ |
| C-136 | findNode: 検索失敗null | E-02 (L322) | ○ |
| C-137 | bind: プロパティバインド | E-02 (L487-717) | ○ |
| C-138 | bind: マテリアルバインド | E-02 (L523-541) | ○ |
| C-139 | bind: ボーンバインド | E-02 (L543-569) | ○ |
| C-140 | bind: morphTargetInfluencesバインド | E-02 (L661-686) | ○ |
| C-141 | bind: ノード不在unavailable | E-02 (L509-514) | ○ |
| C-142 | bind: NeedsUpdateバージョニング | E-02 (L644-647) | ○ |
| C-143 | bind: MatrixWorldNeedsUpdateバージョニング | E-02 (L648-652) | ○ |
| C-144 | unbind: アンバインド | E-02 (L722-731) | ○ |
| C-145 | getValue: 遅延バインド | E-02 (L470-475) | ○ |
| C-146 | setValue: 遅延バインド | E-02 (L477-482) | ○ |

### PropertyMixer (UT-ANI-147 ~ UT-ANI-166)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | constructor: 正常初期化 | E-05 (L15-122) | ○ |
| C-148 | constructor: quaternion6バッファ | E-05 (L58-59) | ○ |
| C-149 | constructor: string/bool Array | E-05 (L62-72) | ○ |
| C-150 | constructor: 数値Float64Array | E-05 (L75-80) | ○ |
| C-151 | accumulate: 値累積 | E-05 (L130-165) | ○ |
| C-152 | accumulate: 初期累積 | E-05 (L141-151) | ○ |
| C-153 | accumulateAdditive: Additive累積 | E-05 (L172-191) | ○ |
| C-154 | accumulateAdditive: identity設定 | E-05 (L178-184) | ○ |
| C-155 | apply: 累積値適用 | E-05 (L198-244) | ○ |
| C-156 | apply: 部分ウェイト適用 | E-05 (L212-220) | ○ |
| C-157 | apply: Additive適用 | E-05 (L223-228) | ○ |
| C-158 | apply: 変更なし最適化 | E-05 (L231-242) | ○ |
| C-159 | saveOriginalState: 状態保存 | E-05 (L250-274) | ○ |
| C-160 | restoreOriginalState: 状態復元 | E-05 (L279-284) | ○ |
| C-161 | _slerp: Quaternion補間 | E-05 (L338-341) | ○ |
| C-162 | _slerpAdditive: Additive Quaternion | E-05 (L344-354) | ○ |
| C-163 | _lerp: 数値補間 | E-05 (L356-367) | ○ |
| C-164 | _lerpAdditive: Additive数値 | E-05 (L370-379) | ○ |
| C-165 | _select: t>=0.5選択 | E-05 (L324-335) | ○ |
| C-166 | _select: t<0.5維持 | E-05 (L326) | ○ |

### AnimationObjectGroup (UT-ANI-167 ~ UT-ANI-178)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-167 | constructor: 正常初期化 | E-08 (L32-95) | ○ |
| C-168 | add: オブジェクト追加 | E-08 (L102-188) | ○ |
| C-169 | add: キャッシュ再アクティブ化 | E-08 (L137-176) | ○ |
| C-170 | add: UUID衝突エラー | E-08 (L177-181) | ○ |
| C-171 | remove: キャッシュ移動 | E-08 (L195-242) | ○ |
| C-172 | remove: キャッシュ済み無視 | E-08 (L210) | ○ |
| C-173 | uncache: 完全削除 | E-08 (L249-336) | ○ |
| C-174 | uncache: キャッシュ済み削除 | E-08 (L269-299) | ○ |
| C-175 | subscribe_: バインディング配列返却 | E-08 (L340-375) | ○ |
| C-176 | subscribe_: キャッシュ | E-08 (L349) | ○ |
| C-177 | unsubscribe_: サブスクリプション解除 | E-08 (L377-406) | ○ |
| C-178 | stats: 統計取得 | E-08 (L73-93) | ○ |

### Composite (UT-ANI-179 ~ UT-ANI-183)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-179 | constructor: 正常初期化 | E-02 (L40-47) | ○ |
| C-180 | getValue: 最初のバインディング取得 | E-02 (L49-59) | ○ |
| C-181 | setValue: 全バインディング設定 | E-02 (L61-70) | ○ |
| C-182 | bind: 全バインドbind | E-02 (L72-82) | ○ |
| C-183 | unbind: 全バインドunbind | E-02 (L84-94) | ○ |

### KeyframeTrack派生クラス (UT-ANI-184 ~ UT-ANI-192)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-184 | VectorKeyframeTrack: 初期化 | E-09 (L8-36) | ○ |
| C-185 | NumberKeyframeTrack: 初期化 | E-10 (L8-36) | ○ |
| C-186 | ColorKeyframeTrack: 初期化 | E-11 (L8-36) | ○ |
| C-187 | QuaternionKeyframeTrack: 初期化 | E-13 (L9-51) | ○ |
| C-188 | QuaternionKeyframeTrack: QuaternionLinearInterpolant | E-13 (L32-36) | ○ |
| C-189 | BooleanKeyframeTrack: 初期化 | E-14 (L9-55) | ○ |
| C-190 | BooleanKeyframeTrack: 補間制限 | E-14 (L52-53) | ○ |
| C-191 | StringKeyframeTrack: 初期化 | E-12 (L9-55) | ○ |
| C-192 | StringKeyframeTrack: 補間制限 | E-12 (L52-53) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースはソースコードから直接抽出されており、根拠が明確です。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 全クラスがテストケースでカバーされているか確認
- [ ] 主要なpublicメソッドが網羅されているか確認
- [ ] 正常系・異常系・境界値のバランスが適切か確認
- [ ] 優先度の設定が妥当か確認
- [ ] テストケースの期待結果が明確か確認
