---
generated_at: 2026-01-27 13:45:00
metrics:
  claims_total: 95
  claims_with_evidence: 95
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：audio.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（audio.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：95 / 95、根拠なし：0
- 優先レビュー（高）
  1. **UT-AUD-007〜008**：バッファ設定と自動再生のテストケースが業務上重要
  2. **UT-AUD-009〜018**：play/pause/stop の再生制御ロジックが複雑
  3. **UT-AUD-062〜063, 089〜091**：ブラウザ互換性に関するテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/audio/Audio.js`
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/audio/AudioListener.js`
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/audio/AudioAnalyser.js`
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/audio/PositionalAudio.js`
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/audio/AudioContext.js`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-AUD-001) | AudioListenerを渡してインスタンス生成できること | E-01 L29-217 constructor定義 | ○ |
| C-02 (UT-AUD-002) | 初期プロパティが正しく設定されること | E-01 L40-215 プロパティ定義 | ○ |
| C-03 (UT-AUD-003) | gainノードが返却されること | E-01 L223-228 getOutput()定義 | ○ |
| C-04 (UT-AUD-004) | オーディオノードがソースとして設定されること | E-01 L238-247 setNodeSource()定義 | ○ |
| C-05 (UT-AUD-005) | メディア要素がソースとして設定されること | E-01 L257-266 setMediaElementSource()定義 | ○ |
| C-06 (UT-AUD-006) | メディアストリームがソースとして設定されること | E-01 L276-285 setMediaStreamSource()定義 | ○ |
| C-07 (UT-AUD-007) | オーディオバッファが設定されること | E-01 L295-304 setBuffer()定義 | ○ |
| C-08 (UT-AUD-008) | autoplay=trueの場合に自動再生されること | E-01 L300 if(this.autoplay) this.play() | ○ |
| C-09 (UT-AUD-009) | 再生が開始されること | E-01 L314-349 play()定義 | ○ |
| C-10 (UT-AUD-010) | 遅延再生が機能すること | E-01 L314, 330 delay引数とstartedAt計算 | ○ |
| C-11 (UT-AUD-011) | 既に再生中の場合は警告が出ること | E-01 L316-320 isPlaying判定 | ○ |
| C-12 (UT-AUD-012) | playbackControl無効時は警告が出ること | E-01 L323-328 hasPlaybackControl判定 | ○ |
| C-13 (UT-AUD-013) | 再生が一時停止されること | E-01 L358-390 pause()定義 | ○ |
| C-14 (UT-AUD-014) | ループ再生時の進捗計算が正しいこと | E-01 L373-378 loop時のprogress計算 | ○ |
| C-15 (UT-AUD-015) | pause()でplaybackControl無効時は警告 | E-01 L360-365 hasPlaybackControl判定 | ○ |
| C-16 (UT-AUD-016) | 再生が停止されること | E-01 L400-422 stop()定義 | ○ |
| C-17 (UT-AUD-017) | 遅延停止が機能すること | E-01 L413 stop(currentTime + delay) | ○ |
| C-18 (UT-AUD-018) | stop()でplaybackControl無効時は警告 | E-01 L402-407 hasPlaybackControl判定 | ○ |
| C-19 (UT-AUD-019) | フィルタなしで接続されること | E-01 L430-454 connect()定義 | ○ |
| C-20 (UT-AUD-020) | フィルタありで接続されること | E-01 L432-442 filtersチェーン処理 | ○ |
| C-21 (UT-AUD-021) | フィルタなしで切断されること | E-01 L462-492 disconnect()定義 | ○ |
| C-22 (UT-AUD-022) | フィルタありで切断されること | E-01 L470-480 filtersチェーン切断 | ○ |
| C-23 (UT-AUD-023) | 未接続時は何もしないこと | E-01 L464-467 _connected判定 | ○ |
| C-24 (UT-AUD-024) | フィルタ配列が返却されること | E-01 L499-503 getFilters()定義 | ○ |
| C-25 (UT-AUD-025) | フィルタ配列が設定されること | E-01 L511-529 setFilters()定義 | ○ |
| C-26 (UT-AUD-026) | 接続中にフィルタ変更時に再接続されること | E-01 L515-519 disconnect/connect | ○ |
| C-27 (UT-AUD-027) | undefinedを渡すと空配列になること | E-01 L513 if(!value) value=[] | ○ |
| C-28 (UT-AUD-028) | デチューン値が設定されること | E-01 L537-549 setDetune()定義 | ○ |
| C-29 (UT-AUD-029) | 再生中は即時適用されること | E-01 L541-544 isPlaying判定 | ○ |
| C-30 (UT-AUD-030) | デチューン値が返却されること | E-01 L556-560 getDetune()定義 | ○ |
| C-31 (UT-AUD-031) | 最初のフィルタが返却されること | E-01 L567-571 getFilter()定義 | ○ |
| C-32 (UT-AUD-032) | フィルタ未設定時はundefinedが返却 | E-01 L569 filters[0]へのアクセス | ○ |
| C-33 (UT-AUD-033) | 単一フィルタが設定されること | E-01 L579-583 setFilter()定義 | ○ |
| C-34 (UT-AUD-034) | undefinedを渡すとフィルタがクリア | E-01 L581 三項演算子 | ○ |
| C-35 (UT-AUD-035) | 再生速度が設定されること | E-01 L593-612 setPlaybackRate()定義 | ○ |
| C-36 (UT-AUD-036) | 再生中は即時適用されること | E-01 L604-607 isPlaying判定 | ○ |
| C-37 (UT-AUD-037) | setPlaybackRateでplaybackControl無効警告 | E-01 L595-600 hasPlaybackControl判定 | ○ |
| C-38 (UT-AUD-038) | 再生速度が返却されること | E-01 L619-623 getPlaybackRate()定義 | ○ |
| C-39 (UT-AUD-039) | 再生終了時に状態がリセットされること | E-01 L628-633 onEnded()定義 | ○ |
| C-40 (UT-AUD-040) | ループフラグが返却されること | E-01 L642-653 getLoop()定義 | ○ |
| C-41 (UT-AUD-041) | getLoopでplaybackControl無効時の処理 | E-01 L644-648 hasPlaybackControl判定 | ○ |
| C-42 (UT-AUD-042) | ループフラグが設定されること | E-01 L663-682 setLoop()定義 | ○ |
| C-43 (UT-AUD-043) | 再生中は即時適用されること | E-01 L674-677 isPlaying判定 | ○ |
| C-44 (UT-AUD-044) | setLoopでplaybackControl無効警告 | E-01 L665-670 hasPlaybackControl判定 | ○ |
| C-45 (UT-AUD-045) | ループ開始位置が設定されること | E-01 L691-697 setLoopStart()定義 | ○ |
| C-46 (UT-AUD-046) | ループ終了位置が設定されること | E-01 L706-712 setLoopEnd()定義 | ○ |
| C-47 (UT-AUD-047) | ボリューム値が返却されること | E-01 L719-723 getVolume()定義 | ○ |
| C-48 (UT-AUD-048) | ボリュームが設定されること | E-01 L731-737 setVolume()定義 | ○ |
| C-49 (UT-AUD-049) | バッファソースタイプの場合にコピー | E-01 L739-768 copy()定義 | ○ |
| C-50 (UT-AUD-050) | バッファ以外のソースタイプで警告 | E-01 L743-748 sourceType判定 | ○ |
| C-51 (UT-AUD-051) | 新しいインスタンスが作成されること | E-01 L770-774 clone()定義 | ○ |
| C-52 (UT-AUD-052) | AudioListenerインスタンス生成 | E-02 L29-76 constructor定義 | ○ |
| C-53 (UT-AUD-053) | gainノードがdestinationに接続 | E-02 L50 gain.connect(destination) | ○ |
| C-54 (UT-AUD-054) | getInput()でgainノード返却 | E-02 L85-89 getInput()定義 | ○ |
| C-55 (UT-AUD-055) | フィルタが削除されること | E-02 L96-109 removeFilter()定義 | ○ |
| C-56 (UT-AUD-056) | フィルタ未設定時は何もしない | E-02 L98 filter判定 | ○ |
| C-57 (UT-AUD-057) | フィルタが返却されること | E-02 L116-120 getFilter()定義 | ○ |
| C-58 (UT-AUD-058) | フィルタが設定されること | E-02 L128-147 setFilter()定義 | ○ |
| C-59 (UT-AUD-059) | 既存フィルタがある場合に置き換え | E-02 L130-139 filter判定分岐 | ○ |
| C-60 (UT-AUD-060) | マスターボリュームが返却 | E-02 L154-158 getMasterVolume()定義 | ○ |
| C-61 (UT-AUD-061) | マスターボリュームが設定 | E-02 L167-173 setMasterVolume()定義 | ○ |
| C-62 (UT-AUD-062) | リスナー位置更新（Chrome/Firefox） | E-02 L189-203 positionX判定分岐 | ○ |
| C-63 (UT-AUD-063) | リスナー位置更新（レガシー） | E-02 L205-208 setPosition/setOrientation | ○ |
| C-64 (UT-AUD-064) | timeDeltaが更新されること | E-02 L181 clock.getDelta() | ○ |
| C-65 (UT-AUD-065) | デフォルトfftSizeでインスタンス生成 | E-03 L36 fftSize=2048デフォルト | ○ |
| C-66 (UT-AUD-066) | カスタムfftSizeでインスタンス生成 | E-03 L36, 44 fftSize設定 | ○ |
| C-67 (UT-AUD-067) | dataがUint8Arrayで初期化 | E-03 L51 new Uint8Array(frequencyBinCount) | ○ |
| C-68 (UT-AUD-068) | audio出力に接続されること | E-03 L53 getOutput().connect(analyser) | ○ |
| C-69 (UT-AUD-069) | 周波数データが返却されること | E-03 L67-73 getFrequencyData()定義 | ○ |
| C-70 (UT-AUD-070) | getByteFrequencyDataが呼ばれる | E-03 L69 analyser.getByteFrequencyData(data) | ○ |
| C-71 (UT-AUD-071) | 平均周波数が計算されること | E-03 L80-93 getAverageFrequency()定義 | ○ |
| C-72 (UT-AUD-072) | データが全て0の場合は0が返却 | E-03 L91 value / data.length | ○ |
| C-73 (UT-AUD-073) | PositionalAudioインスタンス生成 | E-04 L47-61 constructor定義 | ○ |
| C-74 (UT-AUD-074) | pannerがgainに接続されること | E-04 L60 panner.connect(gain) | ○ |
| C-75 (UT-AUD-075) | 親クラスのconnectとpanner接続 | E-04 L64-71 connect()定義 | ○ |
| C-76 (UT-AUD-076) | 親クラスのdisconnectとpanner切断 | E-04 L74-81 disconnect()定義 | ○ |
| C-77 (UT-AUD-077) | pannerノードが返却されること | E-04 L84-88 getOutput()定義 | ○ |
| C-78 (UT-AUD-078) | 参照距離が返却されること | E-04 L95-99 getRefDistance()定義 | ○ |
| C-79 (UT-AUD-079) | 参照距離が設定されること | E-04 L109-115 setRefDistance()定義 | ○ |
| C-80 (UT-AUD-080) | ロールオフファクタが返却 | E-04 L122-126 getRolloffFactor()定義 | ○ |
| C-81 (UT-AUD-081) | ロールオフファクタが設定 | E-04 L134-140 setRolloffFactor()定義 | ○ |
| C-82 (UT-AUD-082) | 距離モデルが返却されること | E-04 L147-151 getDistanceModel()定義 | ○ |
| C-83 (UT-AUD-083) | 距離モデルが設定されること | E-04 L163-169 setDistanceModel()定義 | ○ |
| C-84 (UT-AUD-084) | exponentialモデルが設定できる | E-04 L160 型定義 | ○ |
| C-85 (UT-AUD-085) | 最大距離が返却されること | E-04 L176-180 getMaxDistance()定義 | ○ |
| C-86 (UT-AUD-086) | 最大距離が設定されること | E-04 L191-197 setMaxDistance()定義 | ○ |
| C-87 (UT-AUD-087) | 指向性コーンが設定されること | E-04 L207-215 setDirectionalCone()定義 | ○ |
| C-88 (UT-AUD-088) | coneOuterGain=0で無音設定 | E-04 L211 coneOuterGain設定 | ○ |
| C-89 (UT-AUD-089) | panner位置更新（Chrome/Firefox） | E-04 L229-240 positionX判定分岐 | ○ |
| C-90 (UT-AUD-090) | panner位置更新（レガシー） | E-04 L242-245 setPosition/setOrientation | ○ |
| C-91 (UT-AUD-091) | 未再生時は早期リターン | E-04 L221 hasPlaybackControl && !isPlaying判定 | ○ |
| C-92 (UT-AUD-092) | グローバルコンテキストが返却 | E-05 L15-25 getContext()定義 | ○ |
| C-93 (UT-AUD-093) | 同一インスタンスが返却（シングルトン） | E-05 L17 _context判定 | ○ |
| C-94 (UT-AUD-094) | webkitAudioContextフォールバック | E-05 L19 || window.webkitAudioContext | ○ |
| C-95 (UT-AUD-095) | カスタムコンテキストが設定 | E-05 L32-36 setContext()定義 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースがソースコードに基づいて作成されている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに明確な根拠を持つ
- 1: 中リスク - Web Audio API依存のため、ブラウザ互換性テスト（UT-AUD-062〜063, 089〜090, 094）は実際のブラウザ環境での検証が必要
- 1: 中リスク - 再生制御系テスト（UT-AUD-009〜018）はオーディオコンテキストの状態に依存するため、モック設計が重要

## 6) レビュアーチェックリスト（最小）
- [ ] Audio.jsの再生制御メソッド（play/pause/stop）のテストケースが全パターンを網羅しているか
- [ ] AudioListenerとPositionalAudioのupdateMatrixWorld()のブラウザ互換性テストが適切か
- [ ] AudioAnalyserの周波数データ取得テストがWeb Audio APIの仕様に準拠しているか
- [ ] AudioContextのシングルトンパターンテストが適切か
- [ ] フィルタチェーン接続/切断のテストケースが複数フィルタの場合を考慮しているか
