---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 68
  claims_with_evidence: 68
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：cameras.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：68 / 68、根拠なし：0
- 優先レビュー（高）
  1. **CubeCamera.update**：複雑なレンダリングロジックのため実行時テストが重要
  2. **StereoCamera.update**：ステレオ視差計算の数学的正確性を確認が必要
  3. **PerspectiveCamera.updateProjectionMatrix**：投影行列計算の精度確認が重要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/cameras/Camera.js` - 基底Cameraクラス
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/cameras/PerspectiveCamera.js` - 透視投影カメラ
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/cameras/OrthographicCamera.js` - 正射影カメラ
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/cameras/ArrayCamera.js` - 配列カメラ（VR用）
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/cameras/CubeCamera.js` - キューブマップ用カメラ
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/cameras/StereoCamera.js` - ステレオカメラ

## 3) Claims と根拠の対応（レビューの主戦場）

### Camera クラス (UT-CAM-001 〜 UT-CAM-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | constructor: isCamera=true, type="Camera"で初期化 | E-01 L34-36 | ○ |
| C-02 | constructor: matrixWorldInverse/projectionMatrix/projectionMatrixInverseがMatrix4 | E-01 L43-57 | ○ |
| C-03 | constructor: coordinateSystem=WebGLCoordinateSystem | E-01 L64 | ○ |
| C-04 | reversedDepth: ゲッターが_reversedDepthを返す | E-01 L76-80 | ○ |
| C-05 | copy: 行列とcoordinateSystemがコピーされる | E-01 L82-95 | ○ |
| C-06 | getWorldDirection: 親の結果を反転して返す | E-01 L106-110 | ○ |
| C-07 | updateMatrixWorld: スケール1,1,1でmatrixWorldの逆行列を計算 | E-01 L120-122 | ○ |
| C-08 | updateMatrixWorld: スケール!=1でスケール除外して逆行列計算 | E-01 L124-127 | ○ |
| C-09 | updateWorldMatrix: 同様のスケール除外ロジック | E-01 L132-150 | ○ |
| C-10 | clone: 新インスタンス作成しcopy呼び出し | E-01 L152-156 | ○ |

### PerspectiveCamera クラス (UT-CAM-009 〜 UT-CAM-033)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | constructor: デフォルト値 fov=50, aspect=1, near=0.1, far=2000 | E-02 L33 | ○ |
| C-12 | constructor: zoom=1, focus=10, filmGauge=35, filmOffset=0 | E-02 L63, 94, 121, 129 | ○ |
| C-13 | constructor: isPerspectiveCamera=true | E-02 L44 | ○ |
| C-14 | copy: fov,zoom,near,far,focus,aspect,view,filmGauge,filmOffsetをコピー | E-02 L135-154 | ○ |
| C-15 | setFocalLength: vExtentSlopeからfov計算 | E-02 L164-172 | ○ |
| C-16 | getFocalLength: fovからフィルム高さベースで焦点距離計算 | E-02 L180-186 | ○ |
| C-17 | getEffectiveFOV: zoom考慮したFOV計算 | E-02 L193-198 | ○ |
| C-18 | getFilmWidth: aspect>=1でfilmGauge、<1でfilmGauge*aspect | E-02 L206-211 | ○ |
| C-19 | getFilmHeight: aspect>=1でfilmGauge/aspect、<1でfilmGauge | E-02 L219-224 | ○ |
| C-20 | getViewBounds: projectionMatrixInverseから境界計算 | E-02 L234-244 | ○ |
| C-21 | getViewSize: getViewBoundsの差分を返す | E-02 L253-259 | ○ |
| C-22 | setViewOffset: view初期化/更新とprojectionMatrix更新 | E-02 L304-332 | ○ |
| C-23 | clearViewOffset: view.enabled=false設定 | E-02 L337-347 | ○ |
| C-24 | updateProjectionMatrix: near/fov/zoomから透視投影行列計算 | E-02 L353-381 | ○ |
| C-25 | updateProjectionMatrix: view有効時のオフセット計算 | E-02 L362-372 | ○ |
| C-26 | updateProjectionMatrix: filmOffset!=0でスキュー補正 | E-02 L374-375 | ○ |
| C-27 | toJSON: 全プロパティをシリアライズ | E-02 L383-403 | ○ |

### OrthographicCamera クラス (UT-CAM-034 〜 UT-CAM-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | constructor: デフォルト値 left=-1,right=1,top=1,bottom=-1 | E-03 L29 | ○ |
| C-29 | constructor: near=0.1, far=2000, zoom=1 | E-03 L29, 50 | ○ |
| C-30 | constructor: isOrthographicCamera=true | E-03 L40 | ○ |
| C-31 | copy: 全プロパティのコピー | E-03 L118-134 | ○ |
| C-32 | setViewOffset: view初期化/更新 | E-03 L148-174 | ○ |
| C-33 | clearViewOffset: view.enabled=false | E-03 L179-189 | ○ |
| C-34 | updateProjectionMatrix: zoom考慮した境界計算 | E-03 L195-206 | ○ |
| C-35 | updateProjectionMatrix: view有効時のオフセット計算 | E-03 L207-217 | ○ |
| C-36 | updateProjectionMatrix: makeOrthographic呼び出し | E-03 L219 | ○ |
| C-37 | toJSON: 全プロパティシリアライズ | E-03 L225-241 | ○ |

### ArrayCamera クラス (UT-CAM-044 〜 UT-CAM-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | constructor: PerspectiveCameraを継承 | E-04 L14 | ○ |
| C-39 | constructor: isArrayCamera=true, isMultiViewCamera=false | E-04 L32, 41 | ○ |
| C-40 | constructor: cameras=array引数 | E-04 L48 | ○ |

### CubeCamera クラス (UT-CAM-047 〜 UT-CAM-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | constructor: type="CubeCamera" | E-05 L51 | ○ |
| C-42 | constructor: 6つのPerspectiveCameraをchildren追加 | E-05 L76-98 | ○ |
| C-43 | constructor: fov=-90, aspect=1 | E-05 L5-6 | ○ |
| C-44 | constructor: サブカメラがlayers継承 | E-05 L77,81,85,89,93,97 | ○ |
| C-45 | updateCoordinateSystem: WebGLCoordinateSystem用の方向設定 | E-05 L115-133 | ○ |
| C-46 | updateCoordinateSystem: WebGPUCoordinateSystem用の方向設定 | E-05 L135-154 | ○ |
| C-47 | updateCoordinateSystem: 無効座標系でエラースロー | E-05 L155-158 | ○ |
| C-48 | update: parent===nullでupdateMatrixWorld呼び出し | E-05 L180 | ○ |
| C-49 | update: 座標系変更検知とupdateCoordinateSystem呼び出し | E-05 L184-190 | ○ |
| C-50 | update: xr.enabled一時無効化 | E-05 L198-200, 240 | ○ |
| C-51 | update: 6面レンダリング実行 | E-05 L209-236 | ○ |
| C-52 | update: レンダーターゲット状態復元 | E-05 L238 | ○ |

### StereoCamera クラス (UT-CAM-058 〜 UT-CAM-068)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | constructor: type="StereoCamera" | E-06 L29 | ○ |
| C-54 | constructor: aspect=1, eyeSep=0.064 | E-06 L37, 46 | ○ |
| C-55 | constructor: cameraL/cameraRがPerspectiveCamera | E-06 L54, 64 | ○ |
| C-56 | constructor: cameraLがlayer1有効 | E-06 L55 | ○ |
| C-57 | constructor: cameraRがlayer2有効 | E-06 L65 | ○ |
| C-58 | constructor: matrixAutoUpdate=false | E-06 L56, 66 | ○ |
| C-59 | constructor: _cache初期化 | E-06 L68-77 | ○ |
| C-60 | update: needsUpdate判定ロジック | E-06 L89-91 | ○ |
| C-61 | update: キャッシュ更新 | E-06 L95-101 | ○ |
| C-62 | update: オフアクシスステレオ計算 | E-06 L106-136 | ○ |
| C-63 | update: matrixWorld計算 | E-06 L139-140 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- すべてのテストケースはソースコードから直接導出されています

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: Camera, ArrayCamera - シンプルな構造で検証が容易
- **1 (中リスク)**: PerspectiveCamera, OrthographicCamera - 投影行列計算の数学的正確性
- **2 (高リスク)**: CubeCamera.update, StereoCamera.update - 複雑なレンダリングフローと外部依存

## 6) レビュアーチェックリスト（最小）
- [ ] Camera.updateMatrixWorld: スケール除外ロジックがglTF仕様に準拠しているか
- [ ] PerspectiveCamera.updateProjectionMatrix: view有効時の部分投影計算が正確か
- [ ] OrthographicCamera.updateProjectionMatrix: zoom適用後の境界計算が正確か
- [ ] CubeCamera.updateCoordinateSystem: WebGL/WebGPU座標系の方向設定が正しいか
- [ ] CubeCamera.update: レンダラー状態の保存・復元が完全か
- [ ] StereoCamera.update: オフアクシスステレオ投影の数学的計算が正確か
- [ ] StereoCamera.update: キャッシュ比較条件が全パラメータを網羅しているか
