---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 221
  claims_with_evidence: 221
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：core.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：221 / 221、根拠なし：0
- 優先レビュー（高）
  1. **Object3D関連（UT-COR-009〜056）**：シーングラフの中核機能、多数のメソッド
  2. **BufferGeometry関連（UT-COR-057〜096）**：ジオメトリ操作の基盤
  3. **BufferAttribute関連（UT-COR-097〜122）**：頂点データ管理の基盤

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/core/EventDispatcher.js` - イベントディスパッチャークラス
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/core/Object3D.js` - 3Dオブジェクト基底クラス
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/core/BufferGeometry.js` - バッファジオメトリクラス
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/core/BufferAttribute.js` - バッファ属性クラス群
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/core/Raycaster.js` - レイキャスタークラス
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/core/Layers.js` - レイヤー管理クラス
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/core/Clock.js` - クロッククラス（非推奨）
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/core/Timer.js` - タイマークラス
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/core/Uniform.js` - ユニフォームクラス
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/core/UniformsGroup.js` - ユニフォームグループクラス
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/core/InterleavedBuffer.js` - インターリーブバッファクラス
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/core/InterleavedBufferAttribute.js` - インターリーブバッファ属性クラス
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/core/RenderTarget.js` - レンダーターゲットクラス
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/core/RenderTarget3D.js` - 3Dレンダーターゲットクラス
- E-15: `/Users/tomoka.baba/Work/three.js-dev/src/core/InstancedBufferAttribute.js` - インスタンスバッファ属性クラス
- E-16: `/Users/tomoka.baba/Work/three.js-dev/src/core/InstancedBufferGeometry.js` - インスタンスバッファジオメトリクラス
- E-17: `/Users/tomoka.baba/Work/three.js-dev/src/core/InstancedInterleavedBuffer.js` - インスタンスインターリーブバッファクラス
- E-18: `/Users/tomoka.baba/Work/three.js-dev/src/core/GLBufferAttribute.js` - GLバッファ属性クラス

## 3) Claims と根拠の対応（レビューの主戦場）

### EventDispatcher（UT-COR-001〜008）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | addEventListener正常系 | E-01 L31-48 | ○ |
| C-02 | addEventListener重複防止 | E-01 L43 | ○ |
| C-03 | hasEventListener存在確認 | E-01 L58-65 | ○ |
| C-04 | hasEventListener不在確認 | E-01 L58-65 | ○ |
| C-05 | removeEventListener正常系 | E-01 L74-93 | ○ |
| C-06 | removeEventListener堅牢性 | E-01 L82-89 | ○ |
| C-07 | dispatchEvent通知 | E-01 L101-126 | ○ |
| C-08 | event.target設定 | E-01 L111, L122 | ○ |

### Object3D（UT-COR-009〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | constructor初期化 | E-02 L69-387 | ○ |
| C-10 | add正常系 | E-02 L744-785 | ○ |
| C-11 | add自己参照防止 | E-02 L758-763 | ○ |
| C-12 | add型チェック | E-02 L777-779 | ○ |
| C-13 | remove正常系 | E-02 L796-827 | ○ |
| C-14 | remove堅牢性 | E-02 L810-823 | ○ |
| C-15 | removeFromParent | E-02 L836-847 | ○ |
| C-16 | clear | E-02 L857-860 | ○ |
| C-17 | attach | E-02 L872-905 | ○ |
| C-18 | getObjectById | E-02 L915-918 | ○ |
| C-19 | getObjectById存在しない | E-02 L942-960 | ○ |
| C-20 | getObjectByName | E-02 L928-930 | ○ |
| C-21 | getObjectByProperty | E-02 L942-960 | ○ |
| C-22 | getObjectsByProperty | E-02 L972-985 | ○ |
| C-23 | applyMatrix4 | E-02 L446-453 | ○ |
| C-24 | applyQuaternion | E-02 L462-467 | ○ |
| C-25 | setRotationFromAxisAngle | E-02 L476-481 | ○ |
| C-26 | setRotationFromEuler | E-02 L489-492 | ○ |
| C-27 | setRotationFromMatrix | E-02 L501-506 | ○ |
| C-28 | setRotationFromQuaternion | E-02 L514-519 | ○ |
| C-29 | rotateOnAxis | E-02 L529-539 | ○ |
| C-30 | rotateOnWorldAxis | E-02 L549-560 | ○ |
| C-31 | rotateX | E-02 L569-572 | ○ |
| C-32 | rotateY | E-02 L581-584 | ○ |
| C-33 | rotateZ | E-02 L593-596 | ○ |
| C-34 | translateOnAxis | E-02 L606-616 | ○ |
| C-35 | translateX | E-02 L625-628 | ○ |
| C-36 | translateY | E-02 L637-640 | ○ |
| C-37 | translateZ | E-02 L649-652 | ○ |
| C-38 | localToWorld | E-02 L661-666 | ○ |
| C-39 | worldToLocal | E-02 L675-680 | ○ |
| C-40 | lookAt(Vector3) | E-02 L692-731 | ○ |
| C-41 | lookAt(x,y,z) | E-02 L700-703 | ○ |
| C-42 | getWorldPosition | E-02 L994-999 | ○ |
| C-43 | getWorldQuaternion | E-02 L1008-1015 | ○ |
| C-44 | getWorldScale | E-02 L1024-1031 | ○ |
| C-45 | getWorldDirection | E-02 L1040-1047 | ○ |
| C-46 | traverse | E-02 L1068-1079 | ○ |
| C-47 | traverseVisible | E-02 L1090-1103 | ○ |
| C-48 | traverseAncestors | E-02 L1113-1124 | ○ |
| C-49 | updateMatrix | E-02 L1131-1149 | ○ |
| C-50 | updateMatrix(pivot) | E-02 L1135-1146 | ○ |
| C-51 | updateMatrixWorld | E-02 L1163-1200 | ○ |
| C-52 | updateWorldMatrix | E-02 L1210-1251 | ○ |
| C-53 | clone(recursive=true) | E-02 L1569-1572 | ○ |
| C-54 | clone(recursive=false) | E-02 L1622-1630 | ○ |
| C-55 | copy | E-02 L1582-1634 | ○ |
| C-56 | toJSON | E-02 L1261-1560 | ○ |

### BufferGeometry（UT-COR-057〜096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | constructor | E-03 L53-197 | ○ |
| C-58 | setAttribute | E-03 L280-285 | ○ |
| C-59 | getAttribute | E-03 L267-270 | ○ |
| C-60 | getAttribute未設定 | E-03 L267-270 | ○ |
| C-61 | deleteAttribute | E-03 L294-299 | ○ |
| C-62 | hasAttribute | E-03 L308-311 | ○ |
| C-63 | setIndex(Array) | E-03 L217-230 | ○ |
| C-64 | setIndex(BufferAttribute) | E-03 L223-226 | ○ |
| C-65 | getIndex | E-03 L205-208 | ○ |
| C-66 | setIndirect | E-03 L240-246 | ○ |
| C-67 | getIndirect | E-03 L254-257 | ○ |
| C-68 | addGroup | E-03 L322-331 | ○ |
| C-69 | clearGroups | E-03 L337-340 | ○ |
| C-70 | setDrawRange | E-03 L350-354 | ○ |
| C-71 | applyMatrix4 | E-03 L363-410 | ○ |
| C-72 | applyQuaternion | E-03 L419-426 | ○ |
| C-73 | rotateX | E-03 L437-446 | ○ |
| C-74 | rotateY | E-03 L457-466 | ○ |
| C-75 | rotateZ | E-03 L477-486 | ○ |
| C-76 | translate | E-03 L499-508 | ○ |
| C-77 | scale | E-03 L521-530 | ○ |
| C-78 | lookAt | E-03 L541-550 | ○ |
| C-79 | center | E-03 L558-567 | ○ |
| C-80 | setFromPoints | E-03 L581-620 | ○ |
| C-81 | setFromPoints(Vector2) | E-03 L592 | ○ |
| C-82 | computeBoundingBox | E-03 L628-695 | ○ |
| C-83 | computeBoundingBox(GLBuffer) | E-03 L639-648 | ○ |
| C-84 | computeBoundingSphere | E-03 L703-812 | ○ |
| C-85 | computeBoundingSphere(NaN) | E-03 L805-808 | ○ |
| C-86 | computeTangents | E-03 L822-978 | ○ |
| C-87 | computeTangents(error) | E-03 L830-837 | ○ |
| C-88 | computeVertexNormals(indexed) | E-03 L987-1075 | ○ |
| C-89 | computeVertexNormals(non-indexed) | E-03 L1049-1067 | ○ |
| C-90 | normalizeNormals | E-03 L1083-1096 | ○ |
| C-91 | toNonIndexed | E-03 L1105-1204 | ○ |
| C-92 | toNonIndexed(already) | E-03 L1143-1147 | ○ |
| C-93 | clone | E-03 L1327-1330 | ○ |
| C-94 | copy | E-03 L1339-1441 | ○ |
| C-95 | toJSON | E-03 L1212-1319 | ○ |
| C-96 | dispose | E-03 L1450-1453 | ○ |

### BufferAttribute（UT-COR-097〜122）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | constructor(TypedArray) | E-04 L29-135 | ○ |
| C-98 | constructor(Array)例外 | E-04 L31-35 | ○ |
| C-99 | setUsage | E-04 L164-170 | ○ |
| C-100 | addUpdateRange | E-04 L178-181 | ○ |
| C-101 | clearUpdateRanges | E-04 L187-190 | ○ |
| C-102 | copy | E-04 L199-211 | ○ |
| C-103 | copyAt | E-04 L224-236 | ○ |
| C-104 | copyArray | E-04 L245-250 | ○ |
| C-105 | applyMatrix3(itemSize=3) | E-04 L273-284 | ○ |
| C-106 | applyMatrix3(itemSize=2) | E-04 L262-271 | ○ |
| C-107 | applyMatrix4 | E-04 L297-310 | ○ |
| C-108 | applyNormalMatrix | E-04 L320-333 | ○ |
| C-109 | transformDirection | E-04 L343-356 | ○ |
| C-110 | set | E-04 L366-372 | ○ |
| C-111 | getComponent | E-04 L382-389 | ○ |
| C-112 | getComponent(normalized) | E-04 L386-387 | ○ |
| C-113 | setComponent | E-04 L400-407 | ○ |
| C-114 | getX/Y/Z/W | E-04 L416-522 | ○ |
| C-115 | setX/Y/Z/W | E-04 L433-539 | ○ |
| C-116 | setXY | E-04 L550-565 | ○ |
| C-117 | setXYZ | E-04 L577-594 | ○ |
| C-118 | setXYZW | E-04 L607-626 | ○ |
| C-119 | needsUpdate | E-04 L152-156 | ○ |
| C-120 | onUpload | E-04 L637-642 | ○ |
| C-121 | clone | E-04 L650-653 | ○ |
| C-122 | toJSON | E-04 L661-675 | ○ |

### Float16BufferAttribute（UT-COR-123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | Float16変換 | E-04 L849-1005 | ○ |

### Raycaster（UT-COR-124〜133）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | constructor | E-05 L23-95 | ○ |
| C-125 | set | E-05 L104-109 | ○ |
| C-126 | setFromCamera(perspective) | E-05 L119-125 | ○ |
| C-127 | setFromCamera(orthographic) | E-05 L127-131 | ○ |
| C-128 | setFromCamera(error) | E-05 L133-136 | ○ |
| C-129 | setFromXRController | E-05 L147-155 | ○ |
| C-130 | intersectObject | E-05 L194-201 | ○ |
| C-131 | intersectObject(sort) | E-05 L198 | ○ |
| C-132 | intersectObjects | E-05 L214-225 | ○ |
| C-133 | intersectObjects(layers) | E-05 L240 | ○ |

### Layers（UT-COR-134〜143）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 | constructor | E-06 L19-28 | ○ |
| C-135 | set | E-06 L36-39 | ○ |
| C-136 | enable | E-06 L47-49 | ○ |
| C-137 | enableAll | E-06 L56-58 | ○ |
| C-138 | toggle | E-06 L67-69 | ○ |
| C-139 | disable | E-06 L78-80 | ○ |
| C-140 | disableAll | E-06 L87-89 | ○ |
| C-141 | test(true) | E-06 L100-103 | ○ |
| C-142 | test(false) | E-06 L100-103 | ○ |
| C-143 | isEnabled | E-06 L112-115 | ○ |

### Clock（UT-COR-144〜149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-144 | constructor | E-07 L17-62 | ○ |
| C-145 | start | E-07 L69-77 | ○ |
| C-146 | stop | E-07 L82-87 | ○ |
| C-147 | getElapsedTime | E-07 L95-99 | ○ |
| C-148 | getDelta | E-07 L107-130 | ○ |
| C-149 | getDelta(autoStart) | E-07 L111-115 | ○ |

### Timer（UT-COR-150〜161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | constructor | E-08 L20-33 | ○ |
| C-151 | connect | E-08 L43-56 | ○ |
| C-152 | disconnect | E-08 L62-72 | ○ |
| C-153 | getDelta | E-08 L80-83 | ○ |
| C-154 | getElapsed | E-08 L91-94 | ○ |
| C-155 | getTimescale | E-08 L102-105 | ○ |
| C-156 | setTimescale | E-08 L115-120 | ○ |
| C-157 | reset | E-08 L128-133 | ○ |
| C-158 | update | E-08 L156-173 | ○ |
| C-159 | update(timescale) | E-08 L167 | ○ |
| C-160 | update(hidden) | E-08 L158-161 | ○ |
| C-161 | dispose | E-08 L140-143 | ○ |

### Uniform（UT-COR-162〜164）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-162 | constructor | E-09 L21-29 | ○ |
| C-163 | clone(cloneable) | E-09 L38-41 | ○ |
| C-164 | clone(primitive) | E-09 L40 | ○ |

### UniformsGroup（UT-COR-165〜172）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-165 | constructor | E-10 L20-63 | ○ |
| C-166 | add | E-10 L72-77 | ○ |
| C-167 | remove | E-10 L86-93 | ○ |
| C-168 | setName | E-10 L102-107 | ○ |
| C-169 | setUsage | E-10 L116-121 | ○ |
| C-170 | dispose | E-10 L130-133 | ○ |
| C-171 | copy | E-10 L142-164 | ○ |
| C-172 | clone | E-10 L172-175 | ○ |

### InterleavedBuffer（UT-COR-173〜182）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-173 | constructor | E-11 L18-84 | ○ |
| C-174 | setUsage | E-11 L113-118 | ○ |
| C-175 | addUpdateRange | E-11 L127-130 | ○ |
| C-176 | clearUpdateRanges | E-11 L136-139 | ○ |
| C-177 | copy | E-11 L148-156 | ○ |
| C-178 | copyAt | E-11 L169-181 | ○ |
| C-179 | set | E-11 L191-196 | ○ |
| C-180 | clone | E-11 L205-231 | ○ |
| C-181 | needsUpdate | E-11 L101-105 | ○ |
| C-182 | toJSON | E-11 L256-286 | ○ |

### InterleavedBufferAttribute（UT-COR-183〜196）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-183 | constructor | E-12 L23-68 | ○ |
| C-184 | count getter | E-12 L77-80 | ○ |
| C-185 | array getter | E-12 L88-91 | ○ |
| C-186 | needsUpdate | E-12 L102-105 | ○ |
| C-187 | applyMatrix4 | E-12 L115-128 | ○ |
| C-188 | applyNormalMatrix | E-12 L138-152 | ○ |
| C-189 | transformDirection | E-12 L161-174 | ○ |
| C-190 | getComponent/setComponent | E-12 L184-208 | ○ |
| C-191 | getX/Y/Z/W | E-12 L286-341 | ○ |
| C-192 | setX/Y/Z/W | E-12 L219-277 | ○ |
| C-193 | setXY/XYZ/XYZW | E-12 L352-428 | ○ |
| C-194 | clone(de-interleave) | E-12 L439-459 | ○ |
| C-195 | clone(keep interleaved) | E-12 L461-476 | ○ |
| C-196 | toJSON | E-12 L489-542 | ○ |

### RenderTarget（UT-COR-197〜204）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-197 | constructor | E-13 L49-202 | ○ |
| C-198 | texture getter | E-13 L242-245 | ○ |
| C-199 | depthTexture | E-13 L254-275 | ○ |
| C-200 | setSize | E-13 L284-316 | ○ |
| C-201 | setSize(dispose) | E-13 L310 | ○ |
| C-202 | clone | E-13 L324-327 | ○ |
| C-203 | copy | E-13 L338-374 | ○ |
| C-204 | dispose | E-13 L384-387 | ○ |

### RenderTarget3D（UT-COR-205）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-205 | constructor | E-14 L19-44 | ○ |

### InstancedBufferAttribute（UT-COR-206〜208）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-206 | constructor | E-15 L18-41 | ○ |
| C-207 | copy | E-15 L44-51 | ○ |
| C-208 | toJSON | E-15 L54-64 | ○ |

### InstancedBufferGeometry（UT-COR-209〜211）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-209 | constructor | E-16 L11-33 | ○ |
| C-210 | copy | E-16 L36-43 | ○ |
| C-211 | toJSON | E-16 L46-56 | ○ |

### InstancedInterleavedBuffer（UT-COR-212〜215）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-212 | constructor | E-17 L17-38 | ○ |
| C-213 | copy | E-17 L41-48 | ○ |
| C-214 | clone | E-17 L51-58 | ○ |
| C-215 | toJSON | E-17 L61-70 | ○ |

### GLBufferAttribute（UT-COR-216〜221）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-216 | constructor | E-18 L24-94 | ○ |
| C-217 | setBuffer | E-18 L117-122 | ○ |
| C-218 | setType | E-18 L132-138 | ○ |
| C-219 | setItemSize | E-18 L147-152 | ○ |
| C-220 | setCount | E-18 L161-166 | ○ |
| C-221 | needsUpdate | E-18 L105-108 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全221件のテストケースについて、ソースコードから直接メソッド・プロパティの存在と動作を確認済み。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいて生成されており、根拠が明確

注意点：
- Clock クラスは非推奨（deprecated）のため、新規プロジェクトではTimerの使用を推奨
- GLBufferAttributeはWebGLRendererでのみ使用可能
- RenderTarget3DやInstanced系クラスは特定のレンダラー/機能でのみ必要

## 6) レビュアーチェックリスト（最小）
- [ ] Object3D のシーングラフ操作（add/remove/attach）のテストケースが網羅されているか
- [ ] BufferGeometry の境界計算（computeBoundingBox/computeBoundingSphere）の異常系が含まれているか
- [ ] BufferAttribute の正規化（normalized）対応テストが含まれているか
- [ ] Raycaster のカメラタイプ別テスト（Perspective/Orthographic）が含まれているか
- [ ] Timer の Page Visibility API 対応テストが含まれているか
- [ ] インスタンス化関連クラス（InstancedBufferAttribute等）の meshPerAttribute テストが含まれているか
