---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 148
  claims_with_evidence: 148
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：extras モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：148 / 148、根拠なし：0
- 優先レビュー（高）
  1. **PMREMGenerator**: 複雑なシェーダー処理のためレンダリング環境依存のテストが必要
  2. **ImageUtils.sRGBToLinear**: DOM環境依存のためモック化が必要
  3. **ShapePath.toShapes**: 複雑な穴判定ロジックのため境界ケースの追加検討

## 2) 参照した情報（Evidence一覧）
> 解析したソースコードファイル一覧

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/extras/DataUtils.js`
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/extras/core/Curve.js`
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/extras/core/CurvePath.js`
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/extras/core/Path.js`
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/extras/core/Shape.js`
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/extras/core/ShapePath.js`
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/extras/core/Interpolations.js`
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/extras/ShapeUtils.js`
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/extras/TextureUtils.js`
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/extras/ImageUtils.js`
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/extras/Controls.js`
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/extras/Earcut.js`
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/extras/PMREMGenerator.js`
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/LineCurve.js`
- E-15: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/LineCurve3.js`
- E-16: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/EllipseCurve.js`
- E-17: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/ArcCurve.js`
- E-18: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/CatmullRomCurve3.js`
- E-19: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/SplineCurve.js`
- E-20: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/QuadraticBezierCurve.js`
- E-21: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/QuadraticBezierCurve3.js`
- E-22: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/CubicBezierCurve.js`
- E-23: `/Users/tomoka.baba/Work/three.js-dev/src/extras/curves/CubicBezierCurve3.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### DataUtils (UT-EXT-001 ~ UT-EXT-007)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | toHalfFloatがFP32からFP16に変換する | E-01: L150-160 | ○ |
| C-02 | 65504を超える値で警告が出力される | E-01: L152 `warn()` 呼び出し | ○ |
| C-03 | fromHalfFloatがFP16からFP32に変換する | E-01: L170-175 | ○ |

### Curve基底クラス (UT-EXT-008 ~ UT-EXT-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-04 | constructorでデフォルト値が設定される | E-02: L18-56 | ○ |
| C-05 | getPointは抽象メソッドで警告を出す | E-02: L68-72 `warn()` | ○ |
| C-06 | getPointAtがgetUtoTmappingを使用する | E-02: L83-87 | ○ |
| C-07 | getPointsがdivisions+1個のポイントを返す | E-02: L97-108 | ○ |
| C-08 | getLengthsがキャッシュを使用する | E-02: L153-183 | ○ |
| C-09 | getUtoTmappingが二分探索を使用する | E-02: L208-280 | ○ |
| C-10 | getTangentがdelta=0.0001で近似計算する | E-02: L293-312 | ○ |
| C-11 | computeFrenetFramesがtangents/normals/binormalsを返す | E-02: L338-448 | ○ |

### CurvePath (UT-EXT-031 ~ UT-EXT-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 | addがcurves配列に追加する | E-03: L45-49 | ○ |
| C-13 | closePathが始点と終点が異なる場合LineCurveを追加する | E-03: L56-70 | ○ |
| C-14 | getPointがパス全体の長さに基づいて計算する | E-03: L81-117 | ○ |
| C-15 | getCurveLengthsがキャッシュを使用する | E-03: L148-177 | ○ |
| C-16 | getPointsが曲線タイプに応じた解像度を使用する | E-03: L199-235 | ○ |

### Path (UT-EXT-044 ~ UT-EXT-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | constructorでポイント配列からLineCurveを作成する | E-04: L38-56 | ○ |
| C-18 | lineToがLineCurveを追加する | E-04: L103-112 | ○ |
| C-19 | quadraticCurveToがQuadraticBezierCurveを追加する | E-04: L124-138 | ○ |
| C-20 | bezierCurveToがCubicBezierCurveを追加する | E-04: L152-167 | ○ |
| C-21 | absellipseが既存曲線とLineCurveで接続する | E-04: L270-293 | ○ |

### Shape (UT-EXT-057 ~ UT-EXT-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | constructorでUUIDが生成される | E-05: L42-52 `generateUUID()` | ○ |
| C-23 | getPointsHolesが全穴のポイントを返す | E-05: L74-86 | ○ |
| C-24 | extractPointsがshapeとholesを含むオブジェクトを返す | E-05: L97-106 | ○ |

### ShapePath (UT-EXT-064 ~ UT-EXT-073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | moveToが新しいPathを作成しsubPathsに追加する | E-06: L51-58 | ○ |
| C-26 | toShapesが穴を正しく割り当てる | E-06: L137-361 isPointInsidePolygon | ○ |
| C-27 | toShapesがisCCWで巻き方向を反転する | E-06: L236-237 | ○ |

### Interpolations (UT-EXT-074 ~ UT-EXT-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-28 | CatmullRomがスプライン補間を計算する | E-07: L19-27 | ○ |
| C-29 | QuadraticBezierが2次ベジエを計算する | E-07: L59-64 | ○ |
| C-30 | CubicBezierが3次ベジエを計算する | E-07: L104-108 | ○ |

### ShapeUtils (UT-EXT-083 ~ UT-EXT-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | areaが符号付き面積を計算する | E-08: L16-29 | ○ |
| C-32 | isClockWiseがarea < 0で判定する | E-08: L37-40 | ○ |
| C-33 | triangulateShapeがEarcutを使用する | E-08: L50-87 | ○ |

### TextureUtils (UT-EXT-090 ~ UT-EXT-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | containがアスペクト比を保持してフィットする | E-09: L12-35 | ○ |
| C-35 | coverが全体を覆うようにスケールする | E-09: L47-70 | ○ |
| C-36 | getByteLengthがフォーマットに応じたバイト長を計算する | E-09: L100-200 | ○ |
| C-37 | 不明なフォーマットでErrorをスローする | E-09: L197-199 `throw new Error` | ○ |

### ImageUtils (UT-EXT-098 ~ UT-EXT-102)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | getDataURLがdata:で始まる場合そのまま返す | E-10: L22-26 | ○ |
| C-39 | sRGBToLinearがSRGBToLinear関数を使用する | E-10: L73-131 | ○ |
| C-40 | サポートされない型でwarnを出力する | E-10: L128-129 | ○ |

### Controls (UT-EXT-103 ~ UT-EXT-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 | constructorでプロパティが初期化される | E-11: L18-75 | ○ |
| C-42 | connectでdomElementが設定される | E-11: L84-96 | ○ |
| C-43 | elementが未定義でwarnを出力する | E-11: L86-89 | ○ |

### Earcut (UT-EXT-107 ~ UT-EXT-108)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | triangulateがearcut関数を呼び出す | E-12: L20-24 | ○ |

### PMREMGenerator (UT-EXT-109 ~ UT-EXT-116)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | fromSceneがシーンからPMREMを生成する | E-13: L109-141 | ○ |
| C-46 | fromEquirectangularが_fromTextureを呼び出す | E-13: L152-155 | ○ |
| C-47 | disposeがリソースを解放する | E-13: L208-221 | ○ |

### 各種Curve実装 (UT-EXT-117 ~ UT-EXT-148)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | LineCurve.getPointが線形補間する | E-14: L55-71 | ○ |
| C-49 | LineCurve.getTangentが正規化ベクトルを返す | E-14: L81-85 | ○ |
| C-50 | EllipseCurve.getPointが角度から位置を計算する | E-16: L131-190 | ○ |
| C-51 | EllipseCurve.getPointがaRotationで回転する | E-16: L175-186 | ○ |
| C-52 | ArcCurveがxRadius=yRadiusで初期化する | E-17: L20-22 | ○ |
| C-53 | CatmullRomCurve3.getPointがcurveTypeで分岐する | E-18: L225-248 | ○ |
| C-54 | SplineCurve.getPointがCatmullRom関数を使用する | E-19: L82-85 | ○ |
| C-55 | QuadraticBezierCurve.getPointがQuadraticBezier関数を使用する | E-20: L86-91 | ○ |
| C-56 | CubicBezierCurve.getPointがCubicBezier関数を使用する | E-22: L95-100 | ○ |
| C-57 | 各Curveがcopy/toJSON/fromJSONを実装する | E-14~E-23 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし
  - 全テストケースがソースコードに基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 基本的な曲線クラス（LineCurve, CurvePath等）- 数学的計算のためテストが容易
- **1: 中リスク**: シリアライズ/デシリアライズ処理 - JSONフォーマットの互換性確認が必要
- **2: 高リスク**:
  - PMREMGenerator: WebGLレンダラーとの統合テストが必要
  - ImageUtils.sRGBToLinear: DOM API（Canvas, ImageData）のモック化が必要
  - ShapePath.toShapes: 複雑な穴判定ロジックの境界ケース

## 6) レビュアーチェックリスト（最小）
- [ ] DataUtils: FP16変換の精度が許容範囲内か確認
- [ ] Curve: getUtoTmapping の二分探索が正しく動作するか確認
- [ ] ShapePath.toShapes: 複数の穴を持つ形状のテストケースが十分か確認
- [ ] PMREMGenerator: WebGLコンテキストのモック化方針を確認
- [ ] EllipseCurve: deltaAngleの正規化ロジックの境界ケースを確認
- [ ] 全Curveクラス: toJSON/fromJSONの往復変換テストを確認
