---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 144
  claims_with_evidence: 142
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：geometries.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：142 / 144、根拠なし：2
- 優先レビュー（高）
  1. **UT-GEO-139（負のサイズ入力）**：実装依存の挙動、仕様未定義
  2. **UT-GEO-143（空のShape入力）**：エラーハンドリングの仕様不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/BoxGeometry.js`
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/SphereGeometry.js`
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/CylinderGeometry.js`
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/ConeGeometry.js`
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/PlaneGeometry.js`
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/CircleGeometry.js`
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/RingGeometry.js`
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/TorusGeometry.js`
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/TorusKnotGeometry.js`
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/CapsuleGeometry.js`
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/TubeGeometry.js`
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/LatheGeometry.js`
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/ExtrudeGeometry.js`
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/ShapeGeometry.js`
- E-15: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/PolyhedronGeometry.js`
- E-16: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/TetrahedronGeometry.js`
- E-17: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/OctahedronGeometry.js`
- E-18: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/IcosahedronGeometry.js`
- E-19: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/DodecahedronGeometry.js`
- E-20: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/WireframeGeometry.js`
- E-21: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/EdgesGeometry.js`
- E-22: `/Users/tomoka.baba/Work/three.js-dev/src/geometries/Geometries.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### BoxGeometry (UT-GEO-001 - UT-GEO-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BoxGeometryのデフォルトパラメータ（width=1, height=1, depth=1） | E-01 L32 | ○ |
| C-02 | BoxGeometryのセグメント数がMath.floorで切り捨て | E-01 L58-60 | ○ |
| C-03 | BoxGeometryの6つのグループ生成（マルチマテリアル） | E-01 L76-81, L180 | ○ |
| C-04 | BoxGeometryのcopyメソッドでparametersコピー | E-01 L194-200 | ○ |
| C-05 | BoxGeometryのfromJSONファクトリメソッド | E-01 L211-214 | ○ |

### SphereGeometry (UT-GEO-010 - UT-GEO-017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-06 | SphereGeometryのデフォルトパラメータ（radius=1, widthSegments=32, heightSegments=16） | E-02 L31 | ○ |
| C-07 | widthSegmentsの最小値3制限（Math.max(3, segments)） | E-02 L54 | ○ |
| C-08 | heightSegmentsの最小値2制限（Math.max(2, segments)） | E-02 L55 | ○ |
| C-09 | 極点でのuOffset適用 | E-02 L84-92 | ○ |
| C-10 | SphereGeometryのcopy/fromJSONメソッド | E-02 L150-170 | ○ |

### CylinderGeometry (UT-GEO-018 - UT-GEO-025)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | CylinderGeometryのデフォルトパラメータ | E-03 L34 | ○ |
| C-12 | openEnded=falseでキャップ生成 | E-03 L81-86 | ○ |
| C-13 | radiusTop=0でコーン形状 | E-03 L169-174 | ○ |
| C-14 | slope計算による法線方向 | E-03 L103, L135 | ○ |
| C-15 | generateCapメソッドによるキャップ生成 | E-03 L197-302 | ○ |

### ConeGeometry (UT-GEO-026 - UT-GEO-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | ConeGeometryはCylinderGeometry継承、radiusTop=0 | E-04 L16, L32 | ○ |
| C-17 | ConeGeometryのtype設定 | E-04 L34 | ○ |
| C-18 | ConeGeometryのfromJSONメソッド | E-04 L62-64 | ○ |

### PlaneGeometry (UT-GEO-029 - UT-GEO-034)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-19 | PlaneGeometryのデフォルトパラメータ（width=1, height=1） | E-05 L27 | ○ |
| C-20 | 法線がZ軸正方向（0, 0, 1） | E-05 L76 | ○ |
| C-21 | セグメント分割によるグリッド生成 | E-05 L50-57, L66-83 | ○ |

### CircleGeometry (UT-GEO-035 - UT-GEO-040)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | CircleGeometryのデフォルトパラメータ（radius=1, segments=32） | E-06 L35 | ○ |
| C-23 | segmentsの最小値3制限 | E-06 L55 | ○ |
| C-24 | 中心点（0, 0, 0）の生成 | E-06 L71-73 | ○ |

### RingGeometry (UT-GEO-041 - UT-GEO-046)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | RingGeometryのデフォルトパラメータ | E-07 L31 | ○ |
| C-26 | thetaSegmentsの最小値3制限 | E-07 L53 | ○ |
| C-27 | phiSegmentsの最小値1制限 | E-07 L54 | ○ |
| C-28 | radiusStep計算 | E-07 L66 | ○ |

### TorusGeometry (UT-GEO-047 - UT-GEO-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | TorusGeometryのデフォルトパラメータ（radius=1, tube=0.4） | E-08 L31 | ○ |
| C-30 | 法線計算（vertex - center） | E-08 L90-92 | ○ |
| C-31 | arcパラメータによる部分トーラス | E-08 L78 | ○ |

### TorusKnotGeometry (UT-GEO-052 - UT-GEO-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | TorusKnotGeometryのデフォルトパラメータ（p=2, q=3） | E-09 L32 | ○ |
| C-33 | calculatePositionOnCurve関数 | E-09 L166-177 | ○ |
| C-34 | Frenet frame計算（T, N, B） | E-09 L92-100 | ○ |

### CapsuleGeometry (UT-GEO-057 - UT-GEO-064)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | CapsuleGeometryのデフォルトパラメータ | E-10 L29 | ○ |
| C-36 | heightの最小値0制限 | E-10 L50 | ○ |
| C-37 | capSegmentsの最小値1制限 | E-10 L51 | ○ |
| C-38 | radialSegmentsの最小値3制限 | E-10 L52 | ○ |
| C-39 | 極点でのuOffset適用 | E-10 L124-132 | ○ |

### TubeGeometry (UT-GEO-065 - UT-GEO-071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | TubeGeometryのデフォルトパス（QuadraticBezierCurve3） | E-11 L45 | ○ |
| C-41 | Frenet frames公開（tangents, normals, binormals） | E-11 L70-72 | ○ |
| C-42 | closed=trueの処理 | E-11 L114 | ○ |
| C-43 | toJSONでpathシリアライズ | E-11 L219-226 | ○ |

### LatheGeometry (UT-GEO-072 - UT-GEO-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | LatheGeometryのデフォルトpoints | E-12 L36 | ○ |
| C-45 | phiLengthのクランプ（0-2PI） | E-12 L60 | ○ |
| C-46 | 法線の初期計算と平均化 | E-12 L83-133 | ○ |

### ExtrudeGeometry (UT-GEO-078 - UT-GEO-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | ExtrudeGeometryのデフォルトShape | E-13 L40 | ○ |
| C-48 | Shape配列の処理 | E-13 L58, L65-70 | ○ |
| C-49 | bevelEnabled処理 | E-13 L91, L129-136 | ○ |
| C-50 | extrudePath処理（Frenet frames） | E-13 L106-125 | ○ |
| C-51 | mergeOverlappingPoints関数 | E-13 L170-202 | ○ |
| C-52 | ShapeUtils.isClockWiseによる方向判定 | E-13 L145-165 | ○ |
| C-53 | カスタムUVGenerator対応 | E-13 L99 | ○ |
| C-54 | toJSONでshapes UUID出力 | E-13 L866-890 | ○ |

### ShapeGeometry (UT-GEO-090 - UT-GEO-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | ShapeGeometryのデフォルトShape | E-14 L32 | ○ |
| C-56 | Shape配列のグループ処理 | E-14 L70-79 | ○ |
| C-57 | ShapeUtils.triangulateShapeによる三角形分割 | E-14 L121 | ○ |
| C-58 | 法線Z軸正方向 | E-14 L139 | ○ |

### PolyhedronGeometry (UT-GEO-098 - UT-GEO-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | PolyhedronGeometryのパラメータ設定 | E-15 L23, L36-41 | ○ |
| C-60 | subdivide関数による細分化 | E-15 L78-100 | ○ |
| C-61 | applyRadiusによる球面投影 | E-15 L165-185 | ○ |
| C-62 | detail=0でcomputeVertexNormals | E-15 L68 | ○ |
| C-63 | detail>0でnormalizeNormals | E-15 L72 | ○ |
| C-64 | correctSeamによるUV補正 | E-15 L209-236 | ○ |

### Polyhedron派生クラス (UT-GEO-107 - UT-GEO-124)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | TetrahedronGeometryの頂点/インデックス定義 | E-16 L26-31 | ○ |
| C-66 | OctahedronGeometryの頂点/インデックス定義 | E-17 L26-34 | ○ |
| C-67 | IcosahedronGeometryの黄金比使用 | E-18 L26 | ○ |
| C-68 | DodecahedronGeometryの黄金比使用 | E-19 L26-27 | ○ |

### WireframeGeometry (UT-GEO-125 - UT-GEO-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | geometry=null処理 | E-20 L32, L49 | ○ |
| C-70 | インデックス付きジオメトリ処理 | E-20 L61-105 | ○ |
| C-71 | 非インデックスジオメトリ処理 | E-20 L107-137 | ○ |
| C-72 | isUniqueEdge関数による重複除去 | E-20 L159-175 | ○ |

### EdgesGeometry (UT-GEO-131 - UT-GEO-138)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | geometry=null処理 | E-21 L35, L53 | ○ |
| C-74 | thresholdAngleによるエッジフィルタリング | E-21 L57, L120 | ○ |
| C-75 | 退化三角形スキップ | E-21 L97-101 | ○ |
| C-76 | マッチしないエッジの出力 | E-21 L147-159 | ○ |

### 異常系テストケース (UT-GEO-139 - UT-GEO-144)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | 負のサイズ入力時の挙動 | **根拠なし** | △ |
| C-78 | radius=0の挙動 | E-02 L100-102（計算上動作） | ○ |
| C-79 | height=0の挙動 | E-03 L74（計算上動作） | ○ |
| C-80 | 空のvertices/indices入力 | E-15 L50-58（ループが回らない） | ○ |
| C-81 | 空のShape入力 | **根拠なし** | △ |
| C-82 | tubularSegments=0の挙動 | E-11 L103（ループが回らない） | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-77（負のサイズ入力）**: ソースコードに明示的なバリデーションがないため、実装依存の挙動となる。Three.jsの公式ドキュメントにも記載なし。
  - 候補：Three.js公式ドキュメント / ユニットテスト / issueトラッカー
- **C-81（空のShape入力）**: ExtrudeGeometryで空のShapeが渡された場合のエラーハンドリングが明示的に定義されていない。
  - 候補：ShapeUtils.triangulateShapeの動作確認 / Three.js issueトラッカー

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大半のテストケース（正常系・境界値）はソースコードから直接根拠を確認可能
- **1: 中リスク** - 異常系のテストケース（UT-GEO-139〜144）は仕様が不明確な部分あり
  - 実装を変更する際に挙動が変わる可能性がある
  - テスト実行時にエラーが発生する可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 各ジオメトリクラスのデフォルトパラメータ値が正しいか確認
- [ ] 境界値テスト（Math.max/Math.floor）の制限値が正しいか確認
- [ ] Polyhedron派生クラスの頂点/インデックス数が数学的に正しいか確認
- [ ] copy/fromJSONメソッドのテストケースが適切か確認
- [ ] 異常系テストケースの期待結果が適切か確認（仕様未定義のため要検討）
- [ ] EdgesGeometryのthresholdAngleテストで角度計算が正しいか確認
- [ ] WireframeGeometryのisUniqueEdge関数のハッシュ衝突リスクを評価
