---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 98
  claims_with_evidence: 98
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：helpers.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：98 / 98、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースに根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/helpers/ArrowHelper.js` (172行)
- E-02: `src/helpers/AxesHelper.js` (97行)
- E-03: `src/helpers/Box3Helper.js` (84行)
- E-04: `src/helpers/BoxHelper.js` (150行)
- E-05: `src/helpers/CameraHelper.js` (346行)
- E-06: `src/helpers/DirectionalLightHelper.js` (149行)
- E-07: `src/helpers/GridHelper.js` (83行)
- E-08: `src/helpers/HemisphereLightHelper.js` (131行)
- E-09: `src/helpers/PlaneHelper.js` (97行)
- E-10: `src/helpers/PointLightHelper.js` (136行)
- E-11: `src/helpers/PolarGridHelper.js` (127行)
- E-12: `src/helpers/SkeletonHelper.js` (195行)
- E-13: `src/helpers/SpotLightHelper.js` (155行)

## 3) Claims と根拠の対応（レビューの主戦場）

### ArrowHelper (UT-HLP-001 - UT-HLP-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | constructor: デフォルト値で矢印ヘルパーが生成される | E-01 L45: `dir = new Vector3( 0, 0, 1 ), origin = new Vector3( 0, 0, 0 ), length = 1, color = 0xffff00` | ○ |
| C-02 | constructor: カスタム値で矢印ヘルパーが生成される | E-01 L45-84: constructorのパラメータ処理 | ○ |
| C-03 | setDirection: Y軸上向きでquaternion(0,0,0,1) | E-01 L95-97: `if ( dir.y > 0.99999 ) { this.quaternion.set( 0, 0, 0, 1 ); }` | ○ |
| C-04 | setDirection: Y軸下向きでquaternion(1,0,0,0) | E-01 L99-101: `else if ( dir.y < - 0.99999 ) { this.quaternion.set( 1, 0, 0, 0 ); }` | ○ |
| C-05 | setDirection: 任意方向でsetFromAxisAngle使用 | E-01 L103-111: `_axis.set( dir.z, 0, - dir.x ).normalize(); ... setFromAxisAngle` | ○ |
| C-06 | setLength: 長さとヘッド寸法が正しく設定される | E-01 L122-130: scale設定と位置更新のロジック | ○ |
| C-07 | setLength: 最小値0.0001が適用される | E-01 L124: `Math.max( 0.0001, length - headLength )` コメント#17458 | ○ |
| C-08 | setColor: line/coneの色が変更される | E-01 L138-143: `this.line.material.color.set( color ); this.cone.material.color.set( color );` | ○ |
| C-09 | copy: line/coneがコピーされる | E-01 L145-154: `this.line.copy( source.line ); this.cone.copy( source.cone );` | ○ |
| C-10 | dispose: 全リソースが解放される | E-01 L160-166: 4つのdispose呼び出し | ○ |

### AxesHelper (UT-HLP-011 - UT-HLP-016)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | constructor: デフォルトサイズ=1 | E-02 L25: `constructor( size = 1 )` | ○ |
| C-12 | constructor: カスタムサイズで生成可能 | E-02 L27-31: verticesがsizeパラメータを使用 | ○ |
| C-13 | constructor: X=赤, Y=緑, Z=青 | E-02 L33-37: colors配列 `1, 0, 0` / `0, 1, 0` / `0, 0, 1` | ○ |
| C-14 | setColors: 軸色をカスタマイズ可能 | E-02 L59-78: color.setとtoArrayで各軸に色を設定 | ○ |
| C-15 | setColors: thisを返却 | E-02 L78: `return this;` | ○ |
| C-16 | dispose: リソース解放 | E-02 L86-90: geometry/material dispose | ○ |

### Box3Helper (UT-HLP-017 - UT-HLP-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 | constructor: Box3からヘルパー生成 | E-03 L27-52: constructorでbox受け取り | ○ |
| C-18 | constructor: カスタム色対応 | E-03 L27: `color = 0xffff00` デフォルト、変更可能 | ○ |
| C-19 | updateMatrixWorld: スケール更新 | E-03 L60-63: `box.getCenter`, `box.getSize`, `multiplyScalar( 0.5 )` | ○ |
| C-20 | updateMatrixWorld: 空Boxで早期リターン | E-03 L58: `if ( box.isEmpty() ) return;` | ○ |
| C-21 | dispose: リソース解放 | E-03 L74-78: geometry/material dispose | ○ |

### BoxHelper (UT-HLP-022 - UT-HLP-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | constructor: Object3Dからヘルパー生成 | E-04 L34-57: constructorでobject受け取り | ○ |
| C-23 | constructor: undefinedでも生成可能 | E-04 L65: `if ( this.object !== undefined )` でチェック | ○ |
| C-24 | update: AABBが正しく計算される | E-04 L67-107: setFromObject, min/max取得, position設定 | ○ |
| C-25 | update: undefinedでも動作 | E-04 L65-71: undefinedチェックとisEmptyチェック | ○ |
| C-26 | update: 空Boxで早期リターン | E-04 L71: `if ( _box.isEmpty() ) return;` | ○ |
| C-27 | setFromObject: オブジェクト設定 | E-04 L116-122: object設定とupdate呼び出し | ○ |
| C-28 | setFromObject: this返却 | E-04 L121: `return this;` | ○ |
| C-29 | copy: objectがコピーされる | E-04 L125-132: `this.object = source.object;` | ○ |
| C-30 | dispose: リソース解放 | E-04 L139-143: geometry/material dispose | ○ |

### CameraHelper (UT-HLP-031 - UT-HLP-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | constructor: カメラからヘルパー生成 | E-05 L39-155: constructorでcamera受け取り | ○ |
| C-32 | constructor: pointMap初期化 | E-05 L47-116: addLine/addPointでpointMap構築 | ○ |
| C-33 | setColors: 各部分の色設定 | E-05 L167-223: frustum/cone/up/target/cross色設定 | ○ |
| C-34 | setColors: this返却 | E-05 L222: `return this;` | ○ |
| C-35 | update: WebGL座標系対応 | E-05 L252-255: `nearZ = - 1; farZ = 1;` | ○ |
| C-36 | update: WebGPU座標系対応 | E-05 L257-260: `nearZ = 0; farZ = 1;` | ○ |
| C-37 | update: reversedDepth対応 | E-05 L245-248: `nearZ = 1; farZ = 0;` | ○ |
| C-38 | update: 無効座標系でエラー | E-05 L262-264: `throw new Error` | ○ |
| C-39 | dispose: リソース解放 | E-05 L315-319: geometry/material dispose | ○ |

### DirectionalLightHelper (UT-HLP-040 - UT-HLP-047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | constructor: DirectionalLightからヘルパー生成 | E-06 L40-97: constructorでlight受け取り | ○ |
| C-41 | constructor: カスタムサイズ対応 | E-06 L64-73: sizeパラメータでgeometry生成 | ○ |
| C-42 | constructor: カスタム色対応 | E-06 L60: `this.color = color;` | ○ |
| C-43 | update: ライト位置追従 | E-06 L119-126: setFromMatrixPosition使用 | ○ |
| C-44 | update: ターゲットlookAt | E-06 L126, L140: `lookAt( _v2 )` | ○ |
| C-45 | update: color設定優先 | E-06 L128-131: `if ( this.color !== undefined )` | ○ |
| C-46 | update: ライト色フォールバック | E-06 L133-137: `copy( this.light.color )` | ○ |
| C-47 | dispose: リソース解放 | E-06 L104-110: 4つのdispose呼び出し | ○ |

### GridHelper (UT-HLP-048 - UT-HLP-051)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | constructor: デフォルト値 | E-07 L31: `size = 10, divisions = 10` | ○ |
| C-49 | constructor: カスタム値対応 | E-07 L31-62: パラメータでグリッド生成 | ○ |
| C-50 | constructor: 中央線と他の線の色分け | E-07 L47: `i === center ? color1 : color2` | ○ |
| C-51 | dispose: リソース解放 | E-07 L72-76: geometry/material dispose | ○ |

### HemisphereLightHelper (UT-HLP-052 - UT-HLP-057)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | constructor: HemisphereLightからヘルパー生成 | E-08 L38-77: constructorでlight受け取り | ○ |
| C-53 | constructor: color未指定でvertexColors有効 | E-08 L66: `if ( this.color === undefined ) this.material.vertexColors = true;` | ○ |
| C-54 | update: color設定優先 | E-08 L98-100: `if ( this.color !== undefined )` | ○ |
| C-55 | update: ライト色フォールバック | E-08 L102-117: light.color/groundColor使用 | ○ |
| C-56 | update: ライト反対方向lookAt | E-08 L123: `lookAt( _vector.setFromMatrixPosition(...).negate() )` | ○ |
| C-57 | dispose: リソース解放 | E-08 L83-87: children[0]のdispose | ○ |

### PlaneHelper (UT-HLP-058 - UT-HLP-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | constructor: Planeからヘルパー生成 | E-09 L28-65: constructorでplane受け取り | ○ |
| C-59 | constructor: 半透明メッシュ追加 | E-09 L63: `opacity: 0.2, transparent: true` | ○ |
| C-60 | updateMatrixWorld: 法線方向lookAt | E-09 L73: `this.lookAt( this.plane.normal );` | ○ |
| C-61 | updateMatrixWorld: constant移動 | E-09 L75: `this.translateZ( - this.plane.constant );` | ○ |
| C-62 | updateMatrixWorld: スケール設定 | E-09 L71: `scale.set( 0.5 * this.size, ... )` | ○ |
| C-63 | dispose: リソース解放 | E-09 L85-91: 自身とchildren[0]のdispose | ○ |

### PointLightHelper (UT-HLP-064 - UT-HLP-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | constructor: PointLightからヘルパー生成 | E-10 L31-84: constructorでlight受け取り | ○ |
| C-65 | constructor: カスタムサイズ対応 | E-10 L33: `SphereGeometry( sphereSize, ... )` | ○ |
| C-66 | constructor: ワイヤーフレーム描画 | E-10 L34: `wireframe: true` | ○ |
| C-67 | update: color設定優先 | E-10 L105-107: `if ( this.color !== undefined )` | ○ |
| C-68 | update: ライト色フォールバック | E-10 L109-111: `copy( this.light.color )` | ○ |
| C-69 | update: ワールドマトリックス更新 | E-10 L103: `this.light.updateWorldMatrix( true, false );` | ○ |
| C-70 | dispose: リソース解放 | E-10 L90-94: geometry/material dispose | ○ |

### PolarGridHelper (UT-HLP-071 - UT-HLP-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | constructor: デフォルト値 | E-11 L35: `radius = 10, sectors = 16, rings = 8, divisions = 64` | ○ |
| C-72 | constructor: カスタム値対応 | E-11 L35-106: パラメータでグリッド生成 | ○ |
| C-73 | constructor: sectors=1でセクター線スキップ | E-11 L45: `if ( sectors > 1 )` | ○ |
| C-74 | constructor: 交互色適用 | E-11 L57, L70: `( i & 1 ) ? color1 : color2` | ○ |
| C-75 | dispose: リソース解放 | E-11 L116-120: geometry/material dispose | ○ |

### SkeletonHelper (UT-HLP-076 - UT-HLP-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | constructor: SkinnedMeshからヘルパー生成 | E-12 L31-97: constructorでobject受け取り | ○ |
| C-77 | constructor: ボーン階層取得 | E-12 L33: `const bones = getBoneList( object );` | ○ |
| C-78 | constructor: 親ボーンの場合のみ頂点生成 | E-12 L44: `if ( bone.parent && bone.parent.isBone )` | ○ |
| C-79 | updateMatrixWorld: ボーン位置更新 | E-12 L99-131: position属性の更新ループ | ○ |
| C-80 | updateMatrixWorld: 親inverse適用 | E-12 L106: `_matrixWorldInv.copy( this.root.matrixWorld ).invert();` | ○ |
| C-81 | setColors: ボーン色設定 | E-12 L141-156: colorAttribute更新 | ○ |
| C-82 | setColors: this返却 | E-12 L155: `return this;` | ○ |
| C-83 | dispose: リソース解放 | E-12 L163-167: geometry/material dispose | ○ |

### SpotLightHelper (UT-HLP-084 - UT-HLP-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | constructor: SpotLightからヘルパー生成 | E-13 L36-90: constructorでlight受け取り | ○ |
| C-85 | constructor: カスタム色対応 | E-13 L55: `this.color = color;` | ○ |
| C-86 | constructor: コーン形状ジオメトリ | E-13 L69-79: 32セグメントループでpositions生成 | ○ |
| C-87 | update: distance反映 | E-13 L130: `this.light.distance ? this.light.distance : 1000` | ○ |
| C-88 | update: distance=0でデフォルト1000 | E-13 L130: `: 1000` | ○ |
| C-89 | update: angle反映 | E-13 L131: `Math.tan( this.light.angle )` | ○ |
| C-90 | update: ターゲットlookAt | E-13 L135-137: `cone.lookAt( _vector )` | ○ |
| C-91 | update: 親ありでローカルマトリックス計算 | E-13 L113-120: `parent.matrixWorld.invert()` | ○ |
| C-92 | update: 親なしでライトマトリックスコピー | E-13 L122-126: `this.matrix.copy( this.light.matrixWorld );` | ○ |
| C-93 | update: color設定優先 | E-13 L139-141: `if ( this.color !== undefined )` | ○ |
| C-94 | update: ライト色フォールバック | E-13 L143-147: `copy( this.light.color )` | ○ |
| C-95 | dispose: リソース解放 | E-13 L96-100: cone.geometry/material dispose | ○ |

### getBoneList (UT-HLP-096 - UT-HLP-098)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | 再帰的にボーン取得 | E-12 L173-190: 再帰呼び出しでboneList構築 | ○ |
| C-97 | ボーンでないオブジェクトスキップ | E-12 L177: `if ( object.isBone === true )` | ○ |
| C-98 | 子なしで空配列 | E-12 L175, L183: boneList初期化と空children対応 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません。全テストケースはソースコードから直接導出されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースに明確な根拠があります
- 注意点: Three.jsのWebGPU対応（CameraHelper.update）は比較的新しい機能のため、座標系の違いに関するテストは重点的にレビューすることを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ArrowHelperのsetDirection境界値テスト（0.99999/-0.99999）が適切か
- [ ] CameraHelperの座標系テスト（WebGL/WebGPU/reversedDepth）が網羅されているか
- [ ] dispose()メソッドのテストで全リソース解放が確認されているか
- [ ] Light系HelperのcolorパラメータとLightの色のフォールバック動作が正しく検証されているか
- [ ] SkeletonHelperのボーン階層処理が複雑なケースをカバーしているか
