---
generated_at: 2026-01-27 13:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：lights.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で該当項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **power計算ロジック**：PointLight, SpotLight, RectAreaLightの計算式は物理的正確性の確認が必要
  2. **updateMatricesメソッド**：LightShadow, SpotLightShadowのマトリクス計算ロジックは複雑
  3. **境界値テスト**：ゼロ除算やnull安全性のテストケースはエッジケースの網羅性確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/lights/Light.js`
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/lights/AmbientLight.js`
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/lights/DirectionalLight.js`
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/lights/PointLight.js`
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/lights/SpotLight.js`
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/lights/HemisphereLight.js`
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/lights/RectAreaLight.js`
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/lights/LightProbe.js`
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/lights/LightShadow.js`
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/lights/DirectionalLightShadow.js`
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/lights/PointLightShadow.js`
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/lights/SpotLightShadow.js`
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/lights/webgpu/IESSpotLight.js`
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/lights/webgpu/ProjectorLight.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### Light クラス (UT-LGT-001 ~ UT-LGT-008)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Lightコンストラクタのデフォルト値 | E-01 L19: `constructor( color, intensity = 1 )` | ○ |
| C-02 | Lightコンストラクタのパラメータ設定 | E-01 L39: `this.color = new Color( color )`, L47: `this.intensity = intensity` | ○ |
| C-03 | 文字列色指定 | E-01 L39: Colorクラスが文字列パース対応 | ○ |
| C-04 | intensity=0の境界値 | E-01 L47: 制限なく代入 | ○ |
| C-05 | disposeイベント発火 | E-01 L55-58: `dispatchEvent( { type: 'dispose' } )` | ○ |
| C-06 | copyメソッド | E-01 L61-70: color.copy, intensity代入 | ○ |
| C-07 | toJSONメソッド | E-01 L72-81: color.getHex(), intensity出力 | ○ |
| C-08 | isLightフラグ | E-01 L30: `this.isLight = true` | ○ |

### AmbientLight クラス (UT-LGT-009 ~ UT-LGT-012)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-09 | AmbientLightコンストラクタ | E-02 L23-37: super呼び出し、isAmbientLight設定 | ○ |
| C-10 | パラメータ指定 | E-02 L25: `super( color, intensity )` | ○ |
| C-11 | isAmbientLightフラグ | E-02 L34: `this.isAmbientLight = true` | ○ |
| C-12 | type文字列 | E-02 L36: `this.type = 'AmbientLight'` | ○ |

### DirectionalLight クラス (UT-LGT-013 ~ UT-LGT-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | DirectionalLightコンストラクタ | E-03 L40-78: 初期化処理 | ○ |
| C-14 | position初期値 | E-03 L55: `this.position.copy( Object3D.DEFAULT_UP )` | ○ |
| C-15 | target生成 | E-03 L70: `this.target = new Object3D()` | ○ |
| C-16 | shadow生成 | E-03 L77: `this.shadow = new DirectionalLightShadow()` | ○ |
| C-17 | dispose処理 | E-03 L81-87: `super.dispose()`, `this.shadow.dispose()` | ○ |
| C-18 | copy処理 | E-03 L89-97: target.clone, shadow.clone | ○ |
| C-19 | toJSON処理 | E-03 L100-108: shadow.toJSON, target.uuid | ○ |
| C-20 | isDirectionalLightフラグ | E-03 L51: `this.isDirectionalLight = true` | ○ |

### PointLight クラス (UT-LGT-021 ~ UT-LGT-030)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | PointLightコンストラクタデフォルト値 | E-04 L29: `distance = 0, decay = 2` | ○ |
| C-22 | パラメータ指定 | E-04 L29-72: 各プロパティ代入 | ○ |
| C-23 | shadow生成 | E-04 L70: `this.shadow = new PointLightShadow()` | ○ |
| C-24 | power getter計算 | E-04 L80-85: `this.intensity * 4 * Math.PI` | ○ |
| C-25 | power setter計算 | E-04 L88-92: `power / ( 4 * Math.PI )` | ○ |
| C-26 | power=0境界値 | E-04 L84: intensity*4*PIでゼロ返却 | ○ |
| C-27 | dispose処理 | E-04 L95-100: shadow.dispose呼び出し | ○ |
| C-28 | copy処理 | E-04 L103-114: distance, decay, shadow | ○ |
| C-29 | toJSON処理 | E-04 L116-127: distance, decay, shadow | ○ |
| C-30 | isPointLightフラグ | E-04 L40: `this.isPointLight = true` | ○ |

### SpotLight クラス (UT-LGT-031 ~ UT-LGT-045)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-31 | SpotLightコンストラクタデフォルト値 | E-05 L39: `distance = 0, angle = Math.PI / 3, penumbra = 0, decay = 2` | ○ |
| C-32 | パラメータ指定 | E-05 L39-124: 各プロパティ代入 | ○ |
| C-33 | position初期値 | E-05 L54: `this.position.copy( Object3D.DEFAULT_UP )` | ○ |
| C-34 | target生成 | E-05 L69: `this.target = new Object3D()` | ○ |
| C-35 | shadow生成 | E-05 L123: `this.shadow = new SpotLightShadow()` | ○ |
| C-36 | map初期値 | E-05 L116: `this.map = null` | ○ |
| C-37 | power getter計算 | E-05 L133-138: `this.intensity * Math.PI` | ○ |
| C-38 | power setter計算 | E-05 L141-145: `power / Math.PI` | ○ |
| C-39 | dispose処理 | E-05 L148-154: shadow.dispose呼び出し | ○ |
| C-40 | copy処理 | E-05 L156-171: 全プロパティコピー | ○ |
| C-41 | toJSON処理 | E-05 L173-190: 全プロパティ出力 | ○ |
| C-42 | mapのシリアライズ | E-05 L184: `if ( this.map && this.map.isTexture )` | ○ |
| C-43 | isSpotLightフラグ | E-05 L50: `this.isSpotLight = true` | ○ |
| C-44 | angle上限 | E-05 コメントL35: `upper bound is Math.PI/2` | ○ |
| C-45 | penumbra範囲 | E-05 コメントL36: `Value range is [0,1]` | ○ |

### HemisphereLight クラス (UT-LGT-046 ~ UT-LGT-052)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | HemisphereLightコンストラクタ | E-06 L27-52: 初期化処理 | ○ |
| C-47 | パラメータ指定 | E-06 L27: skyColor, groundColor, intensity | ○ |
| C-48 | position初期値 | E-06 L42: `this.position.copy( Object3D.DEFAULT_UP )` | ○ |
| C-49 | groundColor型 | E-06 L50: `this.groundColor = new Color( groundColor )` | ○ |
| C-50 | copy処理 | E-06 L54-61: groundColor.copy | ○ |
| C-51 | toJSON処理 | E-06 L64-71: groundColor.getHex() | ○ |
| C-52 | isHemisphereLightフラグ | E-06 L38: `this.isHemisphereLight = true` | ○ |

### RectAreaLight クラス (UT-LGT-053 ~ UT-LGT-061)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | RectAreaLightコンストラクタデフォルト値 | E-07 L38: `width = 10, height = 10` | ○ |
| C-54 | パラメータ指定 | E-07 L38-68: 各プロパティ代入 | ○ |
| C-55 | power getter計算 | E-07 L77-81: `this.intensity * this.width * this.height * Math.PI` | ○ |
| C-56 | power setter計算 | E-07 L84-88: `power / ( this.width * this.height * Math.PI )` | ○ |
| C-57 | width/height=0境界値 | E-07 L80: 計算式から導出 | ○ |
| C-58 | ゼロ除算 | E-07 L87: width*height*PIでゼロ除算発生 | ○ |
| C-59 | copy処理 | E-07 L91-99: width, height | ○ |
| C-60 | toJSON処理 | E-07 L102-110: width, height | ○ |
| C-61 | isRectAreaLightフラグ | E-07 L49: `this.isRectAreaLight = true` | ○ |

### LightProbe クラス (UT-LGT-062 ~ UT-LGT-067)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-62 | LightProbeコンストラクタデフォルト値 | E-08 L31: `sh = new SphericalHarmonics3(), intensity = 1` | ○ |
| C-63 | パラメータ指定 | E-08 L31-50: sh, intensity代入 | ○ |
| C-64 | sh型 | E-08 L49: `this.sh = sh` | ○ |
| C-65 | copy処理 | E-08 L53-60: sh.copy | ○ |
| C-66 | toJSON処理 | E-08 L63-70: sh.toArray() | ○ |
| C-67 | isLightProbeフラグ | E-08 L42: `this.isLightProbe = true` | ○ |

### LightShadow クラス (UT-LGT-068 ~ UT-LGT-083)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | LightShadowコンストラクタ | E-09 L25-171: camera設定 | ○ |
| C-69 | デフォルト値 | E-09 L41-158: intensity=1, bias=0, normalBias=0, radius=1, mapSize=(512,512) | ○ |
| C-70 | getViewportCount | E-09 L179-183: `return this._viewportCount` | ○ |
| C-71 | getFrustum | E-09 L190-194: `return this._frustum` | ○ |
| C-72 | updateMatrices | E-09 L201-238: matrix計算ロジック | ○ |
| C-73 | reversedDepth=true | E-09 L216-223: 専用shadowMatrix設定 | ○ |
| C-74 | reversedDepth=false | E-09 L226-233: 標準shadowMatrix設定 | ○ |
| C-75 | getViewport | E-09 L246-249: `return this._viewports[ viewportIndex ]` | ○ |
| C-76 | getFrameExtents | E-09 L256-260: `return this._frameExtents` | ○ |
| C-77 | dispose処理 | E-09 L267-281: map.dispose, mapPass.dispose | ○ |
| C-78 | null安全 | E-09 L269-279: if文でnullチェック | ○ |
| C-79 | copy処理 | E-09 L289-308: 全プロパティコピー | ○ |
| C-80 | clone処理 | E-09 L316-319: `new this.constructor().copy( this )` | ○ |
| C-81 | toJSON処理 | E-09 L328-343: 条件付きプロパティ出力 | ○ |
| C-82 | mapSize条件 | E-09 L336: `if ( this.mapSize.x !== 512 || this.mapSize.y !== 512 )` | ○ |
| C-83 | camera.matrix除外 | E-09 L339: `delete object.camera.matrix` | ○ |

### DirectionalLightShadow クラス (UT-LGT-084 ~ UT-LGT-085)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | OrthographicCamera初期化 | E-10 L16: `super( new OrthographicCamera( - 5, 5, 5, - 5, 0.5, 500 ) )` | ○ |
| C-85 | isDirectionalLightShadowフラグ | E-10 L25: `this.isDirectionalLightShadow = true` | ○ |

### PointLightShadow クラス (UT-LGT-086 ~ UT-LGT-087)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | PerspectiveCamera初期化 | E-11 L16: `super( new PerspectiveCamera( 90, 1, 0.5, 500 ) )` | ○ |
| C-87 | isPointLightShadowフラグ | E-11 L25: `this.isPointLightShadow = true` | ○ |

### SpotLightShadow クラス (UT-LGT-088 ~ UT-LGT-093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | PerspectiveCamera, focus, aspect初期化 | E-12 L15-44: camera, focus=1, aspect=1 | ○ |
| C-89 | updateMatrices処理 | E-12 L47-66: fov, aspect, far更新 | ○ |
| C-90 | distance=0対応 | E-12 L53: `light.distance || camera.far` | ○ |
| C-91 | 最適化 | E-12 L55: if条件で変更時のみupdateProjectionMatrix | ○ |
| C-92 | copy処理 | E-12 L68-76: focus | ○ |
| C-93 | isSpotLightShadowフラグ | E-12 L26: `this.isSpotLightShadow = true` | ○ |

### IESSpotLight クラス (UT-LGT-094 ~ UT-LGT-096)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | iesMap初期値 | E-13 L30: `this.iesMap = null` | ○ |
| C-95 | SpotLight継承 | E-13 L22: `super( color, intensity, distance, angle, penumbra, decay )` | ○ |
| C-96 | copy処理 | E-13 L34-42: iesMap | ○ |

### ProjectorLight クラス (UT-LGT-097 ~ UT-LGT-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | aspect初期値 | E-14 L30: `this.aspect = null` | ○ |
| C-98 | SpotLight継承 | E-14 L22: `super( color, intensity, distance, angle, penumbra, decay )` | ○ |
| C-99 | copy処理 | E-14 L34-42: aspect | ○ |
| C-100 | aspect設定 | E-14 L30: プロパティとして存在 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全てのテストケースにソースコードの根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコードに基づいており、根拠が明確

追加確認推奨事項：
1. **power計算の物理的正確性**: PointLight（4*PI）、SpotLight（PI）、RectAreaLight（width*height*PI）の計算式が物理学的に正しいか確認
2. **RectAreaLightのゼロ除算**: width=0またはheight=0時のpower setter動作（Infinityになる可能性）
3. **LightShadow.updateMatrices**: reversedDepthオプションの挙動確認

## 6) レビュアーチェックリスト（最小）
- [ ] UT-LGT-024, UT-LGT-025: PointLightのpower計算式（4*PI）が正しいか確認
- [ ] UT-LGT-037, UT-LGT-038: SpotLightのpower計算式（PI）が正しいか確認
- [ ] UT-LGT-055, UT-LGT-056: RectAreaLightのpower計算式（width*height*PI）が正しいか確認
- [ ] UT-LGT-058: RectAreaLightのゼロ除算時の期待動作を確認
- [ ] UT-LGT-072 ~ UT-LGT-074: LightShadow.updateMatricesのマトリクス計算が正しいか確認
- [ ] UT-LGT-089 ~ UT-LGT-091: SpotLightShadow.updateMatricesの最適化ロジックが正しいか確認
