---
generated_at: 2026-01-27 10:45:00
metrics:
  claims_total: 181
  claims_with_evidence: 181
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：loaders.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：181 / 181、根拠なし：0
- 優先レビュー（高）
  1. なし - すべてのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/Loader.js` - 基底Loaderクラス
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/Cache.js` - Cacheシングルトン
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/LoadingManager.js` - LoadingManagerクラス
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/LoaderUtils.js` - LoaderUtilsユーティリティ
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/FileLoader.js` - FileLoaderクラス
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/ImageLoader.js` - ImageLoaderクラス
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/TextureLoader.js` - TextureLoaderクラス
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/ImageBitmapLoader.js` - ImageBitmapLoaderクラス
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/CubeTextureLoader.js` - CubeTextureLoaderクラス
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/DataTextureLoader.js` - DataTextureLoaderクラス
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/CompressedTextureLoader.js` - CompressedTextureLoaderクラス
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/AnimationLoader.js` - AnimationLoaderクラス
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/AudioLoader.js` - AudioLoaderクラス
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/BufferGeometryLoader.js` - BufferGeometryLoaderクラス
- E-15: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/MaterialLoader.js` - MaterialLoaderクラス
- E-16: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/ObjectLoader.js` - ObjectLoaderクラス
- E-17: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/nodes/NodeLoader.js` - NodeLoaderクラス
- E-18: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/nodes/NodeMaterialLoader.js` - NodeMaterialLoaderクラス
- E-19: `/Users/tomoka.baba/Work/three.js-dev/src/loaders/nodes/NodeObjectLoader.js` - NodeObjectLoaderクラス

## 3) Claims と根拠の対応（レビューの主戦場）

### Loader（基底クラス）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LoadingManagerを指定してインスタンス化できること | E-01 L15-23 | ○ |
| C-02 | LoadingManager未指定時はDefaultLoadingManagerが設定されること | E-01 L23 | ○ |
| C-03 | 初期プロパティが正しく設定されること | E-01 L29-62 | ○ |
| C-04 | Promise形式でリソースが読み込めること | E-01 L91-101 | ○ |
| C-05 | 読み込み失敗時にPromiseがrejectされること | E-01 L95-97 | ○ |
| C-06 | crossOriginが設定されること | E-01 L119-124 | ○ |
| C-07 | メソッドチェーンが可能であること | E-01 L123 | ○ |
| C-08 | withCredentialsが設定されること | E-01 L135-140 | ○ |
| C-09 | pathが設定されること | E-01 L148-153 | ○ |
| C-10 | resourcePathが設定されること | E-01 L161-166 | ○ |
| C-11 | requestHeaderが設定されること | E-01 L175-180 | ○ |
| C-12 | abortメソッドがthisを返却すること | E-01 L188-192 | ○ |

### Cache
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | enabledのデフォルト値がfalseであること | E-02 L16 | ○ |
| C-14 | enabled=trueの時にキャッシュが追加されること | E-02 L34-42 | ○ |
| C-15 | enabled=falseの時にキャッシュが追加されないこと | E-02 L36 | ○ |
| C-16 | enabled=trueの時にキャッシュが取得できること | E-02 L51-58 | ○ |
| C-17 | enabled=falseの時にundefinedが返却されること | E-02 L53 | ○ |
| C-18 | 存在しないキーでundefinedが返却されること | E-02 L57 | ○ |
| C-19 | 指定キーのキャッシュが削除されること | E-02 L67-71 | ○ |
| C-20 | 全キャッシュが削除されること | E-02 L78-82 | ○ |

### LoadingManager
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | コールバック関数が設定されること | E-03 L27-70 | ○ |
| C-22 | onStartがundefinedで初期化されること | E-03 L46 | ○ |
| C-23 | itemsTotalがインクリメントされること | E-03 L86-88 | ○ |
| C-24 | 初回呼び出し時にonStartが実行されること | E-03 L90-96 | ○ |
| C-25 | itemsLoadedがインクリメントされること | E-03 L110-112 | ○ |
| C-26 | 進捗コールバックが実行されること | E-03 L114-118 | ○ |
| C-27 | 全アイテム完了時にonLoadが実行されること | E-03 L120-130 | ○ |
| C-28 | エラーコールバックが実行されること | E-03 L140-148 | ○ |
| C-29 | URLモディファイアが適用されること | E-03 L157-167 | ○ |
| C-30 | モディファイア未設定時は元のURLが返却されること | E-03 L165 | ○ |
| C-31 | URLモディファイアが設定されること | E-03 L203-209 | ○ |
| C-32 | ハンドラが登録されること | E-03 L225-231 | ○ |
| C-33 | ハンドラが削除されること | E-03 L239-251 | ○ |
| C-34 | マッチするハンドラが返却されること | E-03 L259-278 | ○ |
| C-35 | マッチしない場合nullが返却されること | E-03 L276 | ○ |
| C-36 | AbortControllerがabortされること | E-03 L287-295 | ○ |
| C-37 | 初回アクセス時にAbortControllerが生成されること | E-03 L307-317 | ○ |

### LoaderUtils
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | URLからベースパスが抽出されること | E-04 L12-18 | ○ |
| C-39 | スラッシュがない場合'./'が返却されること | E-04 L16 | ○ |
| C-40 | 相対URLが解決されること | E-04 L31-55 | ○ |
| C-41 | 絶対URLはそのまま返却されること | E-04 L44 | ○ |
| C-42 | Data URIはそのまま返却されること | E-04 L47 | ○ |
| C-43 | Blob URLはそのまま返却されること | E-04 L50 | ○ |
| C-44 | 空文字列の場合空文字列が返却されること | E-04 L34 | ○ |
| C-45 | 非文字列の場合空文字列が返却されること | E-04 L34 | ○ |

### FileLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | プロパティが正しく初期化されること | E-05 L40-68 | ○ |
| C-47 | テキストファイルが読み込めること | E-05 L79-323 | ○ |
| C-48 | キャッシュヒット時にキャッシュから返却されること | E-05 L87-103 | ○ |
| C-49 | 重複リクエストが統合されること | E-05 L107-128 | ○ |
| C-50 | arraybufferレスポンスタイプが正しく処理されること | E-05 L230-232 | ○ |
| C-51 | blobレスポンスタイプが正しく処理されること | E-05 L234-236 | ○ |
| C-52 | jsonレスポンスタイプが正しく処理されること | E-05 L248-250 | ○ |
| C-53 | documentレスポンスタイプが正しく処理されること | E-05 L238-246 | ○ |
| C-54 | HTTPエラー時にonErrorが呼び出されること | E-05 L219-222 | ○ |
| C-55 | 進捗イベントがonProgressに通知されること | E-05 L192-198 | ○ |
| C-56 | responseTypeが設定されること | E-05 L331-336 | ○ |
| C-57 | mimeTypeが設定されること | E-05 L344-349 | ○ |
| C-58 | 進行中のリクエストが中断されること | E-05 L356-362 | ○ |
| C-59 | 新しいAbortControllerが生成されること | E-05 L358-359 | ○ |

### ImageLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Loaderを継承してインスタンス化できること | E-06 L20-31 | ○ |
| C-61 | 画像が読み込めること | E-06 L45-163 | ○ |
| C-62 | キャッシュヒット（完了済み）時に即座に返却されること | E-06 L55-84 | ○ |
| C-63 | キャッシュヒット（読み込み中）時にコールバックが登録されること | E-06 L69-81 | ○ |
| C-64 | 画像読み込み失敗時にonErrorが呼び出されること | E-06 L113-138 | ○ |
| C-65 | crossOriginが設定されること | E-06 L150-154 | ○ |
| C-66 | Data URI時はcrossOriginが設定されないこと | E-06 L150 | ○ |

### TextureLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Loaderを継承してインスタンス化できること | E-07 L21-32 | ○ |
| C-68 | テクスチャが読み込めること | E-07 L46-69 | ○ |
| C-69 | テクスチャのimageプロパティに画像が設定されること | E-07 L56 | ○ |
| C-70 | テクスチャのneedsUpdateがtrueになること | E-07 L57 | ○ |
| C-71 | ImageLoaderにcrossOriginとpathが引き継がれること | E-07 L51-52 | ○ |

### ImageBitmapLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | isImageBitmapLoaderがtrueであること | E-08 L53 | ○ |
| C-73 | optionsのデフォルト値が設定されること | E-08 L73 | ○ |
| C-74 | optionsが設定されること | E-08 L92-98 | ○ |
| C-75 | ImageBitmapが読み込めること | E-08 L109-207 | ○ |
| C-76 | キャッシュヒット（Promise）時に待機すること | E-08 L126-153 | ○ |
| C-77 | キャッシュヒット（ImageBitmap）時に即座に返却されること | E-08 L155-165 | ○ |
| C-78 | エラー時にonErrorが呼び出されること | E-08 L191-202 | ○ |
| C-79 | 進行中のリクエストが中断されること | E-08 L214-220 | ○ |

### CubeTextureLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | Loaderを継承してインスタンス化できること | E-09 L32-43 | ○ |
| C-81 | 6面のキューブテクスチャが読み込めること | E-09 L59-98 | ○ |
| C-82 | colorSpaceがSRGBColorSpaceに設定されること | E-09 L62 | ○ |
| C-83 | 6面すべて読み込み完了後にneedsUpdateがtrueになること | E-09 L80 | ○ |
| C-84 | 1面でもエラー時にonErrorが呼び出されること | E-09 L86 | ○ |

### DataTextureLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | Loaderを継承してインスタンス化できること | E-10 L16-27 | ○ |
| C-86 | DataTextureが生成されること | E-10 L41-147 | ○ |
| C-87 | parseの結果がテクスチャに反映されること | E-10 L75-136 | ○ |
| C-88 | mipmapsが設定されること | E-10 L119-124 | ○ |
| C-89 | parse失敗時にonErrorが呼び出されること | E-10 L60-72 | ○ |

### CompressedTextureLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | Loaderを継承してインスタンス化できること | E-11 L16-27 | ○ |
| C-91 | 配列URLで6面が読み込めること | E-11 L88-94 | ○ |
| C-92 | 単一URLでキューブマップが読み込めること | E-11 L100-121 | ○ |
| C-93 | 単一URLで2Dテクスチャが読み込めること | E-11 L125-131 | ○ |
| C-94 | mipmapCount=1時にminFilterがLinearFilterになること | E-11 L133-137 | ○ |

### AnimationLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | Loaderを継承してインスタンス化できること | E-12 L17-28 | ○ |
| C-96 | アニメーションクリップ配列が読み込めること | E-12 L39-71 | ○ |
| C-97 | JSONパース失敗時にonErrorが呼び出されること | E-12 L53-67 | ○ |
| C-98 | JSON配列からAnimationClip配列が生成されること | E-12 L79-93 | ○ |
| C-99 | 空配列の場合空配列が返却されること | E-12 L81 | ○ |

### AudioLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | Loaderを継承してインスタンス化できること | E-13 L23-34 | ○ |
| C-101 | AudioBufferが読み込めること | E-13 L45-93 | ○ |
| C-102 | バッファのコピーが作成されること | E-13 L60 | ○ |
| C-103 | デコード失敗時にonErrorが呼び出されること | E-13 L77-91 | ○ |

### BufferGeometryLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-104 | Loaderを継承してインスタンス化できること | E-14 L27-38 | ○ |
| C-105 | BufferGeometryが読み込めること | E-14 L48-80 | ○ |
| C-106 | JSONパース失敗時にonErrorが呼び出されること | E-14 L62-76 | ○ |
| C-107 | indexが設定されること | E-14 L129-136 | ○ |
| C-108 | attributesが設定されること | E-14 L138-163 | ○ |
| C-109 | InterleavedBufferAttributeが処理されること | E-14 L145-148 | ○ |
| C-110 | morphAttributesが設定されること | E-14 L165-201 | ○ |
| C-111 | groupsが設定されること | E-14 L211-223 | ○ |
| C-112 | boundingSphereが設定されること | E-14 L225-231 | ○ |
| C-113 | InstancedBufferGeometryが生成されること | E-14 L127 | ○ |

### MaterialLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-114 | Loaderを継承してインスタンス化できること | E-15 L43-61 | ○ |
| C-115 | texturesが空オブジェクトで初期化されること | E-15 L59 | ○ |
| C-116 | マテリアルが読み込めること | E-15 L71-103 | ○ |
| C-117 | JSONパース失敗時にonErrorが呼び出されること | E-15 L85-99 | ○ |
| C-118 | typeに応じたマテリアルが生成されること | E-15 L127 | ○ |
| C-119 | 基本プロパティが設定されること | E-15 L129-226 | ○ |
| C-120 | テクスチャマップが設定されること | E-15 L302-371 | ○ |
| C-121 | uniformsが設定されること | E-15 L230-275 | ○ |
| C-122 | vertexColorsがboolean変換されること | E-15 L214-226 | ○ |
| C-123 | texturesが設定されること | E-15 L384-389 | ○ |
| C-124 | 指定タイプのマテリアルが生成されること | E-15 L410-435 | ○ |

### ObjectLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-125 | Loaderを継承してインスタンス化できること | E-16 L84-95 | ○ |
| C-126 | 3Dオブジェクトが読み込めること | E-16 L105-149 | ○ |
| C-127 | resourcePathが自動設定されること | E-16 L109-110 | ○ |
| C-128 | metadataがない場合エラーになること | E-16 L136-142 | ○ |
| C-129 | typeがgeometryの場合エラーになること | E-16 L136 | ○ |
| C-130 | Promise形式で読み込めること | E-16 L159-185 | ○ |
| C-131 | オブジェクト階層が構築されること | E-16 L195-238 | ○ |
| C-132 | 画像読み込み完了後にonLoadが呼び出されること | E-16 L201-235 | ○ |
| C-133 | Promise形式でパースできること | E-16 L247-266 | ○ |
| C-134 | Shape辞書が生成されること | E-16 L270-288 | ○ |
| C-135 | undefinedの場合空オブジェクトが返却されること | E-16 L274 | ○ |
| C-136 | Skeleton辞書が生成されること | E-16 L290-319 | ○ |
| C-137 | BufferGeometry辞書が生成されること | E-16 L321-369 | ○ |
| C-138 | Geometriesモジュールの型が処理されること | E-16 L344-352 | ○ |
| C-139 | Material辞書が生成されること | E-16 L371-399 | ○ |
| C-140 | AnimationClip辞書が生成されること | E-16 L401-421 | ○ |
| C-141 | 画像辞書が生成されること | E-16 L423-537 | ○ |
| C-142 | 配列URLでCubeTexture用画像が処理されること | E-16 L489-519 | ○ |
| C-143 | Promise形式で画像がパースできること | E-16 L539-633 | ○ |
| C-144 | Texture辞書が生成されること | E-16 L635-741 | ○ |
| C-145 | テクスチャ設定が適用されること | E-16 L700-731 | ○ |
| C-146 | Sceneが生成されること | E-16 L811-862 | ○ |
| C-147 | PerspectiveCameraが生成されること | E-16 L864-874 | ○ |
| C-148 | 各種Lightが生成されること | E-16 L885-928 | ○ |
| C-149 | Meshが生成されること | E-16 L943-950 | ○ |
| C-150 | SkinnedMeshが生成されること | E-16 L930-942 | ○ |
| C-151 | InstancedMeshが生成されること | E-16 L952-964 | ○ |
| C-152 | BatchedMeshが生成されること | E-16 L966-1039 | ○ |
| C-153 | LODが生成されること | E-16 L1041-1045 | ○ |
| C-154 | 子オブジェクトが再帰的に処理されること | E-16 L1144-1154 | ○ |
| C-155 | transformが適用されること | E-16 L1100-1114 | ○ |
| C-156 | SkinnedMeshにSkeletonがバインドされること | E-16 L1195-1218 | ○ |
| C-157 | DirectionalLightにtargetがバインドされること | E-16 L1221-1245 | ○ |

### NodeLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-158 | texturesとnodesが空オブジェクトで初期化されること | E-17 L19-36 | ○ |
| C-159 | Nodeが読み込めること | E-17 L47-77 | ○ |
| C-160 | JSONパース失敗時にonErrorが呼び出されること | E-17 L59-73 | ○ |
| C-161 | Node辞書が生成されること | E-17 L85-117 | ○ |
| C-162 | undefinedの場合空オブジェクトが返却されること | E-17 L89 | ○ |
| C-163 | JSONからNodeが生成されること | E-17 L129-145 | ○ |
| C-164 | texturesが設定されること | E-17 L153-158 | ○ |
| C-165 | nodesが設定されること | E-17 L166-171 | ○ |
| C-166 | 指定タイプのNodeが生成されること | E-17 L179-190 | ○ |
| C-167 | 未登録タイプの場合float()が返却されること | E-17 L181-184 | ○ |

### NodeMaterialLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-168 | nodesとnodeMaterialsが空オブジェクトで初期化されること | E-18 L15-32 | ○ |
| C-169 | NodeMaterialが生成されること | E-18 L41-58 | ○ |
| C-170 | inputNodesが設定されること | E-18 L48-54 | ○ |
| C-171 | nodesが設定されること | E-18 L66-71 | ○ |
| C-172 | nodeMaterialsが設定されること | E-18 L79-84 | ○ |
| C-173 | NodeMaterialが生成されること | E-18 L92-104 | ○ |
| C-174 | 未登録タイプは親クラスにフォールバックすること | E-18 L102 | ○ |

### NodeObjectLoader
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-175 | nodesとnodeMaterialsが空オブジェクトで初期化されること | E-19 L19-45 | ○ |
| C-176 | nodesが設定されること | E-19 L53-58 | ○ |
| C-177 | nodeMaterialsが設定されること | E-19 L66-71 | ○ |
| C-178 | NodeMaterialを使用した3Dオブジェクトが読み込めること | E-19 L80-89 | ○ |
| C-179 | NodeLoaderを使用してNodeがパースされること | E-19 L99-113 | ○ |
| C-180 | undefinedの場合空オブジェクトが返却されること | E-19 L111 | ○ |
| C-181 | NodeMaterialLoaderを使用してマテリアルがパースされること | E-19 L122-147 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - すべてのテストケースはソースコードに基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースにソースコード根拠あり

### 補足事項
- Three.jsはクライアントサイドJavaScriptライブラリのため、ブラウザAPIに依存するテスト（fetch, createImageBitmap, AudioContext等）は実行環境に注意が必要
- FileLoaderの重複リクエスト統合ロジック（UT-LDR-049）はモジュールスコープ変数を使用しているため、テスト間の状態リセットに注意
- DataTextureLoader, CompressedTextureLoaderは抽象クラスのため、テスト時は派生クラスまたはモックを使用

## 6) レビュアーチェックリスト（最小）
- [ ] 各クラスのコンストラクタの初期化処理がテストケースで網羅されているか
- [ ] 非同期処理（load, loadAsync）の正常系・異常系が網羅されているか
- [ ] キャッシュ機能（Cache, FileLoader, ImageLoader）の各パターンがテストされているか
- [ ] setterメソッドの戻り値（メソッドチェーン）が確認されているか
- [ ] abort機能の動作確認テストが含まれているか
- [ ] 境界値テスト（空配列、undefined、null）が適切に設計されているか
- [ ] Node系ローダー（NodeLoader, NodeMaterialLoader, NodeObjectLoader）の依存関係が正しくテストされているか
