---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 100
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：materials.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：100 / 100、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースがソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/materials/Material.js` - 基底Materialクラス（1018行）
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshBasicMaterial.js` - MeshBasicMaterialクラス（251行）
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshStandardMaterial.js` - MeshStandardMaterialクラス（426行）
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshPhysicalMaterial.js` - MeshPhysicalMaterialクラス（537行）
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshPhongMaterial.js` - MeshPhongMaterialクラス（422行）
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshLambertMaterial.js` - MeshLambertMaterialクラス（403行）
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshToonMaterial.js` - MeshToonMaterialクラス（322行）
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshNormalMaterial.js` - MeshNormalMaterialクラス（176行）
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshMatcapMaterial.js` - MeshMatcapMaterialクラス（246行）
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshDepthMaterial.js` - MeshDepthMaterialクラス（149行）
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/materials/MeshDistanceMaterial.js` - MeshDistanceMaterialクラス（120行）
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/materials/LineBasicMaterial.js` - LineBasicMaterialクラス（123行）
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/materials/LineDashedMaterial.js` - LineDashedMaterialクラス（87行）
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/materials/PointsMaterial.js` - PointsMaterialクラス（140行）
- E-15: `/Users/tomoka.baba/Work/three.js-dev/src/materials/SpriteMaterial.js` - SpriteMaterialクラス（137行）
- E-16: `/Users/tomoka.baba/Work/three.js-dev/src/materials/ShadowMaterial.js` - ShadowMaterialクラス（92行）
- E-17: `/Users/tomoka.baba/Work/three.js-dev/src/materials/ShaderMaterial.js` - ShaderMaterialクラス（414行）
- E-18: `/Users/tomoka.baba/Work/three.js-dev/src/materials/RawShaderMaterial.js` - RawShaderMaterialクラス（43行）
- E-19: `/Users/tomoka.baba/Work/three.js-dev/src/materials/Materials.js` - モジュールエクスポート（40行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Material基底クラス（UT-MAT-001〜025）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Materialコンストラクタでデフォルト値が設定される | E-01 (行22-477) | ○ |
| C-02 | alphaTest getter が _alphaTest を返却する | E-01 (行487-491) | ○ |
| C-03 | alphaTest setter で値が設定される | E-01 (行493-503) | ○ |
| C-04 | alphaTest が0から正値に変更時versionが増加 | E-01 (行495-497) | ○ |
| C-05 | alphaTest が正値から0に変更時versionが増加 | E-01 (行495-497) | ○ |
| C-06 | alphaTest が正値から正値への変更時versionが変わらない | E-01 (行495条件式) | ○ |
| C-07 | setValuesでプロパティが設定される | E-01 (行555-595) | ○ |
| C-08 | setValuesでColorプロパティがset経由で設定される | E-01 (行579-581) | ○ |
| C-09 | setValuesでVector3プロパティがcopy経由で設定される | E-01 (行583-585) | ○ |
| C-10 | setValuesでundefinedパラメータは警告が出力される | E-01 (行563-567) | ○ |
| C-11 | setValuesで存在しないプロパティは警告が出力される | E-01 (行572-576) | ○ |
| C-12 | setValuesで空オブジェクトが渡された場合何も変更されない | E-01 (行559 for文) | ○ |
| C-13 | setValuesでundefinedが渡された場合早期リターン | E-01 (行557) | ○ |
| C-14 | toJSONでマテリアルがシリアライズされる | E-01 (行604-881) | ○ |
| C-15 | toJSONで非デフォルト値のみがJSONに含まれる | E-01 (行629-850) | ○ |
| C-16 | toJSONでテクスチャがUUID参照でシリアライズされる | E-01 (行707-708) | ○ |
| C-17 | cloneで新インスタンスが返却される | E-01 (行889-893) | ○ |
| C-18 | cloneでUUIDが元と異なる | E-01 (行50 UUID生成) | ○ |
| C-19 | copyで全プロパティがコピーされる | E-01 (行901-979) | ○ |
| C-20 | copyでclippingPlanesが深コピーされる | E-01 (行934-950) | ○ |
| C-21 | copyでuserDataがJSON経由で深コピーされる | E-01 (行977) | ○ |
| C-22 | disposeでdisposeイベントが発火する | E-01 (行989-998) | ○ |
| C-23 | needsUpdate setterでtrueを設定するとversionが増加 | E-01 (行1009-1013) | ○ |
| C-24 | needsUpdate setterでfalseを設定してもversionが変わらない | E-01 (行1011条件式) | ○ |
| C-25 | customProgramCacheKeyがonBeforeCompile.toString()を返却 | E-01 (行542-546) | ○ |

### MeshBasicMaterial（UT-MAT-026〜029）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | MeshBasicMaterialコンストラクタでデフォルト値が設定される | E-02 (行25-211) | ○ |
| C-27 | パラメータ指定でインスタンスが生成される | E-02 (行209 setValues呼び出し) | ○ |
| C-28 | copyで全プロパティがコピーされる | E-02 (行213-246) | ○ |
| C-29 | envMapRotationがcopyされる | E-02 (行232) | ○ |

### MeshStandardMaterial（UT-MAT-030〜033）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-30 | MeshStandardMaterialコンストラクタでデフォルト値が設定される | E-03 (行52-365) | ○ |
| C-31 | defines.STANDARDが設定される | E-03 (行67) | ○ |
| C-32 | copyで全プロパティがコピーされる | E-03 (行367-420) | ○ |
| C-33 | normalScaleがVector2としてコピーされる | E-03 (行394) | ○ |

### MeshPhysicalMaterial（UT-MAT-034〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | MeshPhysicalMaterialコンストラクタでデフォルト値が設定される | E-04 (行43-324) | ○ |
| C-35 | defines.PHYSICALが設定される | E-04 (行56-61) | ○ |
| C-36 | reflectivity getterがiorから計算される | E-04 (行148-151) | ○ |
| C-37 | reflectivity setterでiorが逆算される | E-04 (行153-156) | ○ |
| C-38 | ior=1.0の場合reflectivity=0 | E-04 (行150計算式) | ○ |
| C-39 | anisotropy getter/setterが動作する | E-04 (行332-348) | ○ |
| C-40 | anisotropy setterでversionが更新される | E-04 (行340-344) | ○ |
| C-41 | clearcoat getter/setterが動作する | E-04 (行358-374) | ○ |
| C-42 | clearcoat setterでversionが更新される | E-04 (行366-370) | ○ |
| C-43 | iridescence getter/setterが動作する | E-04 (行382-398) | ○ |
| C-44 | iridescence setterでversionが更新される | E-04 (行390-394) | ○ |
| C-45 | dispersion getter/setterが動作する | E-04 (行408-424) | ○ |
| C-46 | dispersion setterでversionが更新される | E-04 (行416-420) | ○ |
| C-47 | sheen getter/setterが動作する | E-04 (行432-448) | ○ |
| C-48 | sheen setterでversionが更新される | E-04 (行440-444) | ○ |
| C-49 | transmission getter/setterが動作する | E-04 (行462-478) | ○ |
| C-50 | transmission setterでversionが更新される | E-04 (行470-474) | ○ |
| C-51 | copyで全プロパティがコピーされる | E-04 (行480-531) | ○ |
| C-52 | iridescenceThicknessRangeがスプレッドでコピーされる | E-04 (行508) | ○ |

### MeshPhongMaterial（UT-MAT-053〜054）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | MeshPhongMaterialコンストラクタでデフォルト値が設定される | E-05 (行33-362) | ○ |
| C-54 | specularとshininessがコピーされる | E-05 (行369-370) | ○ |

### MeshLambertMaterial（UT-MAT-055〜056）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | MeshLambertMaterialコンストラクタでデフォルト値が設定される | E-06 (行35-345) | ○ |
| C-56 | copyで全プロパティがコピーされる | E-06 (行347-397) | ○ |

### MeshToonMaterial（UT-MAT-057〜058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | MeshToonMaterialコンストラクタでデフォルト値が設定される | E-07 (行23-274) | ○ |
| C-58 | gradientMapがコピーされる | E-07 (行283) | ○ |

### MeshNormalMaterial（UT-MAT-059〜060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | MeshNormalMaterialコンストラクタでデフォルト値が設定される | E-08 (行21-147) | ○ |
| C-60 | copyで全プロパティがコピーされる | E-08 (行149-170) | ○ |

### MeshMatcapMaterial（UT-MAT-061〜062）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | MeshMatcapMaterialコンストラクタでデフォルト値が設定される | E-09 (行29-204) | ○ |
| C-62 | matcapがコピーされる | E-09 (行215) | ○ |

### MeshDepthMaterial（UT-MAT-063〜064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | MeshDepthMaterialコンストラクタでデフォルト値が設定される | E-10 (行22-123) | ○ |
| C-64 | depthPackingがコピーされる | E-10 (行129) | ○ |

### MeshDistanceMaterial（UT-MAT-065〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | MeshDistanceMaterialコンストラクタでデフォルト値が設定される | E-11 (行25-99) | ○ |
| C-66 | copyで全プロパティがコピーされる | E-11 (行101-114) | ○ |

### LineBasicMaterial（UT-MAT-067〜068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | LineBasicMaterialコンストラクタでデフォルト値が設定される | E-12 (行26-100) | ○ |
| C-68 | linewidth, linecap, linejoinがコピーされる | E-12 (行110-112) | ○ |

### LineDashedMaterial（UT-MAT-069〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-69 | LineDashedMaterialコンストラクタでデフォルト値が設定される | E-13 (行30-70) | ○ |
| C-70 | scale, dashSize, gapSizeがコピーされる | E-13 (行76-78) | ○ |

### PointsMaterial（UT-MAT-071〜072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | PointsMaterialコンストラクタでデフォルト値が設定される | E-14 (行40-116) | ○ |
| C-72 | size, sizeAttenuationがコピーされる | E-14 (行128-129) | ○ |

### SpriteMaterial（UT-MAT-073〜074）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-73 | SpriteMaterialコンストラクタでデフォルト値が設定される | E-15 (行29-112) | ○ |
| C-74 | rotationがコピーされる | E-15 (行124) | ○ |

### ShadowMaterial（UT-MAT-075〜076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | ShadowMaterialコンストラクタでデフォルト値が設定される | E-16 (行33-75) | ○ |
| C-76 | color, fogがコピーされる | E-16 (行81-83) | ○ |

### ShaderMaterial（UT-MAT-077〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | ShaderMaterialコンストラクタでデフォルト値が設定される | E-17 (行50-270) | ○ |
| C-78 | パラメータ指定でuniforms, shaderが設定される | E-17 (行264-268) | ○ |
| C-79 | uniformsが深コピーされる | E-17 (行279-280 cloneUniforms) | ○ |
| C-80 | definesがObject.assignでコピーされる | E-17 (行282) | ○ |
| C-81 | extensionsがObject.assignでコピーされる | E-17 (行291) | ○ |
| C-82 | toJSONでシェーダーコードが含まれる | E-17 (行380-381) | ○ |
| C-83 | toJSONでuniformsがシリアライズされる | E-17 (行310-376) | ○ |
| C-84 | Texture型uniformがuuid参照でシリアライズされる | E-17 (行317-322) | ○ |
| C-85 | Color型uniformがhexでシリアライズされる | E-17 (行324-329) | ○ |
| C-86 | Vector型uniformが配列でシリアライズされる | E-17 (行331-351) | ○ |
| C-87 | Matrix型uniformが配列でシリアライズされる | E-17 (行353-365) | ○ |
| C-88 | 有効なextensionsのみがJSONに含まれる | E-17 (行386-394) | ○ |

### RawShaderMaterial（UT-MAT-089〜090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | RawShaderMaterialコンストラクタでデフォルト値が設定される | E-18 (行23-38) | ○ |
| C-90 | ShaderMaterialを継承している | E-18 (行12 extends ShaderMaterial) | ○ |

### その他（UT-MAT-091〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | インスタンス毎に異なるidが割り当てられる | E-01 (行7, 42 _materialId++) | ○ |
| C-92 | idが連番で増加する | E-01 (行7, 42) | ○ |
| C-93 | UUIDがUUID形式である | E-01 (行50 generateUUID()) | ○ |
| C-94 | blendColorがColorインスタンスである | E-01 (行191) | ○ |
| C-95 | onBeforeRenderが呼び出し可能 | E-01 (行517) | ○ |
| C-96 | onBeforeCompileが呼び出し可能 | E-01 (行531) | ○ |
| C-97 | iorのデフォルト値が1.5 | E-04 (行134) | ○ |
| C-98 | attenuationDistanceのデフォルト値がInfinity | E-04 (行269) | ○ |
| C-99 | iridescenceThicknessRangeのデフォルト値が[100,400] | E-04 (行185) | ○ |
| C-100 | metaがstringの場合ルートオブジェクトとして扱われる | E-01 (行606) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全てのテストケースはソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての根拠がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Material基底クラスのversion管理ロジック（alphaTest, needsUpdate）が正しく網羅されているか
- [ ] MeshPhysicalMaterialの各getter/setterのversion更新条件が正しいか
- [ ] ShaderMaterial.toJSONの各型（Texture, Color, Vector, Matrix）のシリアライズが網羅されているか
- [ ] copyメソッドの深コピー対象（clippingPlanes, userData, iridescenceThicknessRange）が正しいか
- [ ] 各Materialサブクラス固有のプロパティが漏れなくテスト対象になっているか
