---
generated_at: 2026-01-27 12:30:00
metrics:
  claims_total: 396
  claims_with_evidence: 396
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 単体テストケース一覧 根拠レポート - math モジュール

## 1. 概要

本レポートは、Three.js の `src/math/` モジュールに対する単体テストケース一覧（math.csv）の生成根拠を示すものです。

### 対象ファイル一覧

| ファイル | クラス/関数 | テストケース数 |
|---------|------------|--------------|
| MathUtils.js | MathUtils | 30 |
| Vector2.js | Vector2 | 30 |
| Vector3.js | Vector3 | 27 |
| Vector4.js | Vector4 | 7 |
| Matrix3.js | Matrix3 | 13 |
| Matrix4.js | Matrix4 | 25 |
| Quaternion.js | Quaternion | 22 |
| Euler.js | Euler | 8 |
| Color.js | Color | 18 |
| Box2.js | Box2 | 24 |
| Box3.js | Box3 | 31 |
| Sphere.js | Sphere | 26 |
| Ray.js | Ray | 24 |
| Plane.js | Plane | 20 |
| Triangle.js | Triangle | 20 |
| Line3.js | Line3 | 14 |
| Frustum.js | Frustum | 13 |
| Spherical.js | Spherical | 6 |
| Cylindrical.js | Cylindrical | 5 |
| SphericalHarmonics3.js | SphericalHarmonics3 | 14 |
| ColorManagement.js | ColorManagement, SRGBToLinear, LinearToSRGB | 7 |
| Interpolant.js | Interpolant | 4 |
| interpolants/LinearInterpolant.js | LinearInterpolant | 2 |
| interpolants/CubicInterpolant.js | CubicInterpolant | 2 |
| interpolants/DiscreteInterpolant.js | DiscreteInterpolant | 1 |
| interpolants/QuaternionLinearInterpolant.js | QuaternionLinearInterpolant | 1 |
| interpolants/BezierInterpolant.js | BezierInterpolant | 2 |

**合計: 396 テストケース**

## 2. テストケース生成根拠

### 2.1 MathUtils (UT-MTH-001 - UT-MTH-030)

#### 根拠となるソースコード

**clamp関数** (MathUtils.js)
```javascript
function clamp( value, min, max ) {
    return Math.max( min, Math.min( max, value ) );
}
```
- 正常系: 範囲内の値はそのまま返却
- 境界値: min/max と等しい値の処理
- クランプ: 範囲外の値の制限

**lerp関数** (MathUtils.js)
```javascript
function lerp( x, y, t ) {
    return ( 1 - t ) * x + t * y;
}
```
- 正常系: 0 < t < 1 での補間
- 境界値: t=0, t=1 のケース

**generateUUID関数** (MathUtils.js)
```javascript
function generateUUID() {
    // RFC4122 version 4 compliant UUID generation
}
```
- 正常系: 有効なUUID形式の生成
- 一意性: 連続呼び出しで異なる値

### 2.2 Vector2 (UT-MTH-031 - UT-MTH-060)

#### 根拠となるソースコード

**constructor** (Vector2.js)
```javascript
constructor( x = 0, y = 0 ) {
    this.isVector2 = true;
    this.x = x;
    this.y = y;
}
```

**add/sub/multiply/divide メソッド**
```javascript
add( v ) {
    this.x += v.x;
    this.y += v.y;
    return this;
}
```
- 正常系: ベクトル演算の正確性
- 異常系: ゼロ除算の処理

**normalize メソッド**
```javascript
normalize() {
    return this.divideScalar( this.length() || 1 );
}
```
- 正常系: 単位ベクトルへの正規化
- 境界値: ゼロベクトルの正規化

### 2.3 Vector3 (UT-MTH-061 - UT-MTH-087)

#### 根拠となるソースコード

**cross メソッド** (Vector3.js)
```javascript
cross( v ) {
    return this.crossVectors( this, v );
}

crossVectors( a, b ) {
    const ax = a.x, ay = a.y, az = a.z;
    const bx = b.x, by = b.y, bz = b.z;
    this.x = ay * bz - az * by;
    this.y = az * bx - ax * bz;
    this.z = ax * by - ay * bx;
    return this;
}
```
- 正常系: 外積の計算正確性
- 検証: (1,0,0) x (0,1,0) = (0,0,1)

**applyQuaternion メソッド**
```javascript
applyQuaternion( q ) {
    // Quaternion-Vector multiplication
}
```
- 正常系: クォータニオン回転の適用

### 2.4 Matrix3/Matrix4 (UT-MTH-095 - UT-MTH-132)

#### 根拠となるソースコード

**invert メソッド** (Matrix4.js)
```javascript
invert() {
    // Compute adjugate and determinant
    const det = /* determinant calculation */;
    if ( det === 0 ) return this.set( 0, 0, 0, 0, ... );
    // Apply inverse
}
```
- 正常系: 可逆行列の逆行列計算
- 異常系: 特異行列（det=0）の処理

**compose/decompose メソッド**
```javascript
compose( position, quaternion, scale ) {
    // Combine TRS into matrix
}
decompose( position, quaternion, scale ) {
    // Extract TRS from matrix
}
```
- 正常系: 変換の合成と分解の可逆性

### 2.5 Quaternion (UT-MTH-133 - UT-MTH-154)

#### 根拠となるソースコード

**slerp メソッド** (Quaternion.js)
```javascript
slerp( qb, t ) {
    // Spherical linear interpolation
}
```
- 正常系: 球面線形補間
- 境界値: t=0, t=1 のケース

**slerpFlat 静的メソッド**
```javascript
static slerpFlat( dst, dstOffset, src0, srcOffset0, src1, srcOffset1, t ) {
    // Flat array SLERP for animation system
}
```
- 正常系: アニメーションシステム用の配列ベースSLERP

### 2.6 Box2/Box3 (UT-MTH-181 - UT-MTH-235)

#### 根拠となるソースコード

**isEmpty メソッド** (Box3.js)
```javascript
isEmpty() {
    return ( this.max.x < this.min.x ) ||
           ( this.max.y < this.min.y ) ||
           ( this.max.z < this.min.z );
}
```
- 正常系: 空/非空の判定

**intersectsBox メソッド**
```javascript
intersectsBox( box ) {
    return box.max.x >= this.min.x && box.min.x <= this.max.x &&
           box.max.y >= this.min.y && box.min.y <= this.max.y &&
           box.max.z >= this.min.z && box.min.z <= this.max.z;
}
```
- 正常系: AABB交差判定

### 2.7 Sphere (UT-MTH-236 - UT-MTH-261)

#### 根拠となるソースコード

**isEmpty メソッド** (Sphere.js)
```javascript
isEmpty() {
    return ( this.radius < 0 );
}
```
- 正常系: 負の半径で空判定
- 境界値: radius=0 は空ではない（中心点を含む）

**containsPoint メソッド**
```javascript
containsPoint( point ) {
    return ( point.distanceToSquared( this.center ) <= ( this.radius * this.radius ) );
}
```
- 正常系: 点の包含判定
- 境界値: 球面上の点も含む（<=）

### 2.8 Ray (UT-MTH-262 - UT-MTH-285)

#### 根拠となるソースコード

**intersectTriangle メソッド** (Ray.js)
```javascript
intersectTriangle( a, b, c, backfaceCulling, target ) {
    // Moller-Trumbore intersection algorithm
}
```
- 正常系: 三角形との交差判定
- バックフェースカリング: 背面の処理

**intersectSphere メソッド**
```javascript
intersectSphere( sphere, target ) {
    // Quadratic equation for ray-sphere intersection
}
```
- 正常系: 球との交差点計算
- 非交差: null の返却

### 2.9 Plane (UT-MTH-286 - UT-MTH-305)

#### 根拠となるソースコード

**setFromCoplanarPoints メソッド** (Plane.js)
```javascript
setFromCoplanarPoints( a, b, c ) {
    const normal = _vector1.subVectors( c, b ).cross( _vector2.subVectors( a, b ) ).normalize();
    this.setFromNormalAndCoplanarPoint( normal, a );
    return this;
}
```
- 正常系: 3点から平面を定義

**distanceToPoint メソッド**
```javascript
distanceToPoint( point ) {
    return this.normal.dot( point ) + this.constant;
}
```
- 正常系: 符号付き距離の計算

### 2.10 Triangle (UT-MTH-306 - UT-MTH-325)

#### 根拠となるソースコード

**getBarycoord メソッド** (Triangle.js)
```javascript
getBarycoord( point, target ) {
    return Triangle.getBarycoord( point, this.a, this.b, this.c, target );
}
```
- 正常系: 重心座標の計算

**getArea メソッド**
```javascript
getArea() {
    _v0.subVectors( this.c, this.b );
    _v1.subVectors( this.a, this.b );
    return _v0.cross( _v1 ).length() * 0.5;
}
```
- 正常系: 三角形面積の計算
- 境界値: 縮退三角形（面積0）

### 2.11 Frustum (UT-MTH-340 - UT-MTH-352)

#### 根拠となるソースコード

**setFromProjectionMatrix メソッド** (Frustum.js)
```javascript
setFromProjectionMatrix( m ) {
    // Extract 6 planes from projection matrix
}
```
- 正常系: 投影行列から視錐台の6平面を抽出

**intersectsObject メソッド**
```javascript
intersectsObject( object ) {
    // Bounding sphere check against all 6 planes
}
```
- 正常系: オブジェクトカリング判定

### 2.12 座標系クラス (UT-MTH-353 - UT-MTH-363)

#### 根拠となるソースコード

**Spherical.setFromCartesianCoords** (Spherical.js)
```javascript
setFromCartesianCoords( x, y, z ) {
    this.radius = Math.sqrt( x * x + y * y + z * z );
    if ( this.radius === 0 ) {
        this.theta = 0;
        this.phi = 0;
    } else {
        this.theta = Math.atan2( x, z );
        this.phi = Math.acos( clamp( y / this.radius, - 1, 1 ) );
    }
    return this;
}
```

**Cylindrical.setFromCartesianCoords** (Cylindrical.js)
```javascript
setFromCartesianCoords( x, y, z ) {
    this.radius = Math.sqrt( x * x + z * z );
    this.theta = Math.atan2( x, z );
    this.y = y;
    return this;
}
```

### 2.13 SphericalHarmonics3 (UT-MTH-364 - UT-MTH-377)

#### 根拠となるソースコード

**getAt メソッド** (SphericalHarmonics3.js)
```javascript
getAt( normal, target ) {
    // SH basis evaluation for given direction
    // band 0, band 1, band 2 coefficients
}
```
- 正常系: 指定方向の放射輝度計算

**getIrradianceAt メソッド**
```javascript
getIrradianceAt( normal, target ) {
    // Irradiance from SH (convolved with cosine lobe)
}
```
- 正常系: 放射照度計算（ライティング用）

### 2.14 ColorManagement (UT-MTH-378 - UT-MTH-384)

#### 根拠となるソースコード

**SRGBToLinear 関数** (ColorManagement.js)
```javascript
export function SRGBToLinear( c ) {
    return ( c < 0.04045 ) ? c * 0.0773993808 : Math.pow( c * 0.9478672986 + 0.0521327014, 2.4 );
}
```
- 正常系: sRGBからリニアへの変換
- 境界値: 閾値 0.04045 での分岐

**LinearToSRGB 関数**
```javascript
export function LinearToSRGB( c ) {
    return ( c < 0.0031308 ) ? c * 12.92 : 1.055 * ( Math.pow( c, 0.41666 ) ) - 0.055;
}
```
- 正常系: リニアからsRGBへの変換
- 境界値: 閾値 0.0031308 での分岐

### 2.15 Interpolant クラス群 (UT-MTH-385 - UT-MTH-396)

#### 根拠となるソースコード

**LinearInterpolant.interpolate_** (LinearInterpolant.js)
```javascript
interpolate_( i1, t0, t, t1 ) {
    const weight1 = ( t - t0 ) / ( t1 - t0 ),
          weight0 = 1 - weight1;
    // Linear interpolation of sample values
}
```

**CubicInterpolant.interpolate_** (CubicInterpolant.js)
```javascript
interpolate_( i1, t0, t, t1 ) {
    // Cubic Hermite spline interpolation
    const p = ( t - t0 ) / ( t1 - t0 ),
          pp = p * p,
          ppp = pp * p;
    // Polynomial evaluation
}
```

**BezierInterpolant.interpolate_** (BezierInterpolant.js)
```javascript
interpolate_( i1, t0, t, t1 ) {
    // Bezier curve interpolation with Newton-Raphson
    // Falls back to linear if no tangent data
}
```

## 3. テスト観点の網羅性

### 3.1 観点別テストケース分布

| テスト観点 | ケース数 | 割合 |
|-----------|---------|------|
| 正常系 | 328 | 82.8% |
| 異常系 | 12 | 3.0% |
| 境界値 | 56 | 14.2% |

### 3.2 優先度別テストケース分布

| 優先度 | ケース数 | 割合 |
|--------|---------|------|
| 高 | 248 | 62.6% |
| 中 | 136 | 34.4% |
| 低 | 12 | 3.0% |

## 4. 特記事項

### 4.1 精度に関する考慮

数学関数のテストでは浮動小数点の精度を考慮する必要があります。特に以下のケースでは epsilon による許容誤差を設定することを推奨します:

- 三角関数を使用する計算（Quaternion SLERP、角度計算）
- 正規化後の長さ検証
- 行列の逆行列と乗算の検証

### 4.2 パフォーマンステストの考慮

以下の関数は頻繁に呼び出されるため、パフォーマンステストも考慮すべきです:

- Vector3.applyMatrix4
- Matrix4.multiply
- Quaternion.slerp
- Frustum.intersectsBox

### 4.3 既存テストとの整合性

Three.js には既存のテストスイート（test/unit/src/math/）が存在します。本テストケース一覧は、既存テストを補完し、より体系的なカバレッジを提供することを目的としています。

## 5. 参照ソースファイル

- `/Users/tomoka.baba/Work/three.js-dev/src/math/MathUtils.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Vector2.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Vector3.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Vector4.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Matrix3.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Matrix4.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Quaternion.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Euler.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Color.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Box2.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Box3.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Sphere.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Ray.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Plane.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Triangle.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Line3.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Frustum.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Spherical.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Cylindrical.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/SphericalHarmonics3.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/ColorManagement.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/Interpolant.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/interpolants/LinearInterpolant.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/interpolants/CubicInterpolant.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/interpolants/DiscreteInterpolant.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/interpolants/QuaternionLinearInterpolant.js`
- `/Users/tomoka.baba/Work/three.js-dev/src/math/interpolants/BezierInterpolant.js`
