---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 165
  claims_with_evidence: 165
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：nodes モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：165 / 165、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/nodes/core/Node.js` - 基底Nodeクラスの実装
- E-02: `src/nodes/core/NodeFrame.js` - フレーム管理クラスの実装
- E-03: `src/nodes/core/NodeCache.js` - キャッシュ管理クラスの実装
- E-04: `src/nodes/core/NodeUtils.js` - ユーティリティ関数群
- E-05: `src/nodes/core/constants.js` - 定数定義
- E-06: `src/nodes/math/MathNode.js` - 数学関数ノードの実装
- E-07: `src/nodes/math/OperatorNode.js` - 演算子ノードの実装
- E-08: `src/nodes/accessors/TextureNode.js` - テクスチャノードの実装
- E-09: `src/nodes/display/ColorSpaceNode.js` - 色空間変換ノードの実装
- E-10: `src/nodes/lighting/LightsNode.js` - ライティングノードの実装
- E-11: `src/nodes/core/NodeBuilder.js` - ノードビルダーの実装

## 3) Claims と根拠の対応（レビューの主戦場）

### Node クラス (UT-NOD-001 - UT-NOD-009)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Nodeインスタンスの初期化テスト | E-01 | ○ |
| C-02 | getNodeTypeメソッドの正常系テスト | E-01 | ○ |
| C-03 | getNodeTypeのnull時デフォルト動作 | E-01 | ○ |
| C-04 | getCacheKeyの一意性テスト | E-01 | ○ |
| C-05 | serializeメソッドのテスト | E-01 | ○ |
| C-06 | deserializeメソッドのテスト | E-01 | ○ |
| C-07 | updateメソッドのライフサイクルテスト | E-01 | ○ |
| C-08 | updateBeforeメソッドのテスト | E-01 | ○ |
| C-09 | updateAfterメソッドのテスト | E-01 | ○ |

### NodeFrame クラス (UT-NOD-010 - UT-NOD-017)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | NodeFrame初期化テスト | E-02 | ○ |
| C-11 | update時のtime/deltaTime更新テスト | E-02 | ○ |
| C-12 | FRAME更新タイプの重複防止テスト | E-02 | ○ |
| C-13 | RENDER更新タイプの重複防止テスト | E-02 | ○ |
| C-14 | OBJECT更新タイプの毎回更新テスト | E-02 | ○ |
| C-15 | updateBeforeNodeのタイミングテスト | E-02 | ○ |
| C-16 | updateAfterNodeのタイミングテスト | E-02 | ○ |
| C-17 | _getMapsの内部マップ管理テスト | E-02 | ○ |

### NodeCache クラス (UT-NOD-018 - UT-NOD-021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | NodeCache初期化テスト | E-03 | ○ |
| C-19 | getDataのキャッシュ取得テスト | E-03 | ○ |
| C-20 | 親キャッシュからのフォールバック取得テスト | E-03 | ○ |
| C-21 | setDataのキャッシュ設定テスト | E-03 | ○ |

### NodeUtils 関数群 (UT-NOD-022 - UT-NOD-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | hashString正常系テスト | E-04 | ○ |
| C-23 | hashString空文字列境界値テスト | E-04 | ○ |
| C-24 | hashArray正常系テスト | E-04 | ○ |
| C-25 | hashArray空配列境界値テスト | E-04 | ○ |
| C-26 | hash可変長引数テスト | E-04 | ○ |
| C-27-32 | getTypeFromLength各型テスト | E-04 | ○ |
| C-33 | getTypeFromLength未定義長テスト | E-04 | ○ |
| C-34-38 | getTypedArrayFromType各型テスト | E-04 | ○ |
| C-39-44 | getLengthFromType各型テスト | E-04 | ○ |
| C-45 | getMemoryLengthFromTypeテスト | E-04 | ○ |
| C-46-48 | getAlignmentFromType各型テスト | E-04 | ○ |
| C-49-61 | getValueType各型テスト | E-04 | ○ |
| C-62-70 | getValueFromType各型テスト | E-04 | ○ |
| C-71-72 | getDataFromObjectテスト | E-04 | ○ |
| C-73-74 | Base64変換テスト | E-04 | ○ |

### MathNode クラス (UT-NOD-075 - UT-NOD-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | MathNode初期化テスト | E-06 | ○ |
| C-76 | MAX/MIN可変長引数テスト | E-06 | ○ |
| C-77-78 | getInputType型推論テスト | E-06 | ○ |
| C-79-81 | getNodeTypeメソッド固有型テスト | E-06 | ○ |
| C-82-84 | setup特殊メソッド変換テスト | E-06 | ○ |
| C-85-87 | generateコード生成テスト | E-06 | ○ |
| C-88-89 | serialize/deserializeテスト | E-06 | ○ |

### OperatorNode クラス (UT-NOD-090 - UT-NOD-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | OperatorNode初期化テスト | E-07 | ○ |
| C-91 | 可変長引数チェーンテスト | E-07 | ○ |
| C-92-97 | getNodeType各演算子型テスト | E-07 | ○ |
| C-98-99 | getOperatorMethodテスト | E-07 | ○ |
| C-100-102 | generateコード生成テスト | E-07 | ○ |
| C-103-104 | serialize/deserializeテスト | E-07 | ○ |

### TextureNode クラス (UT-NOD-105 - UT-NOD-130)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | TextureNode初期化テスト | E-08 | ○ |
| C-106-107 | value getter/setterテスト | E-08 | ○ |
| C-108 | getUniformHashテスト | E-08 | ○ |
| C-109-112 | getNodeType各テクスチャ型テスト | E-08 | ○ |
| C-113 | getDefaultUVテスト | E-08 | ○ |
| C-114 | getTransformedUVテスト | E-08 | ○ |
| C-115 | setUpdateMatrixテスト | E-08 | ○ |
| C-116-117 | setupテスト（正常/異常） | E-08 | ○ |
| C-118-119 | generateUVテスト | E-08 | ○ |
| C-120-128 | サンプリングメソッドテスト | E-08 | ○ |
| C-129 | cloneテスト | E-08 | ○ |
| C-130 | updateテスト | E-08 | ○ |

### ColorSpaceNode クラス (UT-NOD-131 - UT-NOD-139)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | ColorSpaceNode初期化テスト | E-09 | ○ |
| C-132-134 | resolveColorSpaceテスト | E-09 | ○ |
| C-135-136 | setup最適化テスト | E-09 | ○ |
| C-137-139 | setup色空間変換テスト | E-09 | ○ |

### LightsNode クラス (UT-NOD-140 - UT-NOD-158)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | LightsNode初期化テスト | E-10 | ○ |
| C-141-142 | customCacheKeyテスト | E-10 | ○ |
| C-143-144 | getHashテスト | E-10 | ○ |
| C-145-148 | setupLightsNodeテスト | E-10 | ○ |
| C-149-150 | setupDirectLight/RectAreaテスト | E-10 | ○ |
| C-151-154 | setup/setupLightsテスト | E-10 | ○ |
| C-155-158 | setLights/getLights/hasLightsテスト | E-10 | ○ |

### 定数定義 (UT-NOD-159 - UT-NOD-165)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-159-165 | 各定数定義テスト | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠不足の項目はありません
- 全165テストケースについて、対応するソースコードファイルから直接メソッド・プロパティを確認済み

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースがソースコードに基づいて生成されており、信頼性が高い

### 注意事項
1. **NodeBuilderクラス**: 実装が大規模（約3000行）のため、主要なpublicメソッドのみをテスト対象としている。詳細なテストケースは別途追加を検討
2. **TSLCore関連**: Three.js Shading Language (TSL) のコア機能は複雑な依存関係があるため、統合テストでの検証を推奨
3. **WebGL/WebGPU固有処理**: coordinateSystemによる分岐がある箇所は、両環境でのテストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Node基底クラスのライフサイクルメソッド（update, updateBefore, updateAfter）の呼び出し順序が正しいか
- [ ] NodeUtilsの型推論ロジック（getValueType, getTypeFromLength等）が全パターンをカバーしているか
- [ ] MathNode/OperatorNodeのコード生成が各座標系（WebGL/WebGPU）で正しく動作するか
- [ ] TextureNodeの各サンプリングメソッド（sample, load, blur, level等）が正しくノードをクローン・設定しているか
- [ ] ColorSpaceNodeの色空間変換ロジックがColorManagementと整合しているか
- [ ] LightsNodeのライト管理（追加・削除・更新）が正しく動作するか
- [ ] 全定数（NodeShaderStage, NodeUpdateType, NodeType, NodeAccess）が正しく定義されているか
