---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 158
  claims_with_evidence: 158
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：objects.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と一致しているか
3. **網羅性**：対象モジュールの主要なクラス・メソッドがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で各テストケースの根拠を確認
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：158 / 158、根拠なし：0
- 優先レビュー（高）
  1. **BatchedMesh関連テストケース**：最も複雑なクラスのため重点確認推奨
  2. **SkinnedMesh/Skeleton関連テストケース**：スキニング処理の複雑性
  3. **raycast関連テストケース**：レイキャスト処理の境界条件

## 2) 参照した情報（Evidence一覧）
> 実際にソースコードを読み込んで解析した結果

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Mesh.js`
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Line.js`
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Points.js`
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Sprite.js`
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/objects/InstancedMesh.js`
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/objects/BatchedMesh.js`
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/objects/SkinnedMesh.js`
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Skeleton.js`
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Bone.js`
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/objects/LOD.js`
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/objects/Group.js`
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/objects/LineLoop.js`
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/objects/LineSegments.js`
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/objects/ClippingGroup.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### Mesh クラス（UT-OBJ-001 〜 UT-OBJ-020）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-001 | Mesh.constructor - デフォルト生成 | E-01 L39-108 | ○ |
| UT-OBJ-002 | Mesh.constructor - カスタム初期化 | E-01 L47 | ○ |
| UT-OBJ-003 | Mesh.copy - 基本コピー | E-01 L110-131 | ○ |
| UT-OBJ-004 | Mesh.copy - 配列マテリアル | E-01 L126 | ○ |
| UT-OBJ-005 | Mesh.copy - morphTargetInfluences undefined | E-01 L114-118 | ○ |
| UT-OBJ-006 | Mesh.updateMorphTargets - 基本動作 | E-01 L137-166 | ○ |
| UT-OBJ-007 | Mesh.updateMorphTargets - 空配列 | E-01 L144 | ○ |
| UT-OBJ-008 | Mesh.updateMorphTargets - 名前なし | E-01 L155 | ○ |
| UT-OBJ-009 | Mesh.getVertexPosition - 基本取得 | E-01 L176-218 | ○ |
| UT-OBJ-010 | Mesh.getVertexPosition - モーフ適用 | E-01 L187-213 | ○ |
| UT-OBJ-011 | Mesh.getVertexPosition - ゼロ影響 | E-01 L196-197 | ○ |
| UT-OBJ-012 | Mesh.getVertexPosition - 相対モーフ | E-01 L200-208 | ○ |
| UT-OBJ-013 | Mesh.raycast - 基本交差 | E-01 L226-270 | ○ |
| UT-OBJ-014 | Mesh.raycast - material undefined | E-01 L232 | ○ |
| UT-OBJ-015 | Mesh.raycast - boundingSphere null | E-01 L236-237 | ○ |
| UT-OBJ-016 | Mesh.raycast - 早期リターン（sphere） | E-01 L245-251 | ○ |
| UT-OBJ-017 | Mesh.raycast - 早期リターン（box） | E-01 L260-264 | ○ |
| UT-OBJ-018 | Mesh._computeIntersections - indexed | E-01 L287-343 | ○ |
| UT-OBJ-019 | Mesh._computeIntersections - non-indexed | E-01 L345-403 | ○ |
| UT-OBJ-020 | Mesh._computeIntersections - マルチマテリアル | E-01 L291-319 | ○ |

### Line クラス（UT-OBJ-021 〜 UT-OBJ-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-021 | Line.constructor - デフォルト生成 | E-02 L41-101 | ○ |
| UT-OBJ-022 | Line.copy - 基本コピー | E-02 L103-112 | ○ |
| UT-OBJ-023 | Line.computeLineDistances - non-indexed | E-02 L121-152 | ○ |
| UT-OBJ-024 | Line.computeLineDistances - indexed警告 | E-02 L144-148 | ○ |
| UT-OBJ-025 | Line.computeLineDistances - 1頂点 | E-02 L130-140 | ○ |
| UT-OBJ-026 | Line.raycast - 基本交差 | E-02 L160-257 | ○ |
| UT-OBJ-027 | Line.raycast - threshold | E-02 L164, L182-183 | ○ |
| UT-OBJ-028 | Line.raycast - isLineLoop | E-02 L211-224, L243-253 | ○ |
| UT-OBJ-029 | Line.raycast - isLineSegments | E-02 L185 | ○ |
| UT-OBJ-030 | Line.updateMorphTargets | E-02 L263-292 | ○ |

### Points クラス（UT-OBJ-031 〜 UT-OBJ-036）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-031 | Points.constructor - デフォルト生成 | E-03 L19-79 | ○ |
| UT-OBJ-032 | Points.copy - 基本コピー | E-03 L81-90 | ○ |
| UT-OBJ-033 | Points.raycast - 基本交差 | E-03 L98-157 | ○ |
| UT-OBJ-034 | Points.raycast - threshold | E-03 L102, L120-121 | ○ |
| UT-OBJ-035 | Points.raycast - near/far | E-03 L209 (testPoint内) | ○ |
| UT-OBJ-036 | Points.updateMorphTargets | E-03 L163-192 | ○ |

### Sprite クラス（UT-OBJ-037 〜 UT-OBJ-043）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-037 | Sprite.constructor - デフォルト生成 | E-04 L47-121 | ○ |
| UT-OBJ-038 | Sprite.constructor - 共有geometry | E-04 L69-86 | ○ |
| UT-OBJ-039 | Sprite.raycast - 基本交差 | E-04 L129-202 | ○ |
| UT-OBJ-040 | Sprite.raycast - camera null | E-04 L131-135 | ○ |
| UT-OBJ-041 | Sprite.raycast - rotation | E-04 L150-158 | ○ |
| UT-OBJ-042 | Sprite.raycast - sizeAttenuation | E-04 L144-148 | ○ |
| UT-OBJ-043 | Sprite.copy - 基本コピー | E-04 L204-214 | ○ |

### InstancedMesh クラス（UT-OBJ-044 〜 UT-OBJ-060）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-044 | InstancedMesh.constructor - 基本生成 | E-05 L28-117 | ○ |
| UT-OBJ-045 | InstancedMesh.constructor - identity初期化 | E-05 L111-115 | ○ |
| UT-OBJ-046 | InstancedMesh.computeBoundingBox | E-05 L124-153 | ○ |
| UT-OBJ-047 | InstancedMesh.computeBoundingSphere | E-05 L160-189 | ○ |
| UT-OBJ-048 | InstancedMesh.copy | E-05 L191-208 | ○ |
| UT-OBJ-049 | InstancedMesh.getColorAt | E-05 L217-221 | ○ |
| UT-OBJ-050 | InstancedMesh.setColorAt | E-05 L318-328 | ○ |
| UT-OBJ-051 | InstancedMesh.setColorAt - 初期化 | E-05 L320-324 | ○ |
| UT-OBJ-052 | InstancedMesh.getMatrixAt | E-05 L229-233 | ○ |
| UT-OBJ-053 | InstancedMesh.setMatrixAt | E-05 L337-341 | ○ |
| UT-OBJ-054 | InstancedMesh.getMorphAt | E-05 L241-257 | ○ |
| UT-OBJ-055 | InstancedMesh.setMorphAt | E-05 L351-381 | ○ |
| UT-OBJ-056 | InstancedMesh.setMorphAt - 初期化 | E-05 L357-361 | ○ |
| UT-OBJ-057 | InstancedMesh.raycast | E-05 L259-308 | ○ |
| UT-OBJ-058 | InstancedMesh.raycast - 早期リターン | E-05 L271-276 | ○ |
| UT-OBJ-059 | InstancedMesh.dispose | E-05 L391-402 | ○ |
| UT-OBJ-060 | InstancedMesh.dispose - イベント | E-05 L393 | ○ |

### BatchedMesh クラス（UT-OBJ-061 〜 UT-OBJ-097）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-061 | BatchedMesh.constructor | E-06 L182-285 | ○ |
| UT-OBJ-062 | BatchedMesh.maxInstanceCount getter | E-06 L293-297 | ○ |
| UT-OBJ-063 | BatchedMesh.instanceCount getter | E-06 L305-308 | ○ |
| UT-OBJ-064 | BatchedMesh.addGeometry | E-06 L627-703 | ○ |
| UT-OBJ-065 | BatchedMesh.addGeometry - 容量超過 | E-06 L666-674 | ○ |
| UT-OBJ-066 | BatchedMesh.addGeometry - 予約領域 | E-06 L655-664 | ○ |
| UT-OBJ-067 | BatchedMesh.addInstance | E-06 L561-609 | ○ |
| UT-OBJ-068 | BatchedMesh.addInstance - 容量超過 | E-06 L563-570 | ○ |
| UT-OBJ-069 | BatchedMesh.setGeometryAt | E-06 L714-817 | ○ |
| UT-OBJ-070 | BatchedMesh.setGeometryAt - サイズ超過 | E-06 L729-737 | ○ |
| UT-OBJ-071 | BatchedMesh.deleteGeometry | E-06 L826-853 | ○ |
| UT-OBJ-072 | BatchedMesh.deleteGeometry - 連鎖削除 | E-06 L836-845 | ○ |
| UT-OBJ-073 | BatchedMesh.deleteInstance | E-06 L861-871 | ○ |
| UT-OBJ-074 | BatchedMesh.validateInstanceId | E-06 L453-462 | ○ |
| UT-OBJ-075 | BatchedMesh.validateGeometryId | E-06 L469-478 | ○ |
| UT-OBJ-076 | BatchedMesh.getMatrixAt | E-06 L1095-1100 | ○ |
| UT-OBJ-077 | BatchedMesh.setMatrixAt | E-06 L1075-1086 | ○ |
| UT-OBJ-078 | BatchedMesh.getColorAt | E-06 L1133-1138 | ○ |
| UT-OBJ-079 | BatchedMesh.setColorAt | E-06 L1109-1124 | ○ |
| UT-OBJ-080 | BatchedMesh.getVisibleAt | E-06 L1170-1176 | ○ |
| UT-OBJ-081 | BatchedMesh.setVisibleAt | E-06 L1147-1162 | ○ |
| UT-OBJ-082 | BatchedMesh.getGeometryIdAt | E-06 L1202-1208 | ○ |
| UT-OBJ-083 | BatchedMesh.setGeometryIdAt | E-06 L1185-1194 | ○ |
| UT-OBJ-084 | BatchedMesh.getBoundingBoxAt | E-06 L977-1012 | ○ |
| UT-OBJ-085 | BatchedMesh.getBoundingBoxAt - 無効ID | E-06 L979-983 | ○ |
| UT-OBJ-086 | BatchedMesh.getBoundingSphereAt | E-06 L1022-1064 | ○ |
| UT-OBJ-087 | BatchedMesh.computeBoundingBox | E-06 L499-522 | ○ |
| UT-OBJ-088 | BatchedMesh.computeBoundingSphere | E-06 L529-552 | ○ |
| UT-OBJ-089 | BatchedMesh.optimize | E-06 L879-968 | ○ |
| UT-OBJ-090 | BatchedMesh.raycast | E-06 L1367-1427 | ○ |
| UT-OBJ-091 | BatchedMesh.raycast - 可視性フィルタ | E-06 L1392-1396 | ○ |
| UT-OBJ-092 | BatchedMesh.setCustomSort | E-06 L487-492 | ○ |
| UT-OBJ-093 | BatchedMesh.copy | E-06 L1429-1477 | ○ |
| UT-OBJ-094 | BatchedMesh.dispose | E-06 L1483-1501 | ○ |
| UT-OBJ-095 | BatchedMesh.setInstanceCount | E-06 L1249-1300 | ○ |
| UT-OBJ-096 | BatchedMesh.setGeometrySize | E-06 L1310-1365 | ○ |
| UT-OBJ-097 | BatchedMesh.onBeforeRender | E-06 L1503-1644 | ○ |

### SkinnedMesh クラス（UT-OBJ-098 〜 UT-OBJ-111）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-098 | SkinnedMesh.constructor | E-07 L38-101 | ○ |
| UT-OBJ-099 | SkinnedMesh.bind | E-07 L230-247 | ○ |
| UT-OBJ-100 | SkinnedMesh.bind - デフォルトbindMatrix | E-07 L234-241 | ○ |
| UT-OBJ-101 | SkinnedMesh.pose | E-07 L252-256 | ○ |
| UT-OBJ-102 | SkinnedMesh.normalizeSkinWeights | E-07 L262-288 | ○ |
| UT-OBJ-103 | SkinnedMesh.normalizeSkinWeights - ゼロ | E-07 L274-282 | ○ |
| UT-OBJ-104 | SkinnedMesh.computeBoundingBox | E-07 L109-130 | ○ |
| UT-OBJ-105 | SkinnedMesh.computeBoundingSphere | E-07 L138-159 | ○ |
| UT-OBJ-106 | SkinnedMesh.copy | E-07 L161-176 | ○ |
| UT-OBJ-107 | SkinnedMesh.raycast | E-07 L178-210 | ○ |
| UT-OBJ-108 | SkinnedMesh.getVertexPosition | E-07 L213-221 | ○ |
| UT-OBJ-109 | SkinnedMesh.applyBoneTransform | E-07 L319-348 | ○ |
| UT-OBJ-110 | SkinnedMesh.updateMatrixWorld - Attached | E-07 L290-297 | ○ |
| UT-OBJ-111 | SkinnedMesh.updateMatrixWorld - Detached | E-07 L298-301 | ○ |

### Skeleton クラス（UT-OBJ-112 〜 UT-OBJ-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-112 | Skeleton.constructor | E-08 L37-93 | ○ |
| UT-OBJ-113 | Skeleton.constructor - カスタムboneInverses | E-08 L62-63 | ○ |
| UT-OBJ-114 | Skeleton.init - boneMatrices | E-08 L100-133 | ○ |
| UT-OBJ-115 | Skeleton.init - 不一致警告 | E-08 L117-129 | ○ |
| UT-OBJ-116 | Skeleton.calculateInverses | E-08 L139-157 | ○ |
| UT-OBJ-117 | Skeleton.pose | E-08 L162-203 | ○ |
| UT-OBJ-118 | Skeleton.update | E-08 L208-234 | ○ |
| UT-OBJ-119 | Skeleton.update - boneTexture | E-08 L228-232 | ○ |
| UT-OBJ-120 | Skeleton.clone | E-08 L241-245 | ○ |
| UT-OBJ-121 | Skeleton.computeBoneTexture | E-08 L252-276 | ○ |
| UT-OBJ-122 | Skeleton.computeBoneTexture - サイズ | E-08 L261-263 | ○ |
| UT-OBJ-123 | Skeleton.getBoneByName | E-08 L285-301 | ○ |
| UT-OBJ-124 | Skeleton.getBoneByName - 未発見 | E-08 L299 | ○ |
| UT-OBJ-125 | Skeleton.dispose | E-08 L307-317 | ○ |
| UT-OBJ-126 | Skeleton.toJSON | E-08 L359-388 | ○ |
| UT-OBJ-127 | Skeleton.fromJSON | E-08 L326-351 | ○ |
| UT-OBJ-128 | Skeleton.fromJSON - UUID不一致 | E-08 L335-339 | ○ |

### Bone クラス（UT-OBJ-129 〜 UT-OBJ-130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-129 | Bone.constructor | E-09 L17-38 | ○ |
| UT-OBJ-130 | Bone - Object3D継承 | E-09 L17 | ○ |

### LOD クラス（UT-OBJ-131 〜 UT-OBJ-145）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-131 | LOD.constructor | E-10 L33-85 | ○ |
| UT-OBJ-132 | LOD.addLevel | E-10 L116-140 | ○ |
| UT-OBJ-133 | LOD.addLevel - ソート | E-10 L124-134 | ○ |
| UT-OBJ-134 | LOD.addLevel - 負値 | E-10 L118 | ○ |
| UT-OBJ-135 | LOD.removeLevel | E-10 L149-167 | ○ |
| UT-OBJ-136 | LOD.removeLevel - 未発見 | E-10 L166 | ○ |
| UT-OBJ-137 | LOD.getCurrentLevel | E-10 L175-179 | ○ |
| UT-OBJ-138 | LOD.getObjectForDistance | E-10 L188-220 | ○ |
| UT-OBJ-139 | LOD.getObjectForDistance - 空 | E-10 L218 | ○ |
| UT-OBJ-140 | LOD.update | E-10 L250-297 | ○ |
| UT-OBJ-141 | LOD.update - hysteresis | E-10 L267-272 | ○ |
| UT-OBJ-142 | LOD.update - zoom | E-10 L259 | ○ |
| UT-OBJ-143 | LOD.raycast | E-10 L228-242 | ○ |
| UT-OBJ-144 | LOD.copy | E-10 L87-105 | ○ |
| UT-OBJ-145 | LOD.toJSON | E-10 L300-324 | ○ |

### Group クラス（UT-OBJ-146 〜 UT-OBJ-147）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-146 | Group.constructor | E-11 L20-38 | ○ |
| UT-OBJ-147 | Group - Object3D継承 | E-11 L20 | ○ |

### LineLoop クラス（UT-OBJ-148 〜 UT-OBJ-149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-148 | LineLoop.constructor | E-12 L10-33 | ○ |
| UT-OBJ-149 | LineLoop - Line継承 | E-12 L10 | ○ |

### LineSegments クラス（UT-OBJ-150 〜 UT-OBJ-152）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-150 | LineSegments.constructor | E-13 L14-37 | ○ |
| UT-OBJ-151 | LineSegments.computeLineDistances | E-13 L39-69 | ○ |
| UT-OBJ-152 | LineSegments.computeLineDistances - indexed警告 | E-13 L62-66 | ○ |

### ClippingGroup クラス（UT-OBJ-153 〜 UT-OBJ-158）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| UT-OBJ-153 | ClippingGroup.constructor | E-14 L15-64 | ○ |
| UT-OBJ-154 | ClippingGroup - Group継承 | E-14 L15 | ○ |
| UT-OBJ-155 | ClippingGroup.clippingPlanes | E-14 L36-38 | ○ |
| UT-OBJ-156 | ClippingGroup.enabled | E-14 L44-47 | ○ |
| UT-OBJ-157 | ClippingGroup.clipIntersection | E-14 L52-55 | ○ |
| UT-OBJ-158 | ClippingGroup.clipShadows | E-14 L60-63 | ○ |

## 4) 不足情報（Unknown / Missing）

全てのテストケースはソースコードから直接抽出されており、根拠なしの項目はありません。

補完が必要な可能性のある情報：
- 実際のテスト実装時には、Three.jsのテストユーティリティ（test/unit/配下）を参照することを推奨
- 既存のテストケース（test/unit/src/objects/配下）との重複確認が必要

## 5) リスクフラグ（レビュー観点）

| リスク | 項目 | 理由 |
|--------|------|------|
| 1 | BatchedMesh関連テスト | 最も複雑なクラス、内部状態管理が多い |
| 1 | raycast関連テスト | 境界条件の検証が重要 |
| 1 | SkinnedMesh/Skeleton連携 | ボーン変換の数値精度 |
| 0 | 単純なコンストラクタテスト | 低リスク、実装が単純 |
| 0 | getter/setterテスト | 低リスク、単純な値操作 |

## 6) レビュアーチェックリスト（最小）

- [ ] BatchedMeshの容量管理テストケースが適切か確認
- [ ] raycastの境界条件（near/far、threshold）が網羅されているか確認
- [ ] SkinnedMeshとSkeletonの連携テストが十分か確認
- [ ] モーフターゲット関連のテストケースが適切か確認
- [ ] copy/clone系メソッドで深いコピーが必要な箇所が網羅されているか確認
- [ ] dispose系メソッドでリソースリークがないか確認
- [ ] 既存のThree.jsテストスイート（test/unit/src/objects/）との整合性確認
