---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：renderers.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（renderers.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-RND-129 (WebGPURenderer フォールバック動作)**: 実際のWebGPU非対応環境でのテストが必要
  2. **UT-RND-011 (XR表示中サイズ変更拒否)**: XR環境での実機テストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/renderers/WebGLRenderer.js` - WebGLRendererクラス実装（3500行以上）
- E-02: `src/renderers/WebGLRenderTarget.js` - WebGLRenderTargetクラス実装
- E-03: `src/renderers/WebGL3DRenderTarget.js` - WebGL3DRenderTargetクラス実装
- E-04: `src/renderers/WebGLArrayRenderTarget.js` - WebGLArrayRenderTargetクラス実装
- E-05: `src/renderers/WebGLCubeRenderTarget.js` - WebGLCubeRenderTargetクラス実装
- E-06: `src/renderers/webgl/WebGLCapabilities.js` - WebGLCapabilities機能実装
- E-07: `src/renderers/webgl/WebGLState.js` - WebGLState（ColorBuffer, DepthBuffer, StencilBuffer）実装
- E-08: `src/renderers/webgl/WebGLInfo.js` - レンダリング統計情報管理
- E-09: `src/renderers/webgl/WebGLAttributes.js` - バッファ属性管理
- E-10: `src/renderers/webgl/WebGLExtensions.js` - WebGL拡張管理
- E-11: `src/renderers/webgl/WebGLTextures.js` - テクスチャ管理
- E-12: `src/renderers/webgl/WebGLProgram.js` - シェーダープログラム管理
- E-13: `src/renderers/webgl/WebGLShadowMap.js` - シャドウマップ実装
- E-14: `src/renderers/common/DataMap.js` - 汎用データマップ構造
- E-15: `src/renderers/common/ChainMap.js` - チェーンキーマップ構造
- E-16: `src/renderers/common/Color4.js` - 4成分カラークラス
- E-17: `src/renderers/common/Uniform.js` - ユニフォーム型定義
- E-18: `src/renderers/common/RenderContext.js` - レンダーコンテキスト管理
- E-19: `src/renderers/common/ClippingContext.js` - クリッピングコンテキスト管理
- E-20: `src/renderers/common/QuadMesh.js` - フルスクリーンクワッドメッシュ
- E-21: `src/renderers/common/Info.js` - 統計情報クラス（共通レンダラー）
- E-22: `src/renderers/common/Backend.js` - バックエンド抽象基底クラス
- E-23: `src/renderers/common/Renderer.js` - 共通レンダラー基底クラス
- E-24: `src/renderers/webgpu/WebGPURenderer.js` - WebGPUレンダラー実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | WebGLRenderer.constructorでデフォルト初期化 | E-01 (line 71-86) | ○ |
| C-002 | カスタムcanvas指定 | E-01 (line 74) | ○ |
| C-003 | WebGL1コンテキスト拒否 | E-01 (line 101-105) | ○ |
| C-004 | getContext返却値 | E-01 (line 566-570) | ○ |
| C-005 | getPixelRatioデフォルト値 | E-01 (line 607-612) | ○ |
| C-006 | setPixelRatio設定 | E-01 (line 619-627) | ○ |
| C-007 | setPixelRatio undefined無視 | E-01 (line 621) | ○ |
| C-008 | getSize返却値 | E-01 (line 635-639) | ○ |
| C-009 | setSize動作 | E-01 (line 650-680) | ○ |
| C-010 | setSize updateStyle制御 | E-01 (line 665-669) | ○ |
| C-011 | XR表示中サイズ変更拒否 | E-01 (line 652-657) | △ |
| C-012 | getDrawingBufferSize物理ピクセル | E-01 (line 688-692) | ○ |
| C-013 | setViewport設定 | E-01 (line 787-801) | ○ |
| C-014 | setViewport Vector4対応 | E-01 (line 789-791) | ○ |
| C-015 | setScissor設定 | E-01 (line 824-838) | ○ |
| C-016 | setScissorTest有効化 | E-01 (line 858-862) | ○ |
| C-017 | setClearColor設定 | E-01 (line 908-912) | ○ |
| C-018 | getClearAlpha返却値 | E-01 (line 919-922) | ○ |
| C-019 | clearバッファクリア | E-01 (line 944-1003) | ○ |
| C-020 | clear選択的クリア | E-01 (line 944-1003) | ○ |
| C-021 | 整数フォーマットクリア | E-01 (line 951-988) | ○ |
| C-022 | forceContextLoss動作 | E-01 (line 586-591) | ○ |
| C-023 | forceContextRestore動作 | E-01 (line 596-601) | ○ |
| C-024 | setOpaqueSort設定 | E-01 (line 870-874) | ○ |
| C-025 | setTransparentSort設定 | E-01 (line 882-886) | ○ |
| C-026 | WebGLRenderTargetデフォルト初期化 | E-02 (line 17) | ○ |
| C-027 | WebGLRenderTargetサイズ指定 | E-02 (line 17) | ○ |
| C-028 | isWebGLRenderTargetフラグ | E-02 (line 28) | ○ |
| C-029 | WebGL3DRenderTarget 3Dテクスチャ | E-03 (line 39) | ○ |
| C-030 | WebGL3DRenderTarget depthプロパティ | E-03 (line 32) | ○ |
| C-031 | WebGLArrayRenderTarget配列テクスチャ | E-04 (line 39) | ○ |
| C-032 | isWebGLArrayRenderTargetフラグ | E-04 (line 30) | ○ |
| C-033 | WebGLCubeRenderTargetキューブテクスチャ | E-05 (line 44) | ○ |
| C-034 | fromEquirectangularTexture変換 | E-05 (line 66-154) | ○ |
| C-035 | fromEquirectangularTextureプロパティ継承 | E-05 (line 68-73) | ○ |
| C-036 | WebGLCubeRenderTarget.clear全面クリア | E-05 (line 164-178) | ○ |
| C-037 | getMaxAnisotropy返却値 | E-06 (line 8-26) | ○ |
| C-038 | getMaxAnisotropy非対応時0 | E-06 (line 18-22) | ○ |
| C-039 | getMaxPrecision highp返却 | E-06 (line 55-68) | ○ |
| C-040 | getMaxPrecision フォールバック | E-06 (line 66-81) | ○ |
| C-041 | textureFormatReadable判定 | E-06 (line 28-37) | ○ |
| C-042 | textureTypeReadable判定 | E-06 (line 40-52) | ○ |
| C-043 | WebGLExtensions.has動作 | E-10 (line 25-28) | ○ |
| C-044 | WebGLExtensions.get返却値 | E-10 (line 42-54) | ○ |
| C-045 | WebGLExtensions.get警告 | E-10 (line 46-50) | ○ |
| C-046 | WebGLExtensions.init初期化 | E-10 (line 31-40) | ○ |
| C-047 | ColorBuffer.setMask動作 | E-07 (line 30-38) | ○ |
| C-048 | ColorBuffer.setMaskロック機能 | E-07 (line 32) | ○ |
| C-049 | ColorBuffer.setClear動作 | E-07 (line 47-63) | ○ |
| C-050 | ColorBuffer.setClear premultipliedAlpha | E-07 (line 49-51) | ○ |
| C-051 | DepthBuffer.setTest有効化 | E-07 (line 122-133) | ○ |
| C-052 | DepthBuffer.setFunc設定 | E-07 (line 147-203) | ○ |
| C-053 | DepthBuffer.setFunc逆深度対応 | E-07 (line 149) | ○ |
| C-054 | DepthBuffer.setMask設定 | E-07 (line 136-144) | ○ |
| C-055 | DepthBuffer.setClear設定 | E-07 (line 213-227) | ○ |
| C-056 | DepthBuffer.setReversed設定 | E-07 (line 90-113) | ○ |
| C-057 | StencilBuffer.setTest動作 | E-07 (line 261-277) | ○ |
| C-058 | StencilBuffer.setFunc動作 | E-07 (line 290-300) | ○ |
| C-059 | WebGLInfo.update三角形カウント | E-08 (line 23-26) | ○ |
| C-060 | WebGLInfo.updateラインカウント | E-08 (line 28-35) | ○ |
| C-061 | WebGLInfo.updateポイントカウント | E-08 (line 37-40) | ○ |
| C-062 | WebGLInfo.updateエラーハンドリング | E-08 (line 42-46) | ○ |
| C-063 | WebGLInfo.resetリセット | E-08 (line 52-59) | ○ |
| C-064 | WebGLAttributes Float32Arrayバッファ | E-09 (line 20-22) | ○ |
| C-065 | WebGLAttributes Uint16Arrayバッファ | E-09 (line 28-38) | ○ |
| C-066 | WebGLAttributes Float16対応 | E-09 (line 30-32) | ○ |
| C-067 | WebGLAttributes非サポート型エラー | E-09 (line 64-68) | ○ |
| C-068 | WebGLAttributes.updateバッファ更新 | E-09 (line 181-222) | ○ |
| C-069 | WebGLAttributes updateRangesマージ | E-09 (line 92-147) | ○ |
| C-070 | WebGLAttributesサイズ変更エラー | E-09 (line 212-215) | ○ |
| C-071 | WebGLAttributes Interleaved対応 | E-09 (line 159) | ○ |
| C-072 | WebGLAttributes.remove削除 | E-09 (line 165-178) | ○ |
| C-073 | WebGLTextures resizeImageリサイズ | E-11 (line 45-105) | ○ |
| C-074 | WebGLTextures resizeImage不要判定 | E-11 (line 59-61) | ○ |
| C-075 | WebGLTextures getInternalFormat変換 | E-11 (line 128-200) | ○ |
| C-076 | WebGLTextures カスタムフォーマット | E-11 (line 130-132) | ○ |
| C-077 | WebGLTextures 不明フォーマット警告 | E-11 (line 134) | ○ |
| C-078 | WebGLTextures getTargetType CUBE_MAP | E-11 (line 121) | ○ |
| C-079 | WebGLTextures getTargetType TEXTURE_3D | E-11 (line 122) | ○ |
| C-080 | DataMap.get辞書返却 | E-14 (line 30-43) | ○ |
| C-081 | DataMap.getキャッシュ機能 | E-14 (line 32-39) | ○ |
| C-082 | DataMap.delete削除 | E-14 (line 51-65) | ○ |
| C-083 | DataMap.delete存在しないキー | E-14 (line 53-61) | ○ |
| C-084 | DataMap.has存在確認 | E-14 (line 73-77) | ○ |
| C-085 | DataMap.disposeリソース解放 | E-14 (line 82-86) | ○ |
| C-086 | ChainMap.get値取得 | E-15 (line 55-68) | ○ |
| C-087 | ChainMap.get存在しないキー | E-15 (line 63) | ○ |
| C-088 | ChainMap.set値設定 | E-15 (line 78-96) | ○ |
| C-089 | ChainMap.delete削除 | E-15 (line 104-117) | ○ |
| C-090 | ChainMap.delete削除失敗 | E-15 (line 112) | ○ |
| C-091 | Color4 RGBA初期化 | E-16 (line 23-29) | ○ |
| C-092 | Color4デフォルトalpha | E-16 (line 23) | ○ |
| C-093 | Color4.set値設定 | E-16 (line 42-48) | ○ |
| C-094 | Color4.copyコピー | E-16 (line 56-62) | ○ |
| C-095 | Color4.cloneクローン | E-16 (line 69-73) | ○ |
| C-096 | Uniformコンストラクタ | E-17 (line 23-72) | ○ |
| C-097 | Uniform.setValue更新 | E-17 (line 79-83) | ○ |
| C-098 | NumberUniform設定 | E-17 (line 104-130) | ○ |
| C-099 | Vector2Uniform設定 | E-17 (line 138-164) | ○ |
| C-100 | Vector3Uniform設定 | E-17 (line 172-198) | ○ |
| C-101 | Vector4Uniform設定 | E-17 (line 206-232) | ○ |
| C-102 | Matrix3Uniform設定 | E-17 (line 309-335) | ○ |
| C-103 | Matrix4Uniform設定 | E-17 (line 343-369) | ○ |
| C-104 | RenderContextデフォルト初期化 | E-18 (line 19-241) | ○ |
| C-105 | RenderContext一意ID | E-18 (line 26) | ○ |
| C-106 | RenderContext.getCacheKey | E-18 (line 249-253) | ○ |
| C-107 | ClippingContextデフォルト初期化 | E-19 (line 22-101) | ○ |
| C-108 | ClippingContext親コンテキスト継承 | E-19 (line 91-99) | ○ |
| C-109 | ClippingContext.projectPlanes変換 | E-19 (line 111-129) | ○ |
| C-110 | ClippingContext.updateGlobal更新 | E-19 (line 137-144) | ○ |
| C-111 | ClippingContext.update更新 | E-19 (line 152-219) | ○ |
| C-112 | ClippingContext.getGroupContext取得 | E-19 (line 229-246) | ○ |
| C-113 | ClippingContextコンテキストキャッシュ | E-19 (line 233-238) | ○ |
| C-114 | QuadMesh初期化 | E-20 (line 58-79) | ○ |
| C-115 | QuadMesh.renderレンダリング | E-20 (line 104-108) | ○ |
| C-116 | QuadMesh.renderAsync非推奨警告 | E-20 (line 89-97) | ○ |
| C-117 | Info初期化 | E-21 (line 13-96) | ○ |
| C-118 | Info.updateメッシュカウント | E-21 (line 106-112) | ○ |
| C-119 | Info.updateポイントカウント | E-21 (line 114-116) | ○ |
| C-120 | Info.updateラインセグメントカウント | E-21 (line 118-120) | ○ |
| C-121 | Info.resetリセット | E-21 (line 137-148) | ○ |
| C-122 | Info.dispose完全リセット | E-21 (line 153-167) | ○ |
| C-123 | Backend初期化 | E-22 (line 28-79) | ○ |
| C-124 | Backend.initレンダラー設定 | E-22 (line 90-94) | ○ |
| C-125 | Renderer初期化 | E-23 (line 81-500) | ○ |
| C-126 | Rendererデフォルト値 | E-23 (line 117-201) | ○ |
| C-127 | WebGPURenderer初期化 | E-24 (line 52-102) | ○ |
| C-128 | WebGPURenderer forceWebGL | E-24 (line 56-58) | ○ |
| C-129 | WebGPURendererフォールバック | E-24 (line 64-70) | △ |
| C-130 | WebGLShadowMap初期化 | E-13 (line 35-91) | ○ |
| C-131 | WebGLShadowMap enabled=falseスキップ | E-13 (line 94) | ○ |
| C-132 | WebGLShadowMapライトなしスキップ | E-13 (line 97) | ○ |
| C-133 | WebGLShadowMap PCFSoftShadowMap警告 | E-13 (line 99-103) | ○ |
| C-134 | WebGLShadowMapサイズ制限 | E-13 (line 180-198) | ○ |
| C-135 | getShaderErrorsエラー情報 | E-12 (line 58-81) | ○ |
| C-136 | getShaderErrors正常時空文字 | E-12 (line 65) | ○ |
| C-137 | getToneMappingFunction関数返却 | E-12 (line 110-122) | ○ |
| C-138 | getToneMappingFunctionフォールバック | E-12 (line 114-117) | ○ |
| C-139 | generateDefines定義生成 | E-12 (line 160-176) | ○ |
| C-140 | generateDefines false値スキップ | E-12 (line 168) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-RND-011 (XR表示中サイズ変更拒否)**: XRManagerの`isPresenting`状態のテストには実際のXR環境が必要
  - 候補：WebXR Device API Mock / XR Emulator
- **UT-RND-129 (WebGPU非対応時フォールバック)**: WebGPU非対応環境での動作確認が必要
  - 候補：Chromeフラグでの無効化 / Safari（WebGPU未サポートバージョン）

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコードから直接導出可能
- **1 (中リスク)**: WebGL拡張依存のテスト（環境依存）
  - UT-RND-037〜046: EXT_texture_filter_anisotropic, EXT_color_buffer_float等
  - UT-RND-056: EXT_clip_control（逆深度バッファ）
- **1 (中リスク)**: 描画結果の検証が必要なテスト
  - UT-RND-034, 035: equirectangularからcubemapへの変換
  - UT-RND-073, 074: テクスチャリサイズ

## 6) レビュアーチェックリスト（最小）
- [ ] WebGLRenderer初期化テスト（UT-RND-001〜025）でコンストラクタパラメータが網羅されているか
- [ ] RenderTarget系クラス（UT-RND-026〜036）でテクスチャ型が正しく設定されるか
- [ ] WebGLState系テスト（UT-RND-047〜058）で状態管理が適切に検証されているか
- [ ] 統計情報テスト（UT-RND-059〜063, 117〜122）で描画プリミティブカウントが正確か
- [ ] バッファ管理テスト（UT-RND-064〜072）でメモリリークが発生しないか
- [ ] 共通レンダラーコンポーネント（UT-RND-080〜116）でWebGPU/WebGL両方で動作するか
- [ ] シャドウマップテスト（UT-RND-130〜134）でmaxTextureSizeの制限が機能するか
- [ ] シェーダーエラーハンドリング（UT-RND-135〜140）でユーザーフレンドリーなエラーが出力されるか
