---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 71
  claims_with_evidence: 68
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：scenes モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：68 / 71、根拠なし：3
- 優先レビュー（高）
  1. **C-66 (UT-SCN-066)**：Fog.colorにundefinedを渡した場合の挙動 - Colorクラスの内部実装に依存
  2. **C-67 (UT-SCN-067)**：FogExp2.colorにundefinedを渡した場合の挙動 - Colorクラスの内部実装に依存
  3. **C-68 (UT-SCN-068)**：Scene.copyにnullを渡した場合の挙動 - エラーハンドリングの明示的なコードなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/scenes/Fog.js` - Fogクラス実装（99行）
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/scenes/FogExp2.js` - FogExp2クラス実装（87行）
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/scenes/Scene.js` - Sceneクラス実装（166行）

## 3) Claims と根拠の対応（レビューの主戦場）

### Fog クラス（E-01）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fog.constructor: 色と距離パラメータで正しく初期化 | E-01 L21-65 | ○ |
| C-02 | Fog.constructor: デフォルト値 near=1, far=1000 | E-01 L21 | ○ |
| C-03 | Fog.constructor: Colorオブジェクトで初期化可能 | E-01 L44 | ○ |
| C-04 | Fog.constructor: isFog=true | E-01 L30 | ○ |
| C-05 | Fog.constructor: name='' | E-01 L37 | ○ |
| C-06 | Fog.clone: 同じ値を持つ複製を返却 | E-01 L72-76 | ○ |
| C-07 | Fog.clone: 独立したインスタンス | E-01 L74 (new Fog使用) | ○ |
| C-08 | Fog.toJSON: 正しいJSON形式 | E-01 L84-94 | ○ |
| C-09 | Fog.toJSON: colorがHex値 | E-01 L89 (getHex()) | ○ |
| C-10 | Fog.toJSON: nameプロパティ含む | E-01 L88 | ○ |
| C-11 | Fog.constructor: near=0の境界値 | E-01 L21 (バリデーションなし) | ○ |
| C-12 | Fog.constructor: near=farの境界値 | E-01 L21 (バリデーションなし) | ○ |
| C-13 | Fog.constructor: 負の値の許容 | E-01 L21 (バリデーションなし) | ○ |

### FogExp2 クラス（E-02）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | FogExp2.constructor: 色と密度で正しく初期化 | E-02 L21-54 | ○ |
| C-15 | FogExp2.constructor: デフォルト density=0.00025 | E-02 L21 | ○ |
| C-16 | FogExp2.constructor: isFogExp2=true | E-02 L30 | ○ |
| C-17 | FogExp2.constructor: Colorオブジェクトで初期化可能 | E-02 L44 | ○ |
| C-18 | FogExp2.constructor: name='' | E-02 L37 | ○ |
| C-19 | FogExp2.clone: 同じ値を持つ複製を返却 | E-02 L61-65 | ○ |
| C-20 | FogExp2.clone: 独立したインスタンス | E-02 L63 (new FogExp2使用) | ○ |
| C-21 | FogExp2.toJSON: 正しいJSON形式 | E-02 L73-82 | ○ |
| C-22 | FogExp2.toJSON: type='FogExp2' | E-02 L76 | ○ |
| C-23 | FogExp2.constructor: density=0の境界値 | E-02 L21 (バリデーションなし) | ○ |
| C-24 | FogExp2.constructor: 極小density値 | E-02 L21 (バリデーションなし) | ○ |

### Scene クラス（E-03）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Scene.constructor: 正しく初期化 | E-03 L15-121 | ○ |
| C-26 | Scene: Object3D継承 | E-03 L10, L17 | ○ |
| C-27 | Scene.constructor: background=null | E-03 L40 | ○ |
| C-28 | Scene.constructor: environment=null | E-03 L50 | ○ |
| C-29 | Scene.constructor: fog=null | E-03 L59 | ○ |
| C-30 | Scene.constructor: backgroundBlurriness=0 | E-03 L69 | ○ |
| C-31 | Scene.constructor: backgroundIntensity=1 | E-03 L77 | ○ |
| C-32 | Scene.constructor: backgroundRotation=Euler() | E-03 L86 | ○ |
| C-33 | Scene.constructor: environmentIntensity=1 | E-03 L95 | ○ |
| C-34 | Scene.constructor: environmentRotation=Euler() | E-03 L104 | ○ |
| C-35 | Scene.constructor: overrideMaterial=null | E-03 L113 | ○ |
| C-36 | Scene.copy: backgroundコピー | E-03 L127 | ○ |
| C-37 | Scene.copy: background null処理 | E-03 L127 (条件分岐) | ○ |
| C-38 | Scene.copy: environmentコピー | E-03 L128 | ○ |
| C-39 | Scene.copy: fogコピー | E-03 L129 | ○ |
| C-40 | Scene.copy: fog null処理 | E-03 L129 (条件分岐) | ○ |
| C-41 | Scene.copy: backgroundBlurrinessコピー | E-03 L131 | ○ |
| C-42 | Scene.copy: backgroundIntensityコピー | E-03 L132 | ○ |
| C-43 | Scene.copy: backgroundRotationコピー | E-03 L133 | ○ |
| C-44 | Scene.copy: environmentIntensityコピー | E-03 L135 | ○ |
| C-45 | Scene.copy: environmentRotationコピー | E-03 L136 | ○ |
| C-46 | Scene.copy: overrideMaterialコピー | E-03 L138 | ○ |
| C-47 | Scene.copy: overrideMaterial null処理 | E-03 L138 (条件分岐) | ○ |
| C-48 | Scene.copy: matrixAutoUpdateコピー | E-03 L140 | ○ |
| C-49 | Scene.copy: recursiveパラメータ | E-03 L125 | ○ |
| C-50 | Scene.copy: recursive=false動作 | E-03 L125 | ○ |
| C-51 | Scene.copy: this返却 | E-03 L142 | ○ |
| C-52 | Scene.toJSON: 親クラス呼び出し | E-03 L148 | ○ |
| C-53 | Scene.toJSON: fogシリアライズ | E-03 L150 | ○ |
| C-54 | Scene.toJSON: fog=null時の出力抑制 | E-03 L150 (条件分岐) | ○ |
| C-55 | Scene.toJSON: backgroundBlurriness>0出力 | E-03 L152 | ○ |
| C-56 | Scene.toJSON: backgroundBlurriness=0出力抑制 | E-03 L152 (条件分岐) | ○ |
| C-57 | Scene.toJSON: backgroundIntensity!=1出力 | E-03 L153 | ○ |
| C-58 | Scene.toJSON: backgroundIntensity=1出力抑制 | E-03 L153 (条件分岐) | ○ |
| C-59 | Scene.toJSON: backgroundRotation常時出力 | E-03 L154 | ○ |
| C-60 | Scene.toJSON: environmentIntensity!=1出力 | E-03 L156 | ○ |
| C-61 | Scene.toJSON: environmentIntensity=1出力抑制 | E-03 L156 (条件分岐) | ○ |
| C-62 | Scene.toJSON: environmentRotation常時出力 | E-03 L157 | ○ |
| C-63 | Scene.toJSON: metaパラメータ | E-03 L146, L148 | ○ |
| C-64 | Scene.isScene: trueであること | E-03 L26 | ○ |
| C-65 | Scene.type: 'Scene'であること | E-03 L28 | ○ |
| C-66 | Fog.color: undefined入力時の挙動 | **根拠なし** | △ |
| C-67 | FogExp2.color: undefined入力時の挙動 | **根拠なし** | △ |
| C-68 | Scene.copy: null入力時の挙動 | **根拠なし** | △ |
| C-69 | Scene.background: Color設定可能 | E-03 L32-40 (型定義) | ○ |
| C-70 | Scene.fog: Fog設定可能 | E-03 L52-59 (型定義) | ○ |
| C-71 | Scene.fog: FogExp2設定可能 | E-03 L52-59 (型定義) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-66, C-67: Colorクラスのコンストラクタにundefinedを渡した場合の挙動は、Colorクラス（math/Color.js）の実装に依存する。scenesモジュール内では明示的なバリデーションがないため、テスト時にはColorクラスの挙動を確認する必要がある。
  - 候補：`src/math/Color.js`の実装確認 / Three.js公式ドキュメント / 既存テストケース
- C-68: Scene.copyメソッドはsourceがnullの場合のエラーハンドリングを行っていない。JavaScriptランタイムのエラーが発生すると予想されるが、明示的なテストが必要。
  - 候補：Object3D.copyの実装確認 / ランタイムテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - scenesモジュールは3ファイル・3クラスと小規模で、ロジックもシンプル
- 0: 低リスク - 明確な型定義とJSDocコメントにより意図が明確
- 1: 中リスク - 異常系テスト（undefined/null入力）はColorクラスやObject3Dクラスの挙動に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Fog/FogExp2のclone()が本当に独立したインスタンスを返すか実行確認
- [ ] Scene.copyのrecursive引数がObject3D.copyに正しく渡されるか確認
- [ ] backgroundBlurriness/environmentIntensityの条件分岐（>0と!==1）の違いが意図通りか確認
- [ ] Colorクラスにundefinedを渡した場合のデフォルト挙動を確認
- [ ] Scene.toJSONのmeta引数が親クラスで正しく処理されるか確認
