---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-root モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **probeAsync関連テスト（UT-SRC-037〜039）**：WebGL2環境依存のため実行環境に注意
  2. **DevTools連携テスト（UT-SRC-082）**：ブラウザ環境での動作確認が必要
  3. **複数インポート警告テスト（UT-SRC-083）**：モジュールシステム依存の挙動

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/constants.js` - Three.js定数定義ファイル（1761行）
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/utils.js` - ユーティリティ関数定義ファイル（397行）
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/Three.js` - メインエントリーポイント（188行）
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/Three.Core.js` - コアモジュールエクスポート（166行）
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/Three.Legacy.js` - レガシーモジュール（空ファイル）
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/Three.TSL.js` - TSLエクスポート（643行）
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/Three.WebGPU.js` - WebGPUエクスポート（31行）
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/Three.WebGPU.Nodes.js` - WebGPU Nodesエクスポート（29行）

## 3) Claims と根拠の対応（レビューの主戦場）

### utils.js関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SRC-001〜005) | arrayMin関数のテスト | E-02 L8-22: `function arrayMin(array) { if (array.length === 0) return Infinity; ... }` | ○ |
| C-02 (UT-SRC-006〜010) | arrayMax関数のテスト | E-02 L31-45: `function arrayMax(array) { if (array.length === 0) return -Infinity; ... }` | ○ |
| C-03 (UT-SRC-011〜015) | arrayNeedsUint32関数のテスト | E-02 L59-71: `function arrayNeedsUint32(array) { ... if (array[i] >= 65535) return true; ... }` | ○ |
| C-04 (UT-SRC-016〜019) | getTypedArray関数のテスト | E-02 L81-105: `const TYPED_ARRAYS = {...}; function getTypedArray(type, buffer) { return new TYPED_ARRAYS[type](buffer); }` | ○ |
| C-05 (UT-SRC-020〜024) | isTypedArray関数のテスト | E-02 L113-117: `function isTypedArray(array) { return ArrayBuffer.isView(array) && !(array instanceof DataView); }` | ○ |
| C-06 (UT-SRC-025〜026) | createElementNS関数のテスト | E-02 L129-133: `function createElementNS(name) { return document.createElementNS('http://www.w3.org/1999/xhtml', name); }` | ○ |
| C-07 (UT-SRC-027) | createCanvasElement関数のテスト | E-02 L144-150: `function createCanvasElement() { const canvas = createElementNS('canvas'); canvas.style.display = 'block'; return canvas; }` | ○ |
| C-08 (UT-SRC-028〜030) | setConsoleFunction/getConsoleFunction関数のテスト | E-02 L178-193: `function setConsoleFunction(fn) { _setConsoleFunction = fn; } function getConsoleFunction() { return _setConsoleFunction; }` | ○ |
| C-09 (UT-SRC-031〜032) | log関数のテスト | E-02 L205-219: `function log(...params) { const message = 'THREE.' + params.shift(); ... }` | ○ |
| C-10 (UT-SRC-033) | warn関数のテスト | E-02 L231-245: `function warn(...params) { const message = 'THREE.' + params.shift(); ... }` | ○ |
| C-11 (UT-SRC-034) | error関数のテスト | E-02 L257-271: `function error(...params) { const message = 'THREE.' + params.shift(); ... }` | ○ |
| C-12 (UT-SRC-035〜036) | warnOnce関数のテスト | E-02 L282-292: `function warnOnce(...params) { const message = params.join(' '); if (message in _cache) return; _cache[message] = true; warn(...params); }` | ○ |
| C-13 (UT-SRC-037〜039) | probeAsync関数のテスト | E-02 L308-335: `function probeAsync(gl, sync, interval) { return new Promise(...); }` | ○ |
| C-14 (UT-SRC-040〜041) | toNormalizedProjectionMatrix関数のテスト | E-02 L349-358: `function toNormalizedProjectionMatrix(projectionMatrix) { const m = projectionMatrix.elements; m[2] = 0.5 * m[2] + 0.5 * m[3]; ... }` | ○ |
| C-15 (UT-SRC-042〜043) | toReversedProjectionMatrix関数のテスト | E-02 L376-394: `function toReversedProjectionMatrix(projectionMatrix) { ... if (isPerspectiveMatrix) { m[10] = -m[10] - 1; ... } else { m[10] = -m[10]; ... } }` | ○ |
| C-16 (UT-SRC-085) | TYPED_ARRAYS定数のテスト | E-02 L81-91: `const TYPED_ARRAYS = { Int8Array: Int8Array, Uint8Array: Uint8Array, ... }` | ○ |

### constants.js関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-17 (UT-SRC-044) | REVISION定数 | E-01 L1: `export const REVISION = '183dev';` | ○ |
| C-18 (UT-SRC-045) | MOUSE定数 | E-01 L9: `export const MOUSE = { LEFT: 0, MIDDLE: 1, RIGHT: 2, ROTATE: 0, DOLLY: 1, PAN: 2 };` | ○ |
| C-19 (UT-SRC-046) | TOUCH定数 | E-01 L17: `export const TOUCH = { ROTATE: 0, PAN: 1, DOLLY_PAN: 2, DOLLY_ROTATE: 3 };` | ○ |
| C-20 (UT-SRC-047) | CullFace定数群 | E-01 L25-49: `CullFaceNone = 0; CullFaceBack = 1; CullFaceFront = 2; CullFaceFrontBack = 3;` | ○ |
| C-21 (UT-SRC-048) | ShadowMap定数群 | E-01 L57-83: `BasicShadowMap = 0; PCFShadowMap = 1; PCFSoftShadowMap = 2; VSMShadowMap = 3;` | ○ |
| C-22 (UT-SRC-049) | Side定数群 | E-01 L91-107: `FrontSide = 0; BackSide = 1; DoubleSide = 2;` | ○ |
| C-23 (UT-SRC-050) | Blending定数群 | E-01 L116-164: `NoBlending = 0; NormalBlending = 1; AdditiveBlending = 2; SubtractiveBlending = 3; MultiplyBlending = 4; CustomBlending = 5;` | ○ |
| C-24 (UT-SRC-051) | BlendEquation定数群 | E-01 L172-204: `AddEquation = 100; SubtractEquation = 101; ReverseSubtractEquation = 102; MinEquation = 103; MaxEquation = 104;` | ○ |
| C-25 (UT-SRC-052) | BlendFactor定数群 | E-01 L212-326: ZeroFactor(200)〜OneMinusConstantAlphaFactor(214) | ○ |
| C-26 (UT-SRC-053) | DepthFunc定数群 | E-01 L334-390: NeverDepth(0)〜NotEqualDepth(7) | ○ |
| C-27 (UT-SRC-054) | ToneMapping定数群 | E-01 L422-482: NoToneMapping(0)〜NeutralToneMapping(7) | ○ |
| C-28 (UT-SRC-055) | BindMode定数群 | E-01 L490-499: `AttachedBindMode = 'attached'; DetachedBindMode = 'detached';` | ○ |
| C-29 (UT-SRC-056) | Mapping定数群 | E-01 L507-547: UVMapping(300)〜CubeUVReflectionMapping(306) | ○ |
| C-30 (UT-SRC-057) | Wrapping定数群 | E-01 L555-571: `RepeatWrapping = 1000; ClampToEdgeWrapping = 1001; MirroredRepeatWrapping = 1002;` | ○ |
| C-31 (UT-SRC-058) | Filter定数群 | E-01 L580-634: NearestFilter(1003)〜LinearMipmapLinearFilter(1008) | ○ |
| C-32 (UT-SRC-059) | DataType定数群 | E-01 L642-738: UnsignedByteType(1009)〜UnsignedInt101111Type(35899) | ○ |
| C-33 (UT-SRC-060) | PixelFormat定数群 | E-01 L746-827: AlphaFormat(1021)〜RGBAIntegerFormat(1033) | ○ |
| C-34 (UT-SRC-061) | CompressedFormat定数群 | E-01 L835-1116: RGB_S3TC_DXT1_Format(33776)以降 | ○ |
| C-35 (UT-SRC-062) | Loop定数群 | E-01 L1124-1142: `LoopOnce = 2200; LoopRepeat = 2201; LoopPingPong = 2202;` | ○ |
| C-36 (UT-SRC-063) | Interpolate定数群 | E-01 L1150-1177: InterpolateDiscrete(2300)〜InterpolateBezier(2303) | ○ |
| C-37 (UT-SRC-064) | Ending定数群 | E-01 L1185-1201: `ZeroCurvatureEnding = 2400; ZeroSlopeEnding = 2401; WrapAroundEnding = 2402;` | ○ |
| C-38 (UT-SRC-065) | AnimationBlendMode定数群 | E-01 L1209-1218: `NormalAnimationBlendMode = 2500; AdditiveAnimationBlendMode = 2501;` | ○ |
| C-39 (UT-SRC-066) | DrawMode定数群 | E-01 L1226-1242: `TrianglesDrawMode = 0; TriangleStripDrawMode = 1; TriangleFanDrawMode = 2;` | ○ |
| C-40 (UT-SRC-067) | DepthPacking定数群 | E-01 L1250-1274: BasicDepthPacking(3200)〜RGDepthPacking(3203) | ○ |
| C-41 (UT-SRC-068) | NormalMapType定数群 | E-01 L1282-1290: `TangentSpaceNormalMap = 0; ObjectSpaceNormalMap = 1;` | ○ |
| C-42 (UT-SRC-069) | ColorSpace定数群 | E-01 L1300-1316: `NoColorSpace = ''; SRGBColorSpace = 'srgb'; LinearSRGBColorSpace = 'srgb-linear';` | ○ |
| C-43 (UT-SRC-070) | Transfer定数群 | E-01 L1324-1332: `LinearTransfer = 'linear'; SRGBTransfer = 'srgb';` | ○ |
| C-44 (UT-SRC-071) | StencilOp定数群 | E-01 L1364-1422: ZeroStencilOp(0)〜InvertStencilOp(5386) | ○ |
| C-45 (UT-SRC-072) | StencilFunc定数群 | E-01 L1430-1486: NeverStencilFunc(512)〜AlwaysStencilFunc(519) | ○ |
| C-46 (UT-SRC-073) | Compare定数群 | E-01 L1494-1550: NeverCompare(512)〜AlwaysCompare(519) | ○ |
| C-47 (UT-SRC-074) | Usage定数群 | E-01 L1559-1631: StaticDrawUsage(35044)〜StreamCopyUsage(35042) | ○ |
| C-48 (UT-SRC-075) | GLSL定数群 | E-01 L1639-1647: `GLSL1 = '100'; GLSL3 = '300 es';` | ○ |
| C-49 (UT-SRC-076) | CoordinateSystem定数群 | E-01 L1655-1663: `WebGLCoordinateSystem = 2000; WebGPUCoordinateSystem = 2001;` | ○ |
| C-50 (UT-SRC-077) | TimestampQuery定数 | E-01 L1671-1674: `TimestampQuery = { COMPUTE: 'compute', RENDER: 'render' };` | ○ |
| C-51 (UT-SRC-078) | InterpolationSamplingType定数 | E-01 L1682-1686: `InterpolationSamplingType = { PERSPECTIVE: 'perspective', LINEAR: 'linear', FLAT: 'flat' };` | ○ |
| C-52 (UT-SRC-079) | InterpolationSamplingMode定数 | E-01 L1694-1700: `InterpolationSamplingMode = { NORMAL: 'normal', CENTROID: 'centroid', SAMPLE: 'sample', FIRST: 'first', EITHER: 'either' };` | ○ |
| C-53 (UT-SRC-080) | Compatibility定数 | E-01 L1708-1710: `Compatibility = { TEXTURE_COMPARE: 'depthTextureCompare' };` | ○ |
| C-54 (UT-SRC-081) | レガシーフィルター名 | E-01 L591-602, L623-634: `NearestMipMapNearestFilter = 1004; NearestMipmapNearestFilter = 1004;` (同じ値) | ○ |

### Three.js関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 (UT-SRC-082) | DevTools登録処理 | E-03 L167-172: `if (typeof __THREE_DEVTOOLS__ !== 'undefined') { __THREE_DEVTOOLS__.dispatchEvent(new CustomEvent('register', { detail: { revision: REVISION } })); }` | ○ |
| C-56 (UT-SRC-083) | 複数インポート警告 | E-03 L175-186: `if (window.__THREE__) { warn('WARNING: Multiple instances of Three.js being imported.'); } else { window.__THREE__ = REVISION; }` | ○ |
| C-57 (UT-SRC-084) | バージョン登録 | E-03 L181-183: `window.__THREE__ = REVISION;` | ○ |

## 4) 不足情報（Unknown / Missing）
- 全てのテストケースに対応するソースコードが確認できたため、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - constants.js関連のテストケース（UT-SRC-044〜081）
  - 理由: 単純な定数値の検証であり、ロジックが存在しない
- **1: 中リスク** - utils.js関連のテストケース（UT-SRC-001〜036, 040〜043, 085）
  - 理由: ロジックが存在するが、単純な関数であり、JSDoc等で仕様が明確
- **2: 高リスク** - probeAsync関連テストケース（UT-SRC-037〜039）
  - 理由: WebGL2環境依存、非同期処理、モック実装が必要
- **1: 中リスク** - Three.js関連テストケース（UT-SRC-082〜084）
  - 理由: ブラウザ環境・グローバル変数依存、モジュールシステム依存

## 6) レビュアーチェックリスト（最小）
- [ ] utils.js関数のエッジケース（空配列、null、undefined）が網羅されているか
- [ ] probeAsync関数のWebGL2モック実装方針が適切か
- [ ] constants.jsの定数値がソースコードと一致しているか
- [ ] Three.js DevTools連携テストの実行環境要件が明確か
- [ ] 複数インポート警告テストのモジュールシステム依存性が考慮されているか
- [ ] isTypedArray関数がDataViewを正しく除外しているか（仕様通りか確認）
- [ ] toNormalizedProjectionMatrix/toReversedProjectionMatrixの計算式が正しいか
