---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 110
  claims_with_evidence: 110
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：textures.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：110 / 110、根拠なし：0
- 優先レビュー（高）
  1. なし：すべてのテストケースにソースコードの根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/three.js-dev/src/textures/Texture.js`
- E-02: `/Users/tomoka.baba/Work/three.js-dev/src/textures/Source.js`
- E-03: `/Users/tomoka.baba/Work/three.js-dev/src/textures/DepthTexture.js`
- E-04: `/Users/tomoka.baba/Work/three.js-dev/src/textures/FramebufferTexture.js`
- E-05: `/Users/tomoka.baba/Work/three.js-dev/src/textures/CompressedTexture.js`
- E-06: `/Users/tomoka.baba/Work/three.js-dev/src/textures/CompressedArrayTexture.js`
- E-07: `/Users/tomoka.baba/Work/three.js-dev/src/textures/CompressedCubeTexture.js`
- E-08: `/Users/tomoka.baba/Work/three.js-dev/src/textures/Data3DTexture.js`
- E-09: `/Users/tomoka.baba/Work/three.js-dev/src/textures/DataTexture.js`
- E-10: `/Users/tomoka.baba/Work/three.js-dev/src/textures/DataArrayTexture.js`
- E-11: `/Users/tomoka.baba/Work/three.js-dev/src/textures/CubeTexture.js`
- E-12: `/Users/tomoka.baba/Work/three.js-dev/src/textures/CubeDepthTexture.js`
- E-13: `/Users/tomoka.baba/Work/three.js-dev/src/textures/VideoTexture.js`
- E-14: `/Users/tomoka.baba/Work/three.js-dev/src/textures/VideoFrameTexture.js`
- E-15: `/Users/tomoka.baba/Work/three.js-dev/src/textures/CanvasTexture.js`
- E-16: `/Users/tomoka.baba/Work/three.js-dev/src/textures/ExternalTexture.js`

## 3) Claims と根拠の対応（レビューの主戦場）

### Texture クラス（UT-TEX-001 〜 UT-TEX-037）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Textureコンストラクタでデフォルトパラメータが設定される | E-01 L48-371 | ○ |
| C-02 | Textureコンストラクタでカスタムパラメータが設定される | E-01 L48 | ○ |
| C-03 | image=nullでもエラーなく初期化される | E-01 L48, L93 | ○ |
| C-04 | image.depth存在時にisArrayTexture=trueになる | E-01 L359 | ○ |
| C-05 | width getterがsource.getSize経由で取得 | E-01 L376-379 | ○ |
| C-06 | height getterがsource.getSize経由で取得 | E-01 L385-388 | ○ |
| C-07 | depth getterがsource.getSize経由で取得 | E-01 L394-397 | ○ |
| C-08 | image getterがsource.dataを返す | E-01 L405-408 | ○ |
| C-09 | image setterがsource.dataを設定 | E-01 L411-414 | ○ |
| C-10 | updateMatrixがsetUvTransformを呼ぶ | E-01 L421-424 | ○ |
| C-11 | addUpdateRangeがupdateRangesに追加 | E-01 L433-436 | ○ |
| C-12 | clearUpdateRangesがlengthを0に設定 | E-01 L442-445 | ○ |
| C-13 | cloneがnew this.constructor().copy(this)を返す | E-01 L453-456 | ○ |
| C-14 | copyがすべてのプロパティをコピー | E-01 L465-510 | ○ |
| C-15 | copy時にuserDataがJSON.parse/stringifyでディープコピー | E-01 L505 | ○ |
| C-16 | setValuesがプロパティを一括設定 | E-01 L517-558 | ○ |
| C-17 | setValuesでundefinedはスキップ | E-01 L523-527 | ○ |
| C-18 | setValuesで存在しないプロパティはスキップ | E-01 L530-535 | ○ |
| C-19 | setValuesでVector2はcopyで設定 | E-01 L539-541 | ○ |
| C-20 | setValuesでMatrix3はcopyで設定 | E-01 L547-549 | ○ |
| C-21 | toJSONがJSON形式を返す | E-01 L568-627 | ○ |
| C-22 | toJSONでmetaにキャッシュ | E-01 L572-575, L620-624 | ○ |
| C-23 | toJSONでuserDataが含まれる | E-01 L618 | ○ |
| C-24 | disposeがdisposeイベントを発火 | E-01 L636-645 | ○ |
| C-25 | transformUvがUVMapping時のみ変換 | E-01 L654-656 | ○ |
| C-26 | transformUvでRepeatWrapping処理 | E-01 L664-666 | ○ |
| C-27 | transformUvでClampToEdgeWrapping処理 | E-01 L669-671 | ○ |
| C-28 | transformUvでMirroredRepeatWrapping処理 | E-01 L674-682 | ○ |
| C-29 | transformUvでflipY処理 | E-01 L724-728 | ○ |
| C-30 | needsUpdate setterでversion++とsource.needsUpdate | E-01 L743-751 | ○ |
| C-31 | needsPMREMUpdate setterでpmremVersion++ | E-01 L762-769 | ○ |
| C-32 | DEFAULT_IMAGE=null | E-01 L781 | ○ |
| C-33 | DEFAULT_MAPPING=UVMapping | E-01 L790 | ○ |
| C-34 | DEFAULT_ANISOTROPY=1 | E-01 L799 | ○ |

### Source クラス（UT-TEX-038 〜 UT-TEX-048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Sourceコンストラクタでデフォルト初期化 | E-02 L20-74 | ○ |
| C-36 | getSize通常画像処理 | E-02 L95-97 | ○ |
| C-37 | getSizeでHTMLVideoElement処理 | E-02 L87-89 | ○ |
| C-38 | getSizeでVideoFrame処理 | E-02 L91-93 | ○ |
| C-39 | getSizeでnull時(0,0,0) | E-02 L99-101 | ○ |
| C-40 | needsUpdate setterでversion++ | E-02 L118-121 | ○ |
| C-41 | toJSONでシリアライズ | E-02 L131-192 | ○ |
| C-42 | toJSONでmetaにキャッシュ | E-02 L135-138 | ○ |
| C-43 | toJSONで配列データ（キューブ）対応 | E-02 L152-170 | ○ |

### DepthTexture クラス（UT-TEX-049 〜 UT-TEX-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | DepthTextureコンストラクタ初期化 | E-03 L28-77 | ○ |
| C-45 | フォーマット検証でエラースロー | E-03 L30-34 | ○ |
| C-46 | copyでsourceディープコピー | E-03 L81-89 | ○ |
| C-47 | toJSONでcompareFunction出力 | E-03 L92-99 | ○ |

### FramebufferTexture クラス（UT-TEX-056 〜 UT-TEX-057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | FramebufferTextureコンストラクタ初期化 | E-04 L36-80 | ○ |
| C-49 | needsUpdate=true設定 | E-04 L79 | ○ |

### CompressedTexture クラス（UT-TEX-058 〜 UT-TEX-059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | CompressedTextureコンストラクタ初期化 | E-05 L29-81 | ○ |
| C-51 | mipmaps設定 | E-05 L54 | ○ |

### CompressedArrayTexture クラス（UT-TEX-060 〜 UT-TEX-064）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | CompressedArrayTextureコンストラクタ初期化 | E-06 L24-61 | ○ |
| C-53 | addLayerUpdate実装 | E-06 L72-75 | ○ |
| C-54 | clearLayerUpdates実装 | E-06 L81-84 | ○ |

### CompressedCubeTexture クラス（UT-TEX-065 〜 UT-TEX-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | CompressedCubeTextureコンストラクタ初期化 | E-07 L20-43 | ○ |

### Data3DTexture クラス（UT-TEX-067 〜 UT-TEX-069）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-56 | Data3DTextureコンストラクタ初期化 | E-08 L20-107 | ○ |

### DataTexture クラス（UT-TEX-070 〜 UT-TEX-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | DataTextureコンストラクタ初期化 | E-09 L32-82 | ○ |

### DataArrayTexture クラス（UT-TEX-073 〜 UT-TEX-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-58 | DataArrayTextureコンストラクタ初期化 | E-10 L19-105 | ○ |
| C-59 | addLayerUpdate実装 | E-10 L117-120 | ○ |
| C-60 | clearLayerUpdates実装 | E-10 L126-129 | ○ |

### CubeTexture クラス（UT-TEX-077 〜 UT-TEX-080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | CubeTextureコンストラクタ初期化 | E-11 L36-59 | ○ |
| C-62 | images getter/setter | E-11 L67-76 | ○ |

### CubeDepthTexture クラス（UT-TEX-081 〜 UT-TEX-084）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | CubeDepthTextureコンストラクタ初期化 | E-12 L25-54 | ○ |
| C-64 | 6面分image作成 | E-12 L28-29 | ○ |
| C-65 | images getter/setter | E-12 L62-72 | ○ |

### VideoTexture クラス（UT-TEX-085 〜 UT-TEX-092）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-66 | VideoTextureコンストラクタ初期化 | E-13 L36-83 | ○ |
| C-67 | requestVideoFrameCallbackコールバック登録 | E-13 L78-82 | ○ |
| C-68 | clone実装 | E-13 L86-89 | ○ |
| C-69 | update実装 | E-13 L98-108 | ○ |
| C-70 | dispose実装 | E-13 L111-122 | ○ |

### VideoFrameTexture クラス（UT-TEX-093 〜 UT-TEX-096）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | VideoFrameTextureコンストラクタ初期化 | E-14 L30-43 | ○ |
| C-72 | update空実装 | E-14 L49 | ○ |
| C-73 | clone実装 | E-14 L51-54 | ○ |
| C-74 | setFrame実装 | E-14 L63-67 | ○ |

### CanvasTexture クラス（UT-TEX-097 〜 UT-TEX-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | CanvasTextureコンストラクタ初期化 | E-15 L26-40 | ○ |
| C-76 | needsUpdate=true設定 | E-15 L39 | ○ |

### ExternalTexture クラス（UT-TEX-099 〜 UT-TEX-101）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 | ExternalTextureコンストラクタ初期化 | E-16 L21-42 | ○ |
| C-78 | copy実装 | E-16 L44-51 | ○ |

### ID/UUID一意性（UT-TEX-102 〜 UT-TEX-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | Texture.idの一意性 | E-01 L20, L68 | ○ |
| C-80 | Texture.uuidの一意性 | E-01 L76 | ○ |
| C-81 | Source.idの一意性 | E-02 L5, L38 | ○ |

### 境界値テスト（UT-TEX-105 〜 UT-TEX-110）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | transformUv境界値処理 | E-01 L660-721 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべてのテストケースにソースコードからの根拠が存在

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべてのテストケースがソースコードを直接参照して作成されている
- テストケースは16個のソースファイルを網羅的に解析して生成

## 6) レビュアーチェックリスト（最小）
- [ ] Textureクラスのコンストラクタテスト（UT-TEX-001〜004）が基本動作を網羅しているか確認
- [ ] transformUvメソッドのラッピングモードテスト（UT-TEX-026〜031）が各モードを正しくテストしているか確認
- [ ] 各サブクラス（DepthTexture, VideoTexture等）のコンストラクタテストが固有のプロパティ初期化を検証しているか確認
- [ ] disposeメソッドのリソース解放テスト（UT-TEX-025, 091, 092）がイベント発火とコールバックキャンセルを検証しているか確認
- [ ] DataArrayTextureとCompressedArrayTextureのaddLayerUpdate/clearLayerUpdatesテストが部分更新機能を検証しているか確認

## 7) 解析対象ファイル一覧

| ファイル | クラス | テストケース数 |
|---------|--------|---------------|
| Texture.js | Texture | 37 |
| Source.js | Source | 11 |
| DepthTexture.js | DepthTexture | 7 |
| FramebufferTexture.js | FramebufferTexture | 2 |
| CompressedTexture.js | CompressedTexture | 2 |
| CompressedArrayTexture.js | CompressedArrayTexture | 5 |
| CompressedCubeTexture.js | CompressedCubeTexture | 2 |
| Data3DTexture.js | Data3DTexture | 3 |
| DataTexture.js | DataTexture | 3 |
| DataArrayTexture.js | DataArrayTexture | 4 |
| CubeTexture.js | CubeTexture | 4 |
| CubeDepthTexture.js | CubeDepthTexture | 4 |
| VideoTexture.js | VideoTexture | 8 |
| VideoFrameTexture.js | VideoFrameTexture | 4 |
| CanvasTexture.js | CanvasTexture | 2 |
| ExternalTexture.js | ExternalTexture | 3 |

## 8) テスト観点カバレッジ

| 観点 | テストケース数 | 割合 |
|------|---------------|------|
| 正常系 | 95 | 86.4% |
| 異常系 | 7 | 6.4% |
| 境界値 | 8 | 7.3% |
| 合計 | 110 | 100% |

## 9) 優先度分布

| 優先度 | テストケース数 | 割合 |
|--------|---------------|------|
| 高 | 38 | 34.5% |
| 中 | 55 | 50.0% |
| 低 | 17 | 15.5% |
| 合計 | 110 | 100% |
