---
generated_at: 2026-01-27 13:50:00
metrics:
  claims_total: 80
  claims_with_evidence: 76
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：76 / 80、根拠なし：4
- 優先レビュー（高）
  1. **UAT-073 パストレーサー機能**：外部ライブラリ依存の確認が必要
  2. **UAT-062/063/064 WebXR機能**：デバイス依存のため実機テスト必須
  3. **UAT-075 多言語対応**：全言語の翻訳完了確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `editor/js/Editor.js` - エディターコア機能
- E-02: `editor/js/Menubar.File.js` - ファイル操作メニュー
- E-03: `editor/js/Menubar.Add.js` - オブジェクト追加メニュー
- E-04: `editor/js/Menubar.Edit.js` - 編集メニュー
- E-05: `editor/js/Menubar.View.js` - ビューメニュー
- E-06: `editor/js/Loader.js` - ファイルローダー
- E-07: `editor/js/History.js` - Undo/Redo履歴管理
- E-08: `editor/js/Selector.js` - オブジェクト選択
- E-09: `editor/js/Viewport.js` - ビューポート操作
- E-10: `editor/js/Player.js` - プレビュー再生
- E-11: `editor/js/Script.js` - スクリプト編集
- E-12: `editor/js/Sidebar.js` - サイドバーメイン
- E-13: `editor/js/Sidebar.Geometry.*.js` - ジオメトリ編集パネル
- E-14: `editor/js/Sidebar.Material.js` - マテリアル編集パネル
- E-15: `editor/js/Sidebar.Scene.js` - シーン設定パネル
- E-16: `editor/js/Sidebar.Project.Renderer.js` - レンダラー設定
- E-17: `editor/js/Sidebar.Object.js` - オブジェクトプロパティ
- E-18: `editor/js/Sidebar.Script.js` - スクリプト管理
- E-19: `editor/js/Storage.js` - 自動保存機能
- E-20: `editor/js/Strings.js` - 多言語対応
- E-21: `editor/index.html` - エディターエントリポイント
- E-22: `examples/files.json` - サンプル一覧
- E-23: `package.json` - プロジェクト設定
- E-24: `src/` - Three.jsコアライブラリ
- E-25: `examples/jsm/` - アドオンモジュール
- E-26: `editor/js/Viewport.Pathtracer.js` - パストレーサー
- E-27: `editor/js/Viewport.XR.js` - XR機能
- E-28: `editor/js/Sidebar.Object.Animation.js` - アニメーション管理
- E-29: `editor/js/Sidebar.Project.Resources.js` - リソース管理
- E-30: `examples/webgl_*.html` - WebGLサンプル
- E-31: `examples/webgpu_*.html` - WebGPUサンプル
- E-32: `examples/webxr_*.html` - WebXRサンプル
- E-33: `examples/physics_*.html` - 物理演算サンプル
- E-34: `examples/css3d_*.html` - CSS3Dサンプル
- E-35: `examples/webaudio_*.html` - WebAudioサンプル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001 新規プロジェクト作成機能 | E-02 | ○ |
| C-02 | UAT-002 サンプルプロジェクト読込機能 | E-02, E-22 | ○ |
| C-03 | UAT-003 プロジェクト保存機能 | E-02 | ○ |
| C-04 | UAT-004 プロジェクト読込機能 | E-02 | ○ |
| C-05 | UAT-005〜009 メッシュ追加機能 | E-03 | ○ |
| C-06 | UAT-010〜013 ライト追加機能 | E-03 | ○ |
| C-07 | UAT-014〜015 カメラ追加機能 | E-03 | ○ |
| C-08 | UAT-016 オブジェクト選択機能 | E-08 | ○ |
| C-09 | UAT-017〜019 変形操作機能 | E-09 | ○ |
| C-10 | UAT-020 オブジェクト削除機能 | E-04 | ○ |
| C-11 | UAT-021〜022 ジオメトリ編集機能 | E-13 | ○ |
| C-12 | UAT-023〜025 マテリアル編集機能 | E-14 | ○ |
| C-13 | UAT-026〜029 エクスポート機能 | E-02, E-25 | ○ |
| C-14 | UAT-030〜031 インポート機能 | E-06, E-21 | ○ |
| C-15 | UAT-032〜033 Undo/Redo機能 | E-07 | ○ |
| C-16 | UAT-034〜035 ビュー操作機能 | E-05, E-09 | ○ |
| C-17 | UAT-036〜037 プレビュー機能 | E-10 | ○ |
| C-18 | UAT-038〜039 スクリプト機能 | E-11, E-18 | ○ |
| C-19 | UAT-040〜042 シーン設定機能 | E-15 | ○ |
| C-20 | UAT-043〜044 レンダラー設定機能 | E-16 | ○ |
| C-21 | UAT-045〜047 WebGL描画機能 | E-24, E-30 | ○ |
| C-22 | UAT-048〜053 マテリアル・ポストプロセス機能 | E-24, E-25, E-30 | ○ |
| C-23 | UAT-054〜056 インタラクション機能 | E-25, E-30 | ○ |
| C-24 | UAT-057〜059 ローダー機能 | E-25, E-30 | ○ |
| C-25 | UAT-060〜061 WebGPU機能 | E-24, E-31 | ○ |
| C-26 | UAT-062〜064 WebXR機能 | E-27, E-32 | △ |
| C-27 | UAT-065〜066 物理演算機能 | E-33 | ○ |
| C-28 | UAT-067 CSS3Dレンダラー機能 | E-34 | ○ |
| C-29 | UAT-068 オーディオ機能 | E-35 | ○ |
| C-30 | UAT-069〜070 パフォーマンス機能 | E-30 | ○ |
| C-31 | UAT-071 ヘルパー表示機能 | E-05 | ○ |
| C-32 | UAT-072 自動保存機能 | E-19 | ○ |
| C-33 | UAT-073 パストレーサー機能 | E-26 | △ |
| C-34 | UAT-074 XRプレビュー機能 | E-27 | △ |
| C-35 | UAT-075 多言語対応機能 | E-20 | △ |
| C-36 | UAT-076 グループ操作機能 | E-03 | ○ |
| C-37 | UAT-077 リソース管理機能 | E-29 | ○ |
| C-38 | UAT-078 アニメーション編集機能 | E-28 | ○ |
| C-39 | UAT-079〜080 シェーダー機能 | E-30 | ○ |

## 4) 不足情報（Unknown / Missing）
- **WebXR機能（UAT-062〜064, UAT-074）**: 実機テスト環境が必要。シミュレーションでは完全な検証が困難
  - 候補：VRヘッドセット / ARデバイス / WebXR Emulator拡張機能
- **パストレーサー機能（UAT-073）**: three-gpu-pathtracerライブラリに依存。外部CDN経由の読み込みのため、オフライン環境での動作保証が不明
  - 候補：ローカルビルド / npm依存管理
- **多言語対応（UAT-075）**: Strings.jsに翻訳が含まれるが、全言語の翻訳完了状況の確認が必要
  - 候補：翻訳カバレッジレポート / 言語別テスト

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UAT-001〜044, UAT-071〜072, UAT-076〜080 - エディター内蔵機能。ソースコードで確認済み
- **1（中リスク）**: UAT-045〜070 - Examples依存。ブラウザ互換性・外部リソース依存
- **2（高リスク）**: UAT-062〜064, UAT-073〜075 - デバイス依存・外部ライブラリ依存・多言語対応

## 6) レビュアーチェックリスト（最小）
- [ ] 全80テストケースがプロジェクトの主要機能をカバーしているか確認
- [ ] WebXR関連テスト（UAT-062〜064, UAT-074）の実機テスト計画を策定
- [ ] パストレーサー（UAT-073）の外部ライブラリ依存リスクを評価
- [ ] 多言語対応（UAT-075）の翻訳カバレッジを確認
- [ ] 優先度「高」のテストケースが業務要件を満たしているか確認
- [ ] テスト手順が再現可能かどうかを検証
- [ ] 期待結果が明確で測定可能かどうかを確認
- [ ] ブラウザ互換性要件（WebGL/WebGPU/WebXR）を文書化
