---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 8
  claims_with_evidence: 8
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：8 / 8、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/GLTFExporter.js`（2,086行、glTF 2.0エクスポーター実装）
- E-02: `examples/jsm/exporters/OBJExporter.js`（OBJ形式エクスポーター実装）
- E-03: `examples/jsm/exporters/STLExporter.js`（STL形式エクスポーター実装）
- E-04: `examples/jsm/exporters/PLYExporter.js`（PLY形式エクスポーター実装）
- E-05: `examples/jsm/exporters/DRACOExporter.js`（Draco圧縮エクスポーター実装）
- E-06: `examples/jsm/exporters/USDZExporter.js`（USDZ形式エクスポーター実装）
- E-07: `examples/jsm/exporters/EXRExporter.js`（EXR形式画像エクスポーター実装）
- E-08: `examples/jsm/exporters/KTX2Exporter.js`（KTX2形式テクスチャエクスポーター実装）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GLTFExporterはglTF 2.0形式でシーンをエクスポート。JSON(.gltf)またはバイナリ(.glb)形式に対応 | E-01 | ○ |
| C-02 | OBJExporterはOBJ形式で3Dオブジェクトをエクスポート。頂点位置、法線、UV座標を出力 | E-02 | ○ |
| C-03 | STLExporterはSTL形式で3Dオブジェクトをエクスポート。ASCIIおよびバイナリ形式に対応 | E-03 | ○ |
| C-04 | PLYExporterはPLY形式でエクスポート。頂点位置、色、法線、UV座標を保持 | E-04 | ○ |
| C-05 | DRACOExporterはDraco圧縮形式でジオメトリをエクスポート。メッシュとポイントクラウドに対応 | E-05 | ○ |
| C-06 | USDZExporterはUSDZ形式でシーンをエクスポート。Apple QuickLook対応 | E-06 | ○ |
| C-07 | EXRExporterはEXR形式で画像をエクスポート。HDR画像出力に対応 | E-07 | ○ |
| C-08 | KTX2ExporterはKTX2形式でテクスチャをエクスポート。GPU圧縮テクスチャフォーマット出力 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
  - すべてのエクスポーター機能について、ソースコード内のJSDocコメントおよび実装から情報を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードのJSDocコメントおよび実装に基づいている
- 注意点：Three.jsは3Dグラフィックスライブラリのため、一般的なビジネス帳票（PDF、Excel等）は存在しない。本一覧は3Dデータのエクスポート（出力）機能を帳票相当として整理した

## 6) レビュアーチェックリスト（最小）
- [ ] 各エクスポーターの出力形式と機能説明が正確か
- [ ] カテゴリ分類（3Dモデル出力/画像出力）が適切か
- [ ] 備考欄のファイルパスが正しいか
- [ ] ビジネス帳票ではなく3Dデータエクスポーターを帳票として扱うことが要件と合致しているか
