---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-GLTFExporter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の目標出力時間**：具体的なベンチマーク根拠なし
  2. **想定データ件数**：コードからは上限が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/GLTFExporter.js` 行103-108（GLTFExporterコンストラクタ）
- E-02: `examples/jsm/exporters/GLTFExporter.js` 行120-203（プラグイン登録）
- E-03: `examples/jsm/exporters/GLTFExporter.js` 行269-284（parseメソッド）
- E-04: `examples/jsm/exporters/GLTFExporter.js` 行293-303（parseAsyncメソッド）
- E-05: `examples/jsm/exporters/GLTFExporter.js` 行311-376（WEBGL定数マッピング）
- E-06: `examples/jsm/exporters/GLTFExporter.js` 行367-376（GLB定数定義）
- E-07: `examples/jsm/exporters/GLTFExporter.js` 行584-623（GLTFWriter初期化）
- E-08: `examples/jsm/exporters/GLTFExporter.js` 行644-759（writeAsync処理）
- E-09: `examples/jsm/exporters/GLTFExporter.js` 行646-654（デフォルトオプション）
- E-10: `examples/jsm/exporters/GLTFExporter.js` 行66-99（glTF 2.0拡張サポートコメント）
- E-11: `examples/jsm/exporters/GLTFExporter.js` 行491-495（getPaddedBufferSize関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GLTFExporterはglTF 2.0形式でエクスポートする | E-07 (json.asset.version: '2.0') | ○ |
| C-02 | JSON(.gltf)とバイナリ(.glb)の両形式に対応 | E-08, E-09 (binary オプション) | ○ |
| C-03 | メッシュ、マテリアル、テクスチャを出力可能 | E-07 (cache構造) | ○ |
| C-04 | スキン、スケルトン、モーフターゲット対応 | E-07 (skins配列) | ○ |
| C-05 | アニメーション出力に対応 | E-09 (animations オプション) | ○ |
| C-06 | ライト、カメラ出力に対応 | E-02 (GLTFLightExtension登録) | ○ |
| C-07 | binaryオプションでGLB形式出力 | E-09 (binary: false デフォルト) | ○ |
| C-08 | trsオプションでTRS分解形式出力 | E-09 (trs: false デフォルト) | ○ |
| C-09 | onlyVisibleオプションで可視オブジェクト限定 | E-09 (onlyVisible: true デフォルト) | ○ |
| C-10 | maxTextureSizeでテクスチャサイズ制限 | E-09 (maxTextureSize: Infinity デフォルト) | ○ |
| C-11 | GLBヘッダーは12バイト | E-06 (GLB_HEADER_BYTES = 12) | ○ |
| C-12 | GLBマジックナンバーは0x46546C67 | E-06 (GLB_HEADER_MAGIC = 0x46546C67) | ○ |
| C-13 | GLBバージョンは2 | E-06 (GLB_VERSION = 2) | ○ |
| C-14 | バッファは4バイト境界にアライメント | E-11 (getPaddedBufferSize関数) | ○ |
| C-15 | KHR_lights_punctual拡張対応 | E-02 (GLTFLightExtension登録) | ○ |
| C-16 | KHR_materials_unlit拡張対応 | E-02 (GLTFMaterialsUnlitExtension登録) | ○ |
| C-17 | KHR_materials_transmission拡張対応 | E-02 (GLTFMaterialsTransmissionExtension登録) | ○ |
| C-18 | KHR_materials_volume拡張対応 | E-02 (GLTFMaterialsVolumeExtension登録) | ○ |
| C-19 | KHR_texture_transform拡張対応 | E-08 (applyTextureTransform参照) | ○ |
| C-20 | textureUtilsで圧縮テクスチャ対応 | E-01, E-03 (textureUtils設定) | ○ |
| C-21 | プラグイン機構でカスタム拡張対応 | E-01, E-02 (pluginCallbacks) | ○ |
| C-22 | includeCustomExtensionsでカスタム拡張含有 | E-09 (includeCustomExtensions: false) | ○ |
| C-23 | ジェネレータ情報にREVISIONを含む | E-07 (generator: 'THREE.GLTFExporter r' + REVISION) | ○ |
| C-24 | 目標出力時間10万頂点で1秒以内 | **根拠なし** | △ |
| C-25 | 想定データ件数メッシュ1〜1000 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値はコードから確認できない
  - 候補：ベンチマークテスト結果 / 公式ドキュメント / 開発者コメント
- 想定データ件数の上限はコードに明示的な制限がない
  - 候補：メモリ使用量テスト / ブラウザ制限調査

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 出力形式、対応拡張、オプション仕様は全てコードで確認済み
- 1: 中リスク - パフォーマンス要件は実測値に基づく検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GLB/gltf両形式のエクスポートが正常に動作するか実機確認
- [ ] 記載された全glTF拡張が実際に出力されるか確認
- [ ] パフォーマンス要件の数値が妥当か検証（大規模モデルでテスト）
- [ ] エラー処理の網羅性を確認（圧縮テクスチャ、循環参照等）
