---
generated_at: 2026-01-27 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-OBJExporter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/OBJExporter.js` 行10-21（クラスJSDoc）
- E-02: `examples/jsm/exporters/OBJExporter.js` 行22-32（OBJExporterクラス定義）
- E-03: `examples/jsm/exporters/OBJExporter.js` 行34-45（変数初期化）
- E-04: `examples/jsm/exporters/OBJExporter.js` 行47-169（parseMesh関数）
- E-05: `examples/jsm/exporters/OBJExporter.js` 行64-70（オブジェクト名・マテリアル出力）
- E-06: `examples/jsm/exporters/OBJExporter.js` 行75-88（頂点位置出力）
- E-07: `examples/jsm/exporters/OBJExporter.js` 行93-103（UV出力）
- E-08: `examples/jsm/exporters/OBJExporter.js` 行108-124（法線出力）
- E-09: `examples/jsm/exporters/OBJExporter.js` 行128-162（面定義出力）
- E-10: `examples/jsm/exporters/OBJExporter.js` 行171-227（parseLine関数）
- E-11: `examples/jsm/exporters/OBJExporter.js` 行229-278（parsePoints関数）
- E-12: `examples/jsm/exporters/OBJExporter.js` 行280-300（traverse処理）
- E-13: `examples/jsm/exporters/OBJExporter.js` 行249-257（頂点カラーsRGB変換）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OBJ形式でエクスポートする | E-01, E-02 | ○ |
| C-02 | MTLファイルは非対応 | E-01 ("OBJExporter is not able to export material data into MTL files") | ○ |
| C-03 | parseメソッドで文字列を返却 | E-02 (return string) | ○ |
| C-04 | 頂点位置を出力 | E-06 ('v ' + vertex.x + ' ' + vertex.y + ' ' + vertex.z) | ○ |
| C-05 | UV座標を出力 | E-07 ('vt ' + uv.x + ' ' + uv.y) | ○ |
| C-06 | 法線ベクトルを出力 | E-08 ('vn ' + normal.x + ' ' + normal.y + ' ' + normal.z) | ○ |
| C-07 | 面定義を出力 | E-09 ('f ' + face.join(' ')) | ○ |
| C-08 | オブジェクト名を出力 | E-05 ('o ' + mesh.name) | ○ |
| C-09 | マテリアル参照を出力 | E-05 ('usemtl ' + mesh.material.name) | ○ |
| C-10 | ライン定義を出力 | E-10 ('l ' + ...) | ○ |
| C-11 | ポイント定義を出力 | E-11 ('p ' + ...) | ○ |
| C-12 | isMeshでメッシュ判定 | E-12 (child.isMesh === true) | ○ |
| C-13 | isLineでライン判定 | E-12 (child.isLine === true) | ○ |
| C-14 | isPointsでポイント判定 | E-12 (child.isPoints === true) | ○ |
| C-15 | 頂点をワールド座標に変換 | E-06 (vertex.applyMatrix4(mesh.matrixWorld)) | ○ |
| C-16 | 法線をワールド空間に変換 | E-08 (normal.applyMatrix3(normalMatrixWorld).normalize()) | ○ |
| C-17 | 頂点カラーをsRGBに変換 | E-13 (ColorManagement.workingToColorSpace(color, SRGBColorSpace)) | ○ |
| C-18 | OBJインデックスは1始まり | E-09 (indices.getX(i + m) + 1) | ○ |
| C-19 | 複数オブジェクトはマージ出力 | E-01 ("merged into a single mesh in the file") | ○ |
| C-20 | traverseで再帰走査 | E-12 (object.traverse(function (child))) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。OBJExporterはシンプルな構造のため、全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能仕様がソースコードで確認済み
- コードが308行とコンパクトで、全体を把握しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] v/vt/vn/f各行の出力形式がOBJ仕様に準拠しているか確認
- [ ] ワールド座標変換が正しく行われるか実機テスト
- [ ] Line/LineSegmentsの出力形式の違いを確認
- [ ] 頂点カラー付きPointsの出力が正しいか確認
