---
generated_at: 2026-01-27 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-STLExporter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/STLExporter.js` 行5-16（JSDocコメント）
- E-02: `examples/jsm/exporters/STLExporter.js` 行29-33（オプション設定）
- E-03: `examples/jsm/exporters/STLExporter.js` 行39-60（traverse処理）
- E-04: `examples/jsm/exporters/STLExporter.js` 行62-77（バッファ初期化）
- E-05: `examples/jsm/exporters/STLExporter.js` 行67（バッファ長計算式）
- E-06: `examples/jsm/exporters/STLExporter.js` 行75（ASCII開始文字列）
- E-07: `examples/jsm/exporters/STLExporter.js` 行126-130（ASCII終了処理）
- E-08: `examples/jsm/exporters/STLExporter.js` 行134-169（writeFace関数）
- E-09: `examples/jsm/exporters/STLExporter.js` 行140-146（SkinnedMesh処理）
- E-10: `examples/jsm/exporters/STLExporter.js` 行148-150（ワールド座標変換）
- E-11: `examples/jsm/exporters/STLExporter.js` 行171-191（writeNormal関数）
- E-12: `examples/jsm/exporters/STLExporter.js` 行173-175（外積計算）
- E-13: `examples/jsm/exporters/STLExporter.js` 行193-208（writeVertex関数）
- E-14: `examples/jsm/exporters/STLExporter.js` 行214-219（Options型定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | STL形式でエクスポートする | E-01 | ○ |
| C-02 | ASCIIとバイナリ両形式に対応 | E-01, E-02 | ○ |
| C-03 | binaryオプションでバイナリ出力 | E-02 (binary: false デフォルト), E-14 | ○ |
| C-04 | 表面ジオメトリのみ出力 | E-01 ("surface geometry...no color, texture") | ○ |
| C-05 | ASCII形式は"solid exported"で開始 | E-06 ("solid exported\n") | ○ |
| C-06 | ASCII形式は"endsolid exported"で終了 | E-07 ("endsolid exported\n") | ○ |
| C-07 | バイナリヘッダーは80バイト | E-04, E-05 (offset = 80) | ○ |
| C-08 | バイナリで三角形数を4バイト整数で出力 | E-04 (setUint32) | ○ |
| C-09 | 法線は外積で計算 | E-12 (cb.subVectors(vC, vB).cross(ab)) | ○ |
| C-10 | 法線は正規化される | E-11 (normalize()) | ○ |
| C-11 | 頂点をワールド座標に変換 | E-10 (applyMatrix4(object.matrixWorld)) | ○ |
| C-12 | SkinnedMeshでボーントランスフォーム適用 | E-09 (applyBoneTransform) | ○ |
| C-13 | 属性バイトカウントは常に0 | E-08 (setUint16(offset, 0, true)) | ○ |
| C-14 | isMeshでメッシュ判定 | E-03 (object.isMesh) | ○ |
| C-15 | 三角形数はindex/3またはposition/3 | E-03 (index.count / 3 : positionAttribute.count / 3) | ○ |
| C-16 | バイナリはリトルエンディアン | E-04, E-13 (setFloat32(..., true)) | ○ |
| C-17 | 文字列またはArrayBufferを返却 | E-01, E-04 | ○ |
| C-18 | バッファ長計算式が正しい | E-05 (triangles * 2 + triangles * 3 * 4 * 4 + 80 + 4) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。STLExporterはシンプルな構造のため、全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能仕様がソースコードで確認済み
- コードが221行とコンパクトで、全体を把握しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] ASCII/バイナリ両形式のファイルが3Dプリンタソフトで読み込めるか確認
- [ ] 法線計算（外積・正規化）が正しい向きになっているか確認
- [ ] SkinnedMeshのボーントランスフォーム適用後の形状が正しいか確認
- [ ] 大規模メッシュでのバッファ長計算が正しいか検証
