---
generated_at: 2026-01-27 10:55:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-USDZExporter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/USDZExporter.js` 行127-136（JSDocコメント）
- E-02: `examples/jsm/exporters/USDZExporter.js` 行137-167（USDZExporterクラス定義）
- E-03: `examples/jsm/exporters/USDZExporter.js` 行192-204（デフォルトオプション）
- E-04: `examples/jsm/exporters/USDZExporter.js` 行206-237（ルートノード構築）
- E-05: `examples/jsm/exporters/USDZExporter.js` 行262-295（テクスチャ処理）
- E-06: `examples/jsm/exporters/USDZExporter.js` 行300-322（64バイトアライメント、ZIP圧縮）
- E-07: `examples/jsm/exporters/USDZExporter.js` 行413-426（buildHeader関数）
- E-08: `examples/jsm/exporters/USDZExporter.js` 行430-498（buildHierarchy関数）
- E-09: `examples/jsm/exporters/USDZExporter.js` 行473-478（非対応マテリアル警告）
- E-10: `examples/jsm/exporters/USDZExporter.js` 行505-512（負のスケール警告）
- E-11: `examples/jsm/exporters/USDZExporter.js` 行886-893（DoubleSide警告）
- E-12: `examples/jsm/exporters/USDZExporter.js` 行268-274（圧縮テクスチャエラー）
- E-13: `examples/jsm/exporters/USDZExporter.js` 行400-406（無効画像エラー）
- E-14: `examples/jsm/exporters/USDZExporter.js` 行765-884（buildTextureNodes関数）
- E-15: `examples/jsm/exporters/USDZExporter.js` 行1227-1239（Options型定義）
- E-16: `examples/jsm/exporters/USDZExporter.js` 行12-125（USDNodeクラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | USDZ形式でエクスポートする | E-01 | ○ |
| C-02 | Apple QuickLook対応 | E-01 | ○ |
| C-03 | ArrayBufferとして返却 | E-06 (zipSync → ArrayBuffer相当) | ○ |
| C-04 | maxTextureSizeデフォルト1024 | E-03 | ○ |
| C-05 | includeAnchoringPropertiesデフォルトtrue | E-03 | ○ |
| C-06 | onlyVisibleデフォルトtrue | E-03 | ○ |
| C-07 | ar.anchoring.typeデフォルト'plane' | E-03 | ○ |
| C-08 | ar.planeAnchoring.alignmentデフォルト'horizontal' | E-03 | ○ |
| C-09 | quickLookCompatibleデフォルトfalse | E-03 | ○ |
| C-10 | model.usdaが出力される | E-04, E-06 (files[modelFileName]) | ○ |
| C-11 | geometries/Geometry_N.usdaが出力される | E-08 (geometries/Geometry_ + geometry.id) | ○ |
| C-12 | textures/Texture_N.pngが出力される | E-05 (textures/Texture_${id}.png) | ○ |
| C-13 | MeshStandardMaterialのみ対応 | E-09 | ○ |
| C-14 | 非対応マテリアルで警告 | E-09 (console.warn) | ○ |
| C-15 | 負のスケールで警告 | E-10 (console.warn) | ○ |
| C-16 | DoubleSideで警告 | E-11 (console.warn) | ○ |
| C-17 | 圧縮テクスチャでtextureUtils必須 | E-12 (throw Error) | ○ |
| C-18 | 無効画像でエラー | E-13 (throw Error) | ○ |
| C-19 | USDAヘッダーに"#usda 1.0"含む | E-07 | ○ |
| C-20 | creator = "Three.js USDZExporter" | E-07 | ○ |
| C-21 | defaultPrim = "Root" | E-07 | ○ |
| C-22 | metersPerUnit = 1 | E-07 | ○ |
| C-23 | upAxis = "Y" | E-07 | ○ |
| C-24 | 64バイトアライメント | E-06 (offsetMod64, 64 - offsetMod64) | ○ |
| C-25 | zipSync({ level: 0 })で無圧縮ZIP | E-06 | ○ |
| C-26 | USDNodeでノードツリー構築 | E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。USDZExporterは全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能仕様がソースコードで確認済み
- 1: 中リスク - Apple QuickLookバグ対応（FB10036297, FB11442287）は実機テスト推奨

## 6) レビュアーチェックリスト（最小）
- [ ] iOS/macOS QuickLookで出力ファイルが正しく表示されるか確認
- [ ] AR配置（平面アンカリング）が正しく動作するか確認
- [ ] テクスチャのスケール/オフセット/回転が正しく反映されるか確認
- [ ] MeshPhysicalMaterialのclearcoat等が正しく出力されるか確認
- [ ] quickLookCompatibleモードの効果を実機確認
