---
generated_at: 2026-01-27 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-EXRExporter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/EXRExporter.js` 行15-31（JSDocコメント）
- E-02: `examples/jsm/exporters/EXRExporter.js` 行11-14（圧縮定数）
- E-03: `examples/jsm/exporters/EXRExporter.js` 行47-81（parseメソッド）
- E-04: `examples/jsm/exporters/EXRExporter.js` 行49-52（入力型判定）
- E-05: `examples/jsm/exporters/EXRExporter.js` 行85-112（supportedRTT関数）
- E-06: `examples/jsm/exporters/EXRExporter.js` 行114-145（supportedDT関数）
- E-07: `examples/jsm/exporters/EXRExporter.js` 行147-178（buildInfoRTT関数）
- E-08: `examples/jsm/exporters/EXRExporter.js` 行181-212（buildInfoDT関数）
- E-09: `examples/jsm/exporters/EXRExporter.js` 行243-288（reorganizeDataBuffer関数）
- E-10: `examples/jsm/exporters/EXRExporter.js` 行290-334（compressData関数）
- E-11: `examples/jsm/exporters/EXRExporter.js` 行342-382（compressZIP関数）
- E-12: `examples/jsm/exporters/EXRExporter.js` 行384-481（fillHeader関数）
- E-13: `examples/jsm/exporters/EXRExporter.js` 行389-390（マジックナンバー・バージョン）
- E-14: `examples/jsm/exporters/EXRExporter.js` 行545-547（setFloat16関数）
- E-15: `examples/jsm/exporters/EXRExporter.js` 行610-617（Options型定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EXR形式でエクスポートする | E-01 | ○ |
| C-02 | HDR画像出力に対応 | E-01 | ○ |
| C-03 | Uint8Arrayとして返却 | E-03 (return outBuffer) | ○ |
| C-04 | typeデフォルトHalfFloatType | E-07, E-08 (EXPORTER_TYPE = options.type \|\| HalfFloatType) | ○ |
| C-05 | compressionデフォルトZIP_COMPRESSION | E-07, E-08 (options.compression \|\| ZIP_COMPRESSION) | ○ |
| C-06 | NO_COMPRESSION = 0 | E-02 | ○ |
| C-07 | ZIPS_COMPRESSION = 2 | E-02 | ○ |
| C-08 | ZIP_COMPRESSION = 3 | E-02 | ○ |
| C-09 | マジックナンバー20000630 | E-12, E-13 (setUint32(dv, 20000630, offset)) | ○ |
| C-10 | バージョン2 | E-13 (setUint32(dv, 2, offset)) | ○ |
| C-11 | チャンネル順序A, B, G, R | E-12 (setString 'A', 'B', 'G', 'R') | ○ |
| C-12 | Y座標反転 | E-09 (h - y - 1) | ○ |
| C-13 | DataTexture対応 | E-03, E-04 (isDataTexture) | ○ |
| C-14 | WebGLRenderer+RenderTarget対応 | E-03, E-04 (isWebGLRenderer) | ○ |
| C-15 | WebGPURenderer+RenderTarget対応 | E-03, E-04 (isWebGPURenderer) | ○ |
| C-16 | FloatType/HalfFloatTypeのみ対応 | E-05, E-06 | ○ |
| C-17 | RGBAFormatのみ対応 | E-05, E-06 | ○ |
| C-18 | Cube/3D/Array RenderTarget非対応 | E-05 | ○ |
| C-19 | ZIP圧縮でリオーダー処理 | E-11 (t1, t2, s) | ○ |
| C-20 | ZIP圧縮でプレディクター処理 | E-11 (d - p + 128 + 256) | ○ |
| C-21 | fflate.zlibSyncで圧縮 | E-11 (fflate.zlibSync) | ○ |
| C-22 | Half Float変換にDataUtils.toHalfFloat | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。EXRExporterは全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能仕様がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 出力EXRファイルがPhotoshop、Nuke等で正しく読み込めるか確認
- [ ] 各圧縮方式（NO/ZIPS/ZIP）の出力が正しいか確認
- [ ] HalfFloatType/FloatType両方の出力が正しいか確認
- [ ] 大解像度（4K/8K）での動作確認
- [ ] WebGL/WebGPU両レンダラーでの動作確認
