---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-KTX2Exporter.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `examples/jsm/exporters/KTX2Exporter.js` 行130-139（JSDocコメント）
- E-02: `examples/jsm/exporters/KTX2Exporter.js` 行55-105（VK_FORMAT_MAP）
- E-03: `examples/jsm/exporters/KTX2Exporter.js` 行107-114（KHR_DF_CHANNEL_MAP）
- E-04: `examples/jsm/exporters/KTX2Exporter.js` 行125-129（エラーメッセージ定数）
- E-05: `examples/jsm/exporters/KTX2Exporter.js` 行154-170（入力判定）
- E-06: `examples/jsm/exporters/KTX2Exporter.js` 行172-188（フォーマット検証）
- E-07: `examples/jsm/exporters/KTX2Exporter.js` 行192-206（コンテナ基本設定）
- E-08: `examples/jsm/exporters/KTX2Exporter.js` 行209-256（DFD構築）
- E-09: `examples/jsm/exporters/KTX2Exporter.js` 行260-267（レベルデータ・メタデータ）
- E-10: `examples/jsm/exporters/KTX2Exporter.js` 行271（KTXwriter設定）
- E-11: `examples/jsm/exporters/KTX2Exporter.js` 行275（write関数呼び出し）
- E-12: `examples/jsm/exporters/KTX2Exporter.js` 行281-320（toDataTexture関数）
- E-13: `examples/jsm/exporters/KTX2Exporter.js` 行323-346（getChannelCount関数）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KTX2形式でエクスポートする | E-01 | ○ |
| C-02 | Uint8Arrayとして返却 | E-11 (write() returns Uint8Array) | ○ |
| C-03 | DataTexture対応 | E-05 (isDataTexture) | ○ |
| C-04 | Data3DTexture対応 | E-05 (isData3DTexture) | ○ |
| C-05 | WebGLRenderer+RenderTarget対応 | E-05 (isWebGLRenderer) | ○ |
| C-06 | WebGPURenderer+RenderTarget対応 | E-05 (isWebGPURenderer) | ○ |
| C-07 | RGBAFormat対応 | E-02 (VK_FORMAT_MAP[RGBAFormat]) | ○ |
| C-08 | RGFormat対応 | E-02 (VK_FORMAT_MAP[RGFormat]) | ○ |
| C-09 | RedFormat対応 | E-02 (VK_FORMAT_MAP[RedFormat]) | ○ |
| C-10 | FloatType対応 | E-02 ([FloatType]) | ○ |
| C-11 | HalfFloatType対応 | E-02 ([HalfFloatType]) | ○ |
| C-12 | UnsignedByteType対応 | E-02 ([UnsignedByteType]) | ○ |
| C-13 | SRGBColorSpace対応 | E-02 ([SRGBColorSpace]) | ○ |
| C-14 | LinearSRGBColorSpace対応 | E-02 ([LinearSRGBColorSpace]) | ○ |
| C-15 | NoColorSpace対応 | E-02 ([NoColorSpace]) | ○ |
| C-16 | colorModel = RGBSDA | E-08 (KHR_DF_MODEL_RGBSDA) | ○ |
| C-17 | colorPrimaries = BT709 or UNSPECIFIED | E-08 | ○ |
| C-18 | transferFunction = SRGB or LINEAR | E-08 | ○ |
| C-19 | levelCount = 1 | E-09 (container.levelCount = 1) | ○ |
| C-20 | KTXwriter = "three.js REVISION" | E-10 | ○ |
| C-21 | write({ keepWriter: true }) | E-11 | ○ |
| C-22 | チャンネル数はgetChannelCountで取得 | E-13 | ○ |
| C-23 | toDataTextureでRenderTarget変換 | E-12 | ○ |
| C-24 | ktx-parse.module.jsを使用 | E-07 (createDefaultContainer), E-11 (write) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。KTX2Exporterは全ての主張がソースコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能仕様がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各フォーマット/型/色空間の組み合わせが正しくVkFormatにマップされるか確認
- [ ] 出力KTX2ファイルがKTX2ビューアで正しく表示されるか確認
- [ ] Data3DTextureのpixelDepthが正しく設定されるか確認
- [ ] WebGL/WebGPU両レンダラーでのRenderTarget変換が正しいか確認
- [ ] glTFへのKTX2テクスチャ埋め込みが正常に動作するか確認
