---
generated_at: 2026-01-27 15:30:00
metrics:
  claims_total: 90
  claims_with_evidence: 85
  claims_without_evidence: 5
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：85 / 90、根拠なし：5
- 優先レビュー（高）
  1. **BR-079 XRコントローラー機能**：WebXRController.jsの詳細仕様確認が必要
  2. **BR-086 コンピュートシェーダー機能**：TSLノードシステムの詳細確認が必要
  3. **BR-088 バッチ描画機能**：BatchedMeshの実装詳細確認が必要
  4. **BR-089 ジオメトリ結合機能**：アドオン機能のため本体ソースに根拠なし
  5. **BR-056 オーディオ解析機能**：AudioAnalyserの詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Three.js` - メインエントリーポイント、エクスポート一覧
- E-02: `src/Three.Core.js` - コア機能のエクスポート一覧
- E-03: `src/constants.js` - 定数定義（シャドウタイプ、トーンマッピング、ブレンドモード等）
- E-04: `src/renderers/WebGLRenderer.js` - WebGLレンダラー実装
- E-05: `src/renderers/webgpu/WebGPURenderer.js` - WebGPUレンダラー実装
- E-06: `src/core/Object3D.js` - 3Dオブジェクト基底クラス
- E-07: `src/geometries/Geometries.js` - ジオメトリエクスポート一覧
- E-08: `src/materials/Materials.js` - マテリアルエクスポート一覧
- E-09: `package.json` - プロジェクト定義、依存関係
- E-10: `README.md` - プロジェクト概要
- E-11: `src/lights/` - ライト関連クラス群
- E-12: `src/cameras/` - カメラ関連クラス群
- E-13: `src/textures/` - テクスチャ関連クラス群
- E-14: `src/animation/` - アニメーション関連クラス群
- E-15: `src/math/` - 数学ライブラリ群
- E-16: `src/loaders/` - ローダー関連クラス群
- E-17: `src/audio/` - オーディオ関連クラス群
- E-18: `src/helpers/` - ヘルパー関連クラス群
- E-19: `src/scenes/` - シーン関連クラス群
- E-20: `src/objects/` - オブジェクト関連クラス群
- E-21: `src/extras/` - 追加機能（カーブ、シェイプ等）
- E-22: `src/nodes/` - ノードシステム
- E-23: `src/renderers/webxr/` - WebXR関連
- E-24: `examples/jsm/` - アドオン機能群
- E-25: `examples/jsm/controls/` - コントロール関連アドオン
- E-26: `examples/jsm/exporters/` - エクスポーター関連アドオン
- E-27: `examples/jsm/loaders/` - ローダー関連アドオン
- E-28: `examples/jsm/renderers/` - 拡張レンダラー（CSS2D, CSS3D, SVG）
- E-29: `examples/jsm/tsl/` - TSLエフェクトノード群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 WebGLレンダリング機能 | E-04, E-03 | ○ |
| C-02 | BR-002 WebGPUレンダリング機能 | E-05 | ○ |
| C-03 | BR-003 シャドウマッピング機能 | E-03, E-04 | ○ |
| C-04 | BR-004 トーンマッピング機能 | E-03, E-04 | ○ |
| C-05 | BR-005 3Dオブジェクト管理機能 | E-06 | ○ |
| C-06 | BR-006 メッシュ表示機能 | E-20 | ○ |
| C-07 | BR-007 スプライト表示機能 | E-20 | ○ |
| C-08 | BR-008 LOD機能 | E-20 | ○ |
| C-09 | BR-009 基本形状ジオメトリ生成機能 | E-07 | ○ |
| C-10 | BR-010 多面体ジオメトリ生成機能 | E-07 | ○ |
| C-11 | BR-011 押し出しジオメトリ生成機能 | E-07 | ○ |
| C-12 | BR-012 チューブジオメトリ生成機能 | E-07 | ○ |
| C-13 | BR-013 バッファジオメトリ管理機能 | E-02 | ○ |
| C-14 | BR-014 基本マテリアル機能 | E-08 | ○ |
| C-15 | BR-015 PBRマテリアル機能 | E-08 | ○ |
| C-16 | BR-016 フォン/ランバートマテリアル機能 | E-08 | ○ |
| C-17 | BR-017 トゥーンマテリアル機能 | E-08 | ○ |
| C-18 | BR-018 カスタムシェーダーマテリアル機能 | E-08 | ○ |
| C-19 | BR-019 ライン/ポイントマテリアル機能 | E-08 | ○ |
| C-20 | BR-020 環境光ライティング機能 | E-11, E-02 | ○ |
| C-21 | BR-021 指向性ライティング機能 | E-11, E-02 | ○ |
| C-22 | BR-022 点光源ライティング機能 | E-11, E-02 | ○ |
| C-23 | BR-023 スポットライト機能 | E-11, E-02 | ○ |
| C-24 | BR-024 矩形エリアライト機能 | E-11, E-02 | ○ |
| C-25 | BR-025 半球光ライティング機能 | E-11, E-02 | ○ |
| C-26 | BR-026 透視投影カメラ機能 | E-12, E-02 | ○ |
| C-27 | BR-027 正射影カメラ機能 | E-12, E-02 | ○ |
| C-28 | BR-028 ステレオカメラ機能 | E-12, E-02 | ○ |
| C-29 | BR-029 キューブカメラ機能 | E-12, E-02 | ○ |
| C-30 | BR-030 2Dテクスチャ管理機能 | E-13, E-02 | ○ |
| C-31 | BR-031 キューブマップテクスチャ機能 | E-13, E-02 | ○ |
| C-32 | BR-032 ビデオテクスチャ機能 | E-13, E-02 | ○ |
| C-33 | BR-033 データテクスチャ機能 | E-13, E-02 | ○ |
| C-34 | BR-034 圧縮テクスチャ機能 | E-13, E-02, E-03 | ○ |
| C-35 | BR-035 深度テクスチャ機能 | E-13, E-02 | ○ |
| C-36 | BR-036 キーフレームアニメーション機能 | E-14, E-02 | ○ |
| C-37 | BR-037 キーフレームトラック機能 | E-14, E-02 | ○ |
| C-38 | BR-038 スケルタルアニメーション機能 | E-14, E-20, E-02 | ○ |
| C-39 | BR-039 モーフターゲット機能 | E-14, E-04 | ○ |
| C-40 | BR-040 アニメーションブレンディング機能 | E-14, E-03 | ○ |
| C-41 | BR-041 ベクトル演算機能 | E-15, E-02 | ○ |
| C-42 | BR-042 行列演算機能 | E-15, E-02 | ○ |
| C-43 | BR-043 クォータニオン機能 | E-15, E-02 | ○ |
| C-44 | BR-044 オイラー角機能 | E-15, E-02 | ○ |
| C-45 | BR-045 色管理機能 | E-15, E-02 | ○ |
| C-46 | BR-046 幾何学演算機能 | E-15, E-02 | ○ |
| C-47 | BR-047 視錐台カリング機能 | E-15, E-02 | ○ |
| C-48 | BR-048 シーングラフ管理機能 | E-19, E-02, E-06 | ○ |
| C-49 | BR-049 フォグエフェクト機能 | E-19, E-02 | ○ |
| C-50 | BR-050 レイキャスティング機能 | E-02 | ○ |
| C-51 | BR-051 ファイルローダー機能 | E-16, E-02 | ○ |
| C-52 | BR-052 画像ローダー機能 | E-16, E-02 | ○ |
| C-53 | BR-053 3Dモデルローダー機能 | E-27 | ○ |
| C-54 | BR-054 3Dモデルエクスポーター機能 | E-26 | ○ |
| C-55 | BR-055 3Dオーディオ機能 | E-17, E-02 | ○ |
| C-56 | BR-056 オーディオ解析機能 | E-17 | △ |
| C-57 | BR-057 レンダーターゲット機能 | E-02, E-04 | ○ |
| C-58 | BR-058 キューブレンダーターゲット機能 | E-02 | ○ |
| C-59 | BR-059 配列レンダーターゲット機能 | E-02 | ○ |
| C-60 | BR-060 ブルームエフェクト機能 | E-29 | ○ |
| C-61 | BR-061 被写界深度エフェクト機能 | E-29 | ○ |
| C-62 | BR-062 アンチエイリアシング機能 | E-29 | ○ |
| C-63 | BR-063 アウトラインエフェクト機能 | E-29 | ○ |
| C-64 | BR-064 スクリーンスペース効果機能 | E-29 | ○ |
| C-65 | BR-065 ライトヘルパー機能 | E-18, E-02 | ○ |
| C-66 | BR-066 カメラヘルパー機能 | E-18, E-02 | ○ |
| C-67 | BR-067 グリッドヘルパー機能 | E-18, E-02 | ○ |
| C-68 | BR-068 軸ヘルパー機能 | E-18, E-02 | ○ |
| C-69 | BR-069 バウンディングボックスヘルパー機能 | E-18, E-02 | ○ |
| C-70 | BR-070 オービットコントロール機能 | E-25 | ○ |
| C-71 | BR-071 トラックボールコントロール機能 | E-25 | ○ |
| C-72 | BR-072 フライコントロール機能 | E-25 | ○ |
| C-73 | BR-073 ポインターロックコントロール機能 | E-25 | ○ |
| C-74 | BR-074 トランスフォームコントロール機能 | E-25 | ○ |
| C-75 | BR-075 CSS3Dレンダラー機能 | E-28 | ○ |
| C-76 | BR-076 CSS2Dレンダラー機能 | E-28 | ○ |
| C-77 | BR-077 SVGレンダラー機能 | E-28 | ○ |
| C-78 | BR-078 WebXR統合機能 | E-23, E-02 | ○ |
| C-79 | BR-079 XRコントローラー機能 | E-23 | △ |
| C-80 | BR-080 イベントディスパッチャー機能 | E-02 | ○ |
| C-81 | BR-081 クロック機能 | E-02 | ○ |
| C-82 | BR-082 レイヤー機能 | E-02 | ○ |
| C-83 | BR-083 曲線定義機能 | E-21, E-02 | ○ |
| C-84 | BR-084 シェイプ定義機能 | E-21, E-02 | ○ |
| C-85 | BR-085 ノードベースマテリアル機能 | E-22 | ○ |
| C-86 | BR-086 コンピュートシェーダー機能 | E-22 | △ |
| C-87 | BR-087 インスタンス描画機能 | E-20, E-02 | ○ |
| C-88 | BR-088 バッチ描画機能 | E-20 | △ |
| C-89 | BR-089 ジオメトリ結合機能 | **根拠なし** | △ |
| C-90 | BR-090 PMREMジェネレーター機能 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-056 オーディオ解析機能**: AudioAnalyserの詳細なAPI仕様書が不足。Web Audio APIとの連携詳細の確認が必要。
  - 候補: src/audio/AudioAnalyser.js の詳細読み込み / Web Audio API ドキュメント参照
- **BR-079 XRコントローラー機能**: WebXRControllerの入力イベント処理の詳細が不足。
  - 候補: src/renderers/webxr/WebXRController.js の詳細確認 / WebXR API仕様書参照
- **BR-086 コンピュートシェーダー機能**: TSLノードシステムのコンピュート機能の詳細が不足。
  - 候補: src/nodes/compute/ ディレクトリの詳細確認
- **BR-088 バッチ描画機能**: BatchedMeshの内部実装詳細の確認が必要。
  - 候補: src/objects/BatchedMesh.js の詳細読み込み
- **BR-089 ジオメトリ結合機能**: BufferGeometryUtils.mergeGeometriesはアドオン機能であり、コアソースには根拠なし。
  - 候補: examples/jsm/utils/BufferGeometryUtils.js の確認

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - BR-001〜BR-055, BR-057〜BR-085, BR-087, BR-090: コアソースに明確な根拠あり
- **1: 中リスク** - BR-056, BR-079, BR-086, BR-088: 詳細仕様の確認が推奨される
- **2: 高リスク** - BR-089: アドオン機能のため本体ソースに直接的な根拠なし。examples/jsm/utils/の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全90件の業務要件が適切なカテゴリに分類されているか確認
- [ ] 各業務要件の「関連機能」が実際のクラス名/モジュール名と一致しているか確認
- [ ] 優先度（高/中/低）の設定が妥当か確認
- [ ] △ステータスの5件（BR-056, BR-079, BR-086, BR-088, BR-089）について追加調査の必要性を判断
- [ ] three.jsの最新バージョン（v0.182.0）の機能が網羅されているか確認
- [ ] アドオン機能（examples/jsm/）の業務要件が適切に抽出されているか確認
- [ ] WebGPU関連機能（BR-002, BR-085, BR-086）の実験的機能フラグの妥当性を確認
