# 機能設計書 105-MaterialLoader

## 概要

本ドキュメントは、Three.jsライブラリにおけるマテリアル定義読み込み機能「MaterialLoader」の設計について記述する。MaterialLoaderは、JSON形式でシリアライズされたマテリアル定義を読み込み、対応するMaterialインスタンスを生成するローダークラスである。

### 本機能の処理概要

**業務上の目的・背景**：3Dグラフィックスにおいて、マテリアル（材質）はオブジェクトの見た目を決定する重要な要素である。MaterialLoaderは、事前に定義されたマテリアル設定をJSON形式から復元することで、マテリアルの再利用やエディター連携を可能にする。ObjectLoaderの内部でも使用される重要なコンポーネントである。

**機能の利用シーン**：
- マテリアルプリセットの読み込み
- ObjectLoaderによるシーン復元時のマテリアル生成
- マテリアルのインポート/エクスポート
- マテリアルライブラリからの動的読み込み

**主要な処理内容**：
1. FileLoaderを使用してJSONファイルを読み込み
2. json.typeからマテリアルタイプを判定し、対応するクラスをインスタンス化
3. 基本プロパティ（color, opacity, roughness等）の復元
4. テクスチャマップ参照の解決（map, normalMap, envMap等）
5. ShaderMaterial用のuniforms復元
6. 完成したマテリアルの返却

**関連システム・外部連携**：
- FileLoader: JSONファイルの読み込み
- ObjectLoader: マテリアル復元時に使用
- Texture: テクスチャ参照の解決

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する画面なし |

## 機能種別

データ読み込み / マテリアルローダー / オブジェクト復元

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | string | Yes | 読み込むJSONファイルのパス/URL | なし |
| onLoad | function(Material) | No | 読み込み完了時のコールバック | なし |
| onProgress | function | No | 進捗コールバック | なし |
| onError | function | No | エラー発生時のコールバック | なし |
| manager | LoadingManager | No | ローディングマネージャー | なし |

### 入力データソース

**マテリアルJSON形式**
```json
{
  "type": "MeshStandardMaterial",
  "uuid": "xxx-xxx-xxx",
  "name": "MyMaterial",
  "color": 16777215,
  "roughness": 0.5,
  "metalness": 0.0,
  "map": "texture-uuid",
  "normalMap": "normalmap-uuid",
  ...
}
```

### サポートするマテリアルタイプ

- ShadowMaterial
- SpriteMaterial
- RawShaderMaterial
- ShaderMaterial
- PointsMaterial
- MeshPhysicalMaterial
- MeshStandardMaterial
- MeshPhongMaterial
- MeshToonMaterial
- MeshNormalMaterial
- MeshLambertMaterial
- MeshDepthMaterial
- MeshDistanceMaterial
- MeshBasicMaterial
- MeshMatcapMaterial
- LineDashedMaterial
- LineBasicMaterial
- Material

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| material | Material | パースされたマテリアルインスタンス |

### 出力先

- onLoadコールバック関数への引数として渡される
- parse()メソッドの戻り値として返却

## 処理フロー

### 処理シーケンス

```
1. load()メソッド呼び出し
2. FileLoader.load()でJSONファイル取得
3. JSON.parse()でオブジェクトに変換
4. parse()メソッド呼び出し
   ├─ createMaterialFromType(json.type)でマテリアル生成
   ├─ 基本プロパティの設定（color, opacity等）
   ├─ PBRプロパティの設定（roughness, metalness等）
   ├─ ShaderMaterial用uniformsの復元
   └─ テクスチャマップの参照解決
5. onLoadコールバック実行
```

### フローチャート

```mermaid
flowchart TD
    A[load開始] --> B[FileLoader.load]
    B --> C[JSON.parse]
    C --> D[createMaterialFromType]
    D --> E[基本プロパティ設定]
    E --> F[PBRプロパティ設定]
    F --> G{ShaderMaterial?}
    G -->|Yes| H[uniforms復元]
    G -->|No| I[テクスチャマップ解決]
    H --> I
    I --> J[material返却]
    J --> K[onLoad実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-105-1 | テクスチャ事前設定 | テクスチャはsetTextures()で事前に設定が必要 | テクスチャを使用する場合 |
| BR-105-2 | 型別インスタンス化 | json.typeに対応するマテリアルクラスをインスタンス化 | 常時 |
| BR-105-3 | プロパティ条件付き設定 | プロパティはJSONに存在する場合のみ設定 | 常時 |
| BR-105-4 | Color変換 | 色値は整数（Hex）からColorオブジェクトに変換 | color, emissive, specular等 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | JSON解析エラー | 不正なJSONファイル | onErrorコールバック実行 |
| - | テクスチャ未定義 | テクスチャUUIDが見つからない | warnログ出力、undefined返却 |
| - | 未知のマテリアルタイプ | materialLib[type]が未定義 | エラー発生 |

### リトライ仕様

自動リトライ機能なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特になし

## セキュリティ考慮事項

- 外部JSONファイルの内容検証は行わない
- NodeMaterialはセキュリティ上の理由で非サポート（NodeMaterialLoaderを使用）

## 備考

- NodeMaterialは本ローダーではサポートされない（NodeMaterialLoaderを使用）
- テクスチャはJSONに埋め込まれず、setTextures()で事前に設定が必要
- uniformsのtype識別子: 't'=Texture, 'c'=Color, 'v2'=Vector2, 'v3'=Vector3, 'v4'=Vector4, 'm3'=Matrix3, 'm4'=Matrix4

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: マテリアルタイプの一覧を理解する

MaterialLoaderがサポートするマテリアルタイプを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | MaterialLoader.js | `src/loaders/MaterialLoader.js` | 10-28行目: インポートされるマテリアルクラス |

**読解のコツ**: materialLibオブジェクト（412-431行目）にサポートされる全マテリアルタイプが定義されている。

#### Step 2: ファイル読み込みフローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MaterialLoader.js | `src/loaders/MaterialLoader.js` | 71-103行目: load()メソッド |

**主要処理フロー**:
- **75-78行目**: FileLoaderの設定
- **79-101行目**: 読み込みと parse() 呼び出し
- **83行目**: JSON.parse後にparse()実行

#### Step 3: プロパティ復元処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | MaterialLoader.js | `src/loaders/MaterialLoader.js` | 111-375行目: parse()メソッド |

**主要処理フロー**:
- **127行目**: createMaterialFromType(json.type) - マテリアル生成
- **129-212行目**: 基本プロパティ設定
- **230-275行目**: ShaderMaterial用uniformsの復元
- **302-371行目**: テクスチャマップの参照解決

#### Step 4: テクスチャ参照の解決を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | MaterialLoader.js | `src/loaders/MaterialLoader.js` | 115-125行目: getTexture関数 |

**主要処理フロー**:
- **59行目**: this.textures = {} - テクスチャ辞書
- **384-388行目**: setTextures() - テクスチャ事前設定
- **115-125行目**: getTexture()でUUIDからテクスチャ取得

### プログラム呼び出し階層図

```
MaterialLoader.load(url, onLoad, onProgress, onError)
    │
    ├─ FileLoader.load(url)
    │      └─ JSON.parse(text)
    │
    └─ parse(json)
           │
           ├─ createMaterialFromType(json.type)
           │      └─ new materialLib[type]()
           │
           ├─ 基本プロパティ設定
           │      ├─ material.uuid = json.uuid
           │      ├─ material.name = json.name
           │      ├─ material.color.setHex(json.color)
           │      ├─ material.roughness = json.roughness
           │      ├─ material.metalness = json.metalness
           │      └─ ... (約80種のプロパティ)
           │
           ├─ uniformsの復元（ShaderMaterial）
           │      └─ type別のオブジェクト生成
           │
           └─ テクスチャマップ解決
                  ├─ material.map = getTexture(json.map)
                  ├─ material.normalMap = getTexture(json.normalMap)
                  └─ ... (約20種のマップ)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JSON File ──▶ FileLoader ──▶ JSON Object
                                   │
                                   ▼
               ┌──────────────────────────────────┐
               │         parse(json)               │
               │   ┌─────────────────────────┐    │
setTextures ──▶│   │ createMaterialFromType  │    │
               │   └───────────┬─────────────┘    │
               │               ▼                   │
               │   ┌─────────────────────────┐    │
               │   │   プロパティ設定        │──▶ Material
               │   │   テクスチャ解決        │    │
               │   └─────────────────────────┘    │
               └──────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MaterialLoader.js | `src/loaders/MaterialLoader.js` | ソース | マテリアルローダー本体（440行） |
| FileLoader.js | `src/loaders/FileLoader.js` | ソース | JSONファイル取得 |
| Loader.js | `src/loaders/Loader.js` | ソース | ローダー基底クラス |
| Materials.js | `src/materials/Materials.js` | ソース | マテリアルクラス集約 |
| MeshStandardMaterial.js | `src/materials/MeshStandardMaterial.js` | ソース | PBRマテリアル |
| ShaderMaterial.js | `src/materials/ShaderMaterial.js` | ソース | カスタムシェーダー |
