# 機能設計書 107-AnimationLoader

## 概要

本ドキュメントは、Three.jsライブラリにおけるアニメーションクリップ読み込み機能「AnimationLoader」の設計について記述する。AnimationLoaderは、JSON形式でシリアライズされたアニメーションクリップ配列を読み込み、AnimationClipインスタンスの配列として復元するローダークラスである。

### 本機能の処理概要

**業務上の目的・背景**：3Dアニメーションにおいて、キーフレームデータを含むアニメーションクリップは事前に作成・保存されることが多い。AnimationLoaderは、これらのアニメーションデータをJSON形式から復元することで、アニメーションの再利用やランタイムでの動的読み込みを可能にする。

**機能の利用シーン**：
- 外部作成されたアニメーションデータの読み込み
- アニメーションライブラリからの動的読み込み
- ゲームやアプリケーションでのアニメーションプリロード
- 複数のアニメーションクリップの一括読み込み

**主要な処理内容**：
1. FileLoaderを使用してJSONファイルを読み込み
2. JSON配列の各要素をAnimationClip.parse()で変換
3. AnimationClip配列として返却

**関連システム・外部連携**：
- FileLoader: JSONファイルの読み込み
- AnimationClip: 出力されるアニメーションクリップクラス
- AnimationMixer: クリップを再生するミキサー
- LoadingManager: 読み込み進捗管理

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する画面なし |

## 機能種別

データ読み込み / アニメーションローダー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| url | string | Yes | 読み込むJSONファイルのパス/URL | なし |
| onLoad | function(Array<AnimationClip>) | No | 読み込み完了時のコールバック | なし |
| onProgress | function | No | 進捗コールバック | なし |
| onError | function | No | エラー発生時のコールバック | なし |
| manager | LoadingManager | No | ローディングマネージャー | なし |

### 入力データソース

**アニメーションJSON形式（配列）**
```json
[
  {
    "name": "walk",
    "duration": 2.0,
    "tracks": [
      {
        "name": ".bones[hip].position",
        "type": "vector",
        "times": [0, 0.5, 1.0, 1.5, 2.0],
        "values": [0,0,0, 0,0.1,0, ...]
      }
    ]
  },
  {
    "name": "run",
    ...
  }
]
```

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| animations | Array<AnimationClip> | パースされたアニメーションクリップの配列 |

### 出力先

- onLoadコールバック関数への引数として渡される
- parse()メソッドの戻り値として返却

## 処理フロー

### 処理シーケンス

```
1. load()メソッド呼び出し
2. FileLoader.load()でJSONファイル取得
3. JSON.parse()でオブジェクト配列に変換
4. parse()メソッド呼び出し
   └─ 配列の各要素に対してAnimationClip.parse()を実行
5. AnimationClip配列をonLoadコールバックに渡す
```

### フローチャート

```mermaid
flowchart TD
    A[load開始] --> B[FileLoader.load]
    B --> C[JSON.parse]
    C --> D[parse開始]
    D --> E[for each json item]
    E --> F[AnimationClip.parse]
    F --> G[animations配列に追加]
    G --> H{全要素処理完了?}
    H -->|No| E
    H -->|Yes| I[animations返却]
    I --> J[onLoad実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-1 | 配列入力 | JSONは配列形式で複数のクリップを含む | 常時 |
| BR-107-2 | 委譲パース | 各クリップのパースはAnimationClip.parse()に委譲 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | JSON解析エラー | 不正なJSONファイル | onErrorコールバック実行 |
| - | パースエラー | AnimationClip.parse()でエラー | onErrorコールバック実行、manager.itemError() |

### リトライ仕様

自動リトライ機能なし

## トランザクション仕様

該当なし

## パフォーマンス要件

特になし

## セキュリティ考慮事項

特になし

## 備考

- 本ローダーは配列形式のJSONを期待する
- 単一のアニメーションでも配列として格納する必要がある
- AnimationClip.parse()の詳細はAnimationClipクラスを参照

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: AnimationClipの構造を理解する

AnimationLoaderが出力するAnimationClipの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AnimationClip.js | `src/animation/AnimationClip.js` | name, duration, tracks, blendModeの構造 |

#### Step 2: ファイル読み込みフローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AnimationLoader.js | `src/loaders/AnimationLoader.js` | 39-71行目: load()メソッド |

**主要処理フロー**:
- **43-46行目**: FileLoaderの設定
- **47-69行目**: 読み込みとparse()呼び出し

#### Step 3: パース処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AnimationLoader.js | `src/loaders/AnimationLoader.js` | 79-93行目: parse()メソッド |

**主要処理フロー**:
- **81行目**: 空の配列を作成
- **83-87行目**: 各要素に対してAnimationClip.parse()を実行
- **91行目**: 配列を返却

### プログラム呼び出し階層図

```
AnimationLoader.load(url, onLoad, onProgress, onError)
    │
    ├─ FileLoader.load(url)
    │      └─ JSON.parse(text)
    │
    └─ parse(json)
           │
           └─ for each (item in json)
                  │
                  └─ AnimationClip.parse(item)
                         │
                         └─ new AnimationClip(name, duration, tracks)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

JSON File ──▶ FileLoader ──▶ JSON Array
                                   │
                                   ▼
                            parse(json)
                                   │
                    ┌──────────────┼──────────────┐
                    │              │              │
                    ▼              ▼              ▼
           AnimationClip.parse  AnimationClip.parse  ...
                    │              │              │
                    └──────────────┼──────────────┘
                                   ▼
                         Array<AnimationClip>
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AnimationLoader.js | `src/loaders/AnimationLoader.js` | ソース | アニメーションローダー本体（99行） |
| FileLoader.js | `src/loaders/FileLoader.js` | ソース | JSONファイル取得 |
| AnimationClip.js | `src/animation/AnimationClip.js` | ソース | アニメーションクリップクラス |
| KeyframeTrack.js | `src/animation/KeyframeTrack.js` | ソース | キーフレームトラック |
| Loader.js | `src/loaders/Loader.js` | ソース | ローダー基底クラス |
