# 機能設計書 13-WebGLRenderer

## 概要

本ドキュメントは、Three.jsライブラリにおけるWebGLRenderer機能の設計を詳細に記述するものである。WebGLRendererは、WebGL 2 APIを使用して3Dシーンをリアルタイムでレンダリングするための中核的なレンダリングエンジンである。

### 本機能の処理概要

WebGLRendererクラスは、Three.jsにおける主要なレンダリングエンジンであり、シーングラフを解析してWebGL 2 APIを通じてGPUに描画命令を送信する。カメラの視点からシーンを描画し、HTML5 Canvasに最終的な画像を出力する。

**業務上の目的・背景**：Webブラウザ上で高性能な3Dグラフィックスを実現するためには、GPUを活用した効率的なレンダリングが不可欠である。WebGLRendererは、WebGL 2 APIの複雑な低レベル操作を抽象化し、開発者が3Dアプリケーションを容易に構築できるようにする。r163以降、WebGL 1のサポートは廃止され、WebGL 2専用となっている。

**機能の利用シーン**：3Dエディタ、ゲーム、データビジュアライゼーション、AR/VRアプリケーション、製品コンフィギュレータ、建築ビジュアライゼーションなど、ブラウザ上で3Dコンテンツを表示するあらゆるシーンで使用される。

**主要な処理内容**：
1. WebGL 2コンテキストの初期化と管理
2. シーングラフのトラバースとレンダリングリストの構築
3. シェーダープログラムのコンパイルと管理
4. マテリアル・ジオメトリ・テクスチャのGPU転送
5. シャドウマップの生成とシャドウレンダリング
6. ポストプロセシングエフェクトの適用
7. レンダーターゲットへのオフスクリーンレンダリング
8. VR/AR（WebXR）対応

**関連システム・外部連携**：WebGL 2 API、WebXR Device API、HTML5 Canvas、各種ローダー（glTF、OBJ等）からのモデルデータを処理。

**権限による制御**：特になし。ただしWebXR使用時はユーザーの明示的な許可が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタメイン画面 | 主機能 | 3Dシーンのレンダリング処理を担当 |
| 2 | Viewport | 主機能 | 3Dシーンのプレビューレンダリング |
| 8 | Sidebar - Project | 主機能 | レンダラー設定の管理 |
| 13 | Menubar - Render | 主機能 | 静止画・動画レンダリング |
| 18 | Player | 主機能 | プレビュー再生時のレンダリング |
| 21 | WebGL基本サンプル | 主機能 | WebGLを使用した3Dレンダリング |
| 22 | WebGLポストプロセシング | 補助機能 | ベースレンダリング |
| 39 | スタンドアロンアプリ | 主機能 | エクスポートアプリのレンダリング |

## 機能種別

レンダリング処理 / GPU描画

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| canvas | HTMLCanvasElement/OffscreenCanvas | No | 描画先キャンバス（未指定時は自動生成） | - |
| context | WebGL2RenderingContext | No | 既存のWebGLコンテキスト | WebGL 2のみ |
| depth | boolean | No | 深度バッファの有効化 | デフォルト: true |
| stencil | boolean | No | ステンシルバッファの有効化 | デフォルト: false |
| alpha | boolean | No | アルファチャンネルの有効化 | デフォルト: false |
| antialias | boolean | No | アンチエイリアスの有効化 | デフォルト: false |
| premultipliedAlpha | boolean | No | 事前乗算アルファ | デフォルト: true |
| preserveDrawingBuffer | boolean | No | 描画バッファの保持 | デフォルト: false |
| powerPreference | string | No | GPU電力設定 | 'default'/'high-performance'/'low-power' |
| failIfMajorPerformanceCaveat | boolean | No | パフォーマンス問題時に失敗 | デフォルト: false |
| reversedDepthBuffer | boolean | No | 逆深度バッファ | デフォルト: false |
| outputBufferType | number | No | 出力バッファの型 | デフォルト: UnsignedByteType |

### 入力データソース

- Scene: レンダリング対象のシーングラフ
- Camera: 視点を定義するカメラオブジェクト
- RenderTarget: オフスクリーンレンダリング先（オプション）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| domElement | HTMLCanvasElement | レンダリング結果が描画されるキャンバス |
| info | Object | レンダリング統計情報（メモリ使用量、描画コール数等） |
| capabilities | Object | WebGLコンテキストの機能情報 |

### 出力先

- HTML5 Canvas（画面表示）
- WebGLRenderTarget（オフスクリーン）

## 処理フロー

### 処理シーケンス

```
1. WebGLRendererインスタンスの生成
   └─ WebGL 2コンテキスト取得、各サブシステム初期化

2. レンダリングループ
   ├─ setSize(): キャンバスサイズ設定
   ├─ setRenderTarget(): レンダー先設定（オプション）
   ├─ clear(): バッファクリア（autoClear時は自動）
   └─ render(scene, camera): シーン描画
       ├─ シーングラフのトラバース
       ├─ レンダリングリストの構築
       ├─ 不透明オブジェクトのソート（前から後ろ）
       ├─ 透明オブジェクトのソート（後ろから前）
       ├─ シャドウマップ生成
       └─ 各オブジェクトの描画

3. リソース管理
   ├─ dispose(): リソース解放
   └─ forceContextLoss(): コンテキスト強制解放
```

### フローチャート

```mermaid
flowchart TD
    A[WebGLRenderer生成] --> B[WebGL 2コンテキスト取得]
    B --> C[サブシステム初期化]
    C --> D{render呼び出し?}
    D -->|Yes| E[シーングラフ走査]
    E --> F[レンダリングリスト構築]
    F --> G{シャドウ有効?}
    G -->|Yes| H[シャドウマップ生成]
    G -->|No| I[不透明オブジェクト描画]
    H --> I
    I --> J[透明オブジェクト描画]
    J --> K{ポストプロセス?}
    K -->|Yes| L[エフェクト適用]
    K -->|No| M[フレーム完了]
    L --> M
    M --> D
    D -->|No| N{dispose?}
    N -->|Yes| O[リソース解放]
    N -->|No| D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | WebGL 2必須 | WebGL 1はサポート外（r163以降） | コンテキスト生成時 |
| BR-02 | 自動クリア | autoClear=true時、render前にバッファクリア | render()呼び出し時 |
| BR-03 | ソート順序 | 不透明は前から後ろ、透明は後ろから前にソート | レンダリングリスト構築時 |
| BR-04 | ピクセル比 | setPixelRatio()でデバイスピクセル比に対応 | サイズ設定時 |
| BR-05 | 色空間変換 | outputColorSpaceに基づき色空間変換 | 最終出力時 |

### 計算ロジック

- 描画バッファサイズ = 論理サイズ × ピクセル比
- ビューポート座標 = 論理座標 × ピクセル比

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | WebGL未対応 | ブラウザがWebGL 2をサポートしない | フォールバックまたはエラー表示 |
| - | コンテキスト喪失 | GPUリソース不足等 | webglcontextlostイベントで復旧処理 |
| - | シェーダーコンパイルエラー | 不正なシェーダーコード | debug.checkShaderErrorsで検出 |

### リトライ仕様

- webglcontextrestoredイベントでコンテキスト復旧後に再初期化

## トランザクション仕様

該当なし

## パフォーマンス要件

- フレームレート: 60fps（VR時は90fps）を目標
- 描画コール数の最小化（インスタンシング、バッチング活用）
- テクスチャ・ジオメトリのGPUキャッシュ活用
- オクルージョンカリング、視錐台カリングによる描画対象削減

## セキュリティ考慮事項

- WebGL APIはブラウザサンドボックス内で動作
- クロスオリジンテクスチャはCORS設定が必要
- preserveDrawingBuffer=trueでスクリーンショット取得可能

## 備考

- WebGPURendererが将来の推奨レンダラー
- XRセッション中はVRデバイスへの直接レンダリング
- info.autoResetで統計情報の自動リセットを制御可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WebGLRendererの構造とその依存関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | クラス定義と主要プロパティ |
| 1-2 | WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | オフスクリーンレンダリング用 |
| 1-3 | constants.js | `src/constants.js` | レンダリング関連定数 |

**読解のコツ**: WebGLRendererは多くのサブシステム（WebGLState, WebGLTextures, WebGLPrograms等）で構成されている。まずは公開APIを理解し、その後内部サブシステムを読み解くと効率的。

#### Step 2: エントリーポイントを理解する

WebGLRendererの初期化と主要APIを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | コンストラクタと公開メソッド |

**主要処理フロー**:
1. **71-86行目**: コンストラクタでパラメータ展開（canvas, context, depth, stencil, alpha等）
2. **95行目**: isWebGLRendererフラグ設定
3. **159行目**: domElementプロパティ（描画先キャンバス）
4. **176-188行目**: debugオブジェクト（シェーダーエラーチェック設定）
5. **198-225行目**: autoClear関連プロパティ
6. **241行目**: sortObjectsプロパティ
7. **250-259行目**: clippingPlanesとlocalClippingEnabled
8. **269-277行目**: toneMapping関連プロパティ
9. **423-540行目**: initGLContext()でサブシステム初期化
10. **552-559行目**: WebXRManager初期化
11. **650-680行目**: setSize()でキャンバスサイズ設定
12. **787-801行目**: setViewport()でビューポート設定

#### Step 3: render()メソッドを理解する

メインのレンダリングループを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | render()メソッド |
| 3-2 | WebGLRenderLists.js | `src/renderers/webgl/WebGLRenderLists.js` | レンダリングリスト管理 |
| 3-3 | WebGLShadowMap.js | `src/renderers/webgl/WebGLShadowMap.js` | シャドウマップ生成 |

**主要処理フロー**:
- render()でシーンとカメラを受け取り、描画を実行
- projectObject()でシーングラフをトラバース
- renderObjects()で実際の描画コマンド発行

### プログラム呼び出し階層図

```
WebGLRenderer.render(scene, camera)
    │
    ├─ updateMatrixWorld() ──────▶ シーングラフ行列更新
    │
    ├─ projectObject() ──────────▶ レンダリングリスト構築
    │       │
    │       └─ WebGLRenderLists ─▶ 不透明・透明リスト
    │
    ├─ WebGLShadowMap.render() ──▶ シャドウマップ生成
    │
    ├─ WebGLBackground.render() ─▶ 背景描画
    │
    ├─ renderObjects(opaqueObjects) ──▶ 不透明オブジェクト描画
    │       │
    │       └─ renderObject() ───▶ 個別オブジェクト描画
    │               │
    │               ├─ WebGLPrograms.getProgram() ──▶ シェーダープログラム取得
    │               │
    │               ├─ WebGLUniforms.update() ──────▶ ユニフォーム更新
    │               │
    │               └─ gl.drawElements/drawArrays() ▶ 描画コマンド発行
    │
    └─ renderObjects(transparentObjects) ▶ 透明オブジェクト描画
```

### データフロー図

```
[入力]                        [処理]                            [出力]

Scene (シーングラフ)
    │
    ▼
Object3D.updateMatrixWorld() ────────────────────────────────▶ ワールド行列
    │
    ▼
projectObject() ─────────────▶ WebGLRenderLists ─────────────▶ レンダリングリスト
    │
    ▼
Camera.projectionMatrix ─────────────────────────────────────▶ プロジェクション行列
    │
    ▼
WebGLPrograms ───────────────▶ シェーダーコンパイル ─────────▶ WebGLProgram
    │
    ▼
WebGLTextures ───────────────▶ テクスチャアップロード ───────▶ WebGLTexture
    │
    ▼
WebGLGeometries ─────────────▶ バッファアップロード ─────────▶ WebGLBuffer
    │
    ▼
gl.drawElements/drawArrays() ────────────────────────────────▶ Canvas/RenderTarget
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | ソース | メインレンダラークラス |
| WebGLState.js | `src/renderers/webgl/WebGLState.js` | ソース | WebGL状態管理 |
| WebGLPrograms.js | `src/renderers/webgl/WebGLPrograms.js` | ソース | シェーダープログラム管理 |
| WebGLTextures.js | `src/renderers/webgl/WebGLTextures.js` | ソース | テクスチャ管理 |
| WebGLGeometries.js | `src/renderers/webgl/WebGLGeometries.js` | ソース | ジオメトリバッファ管理 |
| WebGLAttributes.js | `src/renderers/webgl/WebGLAttributes.js` | ソース | 頂点属性管理 |
| WebGLRenderLists.js | `src/renderers/webgl/WebGLRenderLists.js` | ソース | レンダリングリスト管理 |
| WebGLRenderStates.js | `src/renderers/webgl/WebGLRenderStates.js` | ソース | レンダリング状態管理 |
| WebGLShadowMap.js | `src/renderers/webgl/WebGLShadowMap.js` | ソース | シャドウマップ生成 |
| WebGLBackground.js | `src/renderers/webgl/WebGLBackground.js` | ソース | 背景描画 |
| WebGLCapabilities.js | `src/renderers/webgl/WebGLCapabilities.js` | ソース | WebGL機能検出 |
| WebGLExtensions.js | `src/renderers/webgl/WebGLExtensions.js` | ソース | 拡張機能管理 |
| WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | ソース | WebXR対応 |
| WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | ソース | オフスクリーンレンダリング |
