# 機能設計書 15-WebGLRenderTarget

## 概要

本ドキュメントは、Three.jsライブラリにおけるWebGLRenderTarget機能の設計を詳細に記述するものである。WebGLRenderTargetは、WebGLコンテキストでオフスクリーンレンダリングを行うためのフレームバッファオブジェクト（FBO）を抽象化したクラスである。

### 本機能の処理概要

WebGLRenderTargetクラスは、レンダリング結果を画面ではなくテクスチャに書き込むためのレンダーターゲットを提供する。これにより、ポストプロセッシングエフェクト、シャドウマッピング、リフレクション、ピッキングなど、様々な高度なレンダリング技術を実装できる。

**業務上の目的・背景**：現代の3Dグラフィックスでは、最終画像を生成するまでに複数のレンダリングパスが必要になることが多い。シャドウマップ、環境マップ、ポストプロセッシングなどは、すべてオフスクリーンレンダリングに依存している。WebGLRenderTargetは、このオフスクリーンレンダリングを簡潔に行うためのインターフェースを提供し、複雑なマルチパスレンダリングを可能にする。

**機能の利用シーン**：ポストプロセッシングエフェクト（ブルーム、被写界深度、SSAO等）、シャドウマッピング、環境マップの動的生成、ピッキング（オブジェクト選択）、マルチレンダーターゲット（MRT）、デファードレンダリングなど。

**主要な処理内容**：
1. オフスクリーンレンダリング用フレームバッファの管理
2. カラーアタッチメントテクスチャの管理
3. 深度・ステンシルバッファの管理
4. マルチサンプリング（MSAA）のサポート
5. サイズ変更時のリソース再作成
6. 複数カラーアタッチメント（MRT）のサポート

**関連システム・外部連携**：WebGLRenderer、RenderTarget基底クラス、Texture、DepthTexture。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | WebGLポストプロセシング | 補助機能 | オフスクリーンレンダリング |

## 機能種別

レンダリングリソース管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| width | number | No | レンダーターゲットの幅 | デフォルト: 1 |
| height | number | No | レンダーターゲットの高さ | デフォルト: 1 |
| options.generateMipmaps | boolean | No | ミップマップ生成 | デフォルト: false |
| options.minFilter | number | No | 縮小フィルター | デフォルト: LinearFilter |
| options.magFilter | number | No | 拡大フィルター | デフォルト: LinearFilter |
| options.format | number | No | テクスチャフォーマット | デフォルト: RGBAFormat |
| options.type | number | No | テクスチャタイプ | デフォルト: UnsignedByteType |
| options.depthBuffer | boolean | No | 深度バッファの有効化 | デフォルト: true |
| options.stencilBuffer | boolean | No | ステンシルバッファの有効化 | デフォルト: false |
| options.depthTexture | DepthTexture | No | 深度テクスチャ | デフォルト: null |
| options.samples | number | No | MSAAサンプル数 | デフォルト: 0 |
| options.count | number | No | カラーアタッチメント数 | デフォルト: 1 |

### 入力データソース

- プログラムから直接パラメータ指定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| texture | Texture | カラーアタッチメントテクスチャ |
| textures | Array&lt;Texture&gt; | 全カラーアタッチメント配列 |
| depthTexture | DepthTexture | 深度テクスチャ（オプション） |
| width | number | ターゲット幅 |
| height | number | ターゲット高さ |

### 出力先

- WebGLレンダラーで使用（setRenderTarget()）

## 処理フロー

### 処理シーケンス

```
1. WebGLRenderTargetインスタンスの生成
   └─ RenderTarget基底クラス継承、isWebGLRenderTargetフラグ設定

2. レンダラーでの使用
   ├─ renderer.setRenderTarget(target): ターゲットをバインド
   ├─ renderer.render(scene, camera): オフスクリーン描画
   └─ renderer.setRenderTarget(null): デフォルトに戻す

3. テクスチャとしての使用
   └─ target.textureをマテリアルのmapなどに設定

4. サイズ変更
   └─ setSize()でリソース再作成（dispose発行）

5. リソース解放
   └─ dispose()でGPUリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[WebGLRenderTarget生成] --> B[RenderTarget継承初期化]
    B --> C[isWebGLRenderTargetフラグ設定]
    C --> D{レンダラーで使用?}
    D -->|Yes| E[setRenderTarget: ターゲットバインド]
    E --> F[render: オフスクリーン描画]
    F --> G[setRenderTarget(null): 解除]
    G --> H{テクスチャ使用?}
    D -->|No| H
    H -->|Yes| I[texture/texturesをマテリアルに設定]
    I --> J{サイズ変更?}
    H -->|No| J
    J -->|Yes| K[setSize: リソース再作成]
    K --> D
    J -->|No| L{dispose?}
    L -->|Yes| M[リソース解放]
    L -->|No| D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | RenderTarget継承 | RenderTargetクラスを継承 | クラス定義 |
| BR-02 | タイプフラグ | isWebGLRenderTarget=trueを設定 | インスタンス生成時 |
| BR-03 | デフォルトフィルター | minFilter/magFilterのデフォルトはLinearFilter | オプション未指定時 |
| BR-04 | サイズ変更時dispose | setSize()でサイズ変更時はdisposeイベント発行 | サイズ変更時 |
| BR-05 | MRT対応 | countオプションで複数カラーアタッチメント | count > 1時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | WebGL制限 | サポートされていないフォーマット/タイプ | capabilities確認 |
| - | MRT制限 | カラーアタッチメント数超過 | 最大数を確認 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 不要になったレンダーターゲットは速やかにdispose()
- 同一サイズのターゲットは再利用を推奨
- MSAAサンプル数は必要最小限に

## セキュリティ考慮事項

- フレームバッファ内容はWebGL APIを介してのみアクセス可能
- クロスオリジン制限はテクスチャソースに依存

## 備考

- WebGLCubeRenderTargetはキューブマップ用の派生クラス
- WebGPURenderer使用時はRenderTargetを直接使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WebGLRenderTargetの構造とその依存関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | クラス定義と継承 |
| 1-2 | RenderTarget.js | `src/core/RenderTarget.js` | 基底クラスの全機能 |
| 1-3 | Texture.js | `src/textures/Texture.js` | カラーアタッチメント |
| 1-4 | DepthTexture.js | `src/textures/DepthTexture.js` | 深度テクスチャ |

**読解のコツ**: WebGLRenderTargetは非常にシンプルなクラスで、ほとんどの機能はRenderTarget基底クラスに実装されている。まずRenderTargetを理解することが重要。

#### Step 2: エントリーポイントを理解する

WebGLRenderTargetの初期化を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | コンストラクタ |

**主要処理フロー**:
1. **17行目**: コンストラクタでwidth, height, optionsを受け取る
2. **19行目**: super()でRenderTarget基底クラスを初期化
3. **28行目**: isWebGLRenderTargetフラグをtrueに設定

#### Step 3: RenderTarget基底クラスを理解する

全機能の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RenderTarget.js | `src/core/RenderTarget.js` | 基底クラス全体 |

**主要処理フロー**:
1. **49-66行目**: コンストラクタでオプションをマージしデフォルト値設定
2. **75行目**: isRenderTargetフラグ設定
3. **82-91行目**: width, height, depthプロパティ
4. **108-117行目**: scissor, scissorTest, viewportプロパティ
5. **127-146行目**: texturesプロパティ（カラーアタッチメント配列）
6. **156-180行目**: depthBuffer, stencilBuffer関連プロパティ
7. **242-252行目**: textureゲッター/セッター
8. **254-275行目**: depthTextureゲッター/セッター
9. **284-316行目**: setSize()メソッド
10. **324-328行目**: clone()メソッド
11. **338-376行目**: copy()メソッド
12. **384-388行目**: dispose()メソッド

### プログラム呼び出し階層図

```
WebGLRenderTarget
    │
    └─ extends RenderTarget
            │
            ├─ constructor()
            │       │
            │       ├─ width, height設定
            │       │
            │       ├─ textures[]作成
            │       │
            │       └─ depthBuffer/stencilBuffer設定
            │
            ├─ setSize()
            │       │
            │       ├─ width, height更新
            │       │
            │       └─ dispose()発行
            │
            ├─ clone() ────────▶ 新インスタンス作成
            │
            ├─ copy() ─────────▶ プロパティコピー
            │
            └─ dispose() ──────▶ disposeイベント発行
```

### データフロー図

```
[入力]                        [処理]                            [出力]

width, height, options
    │
    ▼
WebGLRenderTarget() ─────────▶ RenderTarget初期化 ───────────▶ textures[]
    │                                                          depthTexture
    │
    ▼
renderer.setRenderTarget(rt) ▶ WebGLTextures.setupRenderTarget() ▶ WebGLFramebuffer
    │
    ▼
renderer.render() ───────────▶ オフスクリーン描画 ────────────▶ textureにレンダリング結果
    │
    ▼
material.map = rt.texture ───▶ シェーダーでサンプリング ──────▶ 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | ソース | WebGL用レンダーターゲット |
| RenderTarget.js | `src/core/RenderTarget.js` | ソース | 基底クラス |
| Texture.js | `src/textures/Texture.js` | ソース | カラーアタッチメント |
| DepthTexture.js | `src/textures/DepthTexture.js` | ソース | 深度テクスチャ |
| EventDispatcher.js | `src/core/EventDispatcher.js` | ソース | イベント機構（RenderTargetが継承） |
| WebGLTextures.js | `src/renderers/webgl/WebGLTextures.js` | ソース | GPU側フレームバッファ管理 |
| WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | ソース | setRenderTarget()呼び出し元 |
| WebGLCubeRenderTarget.js | `src/renderers/WebGLCubeRenderTarget.js` | ソース | キューブマップ用派生クラス |
