# 機能設計書 151-AxesHelper

## 概要

本ドキュメントは、Three.jsライブラリにおけるAxesHelper機能の設計仕様を記載する。AxesHelperは3D空間の座標軸を視覚的に表示するためのヘルパーオブジェクトである。

### 本機能の処理概要

AxesHelperは、3Dシーン内でXYZ軸を色分けされた線分として描画し、開発者やユーザーが空間の方向を直感的に理解できるようにするデバッグ・開発支援機能である。

**業務上の目的・背景**：3D開発において、オブジェクトの位置や回転を調整する際、座標系の方向が視覚的に確認できないと開発効率が大幅に低下する。AxesHelperは、X軸（赤）、Y軸（緑）、Z軸（青）を明確に表示することで、開発者が空間認識を素早く行えるようにし、デバッグ作業を効率化する。

**機能の利用シーン**：
- 3Dシーンの初期構築時に座標系の確認
- オブジェクトの位置・回転調整時の参照軸として
- エディタアプリケーションにおける常時表示のガイド
- 教育目的での3D座標系の説明

**主要な処理内容**：
1. BufferGeometryを使用した6頂点（3本の線分）の生成
2. 頂点カラー属性による軸ごとの色分け（X:赤、Y:緑、Z:青）
3. LineSegmentsを継承した線分オブジェクトとしてのレンダリング
4. setColors()メソッドによる動的な色変更機能

**関連システム・外部連携**：WebGLRenderer/WebGPURendererによるレンダリングパイプラインと連携。シーングラフ構造の一部としてObject3Dの階層に組み込まれる。

**権限による制御**：本機能に権限制御はない。全てのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接的な関連なし。汎用的なヘルパーとして各種画面で利用可能 |

## 機能種別

可視化処理 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| size | number | No | 軸の長さ（デフォルト: 1） | 正の数値 |

### 入力データソース

コンストラクタ引数として直接指定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AxesHelper | LineSegments | 3軸を表す線分オブジェクト |

### 出力先

シーングラフへの追加（scene.add()）によりレンダリング対象となる。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ sizeパラメータの受け取り（デフォルト: 1）
2. 頂点データ配列の生成
   └─ 原点から各軸方向へのsize長の線分を定義
3. 頂点カラー配列の生成
   └─ X軸: 赤(1,0,0)→オレンジ(1,0.6,0)
   └─ Y軸: 緑(0,1,0)→黄緑(0.6,1,0)
   └─ Z軸: 青(0,0,1)→水色(0,0.6,1)
4. BufferGeometryの構築
   └─ position属性とcolor属性を設定
5. LineBasicMaterialの生成
   └─ vertexColors: true, toneMapped: false
6. LineSegmentsとして初期化
   └─ 親クラスのコンストラクタを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new AxesHelper] --> B[size引数受け取り]
    B --> C[頂点座標配列生成]
    C --> D[頂点カラー配列生成]
    D --> E[BufferGeometry作成]
    E --> F[position属性設定]
    F --> G[color属性設定]
    G --> H[LineBasicMaterial作成]
    H --> I[LineSegments初期化]
    I --> J[type='AxesHelper'設定]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-151-01 | 軸カラー規約 | X軸は赤系、Y軸は緑系、Z軸は青系で表示 | 常時 |
| BR-151-02 | グラデーション表現 | 各軸は原点側が濃く、先端が薄い色で表示 | 常時 |
| BR-151-03 | トーンマッピング無効 | ポストプロセスの影響を受けない | toneMapped: false |

### 計算ロジック

頂点座標は以下の6点で構成:
- (0,0,0) → (size,0,0): X軸
- (0,0,0) → (0,size,0): Y軸
- (0,0,0) → (0,0,size): Z軸

## データベース操作仕様

該当なし（本機能はデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 暗黙的エラー | sizeに無効な値を指定 | NaNまたは0の場合、軸が表示されない |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 頂点数: 6（固定）
- ドローコール: 1
- メモリ使用量: 最小限（72バイトの頂点データ + 72バイトのカラーデータ）

## セキュリティ考慮事項

該当なし（クライアントサイドの可視化機能）

## 備考

- dispose()メソッドを呼び出すことでGPUリソースを解放可能
- setColors()メソッドで動的に色を変更可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

AxesHelperはLineSegmentsを継承しており、BufferGeometryとLineBasicMaterialで構成される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BufferGeometry.js | `src/core/BufferGeometry.js` | 頂点データの管理方法 |
| 1-2 | BufferAttribute.js | `src/core/BufferAttribute.js` | Float32BufferAttributeによる属性データ |
| 1-3 | Color.js | `src/math/Color.js` | 色の表現と変換 |

**読解のコツ**: BufferGeometryは頂点属性（position, color等）をBufferAttributeとして管理する。Float32BufferAttributeは32ビット浮動小数点数の配列をGPUに転送可能な形式で保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AxesHelper.js | `src/helpers/AxesHelper.js` | 本体実装 |

**主要処理フロー**:
1. **25-31行目**: 頂点座標配列の定義（6頂点、3本の線分）
2. **33-37行目**: 頂点カラー配列の定義（グラデーション付き）
3. **39-41行目**: BufferGeometryへの属性設定
4. **43行目**: LineBasicMaterialの生成（vertexColors有効）
5. **45行目**: 親クラスLineSegmentsの初期化

#### Step 3: 親クラス構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LineSegments.js | `src/objects/LineSegments.js` | 線分描画の基底クラス |
| 3-2 | LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | 線描画用マテリアル |

**主要処理フロー**:
- **LineSegments**: GL_LINESモードで頂点ペアを線分として描画
- **vertexColors: true**: 頂点ごとに異なる色を使用

#### Step 4: setColorsメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AxesHelper.js | `src/helpers/AxesHelper.js` | 59-80行目のsetColorsメソッド |

**主要処理フロー**:
- **59-79行目**: 各軸の色を動的に変更
- **61-66行目**: X軸の色設定（開始点・終了点）
- **68-70行目**: Y軸の色設定
- **72-74行目**: Z軸の色設定
- **76行目**: needsUpdate=trueで更新をGPUに通知

### プログラム呼び出し階層図

```
AxesHelper (src/helpers/AxesHelper.js)
    │
    ├─ extends LineSegments (src/objects/LineSegments.js)
    │      └─ extends Line (src/objects/Line.js)
    │             └─ extends Object3D (src/core/Object3D.js)
    │
    ├─ uses BufferGeometry (src/core/BufferGeometry.js)
    │      └─ setAttribute() → Float32BufferAttribute
    │
    ├─ uses LineBasicMaterial (src/materials/LineBasicMaterial.js)
    │
    └─ uses Color (src/math/Color.js)
           └─ toArray() → 色データを配列に展開
```

### データフロー図

```
[入力]                     [処理]                              [出力]

size (number)      ───▶  AxesHelper Constructor      ───▶  LineSegmentsオブジェクト
                              │
                              ├─▶ 頂点座標計算
                              │     └─▶ [0,0,0]→[size,0,0] (X軸)
                              │     └─▶ [0,0,0]→[0,size,0] (Y軸)
                              │     └─▶ [0,0,0]→[0,0,size] (Z軸)
                              │
                              └─▶ 頂点カラー設定
                                    └─▶ R/G/B グラデーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AxesHelper.js | `src/helpers/AxesHelper.js` | ソース | メイン実装 |
| LineSegments.js | `src/objects/LineSegments.js` | ソース | 親クラス（線分描画） |
| Line.js | `src/objects/Line.js` | ソース | 祖父クラス（線オブジェクト） |
| Object3D.js | `src/core/Object3D.js` | ソース | 基底クラス（3Dオブジェクト） |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリデータ管理 |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点属性データ |
| LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ソース | 線描画マテリアル |
| Color.js | `src/math/Color.js` | ソース | 色管理ユーティリティ |
