# 機能設計書 152-BoxHelper

## 概要

本ドキュメントは、Three.jsライブラリにおけるBoxHelper機能の設計仕様を記載する。BoxHelperは3Dオブジェクトのワールド軸に沿った境界ボックス（AABB: Axis-Aligned Bounding Box）をワイヤーフレームで可視化するヘルパーオブジェクトである。

### 本機能の処理概要

BoxHelperは、指定されたObject3Dオブジェクト（子要素を含む）の境界を計算し、その範囲を示すワイヤーフレームボックスを描画する。オブジェクトの変形に追従して自動更新が可能なデバッグ・開発支援機能である。

**業務上の目的・背景**：3D開発において、オブジェクトの実際のサイズや境界を視覚的に確認することは、衝突判定のデバッグ、レイアウト調整、パフォーマンス最適化（カリング範囲の確認）において重要である。BoxHelperは、複雑なメッシュでも境界ボックスを明確に表示することで、開発者の空間認識を支援する。

**機能の利用シーン**：
- オブジェクト選択時の視覚的フィードバック（エディタ等）
- 衝突判定範囲のデバッグ
- オブジェクトの実サイズ確認
- シーン構成時のレイアウト調整

**主要な処理内容**：
1. 対象オブジェクトからBox3による境界ボックス計算
2. 8頂点・12辺のワイヤーフレームジオメトリ生成
3. update()メソッドによる境界の動的更新
4. setFromObject()による対象オブジェクト変更

**関連システム・外部連携**：Box3クラスと連携して境界計算を行う。WebGLRenderer/WebGPURendererによるレンダリングパイプラインと連携。

**権限による制御**：本機能に権限制御はない。全てのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | Viewport | 補助機能 | 選択オブジェクトの境界ボックス表示 |

## 機能種別

可視化処理 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| object | Object3D | No | 境界ボックスを表示する対象オブジェクト | Object3Dインスタンス |
| color | number\|Color\|string | No | ボックスの色（デフォルト: 0xffff00 黄色） | 有効なカラー値 |

### 入力データソース

コンストラクタ引数として直接指定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| BoxHelper | LineSegments | 境界ボックスを表すワイヤーフレームオブジェクト |

### 出力先

シーングラフへの追加（scene.add()）によりレンダリング対象となる。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ object, colorパラメータの受け取り
2. インデックス配列の生成
   └─ 12辺を定義する24インデックス
3. 頂点位置配列の初期化
   └─ 8頂点 × 3座標 = 24要素
4. BufferGeometryの構築
   └─ index属性とposition属性を設定
5. LineBasicMaterialの生成
   └─ 指定色、toneMapped: false
6. LineSegmentsとして初期化
7. matrixAutoUpdate = falseに設定
8. update()メソッド呼び出し
   └─ 境界ボックスの初期計算
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new BoxHelper] --> B[object, color引数受け取り]
    B --> C[インデックス配列生成]
    C --> D[頂点位置配列初期化]
    D --> E[BufferGeometry作成]
    E --> F[LineBasicMaterial作成]
    F --> G[LineSegments初期化]
    G --> H[matrixAutoUpdate = false]
    H --> I[update呼び出し]
    I --> J{objectが定義済み?}
    J -->|Yes| K[Box3.setFromObject実行]
    J -->|No| L[スキップ]
    K --> M{ボックスが空?}
    M -->|Yes| L
    M -->|No| N[8頂点座標を計算]
    N --> O[position属性を更新]
    O --> P[boundingSphere計算]
    L --> Q[終了]
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-152-01 | デフォルトカラー | 指定がない場合は黄色(0xffff00)を使用 | color未指定時 |
| BR-152-02 | 自動更新無効 | matrixAutoUpdate=falseで手動更新が必要 | 常時 |
| BR-152-03 | 空ボックス処理 | 境界が空の場合は描画をスキップ | Box3.isEmpty()がtrue |
| BR-152-04 | 子要素含む | 境界計算は対象オブジェクトの子要素も含む | setFromObject使用時 |

### 計算ロジック

境界ボックスの8頂点は以下の組み合わせ:
```
頂点0: (max.x, max.y, max.z)  頂点4: (max.x, max.y, min.z)
頂点1: (min.x, max.y, max.z)  頂点5: (min.x, max.y, min.z)
頂点2: (min.x, min.y, max.z)  頂点6: (min.x, min.y, min.z)
頂点3: (max.x, min.y, max.z)  頂点7: (max.x, min.y, min.z)
```

12辺のインデックス定義:
```
[0,1], [1,2], [2,3], [3,0]  // 前面
[4,5], [5,6], [6,7], [7,4]  // 背面
[0,4], [1,5], [2,6], [3,7]  // 側面
```

## データベース操作仕様

該当なし（本機能はデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 暗黙的処理 | objectがundefined | 空の表示（何も描画されない） |
| - | 暗黙的処理 | objectにジオメトリがない | 空のボックス（スプライト等） |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 頂点数: 8（固定）
- インデックス数: 24（固定）
- ドローコール: 1
- update()はオブジェクト変形時に手動呼び出しが必要

## セキュリティ考慮事項

該当なし（クライアントサイドの可視化機能）

## 備考

- dispose()メソッドを呼び出すことでGPUリソースを解放可能
- setFromObject()で対象オブジェクトを変更可能
- copy()メソッドでヘルパーの複製が可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BoxHelperはBox3クラスを使用して境界計算を行う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Box3.js | `src/math/Box3.js` | 境界ボックスの計算ロジック |
| 1-2 | BufferGeometry.js | `src/core/BufferGeometry.js` | 頂点データの管理方法 |
| 1-3 | BufferAttribute.js | `src/core/BufferAttribute.js` | 頂点属性・インデックスデータ |

**読解のコツ**: Box3.setFromObject()はオブジェクトとその全子要素を走査して境界を計算する。このメソッドの理解がBoxHelperの動作理解に重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BoxHelper.js | `src/helpers/BoxHelper.js` | 本体実装 |

**主要処理フロー**:
1. **7行目**: モジュールスコープでBox3インスタンスをキャッシュ（再利用）
2. **34行目**: コンストラクタ開始
3. **36行目**: 12辺を定義するインデックス配列
4. **37行目**: 8頂点の位置を格納する配列（初期値0）
5. **39-41行目**: BufferGeometryへの属性設定
6. **43行目**: LineBasicMaterialの生成
7. **50行目**: objectプロパティへの参照保存
8. **53行目**: matrixAutoUpdate = false

#### Step 3: updateメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | BoxHelper.js | `src/helpers/BoxHelper.js` | 63-108行目のupdateメソッド |

**主要処理フロー**:
- **65-69行目**: objectが定義されていればBox3を計算
- **71行目**: 空ボックスチェック
- **73-74行目**: min/max座標の取得
- **76-90行目**: 8頂点の座標定義コメント
- **92-103行目**: 頂点座標の配列への設定
- **104行目**: needsUpdate = true
- **106行目**: boundingSphere再計算

#### Step 4: その他メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | BoxHelper.js | `src/helpers/BoxHelper.js` | setFromObject, copy, dispose |

**主要処理フロー**:
- **116-122行目**: setFromObject - 対象オブジェクト変更
- **125-132行目**: copy - ヘルパーの複製
- **139-143行目**: dispose - リソース解放

### プログラム呼び出し階層図

```
BoxHelper (src/helpers/BoxHelper.js)
    │
    ├─ extends LineSegments (src/objects/LineSegments.js)
    │      └─ extends Line (src/objects/Line.js)
    │             └─ extends Object3D (src/core/Object3D.js)
    │
    ├─ uses Box3 (src/math/Box3.js)
    │      └─ setFromObject() → 境界計算
    │      └─ isEmpty() → 空チェック
    │
    ├─ uses BufferGeometry (src/core/BufferGeometry.js)
    │      └─ setIndex()
    │      └─ setAttribute()
    │      └─ computeBoundingSphere()
    │
    └─ uses LineBasicMaterial (src/materials/LineBasicMaterial.js)
```

### データフロー図

```
[入力]                     [処理]                              [出力]

Object3D         ───▶  BoxHelper Constructor         ───▶  LineSegmentsオブジェクト
    │                        │
    │                        ├─▶ Box3.setFromObject()
    │                        │        └─▶ 境界計算
    │                        │
    │                        └─▶ 8頂点座標設定
    │                                 └─▶ min/maxから計算
    │
    └── update() ──▶  境界再計算  ───▶  頂点位置更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| BoxHelper.js | `src/helpers/BoxHelper.js` | ソース | メイン実装 |
| Box3.js | `src/math/Box3.js` | ソース | 境界ボックス計算 |
| LineSegments.js | `src/objects/LineSegments.js` | ソース | 親クラス（線分描画） |
| Line.js | `src/objects/Line.js` | ソース | 祖父クラス（線オブジェクト） |
| Object3D.js | `src/core/Object3D.js` | ソース | 基底クラス（3Dオブジェクト） |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリデータ管理 |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点属性・インデックスデータ |
| LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ソース | 線描画マテリアル |
