# 機能設計書 153-Box3Helper

## 概要

本ドキュメントは、Three.jsライブラリにおけるBox3Helper機能の設計仕様を記載する。Box3HelperはBox3インスタンス（3D境界ボックス）を直接可視化するためのヘルパーオブジェクトである。

### 本機能の処理概要

Box3Helperは、指定されたBox3オブジェクトの境界をワイヤーフレームで描画する。Box3の中心位置とサイズに基づいてヘルパーの位置とスケールを動的に更新し、境界ボックスの変化を視覚的に追跡できるデバッグ・開発支援機能である。

**業務上の目的・背景**：3D開発において、衝突判定やカリングで使用するBox3インスタンスを直接可視化することで、境界計算の正確性を検証できる。BoxHelperがObject3Dから境界を計算するのに対し、Box3Helperは既存のBox3インスタンスをそのまま表示する点が異なる。

**機能の利用シーン**：
- 衝突判定用の境界ボックスのデバッグ
- 空間分割アルゴリズム（オクトリー等）の可視化
- カスタム境界ボックスの確認
- Box3演算結果（union, intersect等）の検証

**主要な処理内容**：
1. 正規化された8頂点ジオメトリ（-1〜1範囲）の生成
2. updateMatrixWorld()オーバーライドによる自動追従
3. Box3の中心をpositionに、サイズの半分をscaleに設定
4. 12辺のワイヤーフレームとして描画

**関連システム・外部連携**：Box3クラスと直接連携。WebGLRenderer/WebGPURendererによるレンダリングパイプラインと連携。

**権限による制御**：本機能に権限制御はない。全てのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接的な関連なし。デバッグ用途で各種画面で利用可能 |

## 機能種別

可視化処理 / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| box | Box3 | Yes | 可視化する境界ボックスインスタンス | Box3インスタンス |
| color | number\|Color\|string | No | ボックスの色（デフォルト: 0xffff00 黄色） | 有効なカラー値 |

### 入力データソース

コンストラクタ引数として直接指定。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Box3Helper | LineSegments | Box3を表すワイヤーフレームオブジェクト |

### 出力先

シーングラフへの追加（scene.add()）によりレンダリング対象となる。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ box, colorパラメータの受け取り
2. インデックス配列の生成
   └─ 12辺を定義する24インデックス
3. 正規化頂点位置配列の生成
   └─ -1〜1の範囲で8頂点を定義
4. BufferGeometryの構築
   └─ index属性とposition属性を設定
5. LineBasicMaterialの生成
   └─ 指定色、toneMapped: false
6. LineSegmentsとして初期化
7. boxプロパティへの参照保存
8. boundingSphere計算
```

### フローチャート

```mermaid
flowchart TD
    A[開始: new Box3Helper] --> B[box, color引数受け取り]
    B --> C[インデックス配列生成]
    C --> D[正規化頂点位置配列生成]
    D --> E[BufferGeometry作成]
    E --> F[LineBasicMaterial作成]
    F --> G[LineSegments初期化]
    G --> H[boxプロパティ設定]
    H --> I[boundingSphere計算]
    I --> J[終了]

    K[updateMatrixWorld呼び出し] --> L{boxが空?}
    L -->|Yes| M[return]
    L -->|No| N[box.getCenter → position]
    N --> O[box.getSize → scale]
    O --> P[scale × 0.5]
    P --> Q[親クラスupdateMatrixWorld]
    Q --> R[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-153-01 | デフォルトカラー | 指定がない場合は黄色(0xffff00)を使用 | color未指定時 |
| BR-153-02 | 自動追従 | updateMatrixWorldでBox3の変化に自動追従 | レンダリング毎 |
| BR-153-03 | 空ボックス処理 | 境界が空の場合は更新をスキップ | Box3.isEmpty()がtrue |
| BR-153-04 | 正規化ジオメトリ | 頂点は-1〜1の範囲で定義しスケールで調整 | 常時 |

### 計算ロジック

正規化頂点座標（-1〜1範囲）:
```
頂点0: (1, 1, 1)    頂点4: (1, 1, -1)
頂点1: (-1, 1, 1)   頂点5: (-1, 1, -1)
頂点2: (-1, -1, 1)  頂点6: (-1, -1, -1)
頂点3: (1, -1, 1)   頂点7: (1, -1, -1)
```

位置・スケール計算:
```javascript
this.position = box.getCenter()
this.scale = box.getSize() * 0.5
```

## データベース操作仕様

該当なし（本機能はデータベースを使用しない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 暗黙的処理 | boxが空（isEmpty） | updateMatrixWorldをスキップ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 頂点数: 8（固定）
- インデックス数: 24（固定）
- ドローコール: 1
- updateMatrixWorld()はレンダリングループで自動呼び出し

## セキュリティ考慮事項

該当なし（クライアントサイドの可視化機能）

## 備考

- dispose()メソッドを呼び出すことでGPUリソースを解放可能
- BoxHelperとの違い: BoxHelperはObject3Dから境界を計算、Box3HelperはBox3インスタンスを直接使用
- updateMatrixWorldのオーバーライドにより、参照しているBox3が変更されると自動的に追従

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Box3Helperは参照するBox3インスタンスの中心とサイズを使用する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Box3.js | `src/math/Box3.js` | getCenter(), getSize(), isEmpty()メソッド |
| 1-2 | BufferGeometry.js | `src/core/BufferGeometry.js` | 頂点データの管理方法 |
| 1-3 | BufferAttribute.js | `src/core/BufferAttribute.js` | Float32BufferAttributeによる属性データ |

**読解のコツ**: Box3はmin/maxプロパティで境界を保持し、getCenter()とgetSize()でそれらから中心とサイズを計算する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Box3Helper.js | `src/helpers/Box3Helper.js` | 本体実装 |

**主要処理フロー**:
1. **27行目**: コンストラクタ開始
2. **29行目**: 12辺を定義するインデックス配列
3. **31行目**: 正規化された8頂点位置（-1〜1範囲）
4. **33-37行目**: BufferGeometryへの属性設定
5. **39行目**: LineBasicMaterialの生成
6. **46行目**: boxプロパティへの参照保存
7. **48行目**: type = 'Box3Helper'
8. **50行目**: boundingSphere計算

#### Step 3: updateMatrixWorldを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Box3Helper.js | `src/helpers/Box3Helper.js` | 54-67行目のupdateMatrixWorld |

**主要処理フロー**:
- **56行目**: boxへの参照取得
- **58行目**: 空ボックスチェック
- **60行目**: box.getCenter()でthis.positionを設定
- **62行目**: box.getSize()でthis.scaleを設定
- **64行目**: scale × 0.5（正規化ジオメトリに合わせる）
- **66行目**: 親クラスのupdateMatrixWorld呼び出し

#### Step 4: disposeを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Box3Helper.js | `src/helpers/Box3Helper.js` | 74-78行目のdispose |

**主要処理フロー**:
- **76行目**: geometry.dispose()
- **77行目**: material.dispose()

### プログラム呼び出し階層図

```
Box3Helper (src/helpers/Box3Helper.js)
    │
    ├─ extends LineSegments (src/objects/LineSegments.js)
    │      └─ extends Line (src/objects/Line.js)
    │             └─ extends Object3D (src/core/Object3D.js)
    │
    ├─ references Box3 (src/math/Box3.js)
    │      └─ getCenter() → 中心座標取得
    │      └─ getSize() → サイズ取得
    │      └─ isEmpty() → 空チェック
    │
    ├─ uses BufferGeometry (src/core/BufferGeometry.js)
    │      └─ setIndex()
    │      └─ setAttribute()
    │      └─ computeBoundingSphere()
    │
    └─ uses LineBasicMaterial (src/materials/LineBasicMaterial.js)
```

### データフロー図

```
[入力]                     [処理]                              [出力]

Box3             ───▶  Box3Helper Constructor        ───▶  LineSegmentsオブジェクト
    │                        │
    │                        ├─▶ 正規化ジオメトリ生成
    │                        │        └─▶ -1〜1範囲の8頂点
    │                        │
    │                        └─▶ boxプロパティに参照保存
    │
    └── [レンダリング時] ──▶  updateMatrixWorld
                                    │
                                    ├─▶ getCenter() → position
                                    └─▶ getSize() × 0.5 → scale
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Box3Helper.js | `src/helpers/Box3Helper.js` | ソース | メイン実装 |
| Box3.js | `src/math/Box3.js` | ソース | 境界ボックス（参照対象） |
| LineSegments.js | `src/objects/LineSegments.js` | ソース | 親クラス（線分描画） |
| Line.js | `src/objects/Line.js` | ソース | 祖父クラス（線オブジェクト） |
| Object3D.js | `src/core/Object3D.js` | ソース | 基底クラス（3Dオブジェクト） |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリデータ管理 |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点属性・インデックスデータ |
| LineBasicMaterial.js | `src/materials/LineBasicMaterial.js` | ソース | 線描画マテリアル |
