# 機能設計書 16-WebGLCubeRenderTarget

## 概要

本ドキュメントは、Three.jsライブラリにおけるWebGLCubeRenderTarget機能の設計を詳細に記述するものである。WebGLCubeRenderTargetは、キューブマップテクスチャへのレンダリングを可能にするレンダーターゲットであり、環境マップの動的生成や反射効果の実装に使用される。

### 本機能の処理概要

WebGLCubeRenderTargetクラスは、6面のキューブマップテクスチャへのオフスクリーンレンダリングを提供する。CubeCameraと組み合わせて使用され、シーン内の特定位置から見た360度の環境を動的にキャプチャし、反射や屈折効果に利用できる。また、等距離円筒図法（Equirectangular）テクスチャからキューブマップへの変換機能も備える。

**業務上の目的・背景**：リアルタイム3Dグラフィックスにおいて、環境マッピングは光沢のある表面やミラー効果を実現するための重要な技術である。静的な環境マップだけでなく、動的に変化するシーンの反射を表現するには、実行時にキューブマップを生成する必要がある。WebGLCubeRenderTargetはこの動的環境マップ生成を効率的に行うためのクラスである。

**機能の利用シーン**：動的な反射効果、屈折効果（透明なオブジェクト）、スカイボックスの動的生成、等距離円筒図法HDR画像からのキューブマップ変換、リアルタイムプローブベースレンダリングなど。

**主要な処理内容**：
1. 6面キューブマップテクスチャの管理
2. CubeCameraとの連携による6方向レンダリング
3. 等距離円筒図法テクスチャからキューブマップへの変換
4. 各面への個別アクセスとクリア機能
5. テクスチャ座標系の処理（左手座標系から右手座標系への変換）

**関連システム・外部連携**：WebGLRenderer、CubeCamera、CubeTexture、ShaderMaterial。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | WebGLCubeRenderTargetは主に内部APIとして使用される |

## 機能種別

レンダリングリソース管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| size | number | No | キューブマップの各面のサイズ | デフォルト: 1 |
| options | Object | No | RenderTarget~Options相当 | - |

### 入力データソース

- 等距離円筒図法テクスチャ（fromEquirectangularTexture用）
- CubeCameraによる6方向レンダリング結果

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| texture | CubeTexture | 6面キューブマップテクスチャ |
| width | number | 各面の幅 |
| height | number | 各面の高さ |

### 出力先

- マテリアルのenvMap等に設定して使用

## 処理フロー

### 処理シーケンス

```
1. WebGLCubeRenderTargetインスタンスの生成
   └─ CubeTexture作成、各面のimage設定

2. 等距離円筒図法からの変換（オプション）
   ├─ fromEquirectangularTexture()呼び出し
   ├─ BoxGeometry + ShaderMaterialでメッシュ作成
   ├─ CubeCameraで6方向レンダリング
   └─ リソースクリーンアップ

3. 動的環境マップ生成
   ├─ CubeCamera.update(renderer, scene)
   └─ 各面へレンダリング

4. 各面のクリア
   └─ clear()で6面すべてをクリア

5. リソース解放
   └─ dispose()でGPUリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[WebGLCubeRenderTarget生成] --> B[CubeTexture作成]
    B --> C[6面分のimage設定]
    C --> D{使用方法?}
    D -->|等距離円筒図法変換| E[fromEquirectangularTexture]
    E --> F[BoxGeometry作成]
    F --> G[ShaderMaterial作成]
    G --> H[CubeCamera.update]
    H --> I[6方向レンダリング]
    I --> J[リソースクリーンアップ]
    D -->|動的環境マップ| K[CubeCamera作成]
    K --> L[camera.update呼び出し]
    L --> M[6方向レンダリング]
    J --> N[envMapとして使用]
    M --> N
    N --> O{クリア要求?}
    O -->|Yes| P[clear: 6面クリア]
    O -->|No| Q{dispose?}
    P --> Q
    Q -->|Yes| R[リソース解放]
    Q -->|No| D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | WebGLRenderTarget継承 | WebGLRenderTargetクラスを継承 | クラス定義 |
| BR-02 | タイプフラグ | isWebGLCubeRenderTarget=trueを設定 | インスタンス生成時 |
| BR-03 | CubeTextureラップ | textureプロパティはCubeTextureインスタンス | インスタンス生成時 |
| BR-04 | 座標系変換 | isRenderTargetTexture=trueで左右反転制御 | テクスチャ使用時 |
| BR-05 | 正方形制約 | 各面は同一サイズの正方形 | サイズ設定時 |

### 計算ロジック

- 等距離円筒図法からキューブマップへの変換はequirectUv()関数を使用

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | テクスチャサイズ制限 | 各面サイズがGPU制限を超過 | サイズを縮小 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 動的環境マップは毎フレーム更新が重い処理
- 必要に応じて更新頻度を制限することを推奨
- fromEquirectangularTextureは初期化時のみ呼び出し推奨

## セキュリティ考慮事項

- フレームバッファ内容はWebGL APIを介してのみアクセス可能

## 備考

- CubeCameraと組み合わせて使用することが一般的
- PMREMGeneratorで環境マップをプリフィルタリング可能
- Three.jsは右手座標系を使用するが、WebGL/glTFの慣例で左手座標系が使用される場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WebGLCubeRenderTargetの構造とその依存関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WebGLCubeRenderTarget.js | `src/renderers/WebGLCubeRenderTarget.js` | クラス定義全体 |
| 1-2 | WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | 親クラス |
| 1-3 | CubeTexture.js | `src/textures/CubeTexture.js` | キューブマップテクスチャ |
| 1-4 | CubeCamera.js | `src/cameras/CubeCamera.js` | 6方向レンダリング用カメラ |

**読解のコツ**: WebGLCubeRenderTargetはWebGLRenderTargetを継承し、textureプロパティをCubeTextureで上書きする。fromEquirectangularTextureはシェーダーを使った変換処理で、GLSLコードを含む。

#### Step 2: エントリーポイントを理解する

WebGLCubeRenderTargetの初期化と主要メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WebGLCubeRenderTarget.js | `src/renderers/WebGLCubeRenderTarget.js` | コンストラクタ・メソッド |

**主要処理フロー**:
1. **23行目**: コンストラクタでsize（デフォルト1）とoptionsを受け取る
2. **25行目**: super()でWebGLRenderTarget（正方形）を初期化
3. **34行目**: isWebGLCubeRenderTargetフラグをtrueに設定
4. **36-37行目**: 6面分のimageオブジェクト作成
5. **44行目**: CubeTextureインスタンスをtextureに設定
6. **55行目**: isRenderTargetTextureをtrueに設定（座標系変換制御）
7. **66-153行目**: fromEquirectangularTexture()メソッド
8. **164-178行目**: clear()メソッドで6面すべてをクリア

#### Step 3: fromEquirectangularTextureを理解する

等距離円筒図法からキューブマップへの変換処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WebGLCubeRenderTarget.js | `src/renderers/WebGLCubeRenderTarget.js` | fromEquirectangularTexture内部 |

**主要処理フロー**:
1. **68-73行目**: テクスチャプロパティの継承（type, colorSpace, generateMipmaps, minFilter, magFilter）
2. **75-119行目**: シェーダー定義（vertexShader, fragmentShader）
3. **81-98行目**: 頂点シェーダー - ワールド方向ベクトルの計算
4. **101-117行目**: フラグメントシェーダー - equirectUv()による座標変換
5. **121行目**: BoxGeometry(5,5,5)作成
6. **123-132行目**: ShaderMaterial作成（BackSide, NoBlending）
7. **137行目**: Meshインスタンス作成
8. **144行目**: CubeCamera(1, 10, this)でレンダリング
9. **145行目**: camera.update()で6方向レンダリング
10. **149-150行目**: geometry/materialのdispose

### プログラム呼び出し階層図

```
WebGLCubeRenderTarget
    │
    └─ extends WebGLRenderTarget
            │
            └─ extends RenderTarget
                    │
                    └─ extends EventDispatcher

WebGLCubeRenderTarget.fromEquirectangularTexture(renderer, texture)
    │
    ├─ BoxGeometry(5, 5, 5)
    │
    ├─ ShaderMaterial({...})
    │       │
    │       ├─ vertexShader: 位置→ワールド方向変換
    │       │
    │       └─ fragmentShader: equirectUv()座標変換
    │
    ├─ Mesh(geometry, material)
    │
    └─ CubeCamera(1, 10, this)
            │
            └─ update(renderer, mesh) ──▶ 6方向レンダリング
```

### データフロー図

```
[入力]                              [処理]                            [出力]

size, options
    │
    ▼
WebGLCubeRenderTarget() ────────────────────────────────────────────▶ CubeTexture
    │
    ▼
Equirectangular Texture
    │
    ▼
fromEquirectangularTexture() ──▶ ShaderMaterial ──▶ equirectUv() ──▶ CubeTexture更新
                                      │
                                      ▼
                                CubeCamera.update() ──▶ 6方向レンダリング

Dynamic Environment
    │
    ▼
CubeCamera.update(renderer, scene) ─────────────────────────────────▶ CubeTexture更新
    │
    ▼
material.envMap = cubeRT.texture ───────────────────────────────────▶ 反射/環境効果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WebGLCubeRenderTarget.js | `src/renderers/WebGLCubeRenderTarget.js` | ソース | キューブマップレンダーターゲット |
| WebGLRenderTarget.js | `src/renderers/WebGLRenderTarget.js` | ソース | 親クラス |
| RenderTarget.js | `src/core/RenderTarget.js` | ソース | 基底クラス |
| CubeTexture.js | `src/textures/CubeTexture.js` | ソース | キューブマップテクスチャ |
| CubeCamera.js | `src/cameras/CubeCamera.js` | ソース | 6方向レンダリング用カメラ |
| BoxGeometry.js | `src/geometries/BoxGeometry.js` | ソース | 変換用ボックスジオメトリ |
| ShaderMaterial.js | `src/materials/ShaderMaterial.js` | ソース | 変換用カスタムシェーダー |
| UniformsUtils.js | `src/renderers/shaders/UniformsUtils.js` | ソース | ユニフォームクローン |
| constants.js | `src/constants.js` | ソース | BackSide, NoBlending等の定数 |
