# 機能設計書 161-HemisphereLightHelper

## 概要

本ドキュメントは、Three.jsライブラリにおけるHemisphereLightHelper機能の設計仕様を記述する。HemisphereLightHelperは、HemisphereLight（半球光）を3Dシーン内で視覚的に表示するためのヘルパークラスである。

### 本機能の処理概要

HemisphereLightHelperは、シーン内の半球光源を視覚化するためのヘルパーオブジェクトを提供する。八面体（OctahedronGeometry）形状のワイヤーフレームメッシュを使用して光源の位置と色を表示し、上半分が空の色（skyColor）、下半分が地面の色（groundColor）で描画される。

**業務上の目的・背景**：3D開発において、半球光源の位置と効果を視覚的に確認することは、ライティング調整作業において不可欠である。このヘルパーを使用することで、開発者やデザイナーはシーン内の半球光の配置を直感的に把握でき、ライティングのデバッグと調整を効率的に行うことができる。

**機能の利用シーン**：
- 3Dエディタでの半球光源の配置確認
- シーンのライティングデバッグ
- 教育・学習目的での光源の動作理解
- 開発時のリアルタイムプレビュー

**主要な処理内容**：
1. OctahedronGeometryを使用した八面体形状のワイヤーフレームメッシュの生成
2. 半球光のskyColorとgroundColorを反映した頂点カラーの設定
3. 光源のワールド変換行列との同期
4. update()メソッドによる色と位置の動的更新
5. dispose()メソッドによるGPUリソースの解放

**関連システム・外部連携**：HemisphereLight、Object3D、MeshBasicMaterial、OctahedronGeometryと連携し、Three.jsのレンダリングパイプラインに統合される。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 12 | Menubar - Add | 補助機能 | 半球光の追加時にヘルパーも追加可能 |

## 機能種別

ビジュアライゼーション / デバッグ補助

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| light | HemisphereLight | Yes | 可視化対象の半球光源 | HemisphereLightインスタンスであること |
| size | number | No | メッシュのサイズ（デフォルト: 1） | 正の数値 |
| color | number/Color/string | No | ヘルパーの色（未設定時は光源の色を使用） | 有効な色値 |

### 入力データソース

コンストラクタ引数として渡されるHemisphereLightインスタンスから光源情報を取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HemisphereLightHelper | Object3D | 半球光を可視化するヘルパーオブジェクト |

### 出力先

Three.jsのシーングラフに追加され、WebGLRenderer/WebGPURendererによってレンダリングされる。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 親クラスObject3Dを初期化
2. 光源参照の保存
   └─ this.light = light
3. 行列の同期設定
   └─ this.matrix = light.matrixWorld, matrixAutoUpdate = false
4. ジオメトリ生成
   └─ OctahedronGeometryを生成し90度回転
5. マテリアル設定
   └─ MeshBasicMaterial（ワイヤーフレーム）を生成
6. カラー属性設定
   └─ 頂点カラー用のBufferAttributeを追加
7. メッシュ追加
   └─ Meshを子として追加
8. 初期更新
   └─ update()を呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[コンストラクタ開始] --> B[Object3D初期化]
    B --> C[light参照を保存]
    C --> D[行列同期設定]
    D --> E[OctahedronGeometry生成]
    E --> F[ジオメトリを90度回転]
    F --> G[MeshBasicMaterial生成]
    G --> H{colorが指定されているか?}
    H -->|No| I[vertexColors = true]
    H -->|Yes| J[指定色を使用]
    I --> K[頂点カラー属性を追加]
    J --> K
    K --> L[Meshを子に追加]
    L --> M[update呼び出し]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 色の継承 | colorパラメータ未指定時は光源のskyColorとgroundColorを使用 | コンストラクタでcolor未指定時 |
| BR-002 | 頂点カラー分割 | 八面体の上半分をskyColor、下半分をgroundColorで着色 | color未指定時のupdate() |
| BR-003 | 行列同期 | ヘルパーの行列は光源のmatrixWorldと同期 | 常時 |

### 計算ロジック

頂点カラーの設定: 頂点インデックス i が (頂点数 / 2) 未満の場合は skyColor、それ以外は groundColor を適用。

## データベース操作仕様

該当なし（クライアントサイドのみで動作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | TypeError | lightがnullまたはundefined | 有効なHemisphereLightを渡す |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 軽量なワイヤーフレーム表示のため、レンダリング負荷は最小限
- update()は光源変更時のみ呼び出しを推奨

## セキュリティ考慮事項

特になし（クライアントサイドのビジュアライゼーション機能）

## 備考

- 光源のプロパティ変更後はupdate()の呼び出しが必要
- dispose()を呼び出してGPUリソースを適切に解放すること

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HemisphereLightHelperはObject3Dを継承し、HemisphereLightへの参照を保持する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HemisphereLightHelper.js | `src/helpers/HemisphereLightHelper.js` | クラス定義とプロパティ構造（light, color, material） |

**読解のコツ**: Object3Dを継承しているため、位置・回転・スケールなどの3D変換機能を持つ。matrixAutoUpdateをfalseに設定し、光源の行列を直接参照している点に注目。

#### Step 2: エントリーポイントを理解する

コンストラクタが主要なエントリーポイントとなる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HemisphereLightHelper.js | `src/helpers/HemisphereLightHelper.js` | constructor (38-77行目) |

**主要処理フロー**:
1. **38-40行目**: super()でObject3Dを初期化
2. **47行目**: this.lightに光源参照を保存
3. **49-50行目**: 行列の同期設定
4. **62-63行目**: OctahedronGeometryの生成と回転
5. **65行目**: MeshBasicMaterialの生成（wireframe: true）
6. **73行目**: メッシュを子として追加
7. **75行目**: update()で初期カラーを設定

#### Step 3: 更新処理を理解する

update()メソッドはヘルパーの色と向きを更新する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HemisphereLightHelper.js | `src/helpers/HemisphereLightHelper.js` | update (94-125行目) |

**主要処理フロー**:
- **98-100行目**: colorが指定されている場合はマテリアル色を設定
- **104-117行目**: colorが未指定の場合、頂点カラーを設定（上半分skyColor、下半分groundColor）
- **121行目**: 光源のワールド行列を更新
- **123行目**: メッシュを光源の反対方向に向ける

#### Step 4: リソース解放を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HemisphereLightHelper.js | `src/helpers/HemisphereLightHelper.js` | dispose (83-88行目) |

**主要処理フロー**:
- **85-86行目**: 子メッシュのジオメトリとマテリアルをdispose

### プログラム呼び出し階層図

```
HemisphereLightHelper (constructor)
    │
    ├─ Object3D (super)
    │
    ├─ OctahedronGeometry
    │      └─ rotateY (90度回転)
    │
    ├─ MeshBasicMaterial
    │      └─ wireframe: true, fog: false
    │
    ├─ BufferAttribute (color)
    │
    ├─ Mesh
    │      └─ geometry + material
    │
    └─ update()
           ├─ Color.copy (skyColor, groundColor)
           ├─ BufferAttribute.setXYZ (頂点カラー設定)
           └─ Mesh.lookAt (方向設定)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HemisphereLight ───────▶ HemisphereLightHelper ───────▶ シーングラフ
  - skyColor               - OctahedronGeometry          - 可視化された
  - groundColor            - 頂点カラー設定               ヘルパーメッシュ
  - matrixWorld            - Mesh生成

size (number) ─────────▶ OctahedronGeometry ──────────▶ ジオメトリサイズ

color (optional) ──────▶ MeshBasicMaterial ───────────▶ マテリアル色
                         または頂点カラー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HemisphereLightHelper.js | `src/helpers/HemisphereLightHelper.js` | ソース | 本機能のメイン実装 |
| Object3D.js | `src/core/Object3D.js` | ソース | 基底クラス（3Dオブジェクト管理） |
| OctahedronGeometry.js | `src/geometries/OctahedronGeometry.js` | ソース | 八面体ジオメトリ生成 |
| MeshBasicMaterial.js | `src/materials/MeshBasicMaterial.js` | ソース | ワイヤーフレームマテリアル |
| Mesh.js | `src/objects/Mesh.js` | ソース | メッシュオブジェクト |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点カラー属性 |
| Color.js | `src/math/Color.js` | ソース | 色計算 |
| Vector3.js | `src/math/Vector3.js` | ソース | 方向計算 |
| HemisphereLight.js | `src/lights/HemisphereLight.js` | ソース | 対象となる光源クラス |
