# 機能設計書 17-PostProcessing

## 概要

本ドキュメントは、Three.jsライブラリにおけるPostProcessing機能の設計を詳細に記述するものである。PostProcessingは、レンダリングパイプラインとポストプロセッシングエフェクトを管理するためのクラスであり、r183以降はRenderPipelineにリネームされた非推奨クラスである。

### 本機能の処理概要

PostProcessingクラス（現RenderPipeline）は、レンダリング結果に対してブルーム、被写界深度、カラーグレーディングなどのポストプロセッシングエフェクトを適用するためのパイプライン管理機能を提供する。ノードベースのシェーディング言語（TSL）と統合されており、柔軟なエフェクトチェーンを構築できる。

**業務上の目的・背景**：現代の3Dグラフィックスでは、シーンをレンダリングした後に画像処理エフェクトを適用することが一般的である。ブルーム（発光効果）、被写界深度（DoF）、スクリーンスペースアンビエントオクルージョン（SSAO）、アンチエイリアシング（FXAA, TAA）などのエフェクトは、最終画像の品質を大幅に向上させる。PostProcessingはこれらのエフェクトを効率的に管理・適用するための統一的なインターフェースを提供する。

**機能の利用シーン**：映画的な視覚効果、ゲームのビジュアル強化、建築ビジュアライゼーション、製品レンダリング、VR/ARコンテンツ制作など。

**主要な処理内容**：
1. レンダリングパイプラインの定義と管理
2. ノードベースのエフェクトチェーン構築
3. トーンマッピングと色空間変換の自動適用
4. フルスクリーンクアッドでのエフェクト描画
5. XRモード時の適切な処理

**関連システム・外部連携**：WebGPURenderer（専用）、RenderPipeline（リネーム先）、TSL（ノードシステム）、NodeMaterial。

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | Menubar - Render | 補助機能 | パストレーシングレンダリング |
| 22 | WebGLポストプロセシング | 主機能 | 後処理エフェクトの適用 |

## 機能種別

レンダリング処理 / ポストプロセッシング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| renderer | Renderer | Yes | WebGPURenderer等のレンダラー参照 | - |
| outputNode | Node&lt;vec4&gt; | No | 出力ノード | デフォルト: vec4(0,0,1,1) |

### 入力データソース

- ノードベースのレンダリングパイプライン定義
- passノードなどのシーンレンダリング結果

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 最終画像 | Canvas | エフェクト適用後の画像がCanvasに描画 |

### 出力先

- レンダラーのCanvas

## 処理フロー

### 処理シーケンス

```
1. PostProcessing/RenderPipelineインスタンスの生成
   └─ renderer参照保持、outputNode設定、QuadMesh作成

2. エフェクトチェーン構築
   ├─ scenePass = pass(scene, camera)
   ├─ bloomPass = bloom(scenePass)
   └─ renderPipeline.outputNode = bloomPass

3. レンダリングループ
   ├─ _update(): ノードグラフ更新
   ├─ トーンマッピング/色空間の一時無効化
   ├─ _quadMesh.render(): フルスクリーン描画
   └─ トーンマッピング/色空間の復元

4. リソース解放
   └─ dispose(): QuadMesh materialのdispose
```

### フローチャート

```mermaid
flowchart TD
    A[PostProcessing生成] --> B[renderer, outputNode設定]
    B --> C[QuadMesh作成]
    C --> D{outputNode設定?}
    D -->|Yes| E[needsUpdate = true]
    D -->|No| F[render()呼び出し待機]
    E --> F
    F --> G{render()呼び出し?}
    G -->|Yes| H[_update: ノードグラフ構築]
    H --> I[トーンマッピング一時無効化]
    I --> J[XR一時無効化]
    J --> K[_quadMesh.render]
    K --> L[XR復元]
    L --> M[トーンマッピング復元]
    M --> F
    G -->|No| N{dispose?}
    N -->|Yes| O[material.dispose]
    N -->|No| F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 非推奨クラス | PostProcessingはr183でRenderPipelineにリネーム | クラス使用時に警告 |
| BR-02 | WebGPURenderer専用 | WebGLRendererでは使用不可 | レンダラー選択時 |
| BR-03 | 自動色変換 | outputColorTransform=trueで自動トーンマッピング・色空間変換 | デフォルト動作 |
| BR-04 | 手動色変換 | outputColorTransform=falseでRenderOutputNodeを使用 | FXAA等で必要 |
| BR-05 | needsUpdate | outputNode変更時はneedsUpdate=trueを設定 | ノード変更時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 非推奨警告 | PostProcessing使用時 | RenderPipelineに移行 |
| - | renderAsync非推奨 | renderAsync()呼び出し時 | render()とawait renderer.init()を使用 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- フルスクリーンクアッドは解像度に比例した負荷
- 複雑なエフェクトチェーンはGPUバウンド
- needsUpdateはフレームごとに評価

## セキュリティ考慮事項

- シェーダーコードはブラウザサンドボックス内で実行

## 備考

- r183以降はRenderPipelineを使用することを推奨
- TSL（Three.js Shading Language）を使用してエフェクトを定義
- onBeforeRenderPipeline/onAfterRenderPipelineコールバックで前後処理可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PostProcessing/RenderPipelineの構造とその依存関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PostProcessing.js | `src/renderers/common/PostProcessing.js` | 非推奨ラッパー |
| 1-2 | RenderPipeline.js | `src/renderers/common/RenderPipeline.js` | 実際の実装 |
| 1-3 | QuadMesh.js | `src/renderers/common/QuadMesh.js` | フルスクリーンクアッド |
| 1-4 | NodeMaterial.js | `src/materials/nodes/NodeMaterial.js` | ノードベースマテリアル |

**読解のコツ**: PostProcessingはRenderPipelineの単純な非推奨ラッパーであり、実際のロジックはRenderPipelineにある。TSLのノードシステムとNodeMaterialの理解が重要。

#### Step 2: エントリーポイントを理解する

RenderPipelineの初期化と主要メソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RenderPipeline.js | `src/renderers/common/RenderPipeline.js` | コンストラクタ・メソッド |

**主要処理フロー**:
1. **30行目**: コンストラクタでrendererとoutputNodeを受け取る
2. **37行目**: rendererプロパティ
3. **46行目**: outputNodeプロパティ（エフェクトチェーンの終端）
4. **66行目**: outputColorTransformプロパティ（自動色変換制御）
5. **73行目**: needsUpdateプロパティ
6. **75-86行目**: NodeMaterialとQuadMeshの作成
7. **104-134行目**: render()メソッド - エフェクト適用と描画
8. **162-202行目**: _update()メソッド - ノードグラフの構築

#### Step 3: PostProcessingラッパーを理解する

非推奨警告の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PostProcessing.js | `src/renderers/common/PostProcessing.js` | 非推奨ラッパー |

**主要処理フロー**:
1. **9行目**: RenderPipelineを継承
2. **18行目**: コンストラクタでwarnOnce()を呼び出して非推奨警告
3. **20行目**: super()でRenderPipelineを初期化

### プログラム呼び出し階層図

```
PostProcessing (deprecated)
    │
    └─ extends RenderPipeline
            │
            ├─ constructor(renderer, outputNode)
            │       │
            │       ├─ NodeMaterial作成
            │       │
            │       └─ QuadMesh作成
            │
            ├─ render()
            │       │
            │       ├─ _update() ──────────▶ ノードグラフ構築
            │       │
            │       ├─ toneMapping一時無効化
            │       │
            │       ├─ _quadMesh.render() ──▶ フルスクリーン描画
            │       │
            │       └─ toneMapping復元
            │
            └─ dispose() ──────────────────▶ material.dispose()
```

### データフロー図

```
[入力]                            [処理]                            [出力]

outputNode (エフェクトチェーン)
    │
    ▼
RenderPipeline._update() ────────▶ ノードグラフ構築 ─────────────▶ fragmentNode
    │                                    │
    │                                    ▼
    │                             renderOutput() ─────────────────▶ トーンマッピング適用
    │                                    │
    ▼                                    ▼
QuadMesh.render() ───────────────▶ フルスクリーン描画 ─────────────▶ Canvas

典型的なエフェクトチェーン:
    scene + camera ──▶ pass() ──▶ bloom() ──▶ fxaa() ──▶ outputNode
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PostProcessing.js | `src/renderers/common/PostProcessing.js` | ソース | 非推奨ラッパー |
| RenderPipeline.js | `src/renderers/common/RenderPipeline.js` | ソース | メイン実装 |
| QuadMesh.js | `src/renderers/common/QuadMesh.js` | ソース | フルスクリーンクアッド |
| NodeMaterial.js | `src/materials/nodes/NodeMaterial.js` | ソース | ノードベースマテリアル |
| TSL.js | `src/nodes/TSL.js` | ソース | ノード関数群 |
| PassNode.js | `src/nodes/display/PassNode.js` | ソース | シーンパス |
| BloomNode.js | `src/nodes/display/BloomNode.js` | ソース | ブルームエフェクト |
| RenderOutputNode.js | `src/nodes/display/RenderOutputNode.js` | ソース | 出力変換 |
| ColorManagement.js | `src/math/ColorManagement.js` | ソース | 色空間管理 |
