# 機能設計書 23-ArrayCamera

## 概要

本ドキュメントは、Three.jsにおけるArrayCamera（アレイカメラ）機能の詳細設計を記述する。ArrayCameraはマルチビューレンダリング用のカメラ配列を提供するクラスである。

### 本機能の処理概要

ArrayCameraは、複数のPerspectiveCameraをサブカメラとして管理し、1回のレンダリングパスで複数のビューポートに対して効率的にシーンをレンダリングするための特殊なカメラクラスである。VRシーンのレンダリングにおいて重要なパフォーマンス最適化を提供する。

**業務上の目的・背景**：VRレンダリングでは左右の目に対して異なるビューをレンダリングする必要があるが、各ビューを個別にレンダリングすると処理コストが2倍になる。ArrayCameraを使用することで、単一のレンダリングパスで複数のビューを効率的に処理でき、VRアプリケーションのパフォーマンスを向上させることができる。

**機能の利用シーン**：
- VRヘッドセットでの効率的なステレオレンダリング
- マルチモニター/マルチウィンドウ環境でのレンダリング
- 複数カメラによる監視システムの表示
- ピクチャーインピクチャー表示
- WebXRでのマルチビューレンダリング

**主要な処理内容**：
1. 複数のPerspectiveCameraをサブカメラ配列として管理
2. 各サブカメラのviewport設定に基づいたビューポート分割
3. マルチビューレンダリングモードの制御（isMultiViewCamera）
4. PerspectiveCameraの機能を継承した親カメラとしての動作

**関連システム・外部連携**：WebGLRenderer、WebGPURenderer、WebXRManagerと連携して動作する。

**権限による制御**：特になし（ライブラリ機能として権限制御は行わない）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 該当なし | - | - | 内部処理機能のため直接の画面関連なし（VR/XR機能で使用） |

## 機能種別

データ管理（カメラ配列の管理）/ 計算処理（ビューポート分割）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| array | Array\<PerspectiveCamera\> | No | サブカメラの配列 | デフォルトは空配列 |

### サブカメラの必須設定

各サブカメラには以下のviewportプロパティを設定する必要がある：

| プロパティ名 | 型 | 説明 |
|-------------|-----|------|
| viewport.x | number | ビューポートの左端位置（ピクセル） |
| viewport.y | number | ビューポートの下端位置（ピクセル） |
| viewport.width | number | ビューポートの幅（ピクセル） |
| viewport.height | number | ビューポートの高さ（ピクセル） |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| cameras | Array\<PerspectiveCamera\> | サブカメラの配列 |
| isArrayCamera | boolean | ArrayCameraであることを示すフラグ（true） |
| isMultiViewCamera | boolean | マルチビューレンダリングモードかどうか |

### 出力先

- レンダラーが各サブカメラのビューポートに対してレンダリング

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ実行
   └─ super()でPerspectiveCameraを初期化
   └─ isArrayCamera = true を設定
   └─ isMultiViewCamera = false を設定
   └─ cameras配列にサブカメラを設定

2. レンダラーでの使用時
   └─ レンダラーがisArrayCameraをチェック
   └─ cameras配列をループ
   └─ 各カメラのviewportでビューポートを設定
   └─ 各カメラでシーンをレンダリング
```

### フローチャート

```mermaid
flowchart TD
    A[ArrayCamera生成] --> B[PerspectiveCamera継承]
    B --> C[isArrayCamera = true]
    C --> D[cameras配列を設定]
    D --> E[レンダラーで使用]
    E --> F{isArrayCamera?}
    F -->|Yes| G[cameras配列をループ]
    G --> H[各カメラのviewportを設定]
    H --> I[各カメラでレンダリング]
    I --> J{次のカメラあり?}
    J -->|Yes| H
    J -->|No| K[終了]
    F -->|No| L[通常レンダリング]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | viewportが必須 | 各サブカメラにはviewportプロパティが必須 | レンダリング時 |
| BR-02 | PerspectiveCamera継承 | 親カメラとしてPerspectiveCameraの機能を持つ | 常時 |
| BR-03 | マルチビューモード | isMultiViewCameraがtrueの場合、特殊な最適化が適用 | WebXR使用時 |

### 計算ロジック

特別な計算ロジックなし。viewportの設定は各サブカメラで個別に行う。

## データベース操作仕様

該当なし（クライアントサイドのみの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 明示的なエラー処理なし | サブカメラのviewport未設定時は正常にレンダリングされない |

### リトライ仕様

リトライ処理は不要

## トランザクション仕様

該当なし（クライアントサイドのみの処理）

## パフォーマンス要件

- マルチビューレンダリングによりVRシーンの描画パフォーマンスを向上
- isMultiViewCameraがtrueの場合、GPU側でのマルチビュー拡張を利用可能

## セキュリティ考慮事項

特になし（ブラウザのセキュリティモデルに依存）

## 備考

- ArrayCameraは非常にシンプルなクラスで、主にカメラ配列のコンテナとして機能
- 実際のマルチビューレンダリング処理はレンダラー側で実装
- WebXRと組み合わせて使用することが多い

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ArrayCameraはPerspectiveCameraを継承したシンプルなクラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ArrayCamera.js | `src/cameras/ArrayCamera.js` | クラスの全体構造（55行） |
| 1-2 | PerspectiveCamera.js | `src/cameras/PerspectiveCamera.js` | 親クラスの構造 |

**読解のコツ**: ArrayCameraは非常にシンプルで、PerspectiveCameraを継承し、cameras配列を追加しただけのクラス。

#### Step 2: コンストラクタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArrayCamera.js | `src/cameras/ArrayCamera.js` | 21-50行目 |

**主要処理フロー**:
1. **21行目**: コンストラクタでarray（デフォルト空配列）を受け取る
2. **23行目**: super()でPerspectiveCameraを初期化
3. **32行目**: isArrayCamera = true を設定
4. **41行目**: isMultiViewCamera = false を設定
5. **48行目**: cameras = array を設定

#### Step 3: クラスの継承関係を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Camera.js | `src/cameras/Camera.js` | Cameraの基底クラス |
| 3-2 | Object3D.js | `src/core/Object3D.js` | Object3Dの基底クラス |

**読解のコツ**:
- ArrayCamera extends PerspectiveCamera extends Camera extends Object3D
- 継承チェーンを理解することで、ArrayCameraの持つプロパティとメソッドが明確になる

### プログラム呼び出し階層図

```
ArrayCamera
    |
    +-- extends PerspectiveCamera
    |       |
    |       +-- extends Camera
    |               |
    |               +-- extends Object3D
    |
    +-- constructor(array = [])
            |
            +-- super()
            +-- isArrayCamera = true
            +-- isMultiViewCamera = false
            +-- cameras = array
```

### データフロー図

```
[入力]                      [処理]                         [出力]

Array<PerspectiveCamera> -> ArrayCamera構築 ────────> ArrayCameraインスタンス
                                  |                         |
                                  v                         v
                           cameras配列に格納          isArrayCamera = true
                                                     isMultiViewCamera = false

                           [レンダラーでの使用]
                                  |
                                  v
cameras[i] ──────────────> viewport設定 ────────> 各ビューポートに
    |                            |               レンダリング結果
    v                            v
各カメラの投影行列 ──────> シーンのレンダリング
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArrayCamera.js | `src/cameras/ArrayCamera.js` | ソース | ArrayCameraクラスの実装 |
| PerspectiveCamera.js | `src/cameras/PerspectiveCamera.js` | ソース | 親クラス |
| Camera.js | `src/cameras/Camera.js` | ソース | カメラ基底クラス |
| Object3D.js | `src/core/Object3D.js` | ソース | 3Dオブジェクト基底クラス |
| WebGLRenderer.js | `src/renderers/WebGLRenderer.js` | ソース | ArrayCameraを使用するレンダラー |
| WebXRManager.js | `src/renderers/webxr/WebXRManager.js` | ソース | XRでのArrayCamera使用 |
