# 機能設計書 24-Scene

## 概要

本ドキュメントは、Three.jsにおけるScene（シーン）機能の詳細設計を記述する。Sceneは3Dオブジェクトを配置するシーングラフのルートオブジェクトである。

### 本機能の処理概要

Sceneは、Three.jsにおける3Dシーンのルートコンテナとして機能するクラスである。メッシュ、ライト、カメラなどの3Dオブジェクトを階層的に配置し、レンダリングの対象となるオブジェクト群を管理する。また、背景色、環境マップ、フォグなどのシーン全体に適用される設定も管理する。

**業務上の目的・背景**：3Dアプリケーションにおいて、複数の3Dオブジェクトを論理的かつ効率的に管理するためにはシーングラフ構造が不可欠である。Sceneクラスは、このシーングラフのルートノードとして機能し、オブジェクトの追加・削除、階層構造の管理、シーン全体のプロパティ設定を一元化する。

**機能の利用シーン**：
- 3Dエディタでのシーン構築
- ゲームやインタラクティブコンテンツのワールド管理
- データビジュアライゼーションの3D表示
- VR/ARアプリケーションの空間定義
- レンダリング対象の組織化

**主要な処理内容**：
1. 3Dオブジェクト（メッシュ、ライト、カメラ等）の階層的な管理
2. 背景（色、テクスチャ、キューブマップ）の設定
3. 環境マップ（PBRマテリアル用）の管理
4. フォグ効果（Fog、FogExp2）の設定
5. オーバーライドマテリアルの設定
6. シリアライズ/デシリアライズ（JSON変換）

**関連システム・外部連携**：WebGLRenderer、WebGPURenderer、ObjectLoader、エディタアプリケーションと連携して動作する。

**権限による制御**：特になし（ライブラリ機能として権限制御は行わない）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | エディタメイン画面 | 主機能 | 編集対象のシーングラフを管理 |
| 3 | Sidebar - Scene | 主機能 | シーングラフの階層構造表示と管理 |
| 10 | Menubar - File | 遷移先機能 | 新規プロジェクト作成時のシーン初期化 |

## 機能種別

データ管理 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | コンストラクタはパラメータなし | - |

### インスタンスプロパティ

| プロパティ名 | 型 | デフォルト | 説明 |
|-------------|-----|----------|------|
| background | Color\|Texture\|null | null | シーンの背景（色、テクスチャ、キューブマップ） |
| environment | Texture\|null | null | PBRマテリアル用の環境マップ |
| fog | Fog\|FogExp2\|null | null | フォグ効果 |
| backgroundBlurriness | number | 0 | 背景のぼかし度合い（0-1） |
| backgroundIntensity | number | 1 | 背景の明度 |
| backgroundRotation | Euler | (0,0,0) | 背景の回転 |
| environmentIntensity | number | 1 | 環境マップの明度 |
| environmentRotation | Euler | (0,0,0) | 環境マップの回転 |
| overrideMaterial | Material\|null | null | 全オブジェクトに適用するマテリアル |

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| isScene | boolean | Sceneであることを示すフラグ（true） |
| children | Array\<Object3D\> | 子オブジェクトの配列（Object3Dから継承） |

### 出力先

- レンダラーへのシーンデータ提供
- JSON形式でのシリアライズ出力

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ実行
   └─ super()でObject3Dを初期化
   └─ isScene = true を設定
   └─ 各プロパティを初期化
   └─ DevToolsへの通知（開発時）

2. オブジェクトの追加/削除
   └─ add()でオブジェクトを追加
   └─ remove()でオブジェクトを削除
   └─ 親子関係の更新

3. レンダリング
   └─ レンダラーがシーンを受け取る
   └─ 背景/環境/フォグの適用
   └─ 子オブジェクトの再帰的レンダリング
```

### フローチャート

```mermaid
flowchart TD
    A[Scene生成] --> B[Object3D初期化]
    B --> C[シーンプロパティ設定]
    C --> D{DevTools存在?}
    D -->|Yes| E[DevToolsへ通知]
    D -->|No| F[シーン使用可能]
    E --> F
    F --> G[add/removeでオブジェクト管理]
    G --> H[レンダラーに渡す]
    H --> I[背景/環境/フォグ適用]
    I --> J[子オブジェクトレンダリング]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 背景種別 | backgroundは色、テクスチャ、キューブマップのいずれかを設定可能 | 常時 |
| BR-02 | 環境マップ優先度 | マテリアルのenvMapが設定されている場合、scene.environmentより優先 | レンダリング時 |
| BR-03 | オーバーライドマテリアル除外 | Material.allowOverrideがfalseの場合、overrideMaterialは適用されない | レンダリング時 |
| BR-04 | ぼかし制限 | backgroundBlurrinessは環境マップ（キューブマップ）にのみ有効 | 背景がキューブマップの場合 |

### 計算ロジック

特別な計算ロジックなし。プロパティの設定と管理が主な役割。

## データベース操作仕様

該当なし（クライアントサイドのみの処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 明示的なエラー処理なし | 入力検証は呼び出し側の責任 |

### リトライ仕様

リトライ処理は不要

## トランザクション仕様

該当なし（クライアントサイドのみの処理）

## パフォーマンス要件

- シーングラフの深さが深くなると再帰処理のコストが増加
- 大量のオブジェクトを持つシーンでは適切なLOD、カリングが重要

## セキュリティ考慮事項

特になし（ブラウザのセキュリティモデルに依存）

## 備考

- DevToolsとの連携により、ブラウザの開発者ツールでシーンの監視が可能
- copy()メソッドで別のシーンからプロパティをコピー可能
- toJSON()でシーン全体をシリアライズ可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

SceneはObject3Dを継承し、シーン固有のプロパティを追加したクラス。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Scene.js | `src/scenes/Scene.js` | クラスの全体構造（166行） |
| 1-2 | Object3D.js | `src/core/Object3D.js` | 親クラスの構造 |
| 1-3 | Euler.js | `src/math/Euler.js` | 回転プロパティの型 |

**読解のコツ**: SceneはObject3Dを継承しているため、add()、remove()、children等のメソッド/プロパティは親クラスから提供される。

#### Step 2: コンストラクタを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Scene.js | `src/scenes/Scene.js` | 15-121行目 |

**主要処理フロー**:
1. **17行目**: super()でObject3Dを初期化
2. **26行目**: isScene = true を設定
3. **28行目**: type = 'Scene' を設定
4. **40行目**: background = null を設定
5. **50行目**: environment = null を設定
6. **59行目**: fog = null を設定
7. **69行目**: backgroundBlurriness = 0 を設定
8. **77行目**: backgroundIntensity = 1 を設定
9. **86行目**: backgroundRotation = new Euler() を設定
10. **95行目**: environmentIntensity = 1 を設定
11. **104行目**: environmentRotation = new Euler() を設定
12. **113行目**: overrideMaterial = null を設定
13. **115-119行目**: DevToolsへの通知

#### Step 3: copy()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Scene.js | `src/scenes/Scene.js` | 123-144行目 |

**主要処理フロー**:
- **125行目**: super.copy()で親クラスのコピー
- **127-129行目**: background、environment、fogのクローン
- **131-136行目**: 各プロパティのコピー
- **138行目**: overrideMaterialのクローン

#### Step 4: toJSON()メソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Scene.js | `src/scenes/Scene.js` | 146-161行目 |

**主要処理フロー**:
- **148行目**: super.toJSON()で親クラスのJSON生成
- **150行目**: fogをJSON化
- **152-157行目**: 各プロパティをJSONに追加

### プログラム呼び出し階層図

```
Scene
    |
    +-- extends Object3D
    |       |
    |       +-- add(object)
    |       +-- remove(object)
    |       +-- traverse(callback)
    |       +-- updateMatrixWorld()
    |
    +-- constructor()
    |       |
    |       +-- super()
    |       +-- プロパティ初期化
    |       +-- DevTools通知
    |
    +-- copy(source, recursive)
    |       |
    |       +-- super.copy()
    |       +-- プロパティコピー
    |
    +-- toJSON(meta)
            |
            +-- super.toJSON()
            +-- fog.toJSON()
            +-- プロパティ追加
```

### データフロー図

```
[入力]                      [処理]                         [出力]

                       Scene構築
                           |
                           v
               プロパティ初期化 ────────> Sceneインスタンス
                           |
                           v
Object3D ────────────> add() ──────────> children配列
                           |
                           v
                    レンダラーで使用
                           |
           +───────────────+───────────────+
           |               |               |
           v               v               v
    background適用    environment適用    fog適用
           |               |               |
           +───────────────+───────────────+
                           |
                           v
                    レンダリング結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Scene.js | `src/scenes/Scene.js` | ソース | Sceneクラスの実装 |
| Object3D.js | `src/core/Object3D.js` | ソース | 親クラス |
| Fog.js | `src/scenes/Fog.js` | ソース | リニアフォグ |
| FogExp2.js | `src/scenes/FogExp2.js` | ソース | 指数フォグ |
| Euler.js | `src/math/Euler.js` | ソース | 回転プロパティの型 |
| Color.js | `src/math/Color.js` | ソース | 背景色の型 |
| Texture.js | `src/textures/Texture.js` | ソース | 背景/環境テクスチャの型 |
