# 機能設計書 31-ConeGeometry

## 概要

本ドキュメントはThree.jsにおける円錐ジオメトリ（ConeGeometry）クラスの機能設計を記述する。ConeGeometryはCylinderGeometryを継承し、上部の半径を0に設定することで円錐形状を生成するジオメトリクラスである。

### 本機能の処理概要

ConeGeometryは3Dグラフィックスにおいて円錐形状のメッシュを生成するための基本的なジオメトリクラスである。底面の半径、高さ、分割数を指定することで、様々なサイズと詳細度の円錐形状を作成できる。

**業務上の目的・背景**：3Dグラフィックスアプリケーションでは、基本的な幾何学形状を組み合わせてシーンを構築する必要がある。円錐形状は矢印、道路コーン、尖塔、樹木など多くのオブジェクトの基本形状として使用される。ConeGeometryはこの基本形状を効率的に生成し、3Dシーンの構築を容易にする。

**機能の利用シーン**：3Dエディタでのオブジェクト追加、ゲーム開発における障害物や装飾オブジェクトの作成、科学的な可視化における方向インジケータの表示、教育用3Dコンテンツにおける幾何学形状の描画などで利用される。

**主要な処理内容**：
1. CylinderGeometryを継承し、上部半径（radiusTop）を0に設定して円錐形状を実現
2. 底面の半径、高さ、周方向・高さ方向の分割数をパラメータとして受け取る
3. 開放/閉鎖の底面、開始角度、中心角を指定可能
4. 頂点位置、法線、UV座標を自動生成

**関連システム・外部連携**：レンダラー（WebGLRenderer、WebGPURenderer）と連携してメッシュを描画する。マテリアルと組み合わせてMeshオブジェクトを構成する。

**権限による制御**：特になし。全てのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし |

## 機能種別

計算処理 / ジオメトリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| radius | number | No | 円錐底面の半径（デフォルト: 1） | なし |
| height | number | No | 円錐の高さ（デフォルト: 1） | なし |
| radialSegments | number | No | 周方向の分割数（デフォルト: 32） | Math.floorで整数化 |
| heightSegments | number | No | 高さ方向の分割数（デフォルト: 1） | Math.floorで整数化 |
| openEnded | boolean | No | 底面を開放するか（デフォルト: false） | なし |
| thetaStart | number | No | 開始角度（ラジアン、デフォルト: 0） | なし |
| thetaLength | number | No | 中心角（ラジアン、デフォルト: Math.PI * 2） | なし |

### 入力データソース

コンストラクタ引数として直接指定される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| position | Float32BufferAttribute | 頂点の3D位置座標 |
| normal | Float32BufferAttribute | 頂点の法線ベクトル |
| uv | Float32BufferAttribute | テクスチャマッピング用UV座標 |
| index | Uint16/Uint32BufferAttribute | 三角形面のインデックス |

### 出力先

BufferGeometry属性として保持され、Meshオブジェクトを通じてGPUに送信される。

## 処理フロー

### 処理シーケンス

```
1. コンストラクタ呼び出し
   └─ 引数（radius, height, radialSegments等）を受け取る
2. CylinderGeometryコンストラクタを呼び出し
   └─ radiusTop=0として円錐形状を生成
3. typeプロパティを設定
   └─ 'ConeGeometry'に設定
4. parametersオブジェクトを設定
   └─ コンストラクタ引数を保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コンストラクタ引数を受け取る]
    B --> C[super呼び出し: CylinderGeometry]
    C --> D[radiusTop=0, radiusBottom=radius]
    D --> E[type = 'ConeGeometry']
    E --> F[parameters保存]
    F --> G[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-31-001 | 円錐形状生成 | 上部半径を0として円柱ジオメトリを生成し円錐を表現 | 常時 |
| BR-31-002 | パラメータ保存 | 生成後のパラメータ変更は形状に反映されない | 常時 |

### 計算ロジック

CylinderGeometryを継承し、radiusTop=0、radiusBottom=radiusとして呼び出す。
頂点座標、法線、UVの計算はCylinderGeometryに委譲される。

## データベース操作仕様

該当なし（クライアントサイドのみで動作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 特別なエラー処理なし | パラメータは暗黙的に処理される |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- radialSegmentsとheightSegmentsの値が大きいほど頂点数が増加し、メモリ使用量とレンダリング負荷が増大する
- デフォルト値（radialSegments=32, heightSegments=1）は一般的な用途に適した設定

## セキュリティ考慮事項

特になし（クライアントサイドのジオメトリ生成処理）

## 備考

- ConeGeometryはCylinderGeometryの特殊ケース（上部半径=0）として実装されている
- 部分的な円錐（扇形）はthetaStartとthetaLengthで制御可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

BufferGeometryの属性構造（position, normal, uv, index）を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BufferGeometry.js | `src/core/BufferGeometry.js` | 頂点属性の管理方法、setIndex/setAttribute |
| 1-2 | BufferAttribute.js | `src/core/BufferAttribute.js` | Float32BufferAttributeによるデータ格納 |

**読解のコツ**: BufferGeometryはWebGLの頂点バッファオブジェクト（VBO）に対応するデータ構造。attributesプロパティに名前付きで属性を格納する。

#### Step 2: エントリーポイントを理解する

ConeGeometryクラスのコンストラクタが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ConeGeometry.js | `src/geometries/ConeGeometry.js` | CylinderGeometry継承とradiusTop=0の設定 |

**主要処理フロー**:
1. **30-32行目**: コンストラクタでCylinderGeometryをradiusTop=0で呼び出し
2. **34行目**: typeプロパティを'ConeGeometry'に設定
3. **43-51行目**: parametersオブジェクトに引数を保存

#### Step 3: 親クラスの処理を理解する

実際のジオメトリ生成はCylinderGeometryで行われる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CylinderGeometry.js | `src/geometries/CylinderGeometry.js` | generateTorso/generateCap関数の処理 |

**主要処理フロー**:
- **79-86行目**: generateTorso()で側面を生成、generateCap()で底面を生成
- **95-195行目**: generateTorso関数で頂点・法線・UVを計算
- **197-303行目**: generateCap関数で底面の頂点を生成

### プログラム呼び出し階層図

```
ConeGeometry.constructor()
    │
    └─ CylinderGeometry.constructor(0, radius, height, ...)
           │
           ├─ generateTorso()
           │      └─ 頂点/法線/UV/インデックス生成
           │
           └─ generateCap(false)  // 底面のみ
                  └─ 底面頂点生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

パラメータ ───▶ ConeGeometry ───▶ BufferGeometry属性
(radius,           │                 (position,
 height,           │                  normal,
 segments等)       │                  uv,
                   ▼                  index)
            CylinderGeometry
            (radiusTop=0)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ConeGeometry.js | `src/geometries/ConeGeometry.js` | ソース | 円錐ジオメトリクラス定義 |
| CylinderGeometry.js | `src/geometries/CylinderGeometry.js` | ソース | 親クラス、実際のジオメトリ生成 |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | 基底クラス、属性管理 |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点属性データ格納 |
| Vector3.js | `src/math/Vector3.js` | ソース | 3Dベクトル計算 |
| Vector2.js | `src/math/Vector2.js` | ソース | 2Dベクトル（UV座標） |
