# 機能設計書 43-OctahedronGeometry

## 概要

本ドキュメントは、Three.jsライブラリにおける正8面体ジオメトリを生成するOctahedronGeometryクラスの機能設計を記述する。

### 本機能の処理概要

OctahedronGeometryは、正8面体（Octahedron）のジオメトリを生成するクラスである。正8面体は6個の頂点と8個の正三角形の面から構成される正多面体であり、3つの座標軸上に頂点が配置された形状を持つ。詳細度（detail）パラメータを調整することで、より滑らかな球体に近い形状を生成することも可能である。

**業務上の目的・背景**：正8面体は、プラトン立体の一つとして幾何学的に重要な形状である。ダイヤモンドの結晶構造や分子モデルの表現に使用されるほか、3Dグラフィックスにおいて低ポリゴンの宝石や結晶を表現する際に活用される。また、正8面体を細分化することで均一な球面を生成できるため、球体近似のベース形状としても使用される。

**機能の利用シーン**：
- 宝石や結晶形状のモデリング
- 分子構造の可視化
- ゲームにおけるパワーアップアイテムやコレクタブル
- 科学的シミュレーションにおける粒子表現
- 装飾的な3Dオブジェクトの作成

**主要な処理内容**：
1. 6個の頂点座標を定義（座標軸上に配置）
2. 8個の三角形面を定義するインデックス配列を構築
3. 親クラスPolyhedronGeometryのコンストラクタを呼び出し
4. 指定された半径と詳細度でジオメトリを生成
5. parametersプロパティにコンストラクタ引数を保存

**関連システム・外部連携**：PolyhedronGeometry（親クラス）、BufferGeometry、Meshなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに関連画面の定義なし |

## 機能種別

計算処理 / ジオメトリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| radius | number | No | 正8面体の半径 | デフォルト: 1 |
| detail | number | No | 細分化の詳細度（0以上の整数） | デフォルト: 0 |

### 入力データソース

コンストラクタ引数として直接渡される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| position属性 | Float32BufferAttribute | 頂点位置データ（3成分/頂点） |
| normal属性 | Float32BufferAttribute | 法線ベクトルデータ（3成分/頂点） |
| uv属性 | Float32BufferAttribute | UV座標データ（2成分/頂点） |
| parameters | Object | コンストラクタパラメータの保存（radius, detail） |

### 出力先

BufferGeometryの属性として格納され、Meshオブジェクトなどで使用される。

## 処理フロー

### 処理シーケンス

```
1. 6頂点の座標定義
   └─ 座標軸上の点: (±1,0,0), (0,±1,0), (0,0,±1)
2. 8面のインデックス定義
   └─ 各三角形面の頂点インデックスを指定
3. 親クラスコンストラクタ呼び出し
   └─ PolyhedronGeometry(vertices, indices, radius, detail)
4. typeプロパティの設定
   └─ 'OctahedronGeometry'
5. parametersの保存
   └─ radius, detailを格納
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[6頂点の座標配列を定義]
    B --> C[8面のインデックス配列を定義]
    C --> D[super: PolyhedronGeometry呼び出し]
    D --> E[type = 'OctahedronGeometry']
    E --> F[parameters保存]
    F --> G[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 座標軸配置 | 6頂点は3つの座標軸上に対称に配置 | 常時 |
| BR-002 | 頂点数固定 | 基本形状は常に6頂点 | detail=0時 |
| BR-003 | 面数固定 | 基本形状は常に8面 | detail=0時 |
| BR-004 | 細分化継承 | detail>0の場合、親クラスの細分化アルゴリズムを適用 | detail>0時 |

### 計算ロジック

**頂点座標**:
正8面体の6頂点は座標軸上に配置される：
- 頂点0: (1, 0, 0)  - X軸正方向
- 頂点1: (-1, 0, 0) - X軸負方向
- 頂点2: (0, 1, 0)  - Y軸正方向
- 頂点3: (0, -1, 0) - Y軸負方向
- 頂点4: (0, 0, 1)  - Z軸正方向
- 頂点5: (0, 0, -1) - Z軸負方向

**インデックス配列**:
8つの三角形面を定義（反時計回り）

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 暗黙的エラー | 負のradiusが指定された場合 | 反転したジオメトリが生成される |
| - | 暗黙的エラー | 負のdetailが指定された場合 | 予期しない結果となる可能性 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- detail=0: 6頂点、8面（24頂点：非インデックス形式）
- detail=1: 18頂点、32面
- detail=2: 66頂点、128面
- 高いdetail値ではメモリと計算時間が指数的に増加

## セキュリティ考慮事項

該当なし（クライアントサイドのジオメトリ生成処理）

## 備考

- 正8面体はプラトン立体の一つで、正6面体（立方体）と双対関係にある
- detail値を上げると球体に近づく
- JSON形式でのシリアライズ・デシリアライズに対応（fromJSONメソッド）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、正8面体の数学的構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | OctahedronGeometry.js | `src/geometries/OctahedronGeometry.js` | 頂点・インデックス定義を確認 |
| 1-2 | PolyhedronGeometry.js | `src/geometries/PolyhedronGeometry.js` | 親クラスの処理フローを理解 |

**読解のコツ**: 正8面体は最もシンプルな頂点配置（座標軸上のみ）を持つため、コードも非常にコンパクト。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | OctahedronGeometry.js | `src/geometries/OctahedronGeometry.js` | コンストラクタの全体フロー |

**主要処理フロー**:
1. **26-29行目**: 6頂点の座標配列定義
2. **31-35行目**: 8面のインデックス配列定義
3. **37行目**: 親クラスコンストラクタ呼び出し
4. **39行目**: typeプロパティ設定
5. **48-51行目**: parameters保存

#### Step 3: 頂点構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | OctahedronGeometry.js | `src/geometries/OctahedronGeometry.js` | vertices配列の構造 |

**頂点配列の構造**:
```javascript
const vertices = [
    1, 0, 0,    // 頂点0: X軸正方向
   -1, 0, 0,    // 頂点1: X軸負方向
    0, 1, 0,    // 頂点2: Y軸正方向
    0, -1, 0,   // 頂点3: Y軸負方向
    0, 0, 1,    // 頂点4: Z軸正方向
    0, 0, -1    // 頂点5: Z軸負方向
];
```

### プログラム呼び出し階層図

```
OctahedronGeometry.constructor(radius, detail)
    │
    └─ PolyhedronGeometry.constructor(vertices, indices, radius, detail)
           │
           ├─ subdivide(detail)
           │      └─ subdivideFace()
           │
           ├─ applyRadius(radius)
           │
           └─ generateUVs()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

radius ──────────────────▶ OctahedronGeometry
detail                        │
                              │ 頂点/インデックス定義
                              ▼
                    PolyhedronGeometry処理
                              │
                              ▼
                    ┌─────────────────────┐
                    │ BufferGeometry      │
                    │  - position属性     │
                    │  - normal属性       │ ────▶ Meshで使用
                    │  - uv属性           │
                    │  - parameters       │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| OctahedronGeometry.js | `src/geometries/OctahedronGeometry.js` | ソース | 正8面体ジオメトリクラス |
| PolyhedronGeometry.js | `src/geometries/PolyhedronGeometry.js` | ソース | 多面体ジオメトリ基底クラス |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリ基底クラス |
| Geometries.js | `src/geometries/Geometries.js` | ソース | ジオメトリクラスのエクスポート |
