# 機能設計書 44-TetrahedronGeometry

## 概要

本ドキュメントは、Three.jsライブラリにおける正4面体ジオメトリを生成するTetrahedronGeometryクラスの機能設計を記述する。

### 本機能の処理概要

TetrahedronGeometryは、正4面体（Tetrahedron）のジオメトリを生成するクラスである。正4面体は4個の頂点と4個の正三角形の面から構成される最もシンプルな正多面体であり、3D空間において最小の面数で閉じた立体を形成する。詳細度（detail）パラメータを調整することで、より滑らかな球体に近い形状を生成することも可能である。

**業務上の目的・背景**：正4面体は、プラトン立体の中で最もシンプルな形状であり、化学における分子構造（メタン分子など）の表現や、3Dグラフィックスにおける基本形状として使用される。また、正4面体は自己双対であるという数学的に興味深い性質を持つ。ゲーム開発やシミュレーションにおいて、シンプルな立体形状が必要な場面で活用される。

**機能の利用シーン**：
- 分子構造の可視化（四面体型分子）
- ゲームにおけるシンプルな立体オブジェクト
- 物理シミュレーションにおける衝突判定用形状
- 幾何学的なアート作品やデザイン
- 教育目的での多面体の表示

**主要な処理内容**：
1. 4個の頂点座標を定義
2. 4個の三角形面を定義するインデックス配列を構築
3. 親クラスPolyhedronGeometryのコンストラクタを呼び出し
4. 指定された半径と詳細度でジオメトリを生成
5. parametersプロパティにコンストラクタ引数を保存

**関連システム・外部連携**：PolyhedronGeometry（親クラス）、BufferGeometry、Meshなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに関連画面の定義なし |

## 機能種別

計算処理 / ジオメトリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| radius | number | No | 正4面体の半径 | デフォルト: 1 |
| detail | number | No | 細分化の詳細度（0以上の整数） | デフォルト: 0 |

### 入力データソース

コンストラクタ引数として直接渡される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| position属性 | Float32BufferAttribute | 頂点位置データ（3成分/頂点） |
| normal属性 | Float32BufferAttribute | 法線ベクトルデータ（3成分/頂点） |
| uv属性 | Float32BufferAttribute | UV座標データ（2成分/頂点） |
| parameters | Object | コンストラクタパラメータの保存（radius, detail） |

### 出力先

BufferGeometryの属性として格納され、Meshオブジェクトなどで使用される。

## 処理フロー

### 処理シーケンス

```
1. 4頂点の座標定義
   └─ 対称的な配置: (1,1,1), (-1,-1,1), (-1,1,-1), (1,-1,-1)
2. 4面のインデックス定義
   └─ 各三角形面の頂点インデックスを指定
3. 親クラスコンストラクタ呼び出し
   └─ PolyhedronGeometry(vertices, indices, radius, detail)
4. typeプロパティの設定
   └─ 'TetrahedronGeometry'
5. parametersの保存
   └─ radius, detailを格納
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[4頂点の座標配列を定義]
    B --> C[4面のインデックス配列を定義]
    C --> D[super: PolyhedronGeometry呼び出し]
    D --> E[type = 'TetrahedronGeometry']
    E --> F[parameters保存]
    F --> G[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 対称配置 | 4頂点は立方体の交互頂点として対称に配置 | 常時 |
| BR-002 | 頂点数固定 | 基本形状は常に4頂点 | detail=0時 |
| BR-003 | 面数固定 | 基本形状は常に4面 | detail=0時 |
| BR-004 | 細分化継承 | detail>0の場合、親クラスの細分化アルゴリズムを適用 | detail>0時 |
| BR-005 | 自己双対性 | 正4面体は自己双対（頂点数=面数） | 常時 |

### 計算ロジック

**頂点座標**:
正4面体の4頂点は立方体の交互頂点として配置される：
- 頂点0: (1, 1, 1)
- 頂点1: (-1, -1, 1)
- 頂点2: (-1, 1, -1)
- 頂点3: (1, -1, -1)

**インデックス配列**:
4つの三角形面を定義

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 暗黙的エラー | 負のradiusが指定された場合 | 反転したジオメトリが生成される |
| - | 暗黙的エラー | 負のdetailが指定された場合 | 予期しない結果となる可能性 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- detail=0: 4頂点、4面（12頂点：非インデックス形式）
- detail=1: 10頂点、16面
- detail=2: 34頂点、64面
- 高いdetail値ではメモリと計算時間が指数的に増加

## セキュリティ考慮事項

該当なし（クライアントサイドのジオメトリ生成処理）

## 備考

- 正4面体はプラトン立体の中で最もシンプル
- 唯一の自己双対正多面体
- detail値を上げると球体に近づく
- JSON形式でのシリアライズ・デシリアライズに対応（fromJSONメソッド）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、正4面体の数学的構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TetrahedronGeometry.js | `src/geometries/TetrahedronGeometry.js` | 頂点・インデックス定義を確認 |
| 1-2 | PolyhedronGeometry.js | `src/geometries/PolyhedronGeometry.js` | 親クラスの処理フローを理解 |

**読解のコツ**: 正4面体は最小の正多面体（4頂点・4面）であり、コードも非常にコンパクト。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TetrahedronGeometry.js | `src/geometries/TetrahedronGeometry.js` | コンストラクタの全体フロー |

**主要処理フロー**:
1. **26-28行目**: 4頂点の座標配列定義
2. **30-31行目**: 4面のインデックス配列定義
3. **33行目**: 親クラスコンストラクタ呼び出し
4. **35行目**: typeプロパティ設定
5. **44-47行目**: parameters保存

#### Step 3: 頂点構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TetrahedronGeometry.js | `src/geometries/TetrahedronGeometry.js` | vertices配列の構造 |

**頂点配列の構造**:
```javascript
const vertices = [
    1, 1, 1,     // 頂点0
   -1, -1, 1,    // 頂点1
   -1, 1, -1,    // 頂点2
    1, -1, -1    // 頂点3
];
```

### プログラム呼び出し階層図

```
TetrahedronGeometry.constructor(radius, detail)
    │
    └─ PolyhedronGeometry.constructor(vertices, indices, radius, detail)
           │
           ├─ subdivide(detail)
           │      └─ subdivideFace()
           │
           ├─ applyRadius(radius)
           │
           └─ generateUVs()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

radius ──────────────────▶ TetrahedronGeometry
detail                        │
                              │ 頂点/インデックス定義
                              ▼
                    PolyhedronGeometry処理
                              │
                              ▼
                    ┌─────────────────────┐
                    │ BufferGeometry      │
                    │  - position属性     │
                    │  - normal属性       │ ────▶ Meshで使用
                    │  - uv属性           │
                    │  - parameters       │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TetrahedronGeometry.js | `src/geometries/TetrahedronGeometry.js` | ソース | 正4面体ジオメトリクラス |
| PolyhedronGeometry.js | `src/geometries/PolyhedronGeometry.js` | ソース | 多面体ジオメトリ基底クラス |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリ基底クラス |
| Geometries.js | `src/geometries/Geometries.js` | ソース | ジオメトリクラスのエクスポート |
