# 機能設計書 45-DodecahedronGeometry

## 概要

本ドキュメントは、Three.jsライブラリにおける正12面体ジオメトリを生成するDodecahedronGeometryクラスの機能設計を記述する。

### 本機能の処理概要

DodecahedronGeometryは、正12面体（Dodecahedron）のジオメトリを生成するクラスである。正12面体は20個の頂点と12個の正五角形の面から構成される正多面体であり、黄金比に基づく座標で定義される。Three.jsでは、各五角形面を三角形に分割して描画するため、実際には36個の三角形面として扱われる。

**業務上の目的・背景**：正12面体は、プラトン立体の中で最も面数が多い形状であり、サッカーボールやウイルスの構造、結晶学において重要な形状である。黄金比に基づく美しい対称性を持ち、アートやデザイン、科学的可視化において広く使用される。また、テーブルトップゲームにおいて12面ダイスとしても知られている。

**機能の利用シーン**：
- テーブルトップゲームの12面ダイス
- 科学的可視化（ウイルス構造など）
- 幾何学的なアート作品やデザイン
- 建築的デザインの基盤形状
- 教育目的での多面体の表示

**主要な処理内容**：
1. 黄金比を用いた20個の頂点座標を定義
2. 36個の三角形面を定義するインデックス配列を構築（12五角形×3三角形）
3. 親クラスPolyhedronGeometryのコンストラクタを呼び出し
4. 指定された半径と詳細度でジオメトリを生成
5. parametersプロパティにコンストラクタ引数を保存

**関連システム・外部連携**：PolyhedronGeometry（親クラス）、BufferGeometry、Meshなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに関連画面の定義なし |

## 機能種別

計算処理 / ジオメトリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| radius | number | No | 正12面体の半径 | デフォルト: 1 |
| detail | number | No | 細分化の詳細度（0以上の整数） | デフォルト: 0 |

### 入力データソース

コンストラクタ引数として直接渡される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| position属性 | Float32BufferAttribute | 頂点位置データ（3成分/頂点） |
| normal属性 | Float32BufferAttribute | 法線ベクトルデータ（3成分/頂点） |
| uv属性 | Float32BufferAttribute | UV座標データ（2成分/頂点） |
| parameters | Object | コンストラクタパラメータの保存（radius, detail） |

### 出力先

BufferGeometryの属性として格納され、Meshオブジェクトなどで使用される。

## 処理フロー

### 処理シーケンス

```
1. 黄金比tと逆数rの計算
   └─ t = (1 + sqrt(5)) / 2, r = 1 / t
2. 20頂点の座標定義
   └─ 黄金比を使用した座標配列を構築
3. 36面のインデックス定義
   └─ 12五角形を各3三角形に分割
4. 親クラスコンストラクタ呼び出し
   └─ PolyhedronGeometry(vertices, indices, radius, detail)
5. typeプロパティの設定
   └─ 'DodecahedronGeometry'
6. parametersの保存
   └─ radius, detailを格納
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[黄金比t, r を計算]
    B --> C[20頂点の座標配列を定義]
    C --> D[36三角形面のインデックス配列を定義]
    D --> E[super: PolyhedronGeometry呼び出し]
    E --> F[type = 'DodecahedronGeometry']
    F --> G[parameters保存]
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 黄金比使用 | t = (1 + sqrt(5)) / 2, r = 1/t を頂点座標の計算に使用 | 常時 |
| BR-002 | 頂点数固定 | 基本形状は常に20頂点 | detail=0時 |
| BR-003 | 面数変換 | 12正五角形を36三角形に変換 | 常時 |
| BR-004 | 細分化継承 | detail>0の場合、親クラスの細分化アルゴリズムを適用 | detail>0時 |

### 計算ロジック

**黄金比（Golden Ratio）**:
- t = (1 + sqrt(5)) / 2 ≈ 1.6180339887
- r = 1 / t ≈ 0.6180339887

**頂点座標**:
正12面体の20頂点は以下の3つのグループで構成される：
- 8頂点: (±1, ±1, ±1) - 立方体の頂点
- 4頂点: (0, ±r, ±t) - X=0平面上
- 4頂点: (±r, ±t, 0) - Z=0平面上
- 4頂点: (±t, 0, ±r) - Y=0平面上

**インデックス配列**:
12個の正五角形を各3つの三角形に分割（計36三角形）

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 暗黙的エラー | 負のradiusが指定された場合 | 反転したジオメトリが生成される |
| - | 暗黙的エラー | 負のdetailが指定された場合 | 予期しない結果となる可能性 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- detail=0: 20頂点、36面（108頂点：非インデックス形式）
- detail=1: 80頂点、144面
- detail=2: 320頂点、576面
- 高いdetail値ではメモリと計算時間が指数的に増加

## セキュリティ考慮事項

該当なし（クライアントサイドのジオメトリ生成処理）

## 備考

- 正12面体はプラトン立体の一つで、正20面体と双対関係にある
- detail値を上げると球体に近づく
- JSON形式でのシリアライズ・デシリアライズに対応（fromJSONメソッド）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、正12面体の数学的構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DodecahedronGeometry.js | `src/geometries/DodecahedronGeometry.js` | 頂点・インデックス定義を確認 |
| 1-2 | PolyhedronGeometry.js | `src/geometries/PolyhedronGeometry.js` | 親クラスの処理フローを理解 |

**読解のコツ**: 頂点配列は黄金比とその逆数を使用した数学的に美しい配置。インデックス配列は12五角形を各3三角形に分割している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DodecahedronGeometry.js | `src/geometries/DodecahedronGeometry.js` | コンストラクタの全体フロー |

**主要処理フロー**:
1. **26-27行目**: 黄金比t, rの計算
2. **29-48行目**: 20頂点の座標配列定義
3. **50-63行目**: 36三角形面のインデックス配列定義
4. **65行目**: 親クラスコンストラクタ呼び出し
5. **67行目**: typeプロパティ設定
6. **76-79行目**: parameters保存

#### Step 3: 頂点構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DodecahedronGeometry.js | `src/geometries/DodecahedronGeometry.js` | vertices配列の構造 |

**頂点配列の構造**（20頂点を3つのグループに分類）:
```javascript
// グループ1: (±1, ±1, ±1) - 8頂点（立方体頂点）
// グループ2: (0, ±1/φ, ±φ) - 4頂点
// グループ3: (±1/φ, ±φ, 0) - 4頂点
// グループ4: (±φ, 0, ±1/φ) - 4頂点
```

### プログラム呼び出し階層図

```
DodecahedronGeometry.constructor(radius, detail)
    │
    └─ PolyhedronGeometry.constructor(vertices, indices, radius, detail)
           │
           ├─ subdivide(detail)
           │      └─ subdivideFace()
           │
           ├─ applyRadius(radius)
           │
           └─ generateUVs()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

radius ──────────────────▶ DodecahedronGeometry
detail                        │
                              │ 黄金比計算
                              │ 頂点/インデックス定義
                              ▼
                    PolyhedronGeometry処理
                              │
                              ▼
                    ┌─────────────────────┐
                    │ BufferGeometry      │
                    │  - position属性     │
                    │  - normal属性       │ ────▶ Meshで使用
                    │  - uv属性           │
                    │  - parameters       │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DodecahedronGeometry.js | `src/geometries/DodecahedronGeometry.js` | ソース | 正12面体ジオメトリクラス |
| PolyhedronGeometry.js | `src/geometries/PolyhedronGeometry.js` | ソース | 多面体ジオメトリ基底クラス |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリ基底クラス |
| Geometries.js | `src/geometries/Geometries.js` | ソース | ジオメトリクラスのエクスポート |
