# 機能設計書 47-WireframeGeometry

## 概要

本ドキュメントは、Three.jsライブラリにおけるワイヤーフレームジオメトリを生成するWireframeGeometryクラスの機能設計を記述する。

### 本機能の処理概要

WireframeGeometryは、既存のジオメトリからすべてのエッジを抽出してLineSegmentsで描画可能なワイヤーフレーム形式に変換するクラスである。EdgesGeometryとは異なり、角度による判定を行わず、すべての三角形エッジを表示する。重複するエッジは自動的に除去される。

**業務上の目的・背景**：ワイヤーフレーム表示は、3Dモデリング、CAD、デバッグ、教育目的など様々な場面で使用される基本的な表示モードである。メッシュの構造を可視化し、ポリゴンの配置やジオメトリの形状を確認するために不可欠な機能である。また、レトロなグラフィックスやアート表現としても活用される。

**機能の利用シーン**：
- 3Dモデルのワイヤーフレーム表示
- ジオメトリ構造のデバッグ
- ポリゴン数やメッシュ構造の確認
- レトロスタイルのグラフィックス表現
- 教育目的でのメッシュ構造の可視化
- CADビューアでのワイヤーフレームモード

**主要な処理内容**：
1. 入力ジオメトリから三角形面を反復処理
2. 各三角形の3つのエッジを抽出
3. Setを使用して重複エッジを除去
4. ユニークなエッジのみを頂点配列として出力
5. インデックス/非インデックスジオメトリの両方に対応

**関連システム・外部連携**：BufferGeometry、Float32BufferAttribute、Vector3、LineSegmentsなど

**権限による制御**：なし（クライアントサイドのJavaScriptライブラリのため）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに関連画面の定義なし |

## 機能種別

計算処理 / ジオメトリ生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| geometry | BufferGeometry | No | ワイヤーフレームを生成する元のジオメトリ | デフォルト: null |

### 入力データソース

コンストラクタ引数として直接渡される。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| position属性 | Float32BufferAttribute | エッジの頂点位置データ（3成分/頂点、2頂点/エッジ） |
| parameters | Object | コンストラクタパラメータの保存（geometry） |

### 出力先

BufferGeometryの属性として格納され、LineSegmentsオブジェクトで使用される。

## 処理フロー

### 処理シーケンス

```
1. BufferGeometryの初期化
   └─ super()を呼び出し、基底クラスを初期化
2. パラメータの保存
   └─ this.parametersにgeometryを格納
3. 入力ジオメトリの判定
   └─ インデックス付き/非インデックスジオメトリを判定
4. エッジの抽出処理
   └─ インデックス付き: グループごとに処理
   └─ 非インデックス: 直接頂点を処理
5. エッジの重複チェック
   └─ Setを使用してユニークなエッジのみを保持
6. position属性の設定
   └─ Float32BufferAttributeとして設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[BufferGeometry初期化]
    B --> C[パラメータ保存]
    C --> D{geometry !== null?}
    D -->|No| K[終了]
    D -->|Yes| E{インデックス付き?}
    E -->|Yes| F[グループごとに処理]
    E -->|No| G[直接頂点を処理]
    F --> H[エッジを抽出]
    G --> H
    H --> I{ユニークなエッジ?}
    I -->|Yes| J[頂点配列に追加]
    I -->|No| L[スキップ]
    J --> M{次のエッジ}
    L --> M
    M -->|あり| H
    M -->|なし| N[position属性を設定]
    N --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 全エッジ抽出 | すべての三角形エッジを抽出（角度判定なし） | 常時 |
| BR-002 | 重複除去 | 同一エッジは一度のみ出力 | 常時 |
| BR-003 | 双方向ハッシュ | 各エッジを正方向・逆方向の両方でハッシュ管理 | 常時 |
| BR-004 | グループ対応 | インデックス付きジオメトリのグループを考慮 | インデックス付きの場合 |

### 計算ロジック

**エッジハッシュ**:
- hash1 = `${start.x},${start.y},${start.z}-${end.x},${end.y},${end.z}`
- hash2 = `${end.x},${end.y},${end.z}-${start.x},${start.y},${start.z}`

**ユニーク判定**:
- edges.has(hash1)またはedges.has(hash2)がtrueなら重複
- 重複でなければedges.add(hash1), edges.add(hash2)で登録

## データベース操作仕様

該当なし（クライアントサイド処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 正常動作 | geometryがnullの場合 | 空のジオメトリが生成される |
| - | 暗黙的エラー | 無効なジオメトリの場合 | 予期しない結果の可能性 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（クライアントサイド処理のみ）

## パフォーマンス要件

- 処理時間は入力ジオメトリの三角形面数に比例
- Setを使用してエッジの重複チェックを高速化

## セキュリティ考慮事項

該当なし（クライアントサイドのジオメトリ生成処理）

## 備考

- シリアライズ/デシリアライズには非対応（公式ドキュメントに記載）
- LineSegmentsと組み合わせて使用
- EdgesGeometryと異なり、すべてのエッジを表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、WireframeGeometryが依存するコアクラスの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | BufferGeometry.js | `src/core/BufferGeometry.js` | index, groups, attributesの構造を理解 |
| 1-2 | Vector3.js | `src/math/Vector3.js` | fromBufferAttribute メソッドを理解 |

**読解のコツ**: WireframeGeometryはSetを用いた重複エッジ除去が核心。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | WireframeGeometry.js | `src/geometries/WireframeGeometry.js` | コンストラクタの全体フローを把握 |

**主要処理フロー**:
1. **32-47行目**: 初期化とパラメータ保存
2. **49-54行目**: vertices配列とedges Setの初期化
3. **56-58行目**: start, endベクトルの初期化
4. **61-105行目**: インデックス付きジオメトリの処理
5. **107-137行目**: 非インデックスジオメトリの処理
6. **141行目**: position属性の設定

#### Step 3: エッジ重複除去アルゴリズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | WireframeGeometry.js | `src/geometries/WireframeGeometry.js` | isUniqueEdge関数 |

**主要処理フロー**:
- **159-176行目**: isUniqueEdge関数
- **161行目**: hash1の生成（start→end）
- **162行目**: hash2の生成（end→start）
- **164行目**: 重複チェック
- **170-172行目**: 新規エッジの登録

#### Step 4: インデックス付きジオメトリの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | WireframeGeometry.js | `src/geometries/WireframeGeometry.js` | インデックス処理部分 |

**主要処理フロー**:
- **65-73行目**: グループの取得（なければデフォルトグループ作成）
- **77-105行目**: グループごとのエッジ抽出ループ
- **88-89行目**: インデックスからの頂点取得
- **91-92行目**: 位置属性からの座標取得

### プログラム呼び出し階層図

```
WireframeGeometry.constructor(geometry)
    │
    ├─ geometry.index
    │      └─ インデックス属性を取得
    │
    ├─ geometry.attributes.position
    │      └─ 位置属性を取得
    │
    ├─ geometry.groups
    │      └─ グループ情報を取得
    │
    ├─ isUniqueEdge(start, end, edges)
    │      └─ エッジの重複チェック
    │
    └─ setAttribute('position')
           └─ Float32BufferAttribute設定
```

### データフロー図

```
[入力]                      [処理]                           [出力]

BufferGeometry ──────────▶ WireframeGeometry
                               │
                               │ インデックス/非インデックス判定
                               │ グループ処理
                               │ エッジ抽出
                               │ 重複除去（Set）
                               ▼
                    ┌─────────────────────┐
                    │ BufferGeometry      │
                    │  - position属性     │ ────▶ LineSegmentsで使用
                    │  - parameters       │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| WireframeGeometry.js | `src/geometries/WireframeGeometry.js` | ソース | ワイヤーフレームジオメトリクラス |
| BufferGeometry.js | `src/core/BufferGeometry.js` | ソース | ジオメトリ基底クラス |
| BufferAttribute.js | `src/core/BufferAttribute.js` | ソース | 頂点属性データ管理 |
| Vector3.js | `src/math/Vector3.js` | ソース | 3次元ベクトル演算 |
| LineSegments.js | `src/objects/LineSegments.js` | ソース | ワイヤーフレーム描画オブジェクト |
